/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.plugin.image;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.CursorLoader;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.MediaMetadataRetriever;
import android.media.MediaScannerConnection;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.RequiresApi;
import android.support.v4.content.FileProvider;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.google.gson.Gson;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongBaseNoActionbarActivity;
import io.rong.imkit.plugin.image.AlbumBitmapCacheHelper;
import io.rong.imkit.plugin.image.PicturePreviewActivity;
import io.rong.imkit.utilities.KitStorageUtils;
import io.rong.imkit.utilities.PermissionCheckUtil;
import io.rong.imlib.IMLibExtensionModuleManager;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.HardwareResource;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class PictureSelectorActivity
extends RongBaseNoActionbarActivity {
    private static final String TAG = PictureSelectorActivity.class.getSimpleName();
    public static final int REQUEST_PREVIEW = 0;
    public static final int REQUEST_CAMERA = 1;
    public static final int REQUEST_CODE_ASK_PERMISSIONS = 100;
    public static final int SIGHT_DEFAULT_DURATION_LIMIT = 300;
    private GridView mGridView;
    private ImageButton mBtnBack;
    private Button mBtnSend;
    private PicTypeBtn mPicType;
    private PreviewBtn mPreviewBtn;
    private View mCatalogView;
    private ListView mCatalogListView;
    private List<MediaItem> mAllItemList = new ArrayList<MediaItem>();
    private Map<String, List<MediaItem>> mItemMap = new ArrayMap();
    private ArrayList<Uri> mAllSelectedItemList = new ArrayList();
    private List<String> mCatalogList = new ArrayList<String>();
    private String mCurrentCatalog = "";
    private Uri mTakePictureUri;
    private boolean mSendOrigin = false;
    private int perWidth;
    private int perHeight;
    private ExecutorService pool;
    private Handler bgHandler;
    private Handler uiHandler;
    private HandlerThread thread;

    @TargetApi(value=23)
    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rc_picsel_activity);
        this.thread = new HandlerThread(TAG);
        this.thread.start();
        this.bgHandler = new Handler(this.thread.getLooper());
        this.uiHandler = new Handler(this.getMainLooper());
        this.mGridView = (GridView)this.findViewById(R.id.gridlist);
        this.mBtnBack = (ImageButton)this.findViewById(R.id.back);
        this.mBtnBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PictureSelectorActivity.this.finish();
            }
        });
        this.mBtnSend = (Button)this.findViewById(R.id.send);
        this.mPicType = (PicTypeBtn)this.findViewById(R.id.pic_type);
        this.mPicType.init((Activity)this);
        this.mPicType.setEnabled(false);
        this.mPreviewBtn = (PreviewBtn)this.findViewById(R.id.preview);
        this.mPreviewBtn.init((Activity)this);
        this.mPreviewBtn.setEnabled(false);
        this.mCatalogView = this.findViewById(R.id.catalog_window);
        this.mCatalogListView = (ListView)this.findViewById(R.id.catalog_listview);
        String[] permissions = new String[]{"android.permission.READ_EXTERNAL_STORAGE"};
        if (!PermissionCheckUtil.checkPermissions((Context)this, permissions)) {
            PermissionCheckUtil.requestPermissions((Activity)this, permissions, 100);
            return;
        }
        this.pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.initView();
    }

    private void initView() {
        this.updatePictureItems(new IExecutedCallback(){

            @Override
            public void executed() {
                if (PictureSelectorActivity.this.uiHandler != null) {
                    PictureSelectorActivity.this.uiHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            PictureSelectorActivity.this.initWidget();
                        }
                    });
                }
            }
        });
    }

    private void initWidget() {
        this.mGridView.setAdapter((ListAdapter)new GridViewAdapter());
        this.mGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (position == 0) {
                    return;
                }
                ArrayList itemList = new ArrayList();
                if (PictureSelectorActivity.this.mCurrentCatalog.isEmpty()) {
                    itemList.addAll(PictureSelectorActivity.this.mAllItemList);
                    PicItemHolder.itemList = itemList;
                    PicItemHolder.itemSelectedList = null;
                } else {
                    Map itemMap = PictureSelectorActivity.this.mItemMap;
                    if (itemMap == null) {
                        return;
                    }
                    List currentMediaItems = (List)itemMap.get(PictureSelectorActivity.this.mCurrentCatalog);
                    if (currentMediaItems != null) {
                        itemList.addAll(currentMediaItems);
                        PicItemHolder.itemList = itemList;
                    }
                    ArrayList<MediaItem> itemSelectList = new ArrayList<MediaItem>();
                    for (String key : itemMap.keySet()) {
                        List mediaItems = (List)itemMap.get(key);
                        if (key.equals(PictureSelectorActivity.this.mCurrentCatalog) || mediaItems == null) continue;
                        for (MediaItem item : mediaItems) {
                            if (!item.selected) continue;
                            itemSelectList.add(item);
                        }
                    }
                    PicItemHolder.itemSelectedList = itemSelectList;
                }
                Intent intent = new Intent((Context)PictureSelectorActivity.this, PicturePreviewActivity.class);
                intent.putExtra("index", position - 1);
                intent.putExtra("sendOrigin", PictureSelectorActivity.this.mSendOrigin);
                PictureSelectorActivity.this.startActivityForResult(intent, 0);
            }
        });
        this.mBtnSend.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LinkedHashMap<String, Integer> mLinkedHashMap = new LinkedHashMap<String, Integer>();
                for (Map.Entry entry : PictureSelectorActivity.this.mItemMap.entrySet()) {
                    for (MediaItem item : (List)entry.getValue()) {
                        if (!item.selected) continue;
                        if (KitStorageUtils.isBuildAndTargetForQ((Context)PictureSelectorActivity.this)) {
                            String fileName = FileUtils.getFileNameWithPath((String)item.uri);
                            String filePath = item.mediaType == 1 ? KitStorageUtils.getImageSavePath((Context)PictureSelectorActivity.this) + File.separator + fileName : (item.mediaType == 3 ? KitStorageUtils.getVideoSavePath((Context)PictureSelectorActivity.this) + File.separator + fileName : KitStorageUtils.getFileSavePath((Context)PictureSelectorActivity.this) + File.separator + fileName);
                            boolean result = FileUtils.copyFile((Context)PictureSelectorActivity.this.getApplicationContext(), (Uri)Uri.parse((String)item.uri_sdk29), (String)filePath);
                            if (!result) continue;
                            mLinkedHashMap.put("file://" + filePath, item.mediaType);
                            continue;
                        }
                        mLinkedHashMap.put("file://" + item.uri, item.mediaType);
                    }
                }
                Gson gson = new Gson();
                String mediaList = gson.toJson(mLinkedHashMap);
                Intent data = new Intent();
                data.putExtra("sendOrigin", PictureSelectorActivity.this.mSendOrigin);
                data.putExtra("android.intent.extra.RETURN_RESULT", mediaList);
                PictureSelectorActivity.this.setResult(-1, data);
                PictureSelectorActivity.this.finish();
            }
        });
        this.mPicType.setEnabled(true);
        this.mPicType.setTextColor(this.getResources().getColor(R.color.rc_picsel_toolbar_send_text_normal));
        this.mPicType.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PictureSelectorActivity.this.mCatalogView.setVisibility(0);
            }
        });
        this.mPreviewBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PicItemHolder.itemList = new ArrayList();
                for (String key : PictureSelectorActivity.this.mItemMap.keySet()) {
                    for (MediaItem item : (List)PictureSelectorActivity.this.mItemMap.get(key)) {
                        if (!item.selected) continue;
                        PicItemHolder.itemList.add(item);
                    }
                }
                if (PictureSelectorActivity.this.mAllSelectedItemList != null && PicItemHolder.itemList != null) {
                    for (int i = 0; i < PictureSelectorActivity.this.mAllSelectedItemList.size(); ++i) {
                        Uri imageUri = (Uri)PictureSelectorActivity.this.mAllSelectedItemList.get(i);
                        for (int j = i + 1; j < PicItemHolder.itemList.size(); ++j) {
                            MediaItem mediaItem = PicItemHolder.itemList.get(j);
                            if (mediaItem == null || !imageUri.toString().contains(mediaItem.uri)) continue;
                            PicItemHolder.itemList.remove(j);
                            PicItemHolder.itemList.add(i, mediaItem);
                        }
                    }
                }
                PicItemHolder.itemSelectedList = null;
                Intent intent = new Intent((Context)PictureSelectorActivity.this, PicturePreviewActivity.class);
                intent.putExtra("sendOrigin", PictureSelectorActivity.this.mSendOrigin);
                PictureSelectorActivity.this.startActivityForResult(intent, 0);
            }
        });
        this.mCatalogView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 1 && PictureSelectorActivity.this.mCatalogView.getVisibility() == 0) {
                    PictureSelectorActivity.this.mCatalogView.setVisibility(8);
                }
                return true;
            }
        });
        this.mCatalogListView.setAdapter((ListAdapter)new CatalogAdapter());
        this.mCatalogListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                String catalog = position == 0 ? "" : (String)PictureSelectorActivity.this.mCatalogList.get(position - 1);
                if (catalog.equals(PictureSelectorActivity.this.mCurrentCatalog)) {
                    PictureSelectorActivity.this.mCatalogView.setVisibility(8);
                    return;
                }
                PictureSelectorActivity.this.mCurrentCatalog = catalog;
                TextView textView = (TextView)view.findViewById(R.id.name);
                PictureSelectorActivity.this.mPicType.setText(textView.getText().toString());
                PictureSelectorActivity.this.mCatalogView.setVisibility(8);
                ((CatalogAdapter)PictureSelectorActivity.this.mCatalogListView.getAdapter()).notifyDataSetChanged();
                ((GridViewAdapter)PictureSelectorActivity.this.mGridView.getAdapter()).notifyDataSetChanged();
            }
        });
        this.perWidth = ((WindowManager)this.getSystemService("window")).getDefaultDisplay().getWidth() / 3;
        this.perHeight = ((WindowManager)this.getSystemService("window")).getDefaultDisplay().getHeight() / 5;
    }

    @TargetApi(value=23)
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100) {
            if (Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") == 0) {
                this.initView();
            } else {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getString(R.string.rc_permission_grant_needed), (int)0).show();
                this.finish();
            }
        }
        if (resultCode == 0) {
            return;
        }
        if (resultCode == 1) {
            this.setResult(-1, data);
            this.finish();
            return;
        }
        switch (requestCode) {
            case 0: {
                CatalogAdapter catalogAdapter;
                this.mSendOrigin = data.getBooleanExtra("sendOrigin", false);
                GridViewAdapter gridViewAdapter = (GridViewAdapter)this.mGridView.getAdapter();
                if (gridViewAdapter != null) {
                    gridViewAdapter.notifyDataSetChanged();
                }
                if ((catalogAdapter = (CatalogAdapter)this.mCatalogListView.getAdapter()) != null) {
                    catalogAdapter.notifyDataSetChanged();
                }
                this.updateToolbar();
                break;
            }
            case 1: {
                if (this.mTakePictureUri == null) break;
                PicItemHolder.itemList = new ArrayList();
                MediaItem item = new MediaItem();
                item.uri = this.mTakePictureUri.getPath();
                item.mediaType = 1;
                PicItemHolder.itemList.add(item);
                PicItemHolder.itemSelectedList = null;
                item.uri_sdk29 = this.mTakePictureUri.toString();
                Intent intent = new Intent((Context)this, PicturePreviewActivity.class);
                this.startActivityForResult(intent, 0);
                MediaScannerConnection.scanFile((Context)this.getApplicationContext(), (String[])new String[]{this.mTakePictureUri.getPath()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                    public void onScanCompleted(String path, Uri uri) {
                        PictureSelectorActivity.this.updatePictureItems(null);
                    }
                });
                break;
            }
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.mCatalogView != null && this.mCatalogView.getVisibility() == 0) {
            this.mCatalogView.setVisibility(8);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void requestCamera() {
        if (IMLibExtensionModuleManager.getInstance().onRequestHardwareResource(HardwareResource.ResourceType.VIDEO)) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.rc_voip_call_video_start_fail), (int)1).show();
            return;
        }
        if (IMLibExtensionModuleManager.getInstance().onRequestHardwareResource(HardwareResource.ResourceType.AUDIO)) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.rc_voip_call_audio_start_fail), (int)1).show();
            return;
        }
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        List resInfoList = this.getPackageManager().queryIntentActivities(intent, 65536);
        if (resInfoList.size() <= 0) {
            Toast.makeText((Context)this, (CharSequence)this.getResources().getString(R.string.rc_voip_cpu_error), (int)0).show();
            return;
        }
        if (KitStorageUtils.isBuildAndTargetForQ((Context)this)) {
            Uri insertUri;
            String name = String.valueOf(System.currentTimeMillis());
            ContentValues values = new ContentValues();
            values.put("description", "This is an image");
            values.put("_display_name", name);
            values.put("mime_type", "image/jpeg");
            values.put("title", name);
            values.put("relative_path", "Pictures");
            Uri external = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            ContentResolver resolver = this.getContentResolver();
            this.mTakePictureUri = insertUri = resolver.insert(external, values);
            intent.putExtra("output", (Parcelable)insertUri);
        } else {
            Uri uri;
            String name = System.currentTimeMillis() + ".jpg";
            File path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            if (!path.exists()) {
                path.mkdirs();
            }
            File file = new File(path, name);
            this.mTakePictureUri = Uri.fromFile((File)file);
            try {
                uri = FileProvider.getUriForFile((Context)this, (String)(this.getPackageName() + this.getString(R.string.rc_authorities_fileprovider)), (File)file);
            }
            catch (Exception e) {
                RLog.e((String)TAG, (String)"requestCamera", (Throwable)e);
                throw new RuntimeException("Please check IMKit Manifest FileProvider config. Please refer to http://support.rongcloud.cn/kb/NzA1");
            }
            for (ResolveInfo resolveInfo : resInfoList) {
                String packageName = resolveInfo.activityInfo.packageName;
                this.grantUriPermission(packageName, uri, 2);
                this.grantUriPermission(packageName, uri, 1);
            }
            intent.putExtra("output", (Parcelable)uri);
        }
        this.startActivityForResult(intent, 1);
    }

    private void updatePictureItems(final IExecutedCallback iExecutedCallback) {
        this.bgHandler.post(new Runnable(){

            @Override
            public void run() {
                String[] projection = new String[]{"_id", "_data", "date_added", "media_type", "mime_type", "title", "duration"};
                Class<?> clazz = null;
                try {
                    clazz = Class.forName("io.rong.sight.SightExtensionModule");
                }
                catch (ClassNotFoundException e) {
                    RLog.e((String)TAG, (String)"updatePictureItems", (Throwable)e);
                }
                String selection = clazz == null ? "media_type=1" : (PictureSelectorActivity.this.getResources().getBoolean(R.bool.rc_media_selector_contain_video) ? "media_type=1 OR media_type=3" : "media_type=1");
                Uri queryUri = MediaStore.Files.getContentUri((String)"external");
                CursorLoader cursorLoader = new CursorLoader((Context)PictureSelectorActivity.this, queryUri, projection, selection, null, "date_added DESC");
                Cursor cursor = cursorLoader.loadInBackground();
                PictureSelectorActivity.this.mItemMap.clear();
                PictureSelectorActivity.this.mAllItemList.clear();
                PictureSelectorActivity.this.mCatalogList.clear();
                PictureSelectorActivity.this.mAllSelectedItemList.clear();
                PicItemHolder.itemAllSelectedMediaItemList = new ArrayList();
                if (cursor != null) {
                    if (cursor.moveToFirst()) {
                        do {
                            String catalog;
                            File file;
                            MediaItem item = new MediaItem();
                            item.name = cursor.getString(5);
                            item.mediaType = cursor.getInt(3);
                            item.mimeType = cursor.getString(4);
                            item.uri = cursor.getString(1);
                            item.duration = cursor.getInt(6);
                            Uri imageUri = ContentUris.withAppendedId((Uri)queryUri, (long)cursor.getLong(0));
                            item.uri_sdk29 = imageUri.toString();
                            if (item.uri == null || item.mediaType == 3 && item.duration == 0 || item.mediaType == 3 && !"video/mp4".equals(item.mimeType) || !(file = new File(item.uri)).exists() || file.length() == 0L) continue;
                            PictureSelectorActivity.this.mAllItemList.add(item);
                            int last = item.uri.lastIndexOf("/");
                            if (last == -1) continue;
                            if (last == 0) {
                                catalog = "/";
                            } else {
                                int secondLast = item.uri.lastIndexOf("/", last - 1);
                                catalog = item.uri.substring(secondLast + 1, last);
                            }
                            if (PictureSelectorActivity.this.mItemMap.containsKey(catalog)) {
                                ((List)PictureSelectorActivity.this.mItemMap.get(catalog)).add(item);
                                continue;
                            }
                            ArrayList<MediaItem> itemList = new ArrayList<MediaItem>();
                            itemList.add(item);
                            PictureSelectorActivity.this.mItemMap.put(catalog, itemList);
                            PictureSelectorActivity.this.mCatalogList.add(catalog);
                        } while (cursor.moveToNext());
                    }
                    cursor.close();
                    if (iExecutedCallback != null) {
                        iExecutedCallback.executed();
                    }
                }
            }
        });
    }

    private int getTotalSelectedNum() {
        int sum = 0;
        for (String key : this.mItemMap.keySet()) {
            List<MediaItem> mediaItemList = this.mItemMap.get(key);
            if (mediaItemList == null) continue;
            ArrayList<MediaItem> tempList = new ArrayList<MediaItem>(mediaItemList);
            for (MediaItem item : tempList) {
                if (!item.selected) continue;
                ++sum;
            }
        }
        return sum;
    }

    private void updateToolbar() {
        int sum = this.getTotalSelectedNum();
        if (sum == 0) {
            this.mBtnSend.setEnabled(false);
            this.mBtnSend.setTextColor(this.getResources().getColor(R.color.rc_picsel_toolbar_send_text_disable));
            this.mBtnSend.setText(R.string.rc_picsel_toolbar_send);
            this.mPreviewBtn.setEnabled(false);
            this.mPreviewBtn.setText(R.string.rc_picsel_toolbar_preview);
        } else if (sum <= 9) {
            this.mBtnSend.setEnabled(true);
            this.mBtnSend.setTextColor(this.getResources().getColor(R.color.rc_picsel_toolbar_send_text_normal));
            this.mBtnSend.setText((CharSequence)String.format(this.getResources().getString(R.string.rc_picsel_toolbar_send_num), sum));
            this.mPreviewBtn.setEnabled(true);
            this.mPreviewBtn.setText(String.format(this.getResources().getString(R.string.rc_picsel_toolbar_preview_num), sum));
        }
    }

    private MediaItem getItemAt(int index) {
        int sum = 0;
        for (String key : this.mItemMap.keySet()) {
            for (MediaItem item : this.mItemMap.get(key)) {
                if (sum == index) {
                    return item;
                }
                ++sum;
            }
        }
        return null;
    }

    private MediaItem getItemAt(String catalog, int index) {
        if (!this.mItemMap.containsKey(catalog)) {
            return null;
        }
        int sum = 0;
        for (MediaItem item : this.mItemMap.get(catalog)) {
            if (sum == index) {
                return item;
            }
            ++sum;
        }
        return null;
    }

    private MediaItem findByUri(String uri) {
        for (String key : this.mItemMap.keySet()) {
            for (MediaItem item : this.mItemMap.get(key)) {
                if (!item.uri.equals(uri)) continue;
                return item;
            }
        }
        return null;
    }

    private void setImageViewBackground(String imagePath, ImageView imageView, int position) {
        Bitmap bitmap = AlbumBitmapCacheHelper.getInstance().getBitmap(imagePath, this.perWidth, this.perHeight, new AlbumBitmapCacheHelper.ILoadImageCallback(){

            @Override
            public void onLoadImageCallBack(Bitmap bitmap, String path1, Object ... objects) {
                if (bitmap == null) {
                    return;
                }
                BitmapDrawable bd = new BitmapDrawable(PictureSelectorActivity.this.getResources(), bitmap);
                View v = PictureSelectorActivity.this.mGridView.findViewWithTag((Object)path1);
                if (v != null) {
                    v.setBackgroundDrawable((Drawable)bd);
                }
            }
        }, position);
        if (bitmap != null) {
            BitmapDrawable bd = new BitmapDrawable(this.getResources(), bitmap);
            imageView.setBackgroundDrawable((Drawable)bd);
        } else {
            imageView.setBackgroundResource(R.drawable.rc_grid_image_default);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 100: {
                if (grantResults[0] == 0) {
                    if (permissions[0].equals("android.permission.READ_EXTERNAL_STORAGE")) {
                        this.initView();
                        break;
                    }
                    if (!permissions[0].equals("android.permission.CAMERA")) break;
                    this.requestCamera();
                    break;
                }
                if (permissions[0].equals("android.permission.CAMERA")) {
                    Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getString(R.string.rc_permission_grant_needed), (int)0).show();
                    break;
                }
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getString(R.string.rc_permission_grant_needed), (int)0).show();
                this.finish();
                break;
            }
            default: {
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }
    }

    protected void onDestroy() {
        PicItemHolder.itemList = null;
        PicItemHolder.itemSelectedList = null;
        PicItemHolder.itemAllSelectedMediaItemList = null;
        this.thread.quit();
        this.bgHandler.removeCallbacks((Runnable)this.thread);
        this.bgHandler = null;
        this.uiHandler = null;
        super.onDestroy();
    }

    private void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private String formatSize(long length) {
        if (length > 0x100000L) {
            float size = (float)Math.round((float)length / 1048576.0f * 100.0f) / 100.0f;
            return size + "M";
        }
        if (length > 1024L) {
            float size = (float)Math.round((float)length / 1024.0f * 100.0f) / 100.0f;
            return size + "KB";
        }
        return length + "B";
    }

    static class PicItemHolder {
        static ArrayList<MediaItem> itemList;
        static ArrayList<MediaItem> itemSelectedList;
        static ArrayList<MediaItem> itemAllSelectedMediaItemList;

        PicItemHolder() {
        }
    }

    public static class SelectBox
    extends ImageView {
        private boolean mIsChecked;

        public SelectBox(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.setImageResource(R.drawable.rc_select_check_nor);
        }

        public void setChecked(boolean check) {
            this.mIsChecked = check;
            this.setImageResource(this.mIsChecked ? R.drawable.rc_select_check_sel : R.drawable.rc_select_check_nor);
        }

        public boolean getChecked() {
            return this.mIsChecked;
        }
    }

    public static class PreviewBtn
    extends LinearLayout {
        private TextView mText;

        public PreviewBtn(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public void init(Activity root) {
            this.mText = (TextView)root.findViewById(R.id.preview_text);
        }

        public void setText(int id2) {
            this.mText.setText(id2);
        }

        public void setText(String text) {
            this.mText.setText((CharSequence)text);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            int color2 = enabled ? R.color.rc_picsel_toolbar_send_text_normal : R.color.rc_picsel_toolbar_send_text_disable;
            this.mText.setTextColor(this.getResources().getColor(color2));
        }

        public boolean onTouchEvent(MotionEvent event) {
            if (this.isEnabled()) {
                switch (event.getAction()) {
                    case 0: {
                        this.mText.setVisibility(4);
                        break;
                    }
                    case 1: {
                        this.mText.setVisibility(0);
                        break;
                    }
                }
            }
            return super.onTouchEvent(event);
        }
    }

    public static class PicTypeBtn
    extends LinearLayout {
        TextView mText;

        public PicTypeBtn(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public void init(Activity root) {
            this.mText = (TextView)root.findViewById(R.id.type_text);
        }

        public void setText(String text) {
            this.mText.setText((CharSequence)text);
        }

        public void setTextColor(int color2) {
            this.mText.setTextColor(color2);
        }

        public boolean onTouchEvent(MotionEvent event) {
            if (this.isEnabled()) {
                switch (event.getAction()) {
                    case 0: {
                        this.mText.setVisibility(4);
                        break;
                    }
                    case 1: {
                        this.mText.setVisibility(0);
                        break;
                    }
                }
            }
            return super.onTouchEvent(event);
        }
    }

    public static class MediaItem
    implements Parcelable {
        String name;
        int mediaType;
        String mimeType;
        String uri;
        boolean selected;
        int duration;
        String uri_sdk29;
        public static final Parcelable.Creator<MediaItem> CREATOR = new Parcelable.Creator<MediaItem>(){

            public MediaItem createFromParcel(Parcel source) {
                return new MediaItem(source);
            }

            public MediaItem[] newArray(int size) {
                return new MediaItem[size];
            }
        };

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.name);
            dest.writeInt(this.mediaType);
            dest.writeString(this.mimeType);
            dest.writeString(this.uri);
            dest.writeByte(this.selected ? (byte)1 : 0);
            dest.writeInt(this.duration);
            dest.writeString(this.uri_sdk29);
        }

        public MediaItem() {
        }

        protected MediaItem(Parcel in) {
            this.name = in.readString();
            this.mediaType = in.readInt();
            this.mimeType = in.readString();
            this.uri = in.readString();
            this.selected = in.readByte() != 0;
            this.duration = in.readInt();
            this.uri_sdk29 = in.readString();
        }
    }

    private class CatalogAdapter
    extends BaseAdapter {
        private LayoutInflater mInflater;

        public CatalogAdapter() {
            this.mInflater = PictureSelectorActivity.this.getLayoutInflater();
        }

        public int getCount() {
            return PictureSelectorActivity.this.mItemMap.size() + 1;
        }

        public Object getItem(int position) {
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            String name;
            String path;
            ViewHolder holder;
            View view = convertView;
            if (view == null) {
                view = this.mInflater.inflate(R.layout.rc_picsel_catalog_listview, parent, false);
                holder = new ViewHolder();
                holder.image = (ImageView)view.findViewById(R.id.image);
                holder.name = (TextView)view.findViewById(R.id.name);
                holder.number = (TextView)view.findViewById(R.id.number);
                holder.selected = (ImageView)view.findViewById(R.id.selected);
                view.setTag((Object)holder);
            } else {
                holder = (ViewHolder)view.getTag();
            }
            if (holder.image.getTag() != null) {
                path = (String)holder.image.getTag();
                AlbumBitmapCacheHelper.getInstance().removePathFromShowlist(path);
            }
            path = "";
            int num = 0;
            boolean showSelected = false;
            if (position == 0) {
                if (PictureSelectorActivity.this.mItemMap.size() == 0) {
                    holder.image.setImageResource(R.drawable.rc_picsel_empty_pic);
                } else {
                    List mediaItems = (List)PictureSelectorActivity.this.mItemMap.get(PictureSelectorActivity.this.mCatalogList.get(0));
                    if (mediaItems != null && mediaItems.size() > 0) {
                        final MediaItem mediaItem = (MediaItem)mediaItems.get(0);
                        if (mediaItem.mediaType == 1) {
                            path = KitStorageUtils.isBuildAndTargetForQ((Context)PictureSelectorActivity.this) ? mediaItem.uri_sdk29 : mediaItem.uri;
                        } else {
                            path = KitStorageUtils.getImageSavePath((Context)PictureSelectorActivity.this) + File.separator + mediaItem.name;
                            if (!new File(path).exists()) {
                                new Thread(new Runnable(){

                                    @Override
                                    @RequiresApi(api=28)
                                    public void run() {
                                        Bitmap videoFrame = null;
                                        if (KitStorageUtils.isBuildAndTargetForQ((Context)PictureSelectorActivity.this)) {
                                            try {
                                                MediaMetadataRetriever media = new MediaMetadataRetriever();
                                                media.setDataSource(PictureSelectorActivity.this.getApplicationContext(), Uri.parse((String)mediaItem.uri_sdk29));
                                                videoFrame = media.getFrameAtTime();
                                            }
                                            catch (Exception e) {
                                                RLog.e((String)TAG, (String)"video get thumbnail error", (Throwable)e);
                                            }
                                        } else {
                                            videoFrame = ThumbnailUtils.createVideoThumbnail((String)mediaItem.uri, (int)1);
                                        }
                                        if (videoFrame != null) {
                                            final File captureImageFile = FileUtils.convertBitmap2File((Bitmap)videoFrame, (String)KitStorageUtils.getImageSavePath((Context)PictureSelectorActivity.this), (String)mediaItem.name);
                                            PictureSelectorActivity.this.runOnUiThread(new Runnable(){

                                                @Override
                                                public void run() {
                                                    PictureSelectorActivity.this.setImageViewBackground(captureImageFile.getAbsolutePath(), holder.image, position);
                                                }
                                            });
                                        }
                                    }
                                }).start();
                            }
                        }
                    }
                    if (!TextUtils.isEmpty((CharSequence)path)) {
                        AlbumBitmapCacheHelper.getInstance().addPathToShowlist(path);
                        holder.image.setTag((Object)path);
                        PictureSelectorActivity.this.setImageViewBackground(path, holder.image, position);
                    }
                }
                name = PictureSelectorActivity.this.getResources().getString(R.string.rc_picsel_catalog_allpic);
                holder.number.setVisibility(8);
                showSelected = PictureSelectorActivity.this.mCurrentCatalog.isEmpty();
            } else {
                final MediaItem mediaItem = (MediaItem)((List)PictureSelectorActivity.this.mItemMap.get(PictureSelectorActivity.this.mCatalogList.get(position - 1))).get(0);
                if (mediaItem.mediaType == 1) {
                    path = KitStorageUtils.isBuildAndTargetForQ((Context)PictureSelectorActivity.this) ? mediaItem.uri_sdk29 : mediaItem.uri;
                } else {
                    path = KitStorageUtils.getImageSavePath((Context)PictureSelectorActivity.this) + File.separator + mediaItem.name;
                    if (!new File(path).exists()) {
                        new Thread(new Runnable(){

                            @Override
                            @RequiresApi(api=28)
                            public void run() {
                                Bitmap videoFrame = null;
                                if (KitStorageUtils.isBuildAndTargetForQ((Context)PictureSelectorActivity.this)) {
                                    try {
                                        MediaMetadataRetriever media = new MediaMetadataRetriever();
                                        media.setDataSource(PictureSelectorActivity.this.getApplicationContext(), Uri.parse((String)mediaItem.uri_sdk29));
                                        videoFrame = media.getFrameAtTime();
                                    }
                                    catch (Exception e) {
                                        RLog.e((String)TAG, (String)"video get thumbnail error", (Throwable)e);
                                    }
                                } else {
                                    videoFrame = ThumbnailUtils.createVideoThumbnail((String)mediaItem.uri, (int)1);
                                }
                                if (videoFrame != null) {
                                    final File captureImageFile = FileUtils.convertBitmap2File((Bitmap)videoFrame, (String)KitStorageUtils.getImageSavePath((Context)PictureSelectorActivity.this), (String)mediaItem.name);
                                    PictureSelectorActivity.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            PictureSelectorActivity.this.setImageViewBackground(captureImageFile.getAbsolutePath(), holder.image, position);
                                        }
                                    });
                                }
                            }
                        }).start();
                    }
                }
                name = (String)PictureSelectorActivity.this.mCatalogList.get(position - 1);
                num = ((List)PictureSelectorActivity.this.mItemMap.get(PictureSelectorActivity.this.mCatalogList.get(position - 1))).size();
                holder.number.setVisibility(0);
                showSelected = name.equals(PictureSelectorActivity.this.mCurrentCatalog);
                AlbumBitmapCacheHelper.getInstance().addPathToShowlist(path);
                holder.image.setTag((Object)path);
                PictureSelectorActivity.this.setImageViewBackground(path, holder.image, position);
            }
            holder.name.setText((CharSequence)name);
            holder.number.setText((CharSequence)String.format(PictureSelectorActivity.this.getResources().getString(R.string.rc_picsel_catalog_number), num));
            holder.selected.setVisibility(showSelected ? 0 : 4);
            return view;
        }

        private class ViewHolder {
            ImageView image;
            TextView name;
            TextView number;
            ImageView selected;

            private ViewHolder() {
            }
        }
    }

    private class GridViewAdapter
    extends BaseAdapter {
        private LayoutInflater mInflater;

        public GridViewAdapter() {
            this.mInflater = PictureSelectorActivity.this.getLayoutInflater();
        }

        public int getCount() {
            int sum = 1;
            if (PictureSelectorActivity.this.mCurrentCatalog.isEmpty()) {
                for (String key : PictureSelectorActivity.this.mItemMap.keySet()) {
                    List mediaItems = (List)PictureSelectorActivity.this.mItemMap.get(key);
                    if (mediaItems == null) continue;
                    sum += mediaItems.size();
                }
            } else {
                List mediaItems = (List)PictureSelectorActivity.this.mItemMap.get(PictureSelectorActivity.this.mCurrentCatalog);
                if (mediaItems != null) {
                    sum += mediaItems.size();
                }
            }
            return sum;
        }

        public Object getItem(int position) {
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        @TargetApi(value=23)
        public View getView(final int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (position == 0) {
                View view = this.mInflater.inflate(R.layout.rc_picsel_grid_camera, parent, false);
                ImageButton mask = (ImageButton)view.findViewById(R.id.camera_mask);
                mask.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        String[] permissions = new String[]{"android.permission.CAMERA"};
                        if (!PermissionCheckUtil.checkPermissions((Context)PictureSelectorActivity.this, permissions)) {
                            PermissionCheckUtil.requestPermissions((Activity)PictureSelectorActivity.this, permissions, 100);
                            return;
                        }
                        PictureSelectorActivity.this.requestCamera();
                    }
                });
                return view;
            }
            final MediaItem item = PictureSelectorActivity.this.mCurrentCatalog.isEmpty() ? (MediaItem)PictureSelectorActivity.this.mAllItemList.get(position - 1) : PictureSelectorActivity.this.getItemAt(PictureSelectorActivity.this.mCurrentCatalog, position - 1);
            View view = convertView;
            if (view == null || view.getTag() == null) {
                view = this.mInflater.inflate(R.layout.rc_picsel_grid_item, parent, false);
                holder = new ViewHolder();
                holder.image = (ImageView)view.findViewById(R.id.image);
                holder.mask = view.findViewById(R.id.mask);
                holder.checkBox = (SelectBox)view.findViewById(R.id.checkbox);
                holder.videoContainer = view.findViewById(R.id.video_container);
                holder.videoDuration = (TextView)view.findViewById(R.id.video_duration);
                view.setTag((Object)holder);
            } else {
                holder = (ViewHolder)view.getTag();
            }
            if (holder.image.getTag() != null) {
                String path = (String)holder.image.getTag();
                AlbumBitmapCacheHelper.getInstance().removePathFromShowlist(path);
            }
            String thumbImagePath = "";
            if (item == null) {
                return view;
            }
            switch (item.mediaType) {
                case 1: {
                    if (KitStorageUtils.isBuildAndTargetForQ((Context)PictureSelectorActivity.this)) {
                        thumbImagePath = item.uri_sdk29;
                        break;
                    }
                    thumbImagePath = item.uri;
                    break;
                }
                case 3: {
                    thumbImagePath = KitStorageUtils.getImageSavePath((Context)PictureSelectorActivity.this) + File.separator + item.name;
                    if (new File(thumbImagePath).exists()) break;
                    Runnable runnable = new Runnable(){

                        @Override
                        @RequiresApi(api=28)
                        public void run() {
                            Bitmap videoFrame = null;
                            if (KitStorageUtils.isBuildAndTargetForQ((Context)PictureSelectorActivity.this)) {
                                try {
                                    MediaMetadataRetriever media = new MediaMetadataRetriever();
                                    media.setDataSource(PictureSelectorActivity.this.getApplicationContext(), Uri.parse((String)item.uri_sdk29));
                                    videoFrame = media.getFrameAtTime();
                                }
                                catch (Exception e) {
                                    RLog.e((String)TAG, (String)"video get thumbnail error", (Throwable)e);
                                }
                            } else {
                                videoFrame = ThumbnailUtils.createVideoThumbnail((String)item.uri, (int)1);
                            }
                            if (videoFrame != null) {
                                final File captureImageFile = FileUtils.convertBitmap2File((Bitmap)videoFrame, (String)KitStorageUtils.getImageSavePath((Context)PictureSelectorActivity.this), (String)item.name);
                                PictureSelectorActivity.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        PictureSelectorActivity.this.setImageViewBackground(captureImageFile.getAbsolutePath(), holder.image, position);
                                    }
                                });
                            }
                        }
                    };
                    PictureSelectorActivity.this.pool.execute(runnable);
                    break;
                }
            }
            AlbumBitmapCacheHelper.getInstance().addPathToShowlist(thumbImagePath);
            holder.image.setTag((Object)thumbImagePath);
            PictureSelectorActivity.this.setImageViewBackground(thumbImagePath, holder.image, position);
            if (item.mediaType == 3) {
                holder.videoContainer.setVisibility(0);
                long minutes = TimeUnit.MILLISECONDS.toMinutes(item.duration);
                long seconds = TimeUnit.MILLISECONDS.toSeconds(item.duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(item.duration));
                holder.videoDuration.setText((CharSequence)String.format(Locale.CHINA, seconds < 10L ? "%d:0%d" : "%d:%d", minutes, seconds));
            } else {
                holder.videoContainer.setVisibility(8);
            }
            holder.checkBox.setChecked(item.selected);
            holder.checkBox.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (item.mediaType == 3) {
                        String[] videoTime;
                        if (TextUtils.isEmpty((CharSequence)holder.videoDuration.getText())) {
                            return;
                        }
                        int maxDuration = RongIMClient.getInstance().getVideoLimitTime();
                        if (maxDuration < 1) {
                            maxDuration = 300;
                        }
                        if (Integer.parseInt((videoTime = holder.videoDuration.getText().toString().split(":"))[0]) * 60 + Integer.parseInt(videoTime[1]) > maxDuration) {
                            new AlertDialog.Builder((Context)PictureSelectorActivity.this).setMessage((CharSequence)PictureSelectorActivity.this.getResources().getString(R.string.rc_picsel_selected_max_time_span_with_param, new Object[]{maxDuration / 60})).setPositiveButton(R.string.rc_confirm, null).setCancelable(false).create().show();
                            return;
                        }
                    }
                    if (item.uri.endsWith(".gif")) {
                        int length = RongIMClient.getInstance().getGIFLimitSize() * 1024;
                        File file = new File(item.uri);
                        if (file != null && file.exists() && file.length() > (long)length) {
                            new AlertDialog.Builder((Context)PictureSelectorActivity.this).setMessage((CharSequence)PictureSelectorActivity.this.getResources().getString(R.string.rc_picsel_selected_max_gif_size_span_with_param)).setPositiveButton(R.string.rc_confirm, null).setCancelable(false).create().show();
                            return;
                        }
                    }
                    if (!holder.checkBox.getChecked() && PictureSelectorActivity.this.getTotalSelectedNum() == 9) {
                        Toast.makeText((Context)PictureSelectorActivity.this, (int)R.string.rc_picsel_selected_max_pic_count, (int)0).show();
                        return;
                    }
                    holder.checkBox.setChecked(!holder.checkBox.getChecked());
                    item.selected = holder.checkBox.getChecked();
                    if (item.selected) {
                        PictureSelectorActivity.this.mAllSelectedItemList.add(Uri.parse((String)("file://" + item.uri)));
                        if (PicItemHolder.itemAllSelectedMediaItemList != null) {
                            PicItemHolder.itemAllSelectedMediaItemList.add(item);
                        }
                        holder.mask.setBackgroundColor(PictureSelectorActivity.this.getResources().getColor(R.color.rc_picsel_grid_mask_pressed));
                    } else {
                        try {
                            PictureSelectorActivity.this.mAllSelectedItemList.remove(Uri.parse((String)("file://" + item.uri)));
                        }
                        catch (Exception e) {
                            RLog.e((String)TAG, (String)"GridViewAdapter getView", (Throwable)e);
                        }
                        if (PicItemHolder.itemAllSelectedMediaItemList != null) {
                            PicItemHolder.itemAllSelectedMediaItemList.remove(item);
                        }
                        holder.mask.setBackgroundDrawable(PictureSelectorActivity.this.getResources().getDrawable(R.drawable.rc_sp_grid_mask));
                    }
                    PictureSelectorActivity.this.updateToolbar();
                }
            });
            if (item.selected) {
                holder.mask.setBackgroundColor(PictureSelectorActivity.this.getResources().getColor(R.color.rc_picsel_grid_mask_pressed));
            } else {
                holder.mask.setBackgroundDrawable(PictureSelectorActivity.this.getResources().getDrawable(R.drawable.rc_sp_grid_mask));
            }
            return view;
        }

        private class ViewHolder {
            ImageView image;
            View mask;
            SelectBox checkBox;
            View videoContainer;
            TextView videoDuration;

            private ViewHolder() {
            }
        }
    }

    static interface IExecutedCallback {
        public void executed();
    }
}

