/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.plugin.image;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.FileProvider;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.google.gson.Gson;
import io.rong.common.FileInfo;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongBaseNoActionbarActivity;
import io.rong.imkit.plugin.image.AlbumBitmapCacheHelper;
import io.rong.imkit.plugin.image.HackyViewPager;
import io.rong.imkit.plugin.image.PictureSelectorActivity;
import io.rong.imkit.utilities.KitStorageUtils;
import io.rong.imlib.RongIMClient;
import io.rong.subscaleview.ImageSource;
import io.rong.subscaleview.SubsamplingScaleImageView;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;

public class PicturePreviewActivity
extends RongBaseNoActionbarActivity {
    private static final String TAG = "PicturePreviewActivity";
    public static final int RESULT_SEND = 1;
    private TextView mIndexTotal;
    private View mWholeView;
    private View mToolbarTop;
    private View mToolbarBottom;
    private ImageButton mBtnBack;
    private Button mBtnSend;
    private CheckButton mUseOrigin;
    private CheckButton mSelectBox;
    private HackyViewPager mViewPager;
    private ArrayList<PictureSelectorActivity.MediaItem> mItemList;
    private ArrayList<PictureSelectorActivity.MediaItem> mItemSelectedList;
    private ArrayList<PictureSelectorActivity.MediaItem> mItemAllSelectedList;
    private int mCurrentIndex;

    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rc_picprev_activity);
        this.initView();
        this.mUseOrigin.setChecked(this.getIntent().getBooleanExtra("sendOrigin", false));
        this.mCurrentIndex = this.getIntent().getIntExtra("index", 0);
        if (this.mItemList == null) {
            this.mItemList = PictureSelectorActivity.PicItemHolder.itemList;
            this.mItemSelectedList = PictureSelectorActivity.PicItemHolder.itemSelectedList;
            this.mItemAllSelectedList = PictureSelectorActivity.PicItemHolder.itemAllSelectedMediaItemList;
        }
        if (this.mItemList == null) {
            RLog.e((String)TAG, (String)"Itemlist is null");
            return;
        }
        this.mIndexTotal.setText((CharSequence)String.format("%d/%d", this.mCurrentIndex + 1, this.mItemList.size()));
        if (Build.VERSION.SDK_INT >= 11) {
            this.mWholeView.setSystemUiVisibility(1024);
            int margin = PicturePreviewActivity.getSmartBarHeight((Context)this);
            if (margin > 0) {
                RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mToolbarBottom.getLayoutParams();
                lp.setMargins(0, 0, 0, margin);
                this.mToolbarBottom.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
        int result = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.getResources().getDimensionPixelSize(resourceId);
        }
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(this.mToolbarTop.getLayoutParams());
        lp.setMargins(0, result, 0, 0);
        this.mToolbarTop.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.mBtnBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent();
                intent.putExtra("sendOrigin", PicturePreviewActivity.this.mUseOrigin.getChecked());
                PicturePreviewActivity.this.setResult(-1, intent);
                PicturePreviewActivity.this.finish();
            }
        });
        this.mBtnSend.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean result;
                String filePath;
                String fileName;
                LinkedHashMap<String, Integer> mLinkedHashMap = new LinkedHashMap<String, Integer>();
                if (PicturePreviewActivity.this.mItemSelectedList != null) {
                    for (PictureSelectorActivity.MediaItem item : PicturePreviewActivity.this.mItemSelectedList) {
                        if (!item.selected) continue;
                        if (KitStorageUtils.isBuildAndTargetForQ(PicturePreviewActivity.this.getApplicationContext())) {
                            fileName = FileUtils.getFileNameWithPath((String)item.uri);
                            filePath = item.mediaType == 1 ? KitStorageUtils.getImageSavePath(PicturePreviewActivity.this.getApplicationContext()) + File.separator + fileName : (item.mediaType == 3 ? KitStorageUtils.getVideoSavePath(PicturePreviewActivity.this.getApplicationContext()) + File.separator + fileName : KitStorageUtils.getFileSavePath(PicturePreviewActivity.this.getApplicationContext()) + File.separator + fileName);
                            result = FileUtils.copyFile((Context)v.getContext(), (Uri)Uri.parse((String)item.uri_sdk29), (String)filePath);
                            if (!result) continue;
                            mLinkedHashMap.put("file://" + filePath, item.mediaType);
                            continue;
                        }
                        mLinkedHashMap.put("file://" + item.uri, item.mediaType);
                    }
                }
                for (PictureSelectorActivity.MediaItem item : PicturePreviewActivity.this.mItemList) {
                    if (!item.selected) continue;
                    if (KitStorageUtils.isBuildAndTargetForQ(PicturePreviewActivity.this.getApplicationContext())) {
                        fileName = FileUtils.getFileNameWithPath((String)item.uri);
                        filePath = item.mediaType == 1 ? KitStorageUtils.getImageSavePath(PicturePreviewActivity.this.getApplicationContext()) + File.separator + fileName : (item.mediaType == 3 ? KitStorageUtils.getVideoSavePath(PicturePreviewActivity.this.getApplicationContext()) + File.separator + fileName : KitStorageUtils.getFileSavePath(PicturePreviewActivity.this.getApplicationContext()) + File.separator + fileName);
                        result = FileUtils.copyFile((Context)PicturePreviewActivity.this.getApplicationContext(), (Uri)Uri.parse((String)item.uri_sdk29), (String)filePath);
                        if (!result) continue;
                        mLinkedHashMap.put("file://" + filePath, item.mediaType);
                        continue;
                    }
                    mLinkedHashMap.put("file://" + item.uri, item.mediaType);
                }
                Gson gson = new Gson();
                String mediaList = gson.toJson(mLinkedHashMap);
                Intent data = new Intent();
                data.putExtra("sendOrigin", PicturePreviewActivity.this.mUseOrigin.getChecked());
                data.putExtra("android.intent.extra.RETURN_RESULT", mediaList);
                PicturePreviewActivity.this.setResult(1, data);
                PicturePreviewActivity.this.finish();
            }
        });
        this.mUseOrigin.setText(R.string.rc_picprev_origin);
        this.mUseOrigin.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PictureSelectorActivity.MediaItem item = (PictureSelectorActivity.MediaItem)PicturePreviewActivity.this.mItemList.get(PicturePreviewActivity.this.mCurrentIndex);
                if (item.uri.endsWith(".gif")) {
                    int length = RongIMClient.getInstance().getGIFLimitSize() * 1024;
                    File file = new File(item.uri);
                    if (file != null && file.exists() && file.length() > (long)length) {
                        new AlertDialog.Builder((Context)PicturePreviewActivity.this).setMessage((CharSequence)PicturePreviewActivity.this.getResources().getString(R.string.rc_picsel_selected_max_gif_size_span_with_param)).setPositiveButton(R.string.rc_confirm, null).setCancelable(false).create().show();
                        return;
                    }
                }
                PicturePreviewActivity.this.mUseOrigin.setChecked(!PicturePreviewActivity.this.mUseOrigin.getChecked());
                if (PicturePreviewActivity.this.mUseOrigin.getChecked() && PicturePreviewActivity.this.getTotalSelectedNum() == 0) {
                    PicturePreviewActivity.this.mSelectBox.setChecked(!PicturePreviewActivity.this.mSelectBox.getChecked());
                    ((PictureSelectorActivity.MediaItem)((PicturePreviewActivity)PicturePreviewActivity.this).mItemList.get((int)((PicturePreviewActivity)PicturePreviewActivity.this).mCurrentIndex)).selected = PicturePreviewActivity.this.mSelectBox.getChecked();
                    PicturePreviewActivity.this.updateToolbar();
                }
            }
        });
        this.mSelectBox.setText(R.string.rc_picprev_select);
        this.mSelectBox.setChecked(this.mItemList.get((int)this.mCurrentIndex).selected);
        this.mSelectBox.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PictureSelectorActivity.MediaItem item = (PictureSelectorActivity.MediaItem)PicturePreviewActivity.this.mItemList.get(PicturePreviewActivity.this.mCurrentIndex);
                if (item.mediaType == 3) {
                    int maxDuration = RongIMClient.getInstance().getVideoLimitTime();
                    if (maxDuration < 1) {
                        maxDuration = 300;
                    }
                    if (TimeUnit.MILLISECONDS.toSeconds(item.duration) > (long)maxDuration) {
                        new AlertDialog.Builder((Context)PicturePreviewActivity.this).setMessage((CharSequence)PicturePreviewActivity.this.getResources().getString(R.string.rc_picsel_selected_max_time_span_with_param, new Object[]{maxDuration / 60})).setPositiveButton(R.string.rc_confirm, null).setCancelable(false).create().show();
                        return;
                    }
                }
                if (item.uri.endsWith(".gif")) {
                    int length = RongIMClient.getInstance().getGIFLimitSize() * 1024;
                    File file = new File(item.uri);
                    if (file != null && file.exists() && file.length() > (long)length) {
                        new AlertDialog.Builder((Context)PicturePreviewActivity.this).setMessage((CharSequence)PicturePreviewActivity.this.getResources().getString(R.string.rc_picsel_selected_max_gif_size_span_with_param)).setPositiveButton(R.string.rc_confirm, null).setCancelable(false).create().show();
                        return;
                    }
                }
                if (!PicturePreviewActivity.this.mSelectBox.getChecked() && PicturePreviewActivity.this.getTotalSelectedNum() == 9) {
                    Toast.makeText((Context)PicturePreviewActivity.this, (int)R.string.rc_picsel_selected_max_pic_count, (int)0).show();
                    return;
                }
                PicturePreviewActivity.this.mSelectBox.setChecked(!PicturePreviewActivity.this.mSelectBox.getChecked());
                ((PictureSelectorActivity.MediaItem)((PicturePreviewActivity)PicturePreviewActivity.this).mItemList.get((int)((PicturePreviewActivity)PicturePreviewActivity.this).mCurrentIndex)).selected = PicturePreviewActivity.this.mSelectBox.getChecked();
                if (PicturePreviewActivity.this.mItemAllSelectedList != null) {
                    if (PicturePreviewActivity.this.mSelectBox.getChecked()) {
                        PicturePreviewActivity.this.mItemAllSelectedList.add(PicturePreviewActivity.this.mItemList.get(PicturePreviewActivity.this.mCurrentIndex));
                    } else {
                        PicturePreviewActivity.this.mItemAllSelectedList.remove(PicturePreviewActivity.this.mItemList.get(PicturePreviewActivity.this.mCurrentIndex));
                    }
                } else {
                    RLog.e((String)PicturePreviewActivity.TAG, (String)"mItemAllSelectedList is null");
                }
                PicturePreviewActivity.this.updateToolbar();
            }
        });
        this.mViewPager.setAdapter(new PreviewAdapter());
        this.mViewPager.setCurrentItem(this.mCurrentIndex);
        this.mViewPager.setOffscreenPageLimit(1);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                PicturePreviewActivity.this.mCurrentIndex = position;
                PicturePreviewActivity.this.mIndexTotal.setText((CharSequence)String.format("%d/%d", position + 1, PicturePreviewActivity.this.mItemList.size()));
                PicturePreviewActivity.this.mSelectBox.setChecked(((PictureSelectorActivity.MediaItem)((PicturePreviewActivity)PicturePreviewActivity.this).mItemList.get((int)position)).selected);
                PictureSelectorActivity.MediaItem mediaItem = (PictureSelectorActivity.MediaItem)PicturePreviewActivity.this.mItemList.get(position);
                PicturePreviewActivity.this.updateToolbar();
                if (mediaItem.mediaType == 3) {
                    PicturePreviewActivity.this.mUseOrigin.rootView.setVisibility(8);
                } else {
                    PicturePreviewActivity.this.mUseOrigin.rootView.setVisibility(0);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.updateToolbar();
    }

    private void initView() {
        this.mToolbarTop = this.findViewById(R.id.toolbar_top);
        this.mIndexTotal = (TextView)this.findViewById(R.id.index_total);
        this.mBtnBack = (ImageButton)this.findViewById(R.id.back);
        this.mBtnSend = (Button)this.findViewById(R.id.send);
        this.mWholeView = this.findViewById(R.id.whole_layout);
        this.mViewPager = (HackyViewPager)this.findViewById(R.id.viewpager);
        this.mToolbarBottom = this.findViewById(R.id.toolbar_bottom);
        this.mUseOrigin = new CheckButton(this.findViewById(R.id.origin_check), R.drawable.rc_origin_check_nor, R.drawable.rc_origin_check_sel);
        this.mSelectBox = new CheckButton(this.findViewById(R.id.select_check), R.drawable.rc_select_check_nor, R.drawable.rc_select_check_sel);
    }

    protected void onResume() {
        super.onResume();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            Intent intent = new Intent();
            intent.putExtra("sendOrigin", this.mUseOrigin.getChecked());
            this.setResult(-1, intent);
        }
        return super.onKeyDown(keyCode, event);
    }

    private int getTotalSelectedNum() {
        int sum = 0;
        for (int i = 0; i < this.mItemList.size(); ++i) {
            if (!this.mItemList.get((int)i).selected) continue;
            ++sum;
        }
        if (this.mItemSelectedList != null) {
            sum += this.mItemSelectedList.size();
        }
        return sum;
    }

    private String getTotalSelectedSize() {
        File file;
        int i;
        float size = 0.0f;
        for (i = 0; i < this.mItemList.size(); ++i) {
            if (!this.mItemList.get((int)i).selected) continue;
            file = new File(this.mItemList.get((int)i).uri);
            size += (float)file.length() / 1024.0f;
        }
        if (this.mItemSelectedList != null) {
            for (i = 0; i < this.mItemSelectedList.size(); ++i) {
                if (!this.mItemSelectedList.get((int)i).selected) continue;
                file = new File(this.mItemSelectedList.get((int)i).uri);
                size += (float)file.length() / 1024.0f;
            }
        }
        String totalSize = size < 1024.0f ? String.format("%.0fK", Float.valueOf(size)) : String.format("%.1fM", Float.valueOf(size / 1024.0f));
        return totalSize;
    }

    private String getSelectedSize(int index) {
        float size = 0.0f;
        if (this.mItemList != null && this.mItemList.size() > 0) {
            long maxSize = 0L;
            if (KitStorageUtils.isBuildAndTargetForQ((Context)this)) {
                FileInfo fileInfo = FileUtils.getFileInfoByUri((Context)this, (Uri)Uri.parse((String)this.mItemList.get((int)index).uri_sdk29));
                if (fileInfo != null) {
                    maxSize = fileInfo.getSize();
                }
            } else {
                maxSize = new File(this.mItemList.get((int)index).uri).length();
            }
            size = (float)maxSize / 1024.0f;
        }
        String returnSize = size < 1024.0f ? String.format("%.0fK", Float.valueOf(size)) : String.format("%.1fM", Float.valueOf(size / 1024.0f));
        return returnSize;
    }

    private void updateToolbar() {
        int selNum = this.getTotalSelectedNum();
        if (this.mItemList.size() == 1 && selNum == 0) {
            this.mBtnSend.setText(R.string.rc_picsel_toolbar_send);
            this.mUseOrigin.setText(R.string.rc_picprev_origin);
            this.mBtnSend.setEnabled(false);
            this.mBtnSend.setTextColor(this.getResources().getColor(R.color.rc_picsel_toolbar_send_text_disable));
            return;
        }
        if (selNum == 0) {
            this.mBtnSend.setText(R.string.rc_picsel_toolbar_send);
            this.mUseOrigin.setText(R.string.rc_picprev_origin);
            this.mUseOrigin.setChecked(false);
            this.mBtnSend.setEnabled(false);
            this.mBtnSend.setTextColor(this.getResources().getColor(R.color.rc_picsel_toolbar_send_text_disable));
        } else if (selNum <= 9) {
            this.mBtnSend.setEnabled(true);
            this.mBtnSend.setTextColor(this.getResources().getColor(R.color.rc_picsel_toolbar_send_text_normal));
            this.mBtnSend.setText((CharSequence)String.format(this.getResources().getString(R.string.rc_picsel_toolbar_send_num), selNum));
        }
        this.mUseOrigin.setText(String.format(this.getResources().getString(R.string.rc_picprev_origin_size), this.getSelectedSize(this.mCurrentIndex)));
        PictureSelectorActivity.MediaItem mediaItem = this.mItemList.get(this.mCurrentIndex);
        if (mediaItem.mediaType == 3) {
            this.mUseOrigin.rootView.setVisibility(8);
        } else {
            this.mUseOrigin.rootView.setVisibility(0);
        }
    }

    @TargetApi(value=11)
    public static int getSmartBarHeight(Context context) {
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object obj = c.newInstance();
            Field field = c.getField("mz_action_button_min_height");
            int height = Integer.parseInt(field.get(obj).toString());
            return context.getResources().getDimensionPixelSize(height);
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"getSmartBarHeight", (Throwable)e);
            return 0;
        }
    }

    public int readPictureDegree(String path, Context context) {
        return FileUtils.readPictureDegree((Context)context, (String)path);
    }

    private String formatSize(long length) {
        if (length > 0x100000L) {
            float size = (float)Math.round((float)length / 1048576.0f * 100.0f) / 100.0f;
            return size + "M";
        }
        if (length > 1024L) {
            float size = (float)Math.round((float)length / 1024.0f * 100.0f) / 100.0f;
            return size + "KB";
        }
        return length + "B";
    }

    private class PreviewAdapter
    extends PagerAdapter {
        private PreviewAdapter() {
        }

        public int getCount() {
            return PicturePreviewActivity.this.mItemList.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        @RequiresApi(api=28)
        public Object instantiateItem(ViewGroup container, int position) {
            String imagePath;
            final PictureSelectorActivity.MediaItem mediaItem = (PictureSelectorActivity.MediaItem)PicturePreviewActivity.this.mItemList.get(position);
            View view = LayoutInflater.from((Context)container.getContext()).inflate(R.layout.rc_picsel_preview, container, false);
            SubsamplingScaleImageView subsamplingScaleImageView = (SubsamplingScaleImageView)view.findViewById(R.id.rc_photoView);
            ImageView gifview = (ImageView)view.findViewById(R.id.rc_gifview);
            ImageButton playButton = (ImageButton)view.findViewById(R.id.rc_play_video);
            container.addView(view, -1, -1);
            if (mediaItem.mediaType == 3) {
                imagePath = KitStorageUtils.getImageSavePath((Context)PicturePreviewActivity.this) + File.separator + mediaItem.name;
                if (!new File(imagePath).exists()) {
                    Bitmap videoFrame = null;
                    if (KitStorageUtils.isBuildAndTargetForQ(PicturePreviewActivity.this.getApplicationContext())) {
                        try {
                            ParcelFileDescriptor pfd = PicturePreviewActivity.this.getApplicationContext().getContentResolver().openFileDescriptor(Uri.parse((String)mediaItem.uri_sdk29), "r");
                            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
                            retriever.setDataSource(pfd.getFileDescriptor());
                            videoFrame = retriever.getFrameAtIndex(0);
                        }
                        catch (IOException e) {
                            RLog.e((String)PicturePreviewActivity.TAG, (String)"instantiateItem Q is error");
                        }
                    } else {
                        videoFrame = ThumbnailUtils.createVideoThumbnail((String)mediaItem.uri, (int)1);
                    }
                    imagePath = videoFrame != null ? FileUtils.convertBitmap2File((Bitmap)videoFrame, (String)KitStorageUtils.getImageSavePath((Context)PicturePreviewActivity.this), (String)mediaItem.name).toString() : "";
                }
                playButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Intent intent = new Intent("android.intent.action.VIEW");
                        if (Build.VERSION.SDK_INT >= 24) {
                            intent.setFlags(0x14000000);
                            Uri uri = FileProvider.getUriForFile((Context)v.getContext(), (String)(v.getContext().getPackageName() + v.getContext().getResources().getString(R.string.rc_authorities_fileprovider)), (File)new File(mediaItem.uri));
                            if (KitStorageUtils.isBuildAndTargetForQ(PicturePreviewActivity.this.getApplicationContext())) {
                                intent.setDataAndType(Uri.parse((String)mediaItem.uri_sdk29), mediaItem.mimeType);
                            } else {
                                intent.setDataAndType(uri, mediaItem.mimeType);
                            }
                            intent.addFlags(1);
                        } else {
                            intent.setDataAndType(Uri.parse((String)("file://" + mediaItem.uri)), mediaItem.mimeType);
                        }
                        PicturePreviewActivity.this.startActivity(intent);
                    }
                });
                playButton.setVisibility(0);
                subsamplingScaleImageView.setImage(ImageSource.uri(imagePath));
                gifview.setVisibility(8);
                subsamplingScaleImageView.setOrientation(PicturePreviewActivity.this.readPictureDegree(imagePath, container.getContext()));
            } else {
                playButton.setVisibility(8);
                imagePath = KitStorageUtils.isBuildAndTargetForQ(PicturePreviewActivity.this.getApplicationContext()) ? ((PictureSelectorActivity.MediaItem)((PicturePreviewActivity)PicturePreviewActivity.this).mItemList.get((int)position)).uri_sdk29 : ((PictureSelectorActivity.MediaItem)((PicturePreviewActivity)PicturePreviewActivity.this).mItemList.get((int)position)).uri;
                if (((PictureSelectorActivity.MediaItem)((PicturePreviewActivity)PicturePreviewActivity.this).mItemList.get((int)position)).uri.endsWith(".gif")) {
                    gifview.setVisibility(0);
                    Glide.with((FragmentActivity)PicturePreviewActivity.this).asGif().load(imagePath).into(gifview);
                } else {
                    gifview.setVisibility(8);
                    subsamplingScaleImageView.setImage(ImageSource.uri(imagePath));
                    subsamplingScaleImageView.setOrientation(PicturePreviewActivity.this.readPictureDegree(imagePath, container.getContext()));
                }
            }
            AlbumBitmapCacheHelper.getInstance().removePathFromShowlist(imagePath);
            AlbumBitmapCacheHelper.getInstance().addPathToShowlist(imagePath);
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
        }
    }

    private static class CheckButton {
        private View rootView;
        private ImageView image;
        private TextView text;
        private boolean checked = false;
        private int nor_resId;
        private int sel_resId;

        public CheckButton(View root, @DrawableRes int norId, @DrawableRes int selId) {
            this.rootView = root;
            this.image = (ImageView)root.findViewById(R.id.image);
            this.text = (TextView)root.findViewById(R.id.text);
            this.nor_resId = norId;
            this.sel_resId = selId;
            this.image.setImageResource(this.nor_resId);
        }

        public void setChecked(boolean check) {
            this.checked = check;
            this.image.setImageResource(this.checked ? this.sel_resId : this.nor_resId);
        }

        public boolean getChecked() {
            return this.checked;
        }

        public void setText(int resId) {
            this.text.setText(resId);
        }

        public void setText(CharSequence chars) {
            this.text.setText(chars);
        }

        public void setOnClickListener(@Nullable View.OnClickListener l) {
            this.rootView.setOnClickListener(l);
        }

        public void setSelectButtonVisibility(int visibility) {
            this.image.setVisibility(visibility);
        }
    }
}

