/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.plugin.image;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.support.annotation.RequiresApi;
import android.support.v4.util.LruCache;
import android.util.Log;
import android.view.WindowManager;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imkit.utilities.KitStorageUtils;
import io.rong.imkit.utilities.RongUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AlbumBitmapCacheHelper {
    private static final String TAG = "AlbumBitmapCacheHelper";
    private static volatile AlbumBitmapCacheHelper instance = null;
    private LruCache<String, Bitmap> cache;
    private static int cacheSize;
    private ArrayList<String> currentShowString;
    private Context mContext;
    ThreadPoolExecutor tpe = new ThreadPoolExecutor(2, 5, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    private AlbumBitmapCacheHelper() {
        this.cache = new LruCache<String, Bitmap>(cacheSize){

            protected int sizeOf(String key, Bitmap value) {
                int result = Build.VERSION.SDK_INT >= 19 ? value.getAllocationByteCount() : (Build.VERSION.SDK_INT >= 12 ? value.getByteCount() : value.getRowBytes() * value.getHeight());
                return result;
            }
        };
        this.currentShowString = new ArrayList();
    }

    public void releaseAllSizeCache() {
        this.cache.evictAll();
        this.cache.resize(1);
    }

    public void releaseHalfSizeCache() {
        this.cache.resize((int)(Runtime.getRuntime().maxMemory() / 1024L / 8L));
    }

    public void resizeCache() {
        this.cache.resize((int)(Runtime.getRuntime().maxMemory() / 1024L / 4L));
    }

    private void clearCache() {
        this.cache.evictAll();
        this.cache = null;
        this.tpe = null;
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlbumBitmapCacheHelper getInstance() {
        if (instance != null) return instance;
        Class<AlbumBitmapCacheHelper> clazz = AlbumBitmapCacheHelper.class;
        synchronized (AlbumBitmapCacheHelper.class) {
            if (instance != null) return instance;
            instance = new AlbumBitmapCacheHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void init(Context context) {
        RLog.d((String)TAG, (String)"init");
        cacheSize = AlbumBitmapCacheHelper.calculateMemoryCacheSize(context);
        AlbumBitmapCacheHelper helper = AlbumBitmapCacheHelper.getInstance();
        helper.mContext = context.getApplicationContext();
    }

    public void uninit() {
        RLog.d((String)TAG, (String)"uninit");
        this.tpe.shutdownNow();
        this.clearCache();
    }

    public Bitmap getBitmap(String path, int width, int height, ILoadImageCallback callback, Object ... objects) {
        Bitmap bitmap = this.getBitmapFromCache(path, width, height);
        if (bitmap != null) {
            Log.e((String)TAG, (String)"getBitmap from cache");
        } else {
            this.decodeBitmapFromPath(path, width, height, callback, objects);
        }
        return bitmap;
    }

    private void decodeBitmapFromPath(final String path, final int width, final int height, final ILoadImageCallback callback, final Object ... objects) throws OutOfMemoryError {
        final Handler handler = new Handler(){

            public void handleMessage(Message msg) {
                if (callback != null) {
                    callback.onLoadImageCallBack((Bitmap)msg.obj, path, objects);
                }
            }
        };
        this.tpe.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!AlbumBitmapCacheHelper.this.currentShowString.contains(path) || AlbumBitmapCacheHelper.this.cache == null) {
                    return;
                }
                Bitmap bitmap = null;
                if (width == 0 || height == 0) {
                    try {
                        bitmap = AlbumBitmapCacheHelper.this.getBitmap(path, width, height);
                    }
                    catch (OutOfMemoryError e) {
                        RLog.e((String)AlbumBitmapCacheHelper.TAG, (String)"decodeBitmapFromPath", (Throwable)e);
                    }
                } else {
                    String hash = RongUtils.md5(path + "_" + width + "_" + height);
                    String tempPath = FileUtils.getInternalCachePath((Context)AlbumBitmapCacheHelper.this.mContext, (String)"image") + "/" + hash + ".temp";
                    File picFile = new File(path);
                    File tempFile = new File(tempPath);
                    if (tempFile.exists() && picFile.lastModified() <= tempFile.lastModified()) {
                        bitmap = BitmapFactory.decodeFile((String)tempPath);
                    }
                    if (bitmap == null) {
                        try {
                            bitmap = AlbumBitmapCacheHelper.this.getBitmap(path, width, height);
                        }
                        catch (OutOfMemoryError e) {
                            bitmap = null;
                        }
                        if (bitmap != null && AlbumBitmapCacheHelper.this.cache != null) {
                            bitmap = AlbumBitmapCacheHelper.centerSquareScaleBitmap(bitmap, bitmap.getWidth() > bitmap.getHeight() ? bitmap.getHeight() : bitmap.getWidth());
                        }
                        if (bitmap != null) {
                            FileOutputStream fos = null;
                            try {
                                File file = new File(tempPath);
                                if (!file.exists()) {
                                    file.createNewFile();
                                } else {
                                    file.delete();
                                    file.createNewFile();
                                }
                                fos = new FileOutputStream(file);
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
                                fos.write(baos.toByteArray());
                                fos.flush();
                            }
                            catch (FileNotFoundException e) {
                                RLog.e((String)AlbumBitmapCacheHelper.TAG, (String)"decodeBitmapFromPath", (Throwable)e);
                            }
                            catch (IOException e) {
                                RLog.e((String)AlbumBitmapCacheHelper.TAG, (String)"decodeBitmapFromPath", (Throwable)e);
                            }
                            finally {
                                if (fos != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (IOException e) {
                                        RLog.e((String)AlbumBitmapCacheHelper.TAG, (String)"decodeBitmapFromPath", (Throwable)e);
                                    }
                                }
                            }
                        }
                    } else if (AlbumBitmapCacheHelper.this.cache != null) {
                        bitmap = AlbumBitmapCacheHelper.centerSquareScaleBitmap(bitmap, bitmap.getWidth() > bitmap.getHeight() ? bitmap.getHeight() : bitmap.getWidth());
                    }
                }
                if (bitmap != null && AlbumBitmapCacheHelper.this.cache != null) {
                    AlbumBitmapCacheHelper.this.cache.put((Object)(path + "_" + width + "_" + height), (Object)bitmap);
                }
                Message msg = Message.obtain();
                msg.obj = bitmap;
                handler.sendMessage(msg);
            }
        });
    }

    public static Bitmap centerSquareScaleBitmap(Bitmap bitmap, int edgeLength) {
        if (null == bitmap || edgeLength <= 0) {
            return null;
        }
        Bitmap result = bitmap;
        int widthOrg = bitmap.getWidth();
        int heightOrg = bitmap.getHeight();
        int xTopLeft = (widthOrg - edgeLength) / 2;
        int yTopLeft = (heightOrg - edgeLength) / 2;
        if (xTopLeft == 0 && yTopLeft == 0) {
            return result;
        }
        try {
            result = Bitmap.createBitmap((Bitmap)bitmap, (int)xTopLeft, (int)yTopLeft, (int)edgeLength, (int)edgeLength);
            if (!bitmap.isRecycled()) {
                bitmap.recycle();
            }
        }
        catch (OutOfMemoryError e) {
            return result;
        }
        return result;
    }

    private int computeScale(BitmapFactory.Options options, int width, int height) {
        int scale;
        if (options == null) {
            return 1;
        }
        int widthScale = (int)((float)options.outWidth / (float)width);
        int heightScale = (int)((float)options.outHeight / (float)height);
        int n = scale = widthScale > heightScale ? widthScale : heightScale;
        if (scale < 1) {
            scale = 1;
        }
        return scale;
    }

    private Bitmap getBitmapFromCache(String path, int width, int height) {
        return (Bitmap)this.cache.get((Object)(path + "_" + width + "_" + height));
    }

    public void addPathToShowlist(String path) {
        this.currentShowString.add(path);
    }

    public void removePathFromShowlist(String path) {
        this.currentShowString.remove(path);
    }

    @RequiresApi(api=24)
    private Bitmap getBitmap(String path, int widthLimit, int heightLimit) throws OutOfMemoryError {
        Bitmap bitmap = null;
        try {
            int sampleSize;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            ExifInterface exifInterface = null;
            if (KitStorageUtils.isBuildAndTargetForQ(this.mContext)) {
                if (!FileUtils.uriStartWithContent((Uri)Uri.parse((String)path))) {
                    exifInterface = new ExifInterface(path);
                } else {
                    ParcelFileDescriptor pfd = this.mContext.getContentResolver().openFileDescriptor(Uri.parse((String)path), "r");
                    exifInterface = new ExifInterface(pfd.getFileDescriptor());
                }
            } else {
                exifInterface = new ExifInterface(path);
            }
            int orientation = exifInterface.getAttributeInt("Orientation", 0);
            if (widthLimit == 0 && heightLimit == 0) {
                sampleSize = this.computeScale(options, ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getWidth(), ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getHeight());
                RLog.d((String)TAG, (String)("sampleSize:" + sampleSize));
            } else {
                if (orientation == 6 || orientation == 8 || orientation == 5 || orientation == 7) {
                    int tmp = widthLimit;
                    widthLimit = heightLimit;
                    heightLimit = tmp;
                }
                sampleSize = this.computeScale(options, widthLimit, heightLimit);
                RLog.d((String)TAG, (String)("sampleSize:" + sampleSize));
            }
            try {
                options = new BitmapFactory.Options();
                options.inJustDecodeBounds = false;
                options.inSampleSize = sampleSize;
                if (KitStorageUtils.isBuildAndTargetForQ(this.mContext)) {
                    if (!FileUtils.uriStartWithContent((Uri)Uri.parse((String)path))) {
                        bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                    } else {
                        ParcelFileDescriptor pfd = this.mContext.getContentResolver().openFileDescriptor(Uri.parse((String)path), "r");
                        bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)pfd.getFileDescriptor(), null, (BitmapFactory.Options)options);
                    }
                } else {
                    bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                }
            }
            catch (OutOfMemoryError e) {
                RLog.e((String)TAG, (String)"getBitmap", (Throwable)e);
                options.inSampleSize <<= 1;
                if (KitStorageUtils.isBuildAndTargetForQ(this.mContext)) {
                    String imageDirPath = KitStorageUtils.getImageSavePath(this.mContext);
                    if (path.startsWith(imageDirPath)) {
                        bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                    } else {
                        ParcelFileDescriptor pfd = this.mContext.getContentResolver().openFileDescriptor(Uri.parse((String)path), "r");
                        bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)pfd.getFileDescriptor(), null, (BitmapFactory.Options)options);
                    }
                }
                bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
            }
            Matrix matrix = new Matrix();
            if (bitmap != null) {
                int w = bitmap.getWidth();
                int h = bitmap.getHeight();
                if (orientation == 6 || orientation == 8 || orientation == 5 || orientation == 7) {
                    int tmp = w;
                    w = h;
                    h = tmp;
                }
                switch (orientation) {
                    case 6: {
                        matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                        break;
                    }
                    case 3: {
                        matrix.setRotate(180.0f, (float)w / 2.0f, (float)h / 2.0f);
                        break;
                    }
                    case 8: {
                        matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                        break;
                    }
                    case 2: {
                        matrix.preScale(-1.0f, 1.0f);
                        break;
                    }
                    case 4: {
                        matrix.preScale(1.0f, -1.0f);
                        break;
                    }
                    case 5: {
                        matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                        matrix.preScale(1.0f, -1.0f);
                        break;
                    }
                    case 7: {
                        matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                        matrix.preScale(1.0f, -1.0f);
                    }
                }
                if (widthLimit == 0 || heightLimit == 0) {
                    RLog.e((String)TAG, (String)"widthLimit or heightLimit is 0");
                } else {
                    float xS = (float)widthLimit / (float)bitmap.getWidth();
                    float yS = (float)heightLimit / (float)bitmap.getHeight();
                    matrix.postScale(Math.min(xS, yS), Math.min(xS, yS));
                }
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            }
        }
        catch (IOException e) {
            RLog.e((String)TAG, (String)"getBitmap", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            RLog.e((String)TAG, (String)"getBitmap", (Throwable)e);
        }
        return bitmap;
    }

    private static int calculateMemoryCacheSize(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        boolean largeHeap = (context.getApplicationInfo().flags & 0x100000) != 0;
        int memoryClass = am.getMemoryClass();
        if (largeHeap) {
            memoryClass = am.getLargeMemoryClass();
        }
        return (int)(0x100000L * (long)memoryClass / 8L);
    }

    public static interface ILoadImageCallback {
        public void onLoadImageCallBack(Bitmap var1, String var2, Object ... var3);
    }
}

