/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.plugin;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.widget.Toast;
import io.rong.imkit.R;
import io.rong.imkit.RongExtension;
import io.rong.imkit.plugin.IPluginModule;
import io.rong.imkit.plugin.location.AMapRealTimeActivity;
import io.rong.imkit.plugin.location.AMapRealTimeActivity2D;
import io.rong.imkit.plugin.location.LocationManager;
import io.rong.imkit.plugin.location.LocationManager2D;

public class RealTimeLocationPlugin
implements IPluginModule {
    @Override
    public Drawable obtainDrawable(Context context) {
        return ContextCompat.getDrawable((Context)context, (int)R.drawable.rc_ext_plugin_location_selector);
    }

    @Override
    public String obtainTitle(Context context) {
        return context.getString(R.string.rc_plugin_location_sharing);
    }

    @Override
    public void onClick(Fragment currentFragment, RongExtension extension) {
        if (currentFragment.getActivity() == null) {
            return;
        }
        int perCoarse = currentFragment.getActivity().checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION");
        int perFine = currentFragment.getActivity().checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION");
        int perNetwork = currentFragment.getActivity().checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE");
        if (perCoarse == -1 || perFine == -1 || perNetwork == -1) {
            Toast.makeText((Context)currentFragment.getActivity(), (CharSequence)currentFragment.getActivity().getResources().getString(R.string.rc_ext_location_permission_failed), (int)0).show();
            return;
        }
        int result = extension.getContext().getResources().getBoolean(R.bool.rc_location_2D) ? LocationManager2D.getInstance().joinLocationSharing() : LocationManager.getInstance().joinLocationSharing();
        if (result == 0) {
            Intent intent = extension.getContext().getResources().getBoolean(R.bool.rc_location_2D) ? new Intent((Context)currentFragment.getActivity(), AMapRealTimeActivity2D.class) : new Intent((Context)currentFragment.getActivity(), AMapRealTimeActivity.class);
            currentFragment.getActivity().startActivity(intent);
        } else if (result == 1) {
            Toast.makeText((Context)currentFragment.getActivity(), (int)R.string.rc_network_exception, (int)0).show();
        } else if (result == 2) {
            Toast.makeText((Context)currentFragment.getActivity(), (int)R.string.rc_location_sharing_exceed_max, (int)0).show();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }
}

