/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.plugin;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.widget.Toast;
import io.rong.common.LibStorageUtils;
import io.rong.imkit.R;
import io.rong.imkit.RongExtension;
import io.rong.imkit.plugin.IPluginModule;
import io.rong.imkit.plugin.IPluginRequestPermissionResultCallback;
import io.rong.imkit.plugin.location.AMapLocationActivity;
import io.rong.imkit.plugin.location.AMapLocationActivity2D;
import io.rong.imkit.plugin.location.AMapRealTimeActivity;
import io.rong.imkit.plugin.location.AMapRealTimeActivity2D;
import io.rong.imkit.plugin.location.LocationManager;
import io.rong.imkit.plugin.location.LocationManager2D;
import io.rong.imkit.utilities.OptionsPopupDialog;
import io.rong.imkit.utilities.PermissionCheckUtil;

public class CombineLocationPlugin
implements IPluginModule,
IPluginRequestPermissionResultCallback {
    @Override
    public Drawable obtainDrawable(Context context) {
        return ContextCompat.getDrawable((Context)context, (int)R.drawable.rc_ext_plugin_location_selector);
    }

    @Override
    public String obtainTitle(Context context) {
        return context.getString(R.string.rc_plugin_location);
    }

    @Override
    public void onClick(Fragment currentFragment, RongExtension extension) {
        String[] permissions = LibStorageUtils.isBuildAndTargetForQ((Context)currentFragment.getContext()) ? new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_BACKGROUND_LOCATION", "android.permission.ACCESS_NETWORK_STATE"} : new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_NETWORK_STATE"};
        if (PermissionCheckUtil.checkPermissions((Context)currentFragment.getActivity(), permissions)) {
            this.sendOrShareLocation(currentFragment, extension);
        } else {
            extension.requestPermissionForPluginResult(permissions, 255, this);
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    private void sendOrShareLocation(final Fragment currentFragment, final RongExtension extension) {
        String[] items = new String[]{currentFragment.getString(R.string.rc_plugin_location_message), currentFragment.getString(R.string.rc_plugin_location_sharing)};
        OptionsPopupDialog.newInstance((Context)currentFragment.getActivity(), items).setOptionsPopupDialogListener(new OptionsPopupDialog.OnOptionsItemClickedListener(){

            @Override
            public void onOptionsItemClicked(int which) {
                if (which == 0) {
                    Intent intent = extension.getContext().getResources().getBoolean(R.bool.rc_location_2D) ? new Intent((Context)currentFragment.getActivity(), AMapLocationActivity2D.class) : new Intent((Context)currentFragment.getActivity(), AMapLocationActivity.class);
                    extension.startActivityForPluginResult(intent, 1, CombineLocationPlugin.this);
                } else if (which == 1) {
                    int result = extension.getContext().getResources().getBoolean(R.bool.rc_location_2D) ? LocationManager2D.getInstance().joinLocationSharing() : LocationManager.getInstance().joinLocationSharing();
                    if (result == 0) {
                        Intent intent = extension.getContext().getResources().getBoolean(R.bool.rc_location_2D) ? new Intent((Context)currentFragment.getActivity(), AMapRealTimeActivity2D.class) : new Intent((Context)currentFragment.getActivity(), AMapRealTimeActivity.class);
                        if (currentFragment.getActivity() != null) {
                            currentFragment.getActivity().startActivity(intent);
                        }
                    } else if (result == 1) {
                        Toast.makeText((Context)currentFragment.getActivity(), (int)R.string.rc_network_exception, (int)0).show();
                    } else if (result == 2) {
                        Toast.makeText((Context)currentFragment.getActivity(), (int)R.string.rc_location_sharing_exceed_max, (int)0).show();
                    }
                }
            }
        }).show();
    }

    @Override
    public boolean onRequestPermissionResult(Fragment fragment, RongExtension extension, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (PermissionCheckUtil.checkPermissions((Context)fragment.getActivity(), permissions)) {
            this.sendOrShareLocation(fragment, extension);
        } else if (fragment.getActivity() != null) {
            extension.showRequestPermissionFailedAlter(PermissionCheckUtil.getNotGrantedPermissionMsg((Context)fragment.getActivity(), permissions, grantResults));
        }
        return true;
    }
}

