/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.phrases;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.phrases.IPhrasesClickListener;
import java.util.ArrayList;
import java.util.List;

public class CommonphrasesAdapter {
    private static final String TAG = CommonphrasesAdapter.class.getSimpleName();
    private ViewGroup mPhrasesPager;
    private List<String> phrasesList = new ArrayList<String>();
    private boolean mInitialized;
    private IPhrasesClickListener mPhrasesClickListener;

    public void setOnPhrasesClickListener(IPhrasesClickListener clickListener) {
        this.mPhrasesClickListener = clickListener;
    }

    public void addPhrases(List<String> phrases) {
        this.phrasesList.addAll(phrases);
    }

    public void bindView(ViewGroup viewGroup) {
        this.mInitialized = true;
        this.initView(viewGroup.getContext(), viewGroup);
    }

    private void initView(Context context, ViewGroup viewGroup) {
        LayoutInflater mLayoutInflater = LayoutInflater.from((Context)context);
        this.mPhrasesPager = (ViewGroup)mLayoutInflater.inflate(R.layout.rc_ext_phrases_pager, null);
        int height = (int)context.getResources().getDimension(R.dimen.rc_extension_board_height);
        this.mPhrasesPager.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
        viewGroup.addView((View)this.mPhrasesPager);
        ListView mListView = (ListView)this.mPhrasesPager.findViewById(R.id.rc_list);
        PhrasesAdapter mAdapter = new PhrasesAdapter();
        mListView.setAdapter((ListAdapter)mAdapter);
        mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                CommonphrasesAdapter.this.mPhrasesClickListener.onClick((String)CommonphrasesAdapter.this.phrasesList.get(position), position);
            }
        });
    }

    public void setVisibility(int visibility) {
        if (this.mPhrasesPager != null) {
            this.mPhrasesPager.setVisibility(visibility);
        }
    }

    public int getVisibility() {
        return this.mPhrasesPager != null ? this.mPhrasesPager.getVisibility() : 8;
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    private class PhrasesAdapter
    extends BaseAdapter {
        private PhrasesAdapter() {
        }

        public int getCount() {
            return CommonphrasesAdapter.this.phrasesList.size();
        }

        public Object getItem(int position) {
            return CommonphrasesAdapter.this.phrasesList.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.rc_ext_phrases_list_item, null);
            }
            TextView tvPhrases = (TextView)convertView.findViewById(R.id.rc_phrases_tv);
            tvPhrases.setText((CharSequence)CommonphrasesAdapter.this.phrasesList.get(position));
            return convertView;
        }
    }
}

