/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.notification;

import android.content.Context;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Vibrator;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.RongNotificationManager;
import io.rong.imkit.model.ConversationInfo;
import io.rong.imkit.utils.NotificationUtil;
import io.rong.imkit.utils.SystemUtils;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.MentionedInfo;
import io.rong.imlib.model.Message;
import io.rong.message.RecallNotificationMessage;
import java.util.Calendar;
import java.util.List;

public class MessageNotificationManager {
    private static final String TAG = "MessageNotificationManager";
    private static final int SOUND_INTERVAL = 3000;
    private long lastSoundTime = 0L;
    private String startTime;
    private int spanTime;
    MediaPlayer mediaPlayer;

    public String getNotificationQuietHoursStartTime() {
        return this.startTime;
    }

    public int getNotificationQuietHoursSpanTime() {
        return this.spanTime;
    }

    public static MessageNotificationManager getInstance() {
        return SingletonHolder.instance;
    }

    public void setNotificationQuietHours(String startTime, int spanTime) {
        this.spanTime = spanTime;
        this.startTime = startTime;
    }

    public void clearNotificationQuietHours() {
        this.startTime = null;
        this.spanTime = 0;
    }

    public void notifyIfNeed(final Context context, final Message message, final int left) {
        MentionedInfo mentionedInfo;
        if (message.getContent().getMentionedInfo() != null && ((mentionedInfo = message.getContent().getMentionedInfo()).getType().equals((Object)MentionedInfo.MentionedType.ALL) || mentionedInfo.getType().equals((Object)MentionedInfo.MentionedType.PART) && mentionedInfo.getMentionedUserIdList() != null && mentionedInfo.getMentionedUserIdList().contains(RongIMClient.getInstance().getCurrentUserId()))) {
            this.notify(context, message, left);
            return;
        }
        boolean quiet = this.isInQuietTime();
        if (quiet) {
            RLog.d((String)TAG, (String)"in quiet time, don't notify.");
            return;
        }
        if (message.getConversationType().equals((Object)Conversation.ConversationType.ENCRYPTED)) {
            MessageNotificationManager.getInstance().notify(context, message, left);
        } else {
            RongIM.getInstance().getConversationNotificationStatus(message.getConversationType(), message.getTargetId(), new RongIMClient.ResultCallback<Conversation.ConversationNotificationStatus>(){

                public void onSuccess(Conversation.ConversationNotificationStatus conversationNotificationStatus) {
                    if (conversationNotificationStatus.equals((Object)Conversation.ConversationNotificationStatus.NOTIFY)) {
                        MessageNotificationManager.getInstance().notify(context, message, left);
                    }
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            });
        }
    }

    private void notify(Context context, Message message, int left) {
        boolean isInBackground = SystemUtils.isInBackground(context);
        RLog.d((String)TAG, (String)("isInBackground:" + isInBackground));
        if (message.getConversationType() == Conversation.ConversationType.CHATROOM) {
            return;
        }
        if (isInBackground) {
            RongNotificationManager.getInstance().onReceiveMessageFromApp(message, left);
        } else if (!this.isInConversationPager(message.getTargetId(), message.getConversationType()) && left == 0 && System.currentTimeMillis() - this.lastSoundTime > 3000L) {
            if (message.getContent() instanceof RecallNotificationMessage || message.getObjectName().equals("RCJrmf:RpOpendMsg")) {
                return;
            }
            if (context.getResources().getBoolean(R.bool.rc_sound_in_foreground)) {
                this.lastSoundTime = System.currentTimeMillis();
                int ringerMode = NotificationUtil.getRingerMode(context);
                if (ringerMode != 0) {
                    if (ringerMode != 1) {
                        this.sound();
                    }
                    this.vibrate(context);
                }
            } else {
                RLog.d((String)TAG, (String)"message sound is disabled in rc_config.xml");
            }
        }
    }

    public boolean isInQuietTime() {
        int hour = -1;
        int minute = -1;
        int second = -1;
        if (!TextUtils.isEmpty((CharSequence)this.startTime) && this.startTime.contains(":")) {
            String[] time = this.startTime.split(":");
            try {
                if (time.length >= 3) {
                    hour = Integer.parseInt(time[0]);
                    minute = Integer.parseInt(time[1]);
                    second = Integer.parseInt(time[2]);
                }
            }
            catch (NumberFormatException e) {
                RLog.e((String)TAG, (String)"getConversationNotificationStatus NumberFormatException");
            }
        }
        if (hour == -1 || minute == -1 || second == -1) {
            return false;
        }
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.set(11, hour);
        startCalendar.set(12, minute);
        startCalendar.set(13, second);
        long startTime = startCalendar.getTimeInMillis();
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTimeInMillis(startTime + (long)(this.spanTime * 60 * 1000));
        Calendar currentCalendar = Calendar.getInstance();
        if (currentCalendar.get(5) == endCalendar.get(5)) {
            return currentCalendar.after(startCalendar) && currentCalendar.before(endCalendar);
        }
        if (currentCalendar.before(startCalendar)) {
            endCalendar.add(5, -1);
            return currentCalendar.before(endCalendar);
        }
        return true;
    }

    private boolean isInConversationPager(String id2, Conversation.ConversationType type) {
        List<ConversationInfo> list = RongContext.getInstance().getCurrentConversationList();
        for (ConversationInfo conversationInfo : list) {
            boolean isInConversationPage = id2.equals(conversationInfo.getTargetId()) && type == conversationInfo.getConversationType();
            if (!isInConversationPage) continue;
            return true;
        }
        return false;
    }

    private void sound() {
        block4: {
            Uri res = RingtoneManager.getDefaultUri((int)2);
            if (RongContext.getInstance().getNotificationSound() != null && !TextUtils.isEmpty((CharSequence)RongContext.getInstance().getNotificationSound().toString())) {
                res = RongContext.getInstance().getNotificationSound();
            }
            try {
                if (this.mediaPlayer != null) {
                    this.mediaPlayer.stop();
                    this.mediaPlayer.reset();
                    this.mediaPlayer.release();
                    this.mediaPlayer = null;
                }
                this.mediaPlayer = new MediaPlayer();
                this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mp) {
                        if (mp != null) {
                            try {
                                mp.stop();
                                mp.reset();
                                mp.release();
                            }
                            catch (Exception e) {
                                RLog.e((String)MessageNotificationManager.TAG, (String)"sound", (Throwable)e);
                            }
                        }
                        if (MessageNotificationManager.this.mediaPlayer != null) {
                            MessageNotificationManager.this.mediaPlayer = null;
                        }
                    }
                });
                this.mediaPlayer.setAudioStreamType(2);
                this.mediaPlayer.setDataSource(RongIM.getInstance().getApplicationContext(), res);
                this.mediaPlayer.prepare();
                this.mediaPlayer.start();
            }
            catch (Exception e) {
                RLog.e((String)TAG, (String)"sound", (Throwable)e);
                if (this.mediaPlayer == null) break block4;
                this.mediaPlayer = null;
            }
        }
    }

    private void vibrate(Context context) {
        Vibrator vibrator = (Vibrator)context.getSystemService("vibrator");
        if (vibrator != null) {
            vibrator.vibrate(new long[]{0L, 200L, 250L, 200L}, -1);
        }
    }

    private static class SingletonHolder {
        static final MessageNotificationManager instance = new MessageNotificationManager();

        private SingletonHolder() {
        }
    }
}

