/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.model;

import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConversationTypeFilter {
    private Level mLevel;
    private List<Conversation.ConversationType> mTypes = new ArrayList<Conversation.ConversationType>();

    public static ConversationTypeFilter obtain(Conversation.ConversationType ... conversationType) {
        return new ConversationTypeFilter(conversationType);
    }

    public static ConversationTypeFilter obtain(Level level) {
        return new ConversationTypeFilter(level);
    }

    public static ConversationTypeFilter obtain() {
        return new ConversationTypeFilter();
    }

    private ConversationTypeFilter(Conversation.ConversationType ... type) {
        this.mTypes.addAll(Arrays.asList(type));
        this.mLevel = Level.CONVERSATION_TYPE;
    }

    private ConversationTypeFilter() {
        this.mLevel = Level.ALL;
    }

    private ConversationTypeFilter(Level level) {
        this.mLevel = level;
    }

    public Level getLevel() {
        return this.mLevel;
    }

    public List<Conversation.ConversationType> getConversationTypeList() {
        return this.mTypes;
    }

    public boolean hasFilter(Message message) {
        if (this.mLevel == Level.ALL) {
            return true;
        }
        if (this.mLevel == Level.CONVERSATION_TYPE) {
            return this.mTypes.contains(message.getConversationType());
        }
        return false;
    }

    public static enum Level {
        ALL,
        CONVERSATION_TYPE,
        NONE;

    }
}

