/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.message;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.UserInfo;
import io.rong.message.MediaMessageContent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:CombineMsg", flag=3)
public class CombineMessage
extends MediaMessageContent {
    private static final String TAG = CombineMessage.class.getSimpleName();
    private String title;
    private Conversation.ConversationType conversationType = Conversation.ConversationType.PRIVATE;
    private List<String> nameList = new ArrayList<String>();
    private List<String> summaryList = new ArrayList<String>();
    public static final Parcelable.Creator<CombineMessage> CREATOR = new Parcelable.Creator<CombineMessage>(){

        public CombineMessage createFromParcel(Parcel source) {
            return new CombineMessage(source);
        }

        public CombineMessage[] newArray(int size) {
            return new CombineMessage[size];
        }
    };

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Conversation.ConversationType getConversationType() {
        return this.conversationType;
    }

    public void setConversationType(Conversation.ConversationType conversationType) {
        this.conversationType = conversationType;
    }

    public List<String> getNameList() {
        return this.nameList;
    }

    public void setNameList(List<String> nameList) {
        this.nameList = nameList;
    }

    public List<String> getSummaryList() {
        return this.summaryList;
    }

    public void setSummaryList(List<String> summaryList) {
        this.summaryList = summaryList;
    }

    protected CombineMessage() {
    }

    public static CombineMessage obtain(Uri url) {
        CombineMessage model = new CombineMessage();
        if (url.toString().startsWith("file")) {
            model.setLocalPath(url);
        } else {
            model.setMediaUrl(url);
        }
        return model;
    }

    public CombineMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e((String)TAG, (String)"UnsupportedEncodingException", (Throwable)e);
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("title")) {
                this.setTitle(jsonObj.optString("title"));
            }
            if (jsonObj.has("name")) {
                this.setName(jsonObj.optString("name"));
            }
            if (jsonObj.has("localPath")) {
                this.setLocalPath(Uri.parse((String)jsonObj.optString("localPath")));
            }
            if (jsonObj.has("remoteUrl")) {
                this.setMediaUrl(Uri.parse((String)jsonObj.optString("remoteUrl")));
            }
            if (jsonObj.has("extra")) {
                this.setExtra(jsonObj.optString("extra"));
            }
            if (jsonObj.has("user")) {
                this.setUserInfo(this.parseJsonToUserInfo(jsonObj.getJSONObject("user")));
            }
            this.setConversationType(Conversation.ConversationType.setValue((int)jsonObj.optInt("conversationType")));
            JSONArray jsonArray = jsonObj.optJSONArray("nameList");
            ArrayList<String> nameList = new ArrayList<String>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                nameList.add((String)jsonArray.get(i));
            }
            this.setNameList(nameList);
            jsonArray = jsonObj.optJSONArray("summaryList");
            ArrayList<String> summaryList = new ArrayList<String>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                summaryList.add((String)jsonArray.get(i));
            }
            this.setSummaryList(summaryList);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)this.getTitle())) {
                jsonObj.put("title", (Object)this.getTitle());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getName())) {
                jsonObj.put("name", (Object)this.getName());
            }
            if (this.getLocalPath() != null) {
                jsonObj.put("localPath", (Object)this.getLocalPath().toString());
            }
            if (this.getMediaUrl() != null) {
                jsonObj.put("remoteUrl", (Object)this.getMediaUrl().toString());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getExtra())) {
                jsonObj.put("extra", (Object)this.getExtra());
            }
            if (this.getJSONUserInfo() != null) {
                jsonObj.putOpt("user", (Object)this.getJSONUserInfo());
            }
            jsonObj.put("conversationType", this.conversationType.getValue());
            JSONArray jsonArray = new JSONArray();
            for (String name : this.nameList) {
                jsonArray.put((Object)name);
            }
            jsonObj.put("nameList", (Object)jsonArray);
            jsonArray = new JSONArray();
            for (String summary : this.summaryList) {
                jsonArray.put((Object)summary);
            }
            jsonObj.put("summaryList", (Object)jsonArray);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e((String)TAG, (String)"UnsupportedEncodingException", (Throwable)e);
            return null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.getExtra());
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.getName());
        ParcelUtils.writeToParcel((Parcel)dest, (Parcelable)this.getLocalPath());
        ParcelUtils.writeToParcel((Parcel)dest, (Parcelable)this.getMediaUrl());
        ParcelUtils.writeToParcel((Parcel)dest, (Parcelable)this.getUserInfo());
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.getConversationType().getValue());
        ParcelUtils.writeToParcel((Parcel)dest, this.getNameList());
        ParcelUtils.writeToParcel((Parcel)dest, this.getSummaryList());
    }

    private CombineMessage(Parcel in) {
        this.setExtra(ParcelUtils.readFromParcel((Parcel)in));
        this.setName(ParcelUtils.readFromParcel((Parcel)in));
        this.setLocalPath((Uri)ParcelUtils.readFromParcel((Parcel)in, Uri.class));
        this.setMediaUrl((Uri)ParcelUtils.readFromParcel((Parcel)in, Uri.class));
        this.setUserInfo((UserInfo)ParcelUtils.readFromParcel((Parcel)in, UserInfo.class));
        this.setConversationType(Conversation.ConversationType.setValue((int)ParcelUtils.readIntFromParcel((Parcel)in)));
        this.setNameList(ParcelUtils.readListFromParcel((Parcel)in, String.class));
        this.setSummaryList(ParcelUtils.readListFromParcel((Parcel)in, String.class));
    }
}

