/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.menu;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.menu.ISubMenuItemClickListener;
import io.rong.imkit.utilities.RongUtils;
import java.util.List;

public class InputSubMenu {
    private PopupWindow mPopupWindow;
    private ViewGroup container;
    private LayoutInflater mInflater;
    private ISubMenuItemClickListener mOnClickListener;

    public InputSubMenu(Context context, List<String> menus) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.container = (ViewGroup)this.mInflater.inflate(R.layout.rc_ext_sub_menu_container, null);
        this.mPopupWindow = new PopupWindow((View)this.container, -2, -2);
        this.setupSubMenus(this.container, menus);
    }

    public void showAtLocation(View parent) {
        this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable());
        this.container.measure(0, 0);
        int[] location = new int[2];
        int w = this.container.getMeasuredWidth();
        int h = this.container.getMeasuredHeight();
        parent.getLocationOnScreen(location);
        int x = location[0] + (parent.getWidth() - w) / 2;
        int maxRightX = RongUtils.getScreenWidth() - RongUtils.dip2px(10.0f);
        if (x + w > maxRightX) {
            x = maxRightX - w;
        }
        int y = location[1] - h - RongUtils.dip2px(3.0f);
        this.mPopupWindow.showAtLocation(parent, 0x800033, x, y);
        this.mPopupWindow.setOutsideTouchable(true);
        this.mPopupWindow.setFocusable(true);
        this.mPopupWindow.update();
    }

    public void setOnItemClickListener(ISubMenuItemClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
    }

    private void setupSubMenus(ViewGroup viewGroup, List<String> menus) {
        for (int i = 0; i < menus.size(); ++i) {
            View view = this.mInflater.inflate(R.layout.rc_ext_sub_menu_item, null);
            TextView tv = (TextView)view.findViewById(R.id.rc_sub_menu_title);
            View divider = view.findViewById(R.id.rc_sub_menu_divider_line);
            String title = menus.get(i);
            tv.setText((CharSequence)title);
            if (i < menus.size() - 1) {
                divider.setVisibility(0);
            }
            view.setTag((Object)i);
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int index = (Integer)v.getTag();
                    InputSubMenu.this.mOnClickListener.onClick(index);
                    InputSubMenu.this.mPopupWindow.dismiss();
                }
            });
            viewGroup.addView(view);
        }
    }
}

