/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.mention;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SectionIndexer;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.RongBaseNoActionbarActivity;
import io.rong.imkit.RongIM;
import io.rong.imkit.mention.RongMentionManager;
import io.rong.imkit.mention.SideBar;
import io.rong.imkit.tools.CharacterParser;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.UserInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MemberMentionedActivity
extends RongBaseNoActionbarActivity {
    private ListView mListView;
    private List<MemberInfo> mAllMemberList;
    private MembersAdapter mAdapter;
    private Handler handler = new Handler();

    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rc_mention_members);
        EditText searchBar = (EditText)this.findViewById(R.id.rc_edit_text);
        this.mListView = (ListView)this.findViewById(R.id.rc_list);
        SideBar mSideBar = (SideBar)this.findViewById(R.id.rc_sidebar);
        TextView letterPopup = (TextView)this.findViewById(R.id.rc_popup_bg);
        mSideBar.setTextView(letterPopup);
        this.mAdapter = new MembersAdapter();
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mAllMemberList = new ArrayList<MemberInfo>();
        String targetId = this.getIntent().getStringExtra("targetId");
        Conversation.ConversationType conversationType = Conversation.ConversationType.setValue((int)this.getIntent().getIntExtra("conversationType", 0));
        RongIM.IGroupMembersProvider groupMembersProvider = RongMentionManager.getInstance().getGroupMembersProvider();
        if (conversationType.equals((Object)Conversation.ConversationType.GROUP) && groupMembersProvider != null) {
            groupMembersProvider.getGroupMembers(targetId, new RongIM.IGroupMemberCallback(){

                @Override
                public void onGetGroupMembersResult(final List<UserInfo> members) {
                    if (members != null && members.size() > 0) {
                        MemberMentionedActivity.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                for (int i = 0; i < members.size(); ++i) {
                                    UserInfo userInfo = (UserInfo)members.get(i);
                                    if (userInfo == null || userInfo.getUserId().equals(RongIMClient.getInstance().getCurrentUserId())) continue;
                                    MemberInfo memberInfo = new MemberInfo(userInfo);
                                    String sortString = "#";
                                    String pinyin = CharacterParser.getInstance().getSelling(userInfo.getName());
                                    if (pinyin != null && pinyin.length() > 0) {
                                        sortString = pinyin.substring(0, 1).toUpperCase();
                                    }
                                    if (sortString.matches("[A-Z]")) {
                                        memberInfo.setLetter(sortString.toUpperCase());
                                    } else {
                                        memberInfo.setLetter("#");
                                    }
                                    MemberMentionedActivity.this.mAllMemberList.add(memberInfo);
                                }
                                Collections.sort(MemberMentionedActivity.this.mAllMemberList, PinyinComparator.getInstance());
                                MemberMentionedActivity.this.mAdapter.setData(MemberMentionedActivity.this.mAllMemberList);
                                MemberMentionedActivity.this.mAdapter.notifyDataSetChanged();
                            }
                        });
                    }
                }
            });
        } else if (conversationType.equals((Object)Conversation.ConversationType.DISCUSSION)) {
            RongIMClient.getInstance().getDiscussion(targetId, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Discussion>(){

                public void onSuccess(Discussion discussion) {
                    List memeberIds = discussion.getMemberIdList();
                    for (String id2 : memeberIds) {
                        UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(id2);
                        if (userInfo == null || userInfo.getUserId().equals(RongIMClient.getInstance().getCurrentUserId())) continue;
                        MemberInfo memberInfo = new MemberInfo(userInfo);
                        String sortString = "#";
                        String pinyin = CharacterParser.getInstance().getSelling(userInfo.getName());
                        if (pinyin != null && pinyin.length() > 0) {
                            sortString = pinyin.substring(0, 1).toUpperCase();
                        }
                        if (sortString.matches("[A-Z]")) {
                            memberInfo.setLetter(sortString.toUpperCase());
                        } else {
                            memberInfo.setLetter("#");
                        }
                        MemberMentionedActivity.this.mAllMemberList.add(memberInfo);
                    }
                    Collections.sort(MemberMentionedActivity.this.mAllMemberList, PinyinComparator.getInstance());
                    MemberMentionedActivity.this.mAdapter.setData(MemberMentionedActivity.this.mAllMemberList);
                    MemberMentionedActivity.this.mAdapter.notifyDataSetChanged();
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            });
        }
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                MemberMentionedActivity.this.finish();
                MemberInfo item = MemberMentionedActivity.this.mAdapter.getItem(position);
                if (item != null && item.userInfo != null) {
                    RongMentionManager.getInstance().mentionMember(item.userInfo);
                }
            }
        });
        mSideBar.setOnTouchingLetterChangedListener(new SideBar.OnTouchingLetterChangedListener(){

            @Override
            public void onTouchingLetterChanged(String s) {
                int position = MemberMentionedActivity.this.mAdapter.getPositionForSection(s.charAt(0));
                if (position != -1) {
                    MemberMentionedActivity.this.mListView.setSelection(position);
                }
            }
        });
        searchBar.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                ArrayList<MemberInfo> filterDataList = new ArrayList();
                if (TextUtils.isEmpty((CharSequence)s.toString())) {
                    filterDataList = MemberMentionedActivity.this.mAllMemberList;
                } else {
                    filterDataList.clear();
                    for (MemberInfo member : MemberMentionedActivity.this.mAllMemberList) {
                        String name = member.userInfo.getName();
                        if (name == null || !name.contains(s) && !CharacterParser.getInstance().getSelling(name).startsWith(s.toString())) continue;
                        filterDataList.add(member);
                    }
                }
                Collections.sort(filterDataList, PinyinComparator.getInstance());
                MemberMentionedActivity.this.mAdapter.setData(filterDataList);
                MemberMentionedActivity.this.mAdapter.notifyDataSetChanged();
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.findViewById(R.id.rc_btn_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MemberMentionedActivity.this.finish();
            }
        });
    }

    public static class PinyinComparator
    implements Comparator<MemberInfo> {
        public static PinyinComparator instance = null;

        public static PinyinComparator getInstance() {
            if (instance == null) {
                instance = new PinyinComparator();
            }
            return instance;
        }

        @Override
        public int compare(MemberInfo o1, MemberInfo o2) {
            if (o1.getLetter().equals("@") || o2.getLetter().equals("#")) {
                return -1;
            }
            if (o1.getLetter().equals("#") || o2.getLetter().equals("@")) {
                return 1;
            }
            return o1.getLetter().compareTo(o2.getLetter());
        }
    }

    private class MemberInfo {
        UserInfo userInfo;
        String letter;

        MemberInfo(UserInfo userInfo) {
            this.userInfo = userInfo;
        }

        public void setLetter(String letter) {
            this.letter = letter;
        }

        public String getLetter() {
            return this.letter;
        }
    }

    class ViewHolder {
        AsyncImageView portrait;
        TextView name;
        TextView letter;

        ViewHolder() {
        }
    }

    class MembersAdapter
    extends BaseAdapter
    implements SectionIndexer {
        private List<MemberInfo> mList = new ArrayList<MemberInfo>();

        MembersAdapter() {
        }

        public void setData(List<MemberInfo> list) {
            this.mList = list;
        }

        public int getCount() {
            return this.mList.size();
        }

        public MemberInfo getItem(int position) {
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            int section;
            ViewHolder viewHolder;
            if (convertView == null) {
                viewHolder = new ViewHolder();
                convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.rc_mention_list_item, null);
                viewHolder.name = (TextView)convertView.findViewById(R.id.rc_user_name);
                viewHolder.portrait = (AsyncImageView)convertView.findViewById(R.id.rc_user_portrait);
                viewHolder.letter = (TextView)convertView.findViewById(R.id.letter);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            UserInfo userInfo = this.mList.get((int)position).userInfo;
            if (userInfo != null) {
                viewHolder.name.setText((CharSequence)userInfo.getName());
                viewHolder.portrait.setAvatar(userInfo.getPortraitUri());
            }
            if (position == this.getPositionForSection(section = this.getSectionForPosition(position))) {
                viewHolder.letter.setVisibility(0);
                viewHolder.letter.setText((CharSequence)this.mList.get(position).getLetter());
            } else {
                viewHolder.letter.setVisibility(8);
            }
            return convertView;
        }

        public Object[] getSections() {
            return new Object[0];
        }

        public int getPositionForSection(int sectionIndex) {
            for (int i = 0; i < this.getCount(); ++i) {
                String sortStr = this.mList.get(i).getLetter();
                char firstChar = sortStr.toUpperCase().charAt(0);
                if (firstChar != sectionIndex) continue;
                return i;
            }
            return -1;
        }

        public int getSectionForPosition(int position) {
            return this.mList.get(position).getLetter().charAt(0);
        }
    }
}

