/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.manager;

import io.rong.common.RLog;
import io.rong.eventbus.EventBus;
import io.rong.imkit.manager.IUnReadMessageObserver;
import io.rong.imkit.model.Event;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import java.util.ArrayList;
import java.util.List;

public class UnReadMessageManager {
    private static final String TAG = "UnReadMessageManager";
    private final List<MultiConversationUnreadMsgInfo> mMultiConversationUnreadInfos = new ArrayList<MultiConversationUnreadMsgInfo>();
    private int left;

    private UnReadMessageManager() {
        EventBus.getDefault().register(this);
    }

    public static UnReadMessageManager getInstance() {
        return SingletonHolder.sInstance;
    }

    public void onEventMainThread(Event.OnReceiveMessageEvent event) {
        this.left = event.getLeft();
        if (event.getLeft() == 0) {
            this.syncUnreadCount(event.getMessage(), event.getLeft());
        }
    }

    public void onEventMainThread(Event.MessageLeftEvent event) {
        RLog.d((String)TAG, (String)("MessageLeftEvent " + event.left));
        this.syncUnreadCount(null, event.left);
    }

    public void onEventMainThread(Event.ConnectEvent event) {
        this.syncUnreadCount(null, 0);
    }

    private void syncUnreadCount(Message message, int left) {
        for (final MultiConversationUnreadMsgInfo msgInfo : this.mMultiConversationUnreadInfos) {
            if (left != 0 && this.left != 0) continue;
            RongIMClient.getInstance().getUnreadCount(msgInfo.conversationTypes, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Integer>(){

                public void onSuccess(Integer integer2) {
                    RLog.d((String)UnReadMessageManager.TAG, (String)("get result: " + integer2));
                    msgInfo.count = integer2;
                    msgInfo.observer.onCountChanged(integer2);
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            });
        }
    }

    public void onEventMainThread(Event.ConversationRemoveEvent removeEvent) {
        Conversation.ConversationType conversationType = removeEvent.getType();
        block0: for (final MultiConversationUnreadMsgInfo msgInfo : this.mMultiConversationUnreadInfos) {
            for (Conversation.ConversationType ct : msgInfo.conversationTypes) {
                if (!ct.equals((Object)conversationType)) continue;
                RongIMClient.getInstance().getUnreadCount(msgInfo.conversationTypes, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Integer>(){

                    public void onSuccess(Integer integer2) {
                        msgInfo.count = integer2;
                        msgInfo.observer.onCountChanged(integer2);
                    }

                    public void onError(RongIMClient.ErrorCode e) {
                    }
                });
                continue block0;
            }
        }
    }

    public void onEventMainThread(Message message) {
        this.syncUnreadCount(message, 0);
    }

    public void onEventMainThread(Event.ConversationUnreadEvent unreadEvent) {
        Conversation.ConversationType conversationType = unreadEvent.getType();
        block0: for (final MultiConversationUnreadMsgInfo msgInfo : this.mMultiConversationUnreadInfos) {
            for (Conversation.ConversationType ct : msgInfo.conversationTypes) {
                if (!ct.equals((Object)conversationType)) continue;
                RongIMClient.getInstance().getUnreadCount(msgInfo.conversationTypes, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Integer>(){

                    public void onSuccess(Integer integer2) {
                        msgInfo.count = integer2;
                        msgInfo.observer.onCountChanged(integer2);
                    }

                    public void onError(RongIMClient.ErrorCode e) {
                    }
                });
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Conversation.ConversationType[] conversationTypes, IUnReadMessageObserver observer) {
        List<MultiConversationUnreadMsgInfo> list = this.mMultiConversationUnreadInfos;
        synchronized (list) {
            final MultiConversationUnreadMsgInfo msgInfo = new MultiConversationUnreadMsgInfo();
            msgInfo.conversationTypes = conversationTypes;
            msgInfo.observer = observer;
            this.mMultiConversationUnreadInfos.add(msgInfo);
            RongIMClient.getInstance().getUnreadCount(conversationTypes, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Integer>(){

                public void onSuccess(Integer integer2) {
                    msgInfo.count = integer2;
                    msgInfo.observer.onCountChanged(integer2);
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(IUnReadMessageObserver observer) {
        List<MultiConversationUnreadMsgInfo> list = this.mMultiConversationUnreadInfos;
        synchronized (list) {
            MultiConversationUnreadMsgInfo result = null;
            for (MultiConversationUnreadMsgInfo msgInfo : this.mMultiConversationUnreadInfos) {
                if (msgInfo.observer != observer) continue;
                result = msgInfo;
                break;
            }
            if (result != null) {
                this.mMultiConversationUnreadInfos.remove(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearObserver() {
        List<MultiConversationUnreadMsgInfo> list = this.mMultiConversationUnreadInfos;
        synchronized (list) {
            this.mMultiConversationUnreadInfos.clear();
        }
    }

    public void onMessageReceivedStatusChanged() {
        this.syncUnreadCount(null, 0);
    }

    public void onEventMainThread(Event.SyncReadStatusEvent event) {
        RLog.d((String)TAG, (String)("SyncReadStatusEvent " + this.left));
        if (this.left == 0) {
            Conversation.ConversationType conversationType = event.getConversationType();
            block0: for (final MultiConversationUnreadMsgInfo msgInfo : this.mMultiConversationUnreadInfos) {
                for (Conversation.ConversationType ct : msgInfo.conversationTypes) {
                    if (!ct.equals((Object)conversationType)) continue;
                    RongIMClient.getInstance().getUnreadCount(msgInfo.conversationTypes, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Integer>(){

                        public void onSuccess(Integer integer2) {
                            msgInfo.count = integer2;
                            msgInfo.observer.onCountChanged(integer2);
                        }

                        public void onError(RongIMClient.ErrorCode e) {
                        }
                    });
                    continue block0;
                }
            }
        }
    }

    public void onEventMainThread(Event.RemoteMessageRecallEvent event) {
        RLog.d((String)TAG, (String)("SyncReadStatusEvent " + this.left));
        if (this.left == 0) {
            Conversation.ConversationType conversationType = event.getConversationType();
            block0: for (final MultiConversationUnreadMsgInfo msgInfo : this.mMultiConversationUnreadInfos) {
                for (Conversation.ConversationType ct : msgInfo.conversationTypes) {
                    if (!ct.equals((Object)conversationType)) continue;
                    RongIMClient.getInstance().getUnreadCount(msgInfo.conversationTypes, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Integer>(){

                        public void onSuccess(Integer integer2) {
                            msgInfo.count = integer2;
                            msgInfo.observer.onCountChanged(integer2);
                        }

                        public void onError(RongIMClient.ErrorCode e) {
                        }
                    });
                    continue block0;
                }
            }
        }
    }

    private class MultiConversationUnreadMsgInfo {
        Conversation.ConversationType[] conversationTypes;
        int count;
        IUnReadMessageObserver observer;

        private MultiConversationUnreadMsgInfo() {
        }
    }

    private static class SingletonHolder {
        static UnReadMessageManager sInstance = new UnReadMessageManager();

        private SingletonHolder() {
        }
    }
}

