/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.manager;

import android.net.Uri;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.message.GIFMessage;
import io.rong.message.ImageMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SendImageManager {
    private static final String TAG = "SendImageManager";
    private ExecutorService executorService = this.getExecutorService();
    private UploadController uploadController = new UploadController();

    public static SendImageManager getInstance() {
        return SingletonHolder.sInstance;
    }

    private SendImageManager() {
    }

    public void sendImages(Conversation.ConversationType conversationType, String targetId, List<Uri> imageList, boolean isFull) {
        this.sendImages(conversationType, targetId, imageList, isFull, false, 0L);
    }

    public void sendImages(Conversation.ConversationType conversationType, String targetId, List<Uri> imageList, boolean isFull, boolean isDestruct, long destructTime) {
        RLog.d((String)TAG, (String)("sendImages " + imageList.size()));
        for (Uri image : imageList) {
            RongIM.OnSendMessageListener listener;
            File file;
            if (TextUtils.isEmpty((CharSequence)image.getPath()) || !(file = new File(image.getPath())).exists() || image.getPath() == null) continue;
            Object content = image.getPath().endsWith("gif") ? GIFMessage.obtain((Uri)image) : ImageMessage.obtain((Uri)image, (Uri)image, (boolean)isFull);
            if (isDestruct && content != null) {
                content.setDestructTime(destructTime);
            }
            if ((listener = RongContext.getInstance().getOnSendMessageListener()) != null) {
                Message message = listener.onSend(Message.obtain((String)targetId, (Conversation.ConversationType)conversationType, (MessageContent)content));
                if (message == null) continue;
                RongIMClient.getInstance().insertOutgoingMessage(conversationType, targetId, null, message.getContent(), (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Message>(){

                    public void onSuccess(Message message) {
                        message.setSentStatus(Message.SentStatus.SENDING);
                        RongIMClient.getInstance().setMessageSentStatus(message, null);
                        RongContext.getInstance().getEventBus().post(message);
                        SendImageManager.this.uploadController.execute(message);
                    }

                    public void onError(RongIMClient.ErrorCode e) {
                    }
                });
                continue;
            }
            RongIMClient.getInstance().insertOutgoingMessage(conversationType, targetId, null, (MessageContent)content, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Message>(){

                public void onSuccess(Message message) {
                    message.setSentStatus(Message.SentStatus.SENDING);
                    RongIMClient.getInstance().setMessageSentStatus(message, null);
                    RongContext.getInstance().getEventBus().post(message);
                    SendImageManager.this.uploadController.execute(message);
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            });
        }
    }

    public void cancelSendingImages(Conversation.ConversationType conversationType, String targetId) {
        RLog.d((String)TAG, (String)"cancelSendingImages");
        if (conversationType != null && targetId != null && this.uploadController != null) {
            this.uploadController.cancel(conversationType, targetId);
        }
    }

    public void cancelSendingImage(Conversation.ConversationType conversationType, String targetId, int messageId) {
        RLog.d((String)TAG, (String)"cancelSendingImages");
        if (conversationType != null && targetId != null && this.uploadController != null && messageId > 0) {
            this.uploadController.cancel(conversationType, targetId, messageId);
        }
    }

    public void reset() {
        this.uploadController.reset();
    }

    private ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.threadFactory());
        }
        return this.executorService;
    }

    private ThreadFactory threadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(@Nullable Runnable runnable) {
                Thread result = new Thread(runnable, "Rong SendMediaManager");
                result.setDaemon(false);
                return result;
            }
        };
    }

    private class UploadController
    implements Runnable {
        final List<Message> pendingMessages = new ArrayList<Message>();
        Message executingMessage;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Message message) {
            List<Message> list = this.pendingMessages;
            synchronized (list) {
                this.pendingMessages.add(message);
                if (this.executingMessage == null) {
                    this.executingMessage = this.pendingMessages.remove(0);
                    SendImageManager.this.executorService.submit(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            RLog.w((String)SendImageManager.TAG, (String)"Rest Sending Images.");
            List<Message> list = this.pendingMessages;
            synchronized (list) {
                for (Message message : this.pendingMessages) {
                    message.setSentStatus(Message.SentStatus.FAILED);
                    RongContext.getInstance().getEventBus().post(message);
                }
                this.pendingMessages.clear();
            }
            if (this.executingMessage != null) {
                this.executingMessage.setSentStatus(Message.SentStatus.FAILED);
                RongContext.getInstance().getEventBus().post(this.executingMessage);
                this.executingMessage = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(Conversation.ConversationType conversationType, String targetId) {
            List<Message> list = this.pendingMessages;
            synchronized (list) {
                Iterator<Message> it = this.pendingMessages.iterator();
                while (it.hasNext()) {
                    Message msg = it.next();
                    if (!msg.getConversationType().equals((Object)conversationType) || !msg.getTargetId().equals(targetId)) continue;
                    it.remove();
                }
                if (this.pendingMessages.size() == 0) {
                    this.executingMessage = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(Conversation.ConversationType conversationType, String targetId, int messageId) {
            List<Message> list = this.pendingMessages;
            synchronized (list) {
                int count = this.pendingMessages.size();
                for (int i = 0; i < count; ++i) {
                    Message msg = this.pendingMessages.get(i);
                    if (!msg.getConversationType().equals((Object)conversationType) || !msg.getTargetId().equals(targetId) || msg.getMessageId() != messageId) continue;
                    this.pendingMessages.remove(msg);
                    break;
                }
                if (this.pendingMessages.size() == 0) {
                    this.executingMessage = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void polling() {
            List<Message> list = this.pendingMessages;
            synchronized (list) {
                RLog.d((String)SendImageManager.TAG, (String)("polling " + this.pendingMessages.size()));
                if (this.pendingMessages.size() > 0) {
                    this.executingMessage = this.pendingMessages.remove(0);
                    SendImageManager.this.executorService.submit(this);
                } else {
                    this.executingMessage = null;
                }
            }
        }

        @Override
        public void run() {
            boolean isDestruct = false;
            if (this.executingMessage.getContent() != null) {
                isDestruct = this.executingMessage.getContent().isDestruct();
            }
            RongIM.getInstance().sendImageMessage(this.executingMessage, isDestruct ? RongIM.getInstance().getApplicationContext().getString(R.string.rc_message_content_burn) : null, null, false, new RongIMClient.SendImageMessageCallback(){

                public void onAttached(Message message) {
                }

                public void onError(Message message, RongIMClient.ErrorCode code) {
                    UploadController.this.polling();
                }

                public void onSuccess(Message message) {
                    UploadController.this.polling();
                }

                public void onProgress(Message message, int progress) {
                }
            });
        }
    }

    static class SingletonHolder {
        static SendImageManager sInstance = new SendImageManager();

        SingletonHolder() {
        }
    }
}

