/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.manager;

import android.content.Context;
import io.rong.common.RLog;
import io.rong.imkit.manager.IExternalModule;
import io.rong.imkit.plugin.IPluginModule;
import io.rong.imlib.model.Conversation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class InternalModuleManager {
    private static final String TAG = "InternalModuleManager";
    private static IExternalModule callModule;
    private static IExternalModule callModule2;

    private InternalModuleManager() {
    }

    public static InternalModuleManager getInstance() {
        return SingletonHolder.sInstance;
    }

    public static void init(Context context) {
        RLog.i((String)TAG, (String)"init");
        try {
            String moduleName = "io.rong.callkit.RongCallModule";
            Class<?> cls = Class.forName(moduleName);
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            callModule = (IExternalModule)constructor.newInstance(new Object[0]);
            callModule.onCreate(context);
        }
        catch (Exception e) {
            RLog.i((String)TAG, (String)"Can not find RongCallModule.");
        }
        try {
            String moudleName2 = "io.rong.signalingkit.RCSCallModule";
            Class<?> cls2 = Class.forName(moudleName2);
            Constructor<?> constructor2 = cls2.getConstructor(new Class[0]);
            callModule2 = (IExternalModule)constructor2.newInstance(new Object[0]);
            callModule2.onCreate(context);
        }
        catch (Exception e) {
            RLog.i((String)TAG, (String)"Can not find RCSCallModule.");
        }
    }

    public void onInitialized(String appKey) {
        RLog.i((String)TAG, (String)"onInitialized");
        if (callModule != null) {
            callModule.onInitialized(appKey);
        }
        if (callModule2 != null) {
            callModule2.onInitialized(appKey);
        }
    }

    public List<IPluginModule> getInternalPlugins(Conversation.ConversationType conversationType) {
        ArrayList<IPluginModule> pluginModules = new ArrayList<IPluginModule>();
        if (callModule != null && (conversationType.equals((Object)Conversation.ConversationType.PRIVATE) || conversationType.equals((Object)Conversation.ConversationType.DISCUSSION) || conversationType.equals((Object)Conversation.ConversationType.GROUP))) {
            pluginModules.addAll(callModule.getPlugins(conversationType));
        }
        if (callModule2 != null && (conversationType.equals((Object)Conversation.ConversationType.PRIVATE) || conversationType.equals((Object)Conversation.ConversationType.DISCUSSION) || conversationType.equals((Object)Conversation.ConversationType.GROUP))) {
            pluginModules.addAll(callModule2.getPlugins(conversationType));
        }
        return pluginModules;
    }

    public void onConnected(String token) {
        RLog.i((String)TAG, (String)"onConnected");
        if (callModule != null) {
            callModule.onConnected(token);
        }
        if (callModule2 != null) {
            callModule2.onConnected(token);
        }
    }

    public void onLoaded() {
        RLog.i((String)TAG, (String)"onLoaded");
        if (callModule != null) {
            callModule.onViewCreated();
        }
        if (callModule2 != null) {
            callModule2.onViewCreated();
        }
    }

    static class SingletonHolder {
        static InternalModuleManager sInstance = new InternalModuleManager();

        SingletonHolder() {
        }
    }
}

