/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.manager;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import io.rong.common.RLog;
import io.rong.imkit.manager.IAudioPlayListener;
import java.io.FileInputStream;
import java.io.IOException;

public class AudioPlayManager
implements SensorEventListener {
    private static final String TAG = "AudioPlayManager";
    private MediaPlayer mMediaPlayer;
    private IAudioPlayListener _playListener;
    private Uri mUriPlaying;
    private Sensor _sensor;
    private SensorManager _sensorManager;
    private AudioManager mAudioManager;
    private PowerManager _powerManager;
    private PowerManager.WakeLock _wakeLock;
    private AudioManager.OnAudioFocusChangeListener afChangeListener;
    private Context mContext;
    private Handler handler;
    private final Object mLock = new Object();
    private boolean isVOIPMode = false;

    private AudioPlayManager() {
        this.handler = new Handler(Looper.getMainLooper());
    }

    public static AudioPlayManager getInstance() {
        return SingletonHolder.sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public void onSensorChanged(SensorEvent event) {
        Object object = this.mLock;
        synchronized (object) {
            float range = event.values[0];
            RLog.d((String)TAG, (String)("onSensorChanged. range:" + range + "; max range:" + event.sensor.getMaximumRange()));
            double rangeJudgeValue = 0.0;
            if (this._sensor == null || this.mMediaPlayer == null || this.mAudioManager == null) {
                return;
            }
            boolean judge = this.judgeCondition(event, range, rangeJudgeValue);
            if (this.mMediaPlayer.isPlaying()) {
                FileInputStream fis = null;
                if (judge) {
                    if (this.mAudioManager.getMode() == 0) {
                        return;
                    }
                    this.mAudioManager.setMode(0);
                    this.mAudioManager.setSpeakerphoneOn(true);
                    final int positions = this.mMediaPlayer.getCurrentPosition();
                    try {
                        this.mMediaPlayer.reset();
                        if (Build.VERSION.SDK_INT >= 21) {
                            AudioAttributes attributes = new AudioAttributes.Builder().setUsage(1).build();
                            this.mMediaPlayer.setAudioAttributes(attributes);
                        } else {
                            this.mMediaPlayer.setAudioStreamType(3);
                        }
                        this.mMediaPlayer.setVolume(1.0f, 1.0f);
                        fis = new FileInputStream(this.mUriPlaying.getPath());
                        this.mMediaPlayer.setDataSource(fis.getFD());
                        this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                            public void onPrepared(MediaPlayer mp) {
                                mp.seekTo(positions);
                            }
                        });
                        this.mMediaPlayer.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

                            public void onSeekComplete(MediaPlayer mp) {
                                mp.start();
                            }
                        });
                        this.mMediaPlayer.prepareAsync();
                    }
                    catch (IOException e) {
                        RLog.e((String)TAG, (String)"onSensorChanged", (Throwable)e);
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e) {
                                RLog.e((String)TAG, (String)"startPlay", (Throwable)e);
                            }
                        }
                    }
                    this.setScreenOn();
                } else {
                    if (!Build.BRAND.equals("samsung") || !Build.MODEL.equals("SM-N9200")) {
                        this.setScreenOff();
                    }
                    if (Build.VERSION.SDK_INT >= 11) {
                        if (this.mAudioManager.getMode() == 3) {
                            return;
                        }
                        this.mAudioManager.setMode(3);
                    } else {
                        if (this.mAudioManager.getMode() == 2) {
                            return;
                        }
                        this.mAudioManager.setMode(2);
                    }
                    this.mAudioManager.setSpeakerphoneOn(false);
                    this.replay();
                }
            } else if ((double)range > 0.0) {
                if (this.mAudioManager.getMode() == 0) {
                    return;
                }
                this.mAudioManager.setMode(0);
                this.mAudioManager.setSpeakerphoneOn(true);
                this.setScreenOn();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean judgeCondition(SensorEvent event, float range, double rangeJudgeValue) {
        Object object = this.mLock;
        synchronized (object) {
            boolean judge;
            if (Build.BRAND.equalsIgnoreCase("HUAWEI")) {
                judge = range >= event.sensor.getMaximumRange();
            } else {
                if (Build.BRAND.equalsIgnoreCase("ZTE")) {
                    rangeJudgeValue = 1.0;
                } else if (Build.BRAND.equalsIgnoreCase("nubia")) {
                    rangeJudgeValue = 3.0;
                }
                judge = (double)range > rangeJudgeValue;
            }
            return judge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=21)
    private void setScreenOff() {
        Object object = this.mLock;
        synchronized (object) {
            if (this._wakeLock == null && this._powerManager != null) {
                this._wakeLock = this._powerManager.newWakeLock(32, "AudioPlayManager:wakelockTag");
            }
            if (this._wakeLock != null && !this._wakeLock.isHeld()) {
                this._wakeLock.acquire(600000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setScreenOn() {
        Object object = this.mLock;
        synchronized (object) {
            if (this._wakeLock != null && this._wakeLock.isHeld()) {
                this._wakeLock.setReferenceCounted(false);
                this._wakeLock.release();
                this._wakeLock = null;
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replay() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMediaPlayer == null) {
                return;
            }
            FileInputStream fis = null;
            try {
                AudioAttributes attributes;
                this.mMediaPlayer.reset();
                if (Build.BRAND.equals("samsung") && Build.MODEL.equals("SM-N9200")) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        attributes = new AudioAttributes.Builder().setUsage(2).build();
                        this.mMediaPlayer.setAudioAttributes(attributes);
                    } else {
                        this.mMediaPlayer.setAudioStreamType(0);
                    }
                } else if (Build.VERSION.SDK_INT >= 21) {
                    attributes = new AudioAttributes.Builder().setUsage(1).build();
                    this.mMediaPlayer.setAudioAttributes(attributes);
                } else {
                    this.mMediaPlayer.setAudioStreamType(3);
                }
                this.mMediaPlayer.setVolume(1.0f, 1.0f);
                fis = new FileInputStream(this.mUriPlaying.getPath());
                this.mMediaPlayer.setDataSource(fis.getFD());
                this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                    public void onPrepared(MediaPlayer mp) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            RLog.e((String)AudioPlayManager.TAG, (String)"replay", (Throwable)e);
                            Thread.currentThread().interrupt();
                        }
                        mp.start();
                    }
                });
                this.mMediaPlayer.prepareAsync();
            }
            catch (IOException e) {
                RLog.e((String)TAG, (String)"replay", (Throwable)e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        RLog.e((String)TAG, (String)"replay", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPlay(final Context context, Uri audioUri, IAudioPlayListener playListener) {
        Object object = this.mLock;
        synchronized (object) {
            if (context == null || audioUri == null) {
                RLog.e((String)TAG, (String)"startPlay context or audioUri is null.");
                return;
            }
            this.mContext = context;
            if (this._playListener != null && this.mUriPlaying != null) {
                this._playListener.onStop(this.mUriPlaying);
            }
            this.resetMediaPlayer();
            this.afChangeListener = new AudioManager.OnAudioFocusChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onAudioFocusChange(int focusChange) {
                    Object object = AudioPlayManager.this.mLock;
                    synchronized (object) {
                        RLog.d((String)AudioPlayManager.TAG, (String)("OnAudioFocusChangeListener " + focusChange));
                        if (AudioPlayManager.this.mAudioManager != null && focusChange == -1) {
                            AudioPlayManager.this.mAudioManager.abandonAudioFocus(AudioPlayManager.this.afChangeListener);
                            AudioPlayManager.this.afChangeListener = null;
                            AudioPlayManager.this.handler.post(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object object = AudioPlayManager.this.mLock;
                                    synchronized (object) {
                                        if (AudioPlayManager.this._playListener != null) {
                                            AudioPlayManager.this._playListener.onComplete(AudioPlayManager.this.mUriPlaying);
                                            AudioPlayManager.this._playListener = null;
                                        }
                                    }
                                }
                            });
                            AudioPlayManager.this.reset();
                        }
                    }
                }
            };
            FileInputStream fis = null;
            ((Activity)context).getWindow().addFlags(128);
            try {
                this._powerManager = (PowerManager)context.getApplicationContext().getSystemService("power");
                this.mAudioManager = (AudioManager)context.getApplicationContext().getSystemService("audio");
                if (!this.isHeadphonesPlugged(this.mAudioManager)) {
                    this._sensorManager = (SensorManager)context.getApplicationContext().getSystemService("sensor");
                    if (this._sensorManager != null) {
                        this._sensor = this._sensorManager.getDefaultSensor(8);
                        this._sensorManager.registerListener((SensorEventListener)this, this._sensor, 3);
                    }
                }
                this.muteAudioFocus(this.mAudioManager, true);
                this._playListener = playListener;
                this.mUriPlaying = audioUri;
                this.mMediaPlayer = new MediaPlayer();
                this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onCompletion(MediaPlayer mp) {
                        Object object = AudioPlayManager.this.mLock;
                        synchronized (object) {
                            if (AudioPlayManager.this._playListener != null) {
                                AudioPlayManager.this._playListener.onComplete(AudioPlayManager.this.mUriPlaying);
                                AudioPlayManager.this._playListener = null;
                            }
                            AudioPlayManager.this.reset();
                            ((Activity)context).getWindow().clearFlags(128);
                        }
                    }
                });
                this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean onError(MediaPlayer mp, int what, int extra) {
                        Object object = AudioPlayManager.this.mLock;
                        synchronized (object) {
                            AudioPlayManager.this.reset();
                            return true;
                        }
                    }
                });
                fis = new FileInputStream(audioUri.getPath());
                this.mMediaPlayer.setDataSource(fis.getFD());
                if (Build.VERSION.SDK_INT >= 21) {
                    AudioAttributes attributes = new AudioAttributes.Builder().setUsage(1).build();
                    this.mMediaPlayer.setAudioAttributes(attributes);
                } else {
                    this.mMediaPlayer.setAudioStreamType(3);
                }
                this.mMediaPlayer.prepare();
                this.mMediaPlayer.start();
                if (this._playListener != null) {
                    this._playListener.onStart(this.mUriPlaying);
                }
            }
            catch (Exception e) {
                RLog.e((String)TAG, (String)"startPlay", (Throwable)e);
                if (this._playListener != null) {
                    this._playListener.onStop(audioUri);
                    this._playListener = null;
                }
                this.reset();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        RLog.e((String)TAG, (String)"startPlay", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHeadphonesPlugged(AudioManager audioManager) {
        Object object = this.mLock;
        synchronized (object) {
            if (audioManager == null) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                AudioDeviceInfo[] audioDevices;
                for (AudioDeviceInfo deviceInfo : audioDevices = audioManager.getDevices(3)) {
                    if (deviceInfo.getType() != 4 && deviceInfo.getType() != 3) continue;
                    return true;
                }
                return false;
            }
            return audioManager.isWiredHeadsetOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayListener(IAudioPlayListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this._playListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlay() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mContext != null) {
                ((Activity)this.mContext).getWindow().clearFlags(128);
            }
            if (this._playListener != null && this.mUriPlaying != null) {
                this._playListener.onStop(this.mUriPlaying);
            }
            this.reset();
        }
    }

    private void reset() {
        this.resetMediaPlayer();
        this.resetAudioPlayManager();
    }

    private void resetAudioPlayManager() {
        if (this.mAudioManager != null) {
            this.mAudioManager.setMode(0);
            this.muteAudioFocus(this.mAudioManager, false);
        }
        if (this._sensorManager != null) {
            this.setScreenOn();
            this._sensorManager.unregisterListener((SensorEventListener)this);
        }
        this._sensorManager = null;
        this._sensor = null;
        this._powerManager = null;
        this.mAudioManager = null;
        this._wakeLock = null;
        this.mUriPlaying = null;
        this._playListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetMediaPlayer() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMediaPlayer != null) {
                try {
                    this.mMediaPlayer.stop();
                    this.mMediaPlayer.reset();
                    this.mMediaPlayer.release();
                    this.mMediaPlayer = null;
                }
                catch (IllegalStateException e) {
                    RLog.e((String)TAG, (String)"resetMediaPlayer", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri getPlayingUri() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUriPlaying != null ? this.mUriPlaying : Uri.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=8)
    private void muteAudioFocus(AudioManager audioManager, boolean bMute) {
        Object object = this.mLock;
        synchronized (object) {
            if (audioManager == null) {
                return;
            }
            if (bMute) {
                audioManager.requestAudioFocus(this.afChangeListener, 3, 2);
            } else {
                audioManager.abandonAudioFocus(this.afChangeListener);
                this.afChangeListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInNormalMode(Context context) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAudioManager == null) {
                this.mAudioManager = (AudioManager)context.getApplicationContext().getSystemService("audio");
            }
            return this.mAudioManager != null && this.mAudioManager.getMode() == 0;
        }
    }

    public boolean isInVOIPMode(Context context) {
        return this.isVOIPMode;
    }

    public void setInVoipMode(boolean isVOIPMode) {
        this.isVOIPMode = isVOIPMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaying() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mMediaPlayer != null && this.mMediaPlayer.isPlaying();
        }
    }

    static class SingletonHolder {
        static AudioPlayManager sInstance = new AudioPlayManager();

        SingletonHolder() {
        }
    }
}

