/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.fragment.BaseSettingFragment;
import io.rong.imkit.model.Event;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;

public class SetConversationToTopFragment
extends BaseSettingFragment {
    private static String TAG = SetConversationToTopFragment.class.getSimpleName();

    @Override
    protected void initData() {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().getEventBus().register((Object)this);
        }
        RongIM.getInstance().getConversation(this.getConversationType(), this.getTargetId(), new RongIMClient.ResultCallback<Conversation>(){

            public void onSuccess(Conversation conversation) {
                if (conversation != null) {
                    SetConversationToTopFragment.this.setSwitchBtnStatus(conversation.isTop());
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
            }
        });
    }

    @Override
    protected boolean setSwitchButtonEnabled() {
        return true;
    }

    @Override
    protected String setTitle() {
        return this.getString(R.string.rc_setting_set_top);
    }

    @Override
    public boolean handleMessage(Message msg) {
        return false;
    }

    @Override
    protected void onSettingItemClick(View v) {
        RLog.i((String)TAG, (String)("onSettingItemClick, " + v.toString()));
    }

    @Override
    protected int setSwitchBtnVisibility() {
        return 0;
    }

    @Override
    protected void toggleSwitch(boolean toggle) {
        if (this.getConversationType() != null && !TextUtils.isEmpty((CharSequence)this.getTargetId())) {
            RongIM.getInstance().setConversationToTop(this.getConversationType(), this.getTargetId(), toggle, null);
        } else {
            RLog.e((String)TAG, (String)"toggleSwitch() args is null");
        }
    }

    public void onEventMainThread(Event.ConversationTopEvent conversationTopEvent) {
        if (conversationTopEvent != null && conversationTopEvent.getTargetId().equals(this.getTargetId()) && conversationTopEvent.getConversationType().getValue() == this.getConversationType().getValue()) {
            this.setSwitchBtnStatus(conversationTopEvent.isTop());
        }
    }

    @Override
    public void onDestroy() {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().getEventBus().unregister((Object)this);
        }
        super.onDestroy();
    }
}

