/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.fragment.BaseSettingFragment;
import io.rong.imkit.model.Event;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;

public class SetConversationNotificationFragment
extends BaseSettingFragment {
    private static final String TAG = "SetConversationNotificationFragment";

    public static SetConversationNotificationFragment newInstance() {
        return new SetConversationNotificationFragment();
    }

    @Override
    protected void initData() {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().getEventBus().register((Object)this);
        }
        RongIM.getInstance().getConversationNotificationStatus(this.getConversationType(), this.getTargetId(), new RongIMClient.ResultCallback<Conversation.ConversationNotificationStatus>(){

            public void onSuccess(Conversation.ConversationNotificationStatus notificationStatus) {
                if (notificationStatus != null) {
                    SetConversationNotificationFragment.this.setSwitchBtnStatus(notificationStatus != Conversation.ConversationNotificationStatus.DO_NOT_DISTURB);
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                SetConversationNotificationFragment.this.setSwitchBtnStatus(!SetConversationNotificationFragment.this.getSwitchBtnStatus());
            }
        });
    }

    @Override
    protected boolean setSwitchButtonEnabled() {
        return true;
    }

    @Override
    protected String setTitle() {
        return this.getString(R.string.rc_setting_conversation_notify);
    }

    @Override
    public boolean handleMessage(Message msg) {
        return false;
    }

    @Override
    protected void onSettingItemClick(View v) {
        RLog.i((String)TAG, (String)("onSettingItemClick, " + v.toString()));
    }

    @Override
    protected int setSwitchBtnVisibility() {
        return 0;
    }

    @Override
    protected void toggleSwitch(boolean toggle) {
        Conversation.ConversationNotificationStatus status = toggle ? Conversation.ConversationNotificationStatus.NOTIFY : Conversation.ConversationNotificationStatus.DO_NOT_DISTURB;
        if (this.getConversationType() != null && !TextUtils.isEmpty((CharSequence)this.getTargetId())) {
            RongIM.getInstance().setConversationNotificationStatus(this.getConversationType(), this.getTargetId(), status, new RongIMClient.ResultCallback<Conversation.ConversationNotificationStatus>(){

                public void onSuccess(Conversation.ConversationNotificationStatus status) {
                    RLog.i((String)SetConversationNotificationFragment.TAG, (String)"SetConversationNotificationFragment onSuccess--");
                }

                public void onError(RongIMClient.ErrorCode errorCode) {
                    SetConversationNotificationFragment.this.setSwitchBtnStatus(!SetConversationNotificationFragment.this.getSwitchBtnStatus());
                }
            });
        } else {
            RLog.e((String)TAG, (String)"SetConversationNotificationFragment Arguments is null");
        }
    }

    public void onEventMainThread(Event.ConversationNotificationEvent event) {
        if (event != null && event.getTargetId().equals(this.getTargetId()) && event.getConversationType().getValue() == this.getConversationType().getValue()) {
            this.setSwitchBtnStatus(event.getStatus() == Conversation.ConversationNotificationStatus.NOTIFY);
        }
    }

    @Override
    public void onDestroy() {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().getEventBus().unregister((Object)this);
        }
        super.onDestroy();
    }
}

