/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.fragment.DispatchResultFragment;
import io.rong.imkit.fragment.SetConversationNotificationFragment;
import io.rong.imkit.model.Event;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.LoadingDialogFragment;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.PublicServiceProfile;
import java.util.Locale;

public class PublicServiceProfileFragment
extends DispatchResultFragment {
    public static final String AGS_PUBLIC_ACCOUNT_INFO = "arg_public_account_info";
    PublicServiceProfile mPublicAccountInfo;
    private AsyncImageView mPortraitIV;
    private TextView mNameTV;
    private TextView mAccountTV;
    private TextView mDescriptionTV;
    private Button mEnterBtn;
    private Button mFollowBtn;
    private Button mUnfollowBtn;
    private String mTargetId;
    private Conversation.ConversationType mConversationType;
    private String name;
    private LoadingDialogFragment mLoadingDialogFragment;

    @Override
    protected void initFragment(Uri uri) {
        if (this.getActivity() != null && this.getActivity().getIntent() != null) {
            this.mPublicAccountInfo = (PublicServiceProfile)this.getActivity().getIntent().getParcelableExtra(AGS_PUBLIC_ACCOUNT_INFO);
        }
        if (uri != null) {
            if (this.mPublicAccountInfo == null) {
                String pathSeg = uri.getLastPathSegment();
                String typeStr = !TextUtils.isEmpty((CharSequence)pathSeg) ? pathSeg.toUpperCase(Locale.US) : "";
                this.mConversationType = Conversation.ConversationType.valueOf((String)typeStr);
                this.mTargetId = uri.getQueryParameter("targetId");
                this.name = uri.getQueryParameter("name");
            } else {
                this.mConversationType = this.mPublicAccountInfo.getConversationType();
                this.mTargetId = this.mPublicAccountInfo.getTargetId();
                this.name = this.mPublicAccountInfo.getName();
            }
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.rc_fr_public_service_inf, container, false);
        this.mPortraitIV = (AsyncImageView)view.findViewById(R.id.portrait);
        this.mNameTV = (TextView)view.findViewById(R.id.name);
        this.mAccountTV = (TextView)view.findViewById(R.id.account);
        this.mDescriptionTV = (TextView)view.findViewById(R.id.description);
        this.mEnterBtn = (Button)view.findViewById(R.id.enter);
        this.mFollowBtn = (Button)view.findViewById(R.id.follow);
        this.mUnfollowBtn = (Button)view.findViewById(R.id.unfollow);
        return view;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mLoadingDialogFragment = LoadingDialogFragment.newInstance("", this.getResources().getString(R.string.rc_notice_data_is_loading));
        if (this.mPublicAccountInfo != null) {
            this.initData(this.mPublicAccountInfo);
        } else if (!TextUtils.isEmpty((CharSequence)this.mTargetId)) {
            Conversation.PublicServiceType publicServiceType = null;
            if (this.mConversationType == Conversation.ConversationType.APP_PUBLIC_SERVICE) {
                publicServiceType = Conversation.PublicServiceType.APP_PUBLIC_SERVICE;
            } else if (this.mConversationType == Conversation.ConversationType.PUBLIC_SERVICE) {
                publicServiceType = Conversation.PublicServiceType.PUBLIC_SERVICE;
            } else {
                System.err.print("the public service type is error!!");
            }
            RongIM.getInstance().getPublicServiceProfile(publicServiceType, this.mTargetId, new RongIMClient.ResultCallback<PublicServiceProfile>(){

                public void onSuccess(PublicServiceProfile info) {
                    if (info != null) {
                        PublicServiceProfileFragment.this.initData(info);
                        RongUserInfoManager.getInstance().setPublicServiceProfile(info);
                    }
                }

                public void onError(RongIMClient.ErrorCode e) {
                    RLog.e((String)"PublicServiceProfileFragment", (String)"Failure to get data!!!");
                }
            });
        }
    }

    private void initData(final PublicServiceProfile info) {
        if (info != null) {
            this.mPortraitIV.setResource(info.getPortraitUri());
            this.mNameTV.setText((CharSequence)info.getName());
            this.mAccountTV.setText((CharSequence)String.format(this.getResources().getString(R.string.rc_pub_service_info_account), info.getTargetId()));
            this.mDescriptionTV.setText((CharSequence)info.getIntroduction());
            boolean isFollow = info.isFollow();
            boolean isGlobal = info.isGlobal();
            if (isGlobal) {
                if (this.getFragmentManager() != null) {
                    FragmentTransaction ft = this.getFragmentManager().beginTransaction();
                    ft.add(R.id.rc_layout, (Fragment)SetConversationNotificationFragment.newInstance());
                    ft.commitAllowingStateLoss();
                }
                this.mFollowBtn.setVisibility(8);
                this.mEnterBtn.setVisibility(0);
                this.mUnfollowBtn.setVisibility(8);
            } else if (isFollow) {
                if (this.getFragmentManager() != null) {
                    FragmentTransaction ft = this.getFragmentManager().beginTransaction();
                    ft.add(R.id.rc_layout, (Fragment)SetConversationNotificationFragment.newInstance());
                    ft.commitAllowingStateLoss();
                }
                this.mFollowBtn.setVisibility(8);
                this.mEnterBtn.setVisibility(0);
                this.mUnfollowBtn.setVisibility(0);
            } else {
                this.mFollowBtn.setVisibility(0);
                this.mEnterBtn.setVisibility(8);
                this.mUnfollowBtn.setVisibility(8);
            }
            this.mEnterBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RongIM.PublicServiceBehaviorListener listener = RongContext.getInstance().getPublicServiceBehaviorListener();
                    if (listener != null && listener.onEnterConversationClick(v.getContext(), info)) {
                        return;
                    }
                    if (PublicServiceProfileFragment.this.getActivity() != null) {
                        PublicServiceProfileFragment.this.getActivity().finish();
                    }
                    RongIM.getInstance().startConversation((Context)PublicServiceProfileFragment.this.getActivity(), info.getConversationType(), info.getTargetId(), info.getName());
                }
            });
            this.mFollowBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(final View v) {
                    Conversation.PublicServiceType publicServiceType = null;
                    if (PublicServiceProfileFragment.this.mConversationType == Conversation.ConversationType.APP_PUBLIC_SERVICE) {
                        publicServiceType = Conversation.PublicServiceType.APP_PUBLIC_SERVICE;
                    } else if (PublicServiceProfileFragment.this.mConversationType == Conversation.ConversationType.PUBLIC_SERVICE) {
                        publicServiceType = Conversation.PublicServiceType.PUBLIC_SERVICE;
                    } else {
                        System.err.print("the public service type is error!!");
                    }
                    RongIM.getInstance().subscribePublicService(publicServiceType, info.getTargetId(), new RongIMClient.OperationCallback(){

                        public void onSuccess() {
                            PublicServiceProfileFragment.this.mLoadingDialogFragment.dismiss();
                            PublicServiceProfileFragment.this.mFollowBtn.setVisibility(8);
                            PublicServiceProfileFragment.this.mEnterBtn.setVisibility(0);
                            PublicServiceProfileFragment.this.mUnfollowBtn.setVisibility(0);
                            RongUserInfoManager.getInstance().setPublicServiceProfile(info);
                            RongContext.getInstance().getEventBus().post(Event.PublicServiceFollowableEvent.obtain(info.getTargetId(), info.getConversationType(), true));
                            RongIM.PublicServiceBehaviorListener listener = RongContext.getInstance().getPublicServiceBehaviorListener();
                            if (listener != null && listener.onFollowClick(v.getContext(), info)) {
                                return;
                            }
                            if (PublicServiceProfileFragment.this.getActivity() != null) {
                                PublicServiceProfileFragment.this.getActivity().finish();
                            }
                            RongIM.getInstance().startConversation((Context)PublicServiceProfileFragment.this.getActivity(), info.getConversationType(), info.getTargetId(), info.getName());
                        }

                        public void onError(RongIMClient.ErrorCode errorCode) {
                            PublicServiceProfileFragment.this.mLoadingDialogFragment.dismiss();
                        }
                    });
                    PublicServiceProfileFragment.this.mLoadingDialogFragment.show(PublicServiceProfileFragment.this.getFragmentManager());
                }
            });
            this.mUnfollowBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(final View v) {
                    Conversation.PublicServiceType publicServiceType = null;
                    if (PublicServiceProfileFragment.this.mConversationType == Conversation.ConversationType.APP_PUBLIC_SERVICE) {
                        publicServiceType = Conversation.PublicServiceType.APP_PUBLIC_SERVICE;
                    } else if (PublicServiceProfileFragment.this.mConversationType == Conversation.ConversationType.PUBLIC_SERVICE) {
                        publicServiceType = Conversation.PublicServiceType.PUBLIC_SERVICE;
                    } else {
                        System.err.print("the public service type is error!!");
                    }
                    RongIM.getInstance().unsubscribePublicService(publicServiceType, info.getTargetId(), new RongIMClient.OperationCallback(){

                        public void onSuccess() {
                            PublicServiceProfileFragment.this.mFollowBtn.setVisibility(0);
                            PublicServiceProfileFragment.this.mEnterBtn.setVisibility(8);
                            PublicServiceProfileFragment.this.mUnfollowBtn.setVisibility(8);
                            RongContext.getInstance().getEventBus().post(Event.PublicServiceFollowableEvent.obtain(info.getTargetId(), info.getConversationType(), false));
                            RongIM.PublicServiceBehaviorListener listener = RongContext.getInstance().getPublicServiceBehaviorListener();
                            if (listener != null && listener.onUnFollowClick(v.getContext(), info)) {
                                return;
                            }
                            if (PublicServiceProfileFragment.this.getActivity() != null) {
                                PublicServiceProfileFragment.this.getActivity().finish();
                            }
                        }

                        public void onError(RongIMClient.ErrorCode errorCode) {
                        }
                    });
                }
            });
        }
    }

    @Override
    public boolean handleMessage(Message msg) {
        return false;
    }
}

