/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import io.rong.imkit.R;
import io.rong.imkit.RongConfigurationManager;
import io.rong.imkit.activity.FileListActivity;
import io.rong.imkit.model.FileInfo;
import io.rong.imkit.utils.FileTypeUtils;
import io.rong.imkit.widget.LoadingDialogFragment;
import io.rong.imkit.widget.adapter.FileListAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class FileListFragment
extends Fragment
implements AdapterView.OnItemClickListener,
View.OnClickListener {
    private static final String MOBILE_DIR = "directory";
    private static final int ALL_FILE_FILES = 1;
    private static final int ALL_VIDEO_FILES = 2;
    private static final int ALL_AUDIO_FILES = 3;
    private static final int ALL_other_FILES = 4;
    private static final int ALL_RAM_FILES = 5;
    private static final int ALL_SD_FILES = 6;
    private static final int ROOT_DIR = 100;
    private static final int SD_CARD_ROOT_DIR = 101;
    private static final int FILE_TRAVERSE_TYPE_ONE = 200;
    private static final int FILE_TRAVERSE_TYPE_TWO = 201;
    private ImageView mFileListTitleImageBack;
    private TextView mFilesCategoryTitleTextView;
    private TextView mFileSelectStateTextView;
    private ListView mFilesListView;
    private LinearLayout mFileLoadingLinearLayout;
    private TextView mNoFileMessageTextView;
    private FileListAdapter mFileListAdapter;
    private AsyncTask mLoadFilesTask;
    private List<FileInfo> mFilesList;
    private HashSet<FileInfo> mSelectedFiles = new HashSet();
    private File currentDir;
    private File startDir;
    private String mFileInfoMessage;
    private int fileTraverseType;
    private int fileFilterType;
    private LoadingDialogFragment mLoadingDialogFragment;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getActivity() == null) {
            return;
        }
        Intent intent = this.getActivity().getIntent();
        int rootDirType = intent.getIntExtra("rootDirType", -1);
        this.fileFilterType = intent.getIntExtra("fileFilterType", -1);
        this.fileTraverseType = intent.getIntExtra("fileTraverseType", -1);
        String mPath = intent.getStringExtra("rootDir");
        Bundle arguments = this.getArguments();
        if (arguments != null && arguments.containsKey(MOBILE_DIR)) {
            this.currentDir = new File(arguments.getString(MOBILE_DIR));
        } else if (rootDirType == 100) {
            String path = Environment.getExternalStorageDirectory().getPath();
            this.currentDir = new File(path);
        } else if (rootDirType == 101) {
            this.currentDir = new File(mPath);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.rc_fr_file_list, container, false);
        this.mFileListTitleImageBack = (ImageView)view.findViewById(R.id.rc_ad_iv_file_list_go_back);
        this.mFilesCategoryTitleTextView = (TextView)view.findViewById(R.id.rc_ad_tv_file_list_title);
        this.mFileSelectStateTextView = (TextView)view.findViewById(R.id.rc_ad_tv_file_list_select_state);
        this.mFilesListView = (ListView)view.findViewById(R.id.rc_fm_lv_storage_folder_list_files);
        this.mFileLoadingLinearLayout = (LinearLayout)view.findViewById(R.id.rc_fm_ll_storage_folder_list_load);
        this.mNoFileMessageTextView = (TextView)view.findViewById(R.id.rc_fm_tv_no_file_message);
        return view;
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mLoadingDialogFragment = LoadingDialogFragment.newInstance("", this.getResources().getString(R.string.rc_notice_data_is_loading));
        this.loadFileList();
        String text = "";
        switch (this.fileFilterType) {
            case 1: {
                text = this.getString(R.string.rc_fr_file_category_title_text);
                break;
            }
            case 2: {
                text = this.getString(R.string.rc_fr_file_category_title_video);
                break;
            }
            case 3: {
                text = this.getString(R.string.rc_fr_file_category_title_audio);
                break;
            }
            case 4: {
                text = this.getString(R.string.rc_fr_file_category_title_other);
                break;
            }
            case 5: {
                text = this.getString(R.string.rc_fr_file_category_title_ram);
                break;
            }
            case 6: {
                text = this.getString(R.string.rc_fr_file_category_title_sd);
            }
        }
        this.mFilesCategoryTitleTextView.setText((CharSequence)text);
        this.mFilesListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mFileListTitleImageBack.setOnClickListener((View.OnClickListener)this);
        this.mFileSelectStateTextView.setOnClickListener((View.OnClickListener)this);
        this.mFileSelectStateTextView.setClickable(false);
        this.mFileSelectStateTextView.setSelected(false);
    }

    public void onDestroyView() {
        this.mFilesListView = null;
        this.mLoadingDialogFragment = null;
        super.onDestroyView();
    }

    public void onDestroy() {
        if (this.mLoadFilesTask != null) {
            this.mLoadFilesTask.cancel(true);
        }
        super.onDestroy();
    }

    @TargetApi(value=11)
    private void loadFileList() {
        if (this.mLoadFilesTask != null) {
            return;
        }
        this.mLoadFilesTask = Build.VERSION.SDK_INT >= 11 ? new AsyncTask<File, Void, List<FileInfo>>(){

            protected void onPreExecute() {
                FileListFragment.this.mLoadingDialogFragment.show(FileListFragment.this.getFragmentManager());
                if (FileListFragment.this.fileTraverseType == 200) {
                    FileListFragment.this.showLoadingFileView();
                }
                super.onPreExecute();
            }

            protected List<FileInfo> doInBackground(File ... params) {
                FileListFragment.this.mFileInfoMessage = "";
                try {
                    List<Object> fileInfos = new ArrayList();
                    if (FileListFragment.this.fileTraverseType == 201) {
                        File[] files = params[0].listFiles(FileTypeUtils.ALL_FOLDER_AND_FILES_FILTER);
                        fileInfos = FileTypeUtils.getFileInfosFromFileArray(files);
                    } else if (FileListFragment.this.fileTraverseType == 200) {
                        if (FileListFragment.this.getActivity() == null) {
                            return fileInfos;
                        }
                        FileListFragment.this.startDir = new File(Environment.getExternalStorageDirectory().getPath());
                        switch (FileListFragment.this.fileFilterType) {
                            case 1: {
                                fileInfos = FileTypeUtils.getTextFilesInfo((Context)FileListFragment.this.getActivity(), FileListFragment.this.startDir);
                                FileListFragment.this.mFileInfoMessage = FileListFragment.this.getString(R.string.rc_fr_file_category_title_text);
                                break;
                            }
                            case 2: {
                                fileInfos = FileTypeUtils.getVideoFilesInfo((Context)FileListFragment.this.getActivity(), FileListFragment.this.startDir);
                                FileListFragment.this.mFileInfoMessage = FileListFragment.this.getString(R.string.rc_fr_file_category_title_video);
                                break;
                            }
                            case 3: {
                                fileInfos = FileTypeUtils.getAudioFilesInfo((Context)FileListFragment.this.getActivity(), FileListFragment.this.startDir);
                                FileListFragment.this.mFileInfoMessage = FileListFragment.this.getString(R.string.rc_fr_file_category_title_audio);
                                break;
                            }
                            case 4: {
                                fileInfos = FileTypeUtils.getOtherFilesInfo((Context)FileListFragment.this.getActivity(), FileListFragment.this.startDir);
                                FileListFragment.this.mFileInfoMessage = FileListFragment.this.getString(R.string.rc_fr_file_category_title_other);
                            }
                        }
                    }
                    if (fileInfos == null) {
                        return new ArrayList<FileInfo>();
                    }
                    if (this.isCancelled()) {
                        return new ArrayList<FileInfo>();
                    }
                    Collections.sort(fileInfos, new FileTypeUtils.FileNameComparator());
                    if (FileListFragment.this.mLoadingDialogFragment != null) {
                        FileListFragment.this.mLoadingDialogFragment.dismiss();
                    }
                    return fileInfos;
                }
                catch (Exception e) {
                    if (FileListFragment.this.mLoadingDialogFragment != null) {
                        FileListFragment.this.mLoadingDialogFragment.dismiss();
                    }
                    return new ArrayList<FileInfo>();
                }
            }

            protected void onCancelled() {
                FileListFragment.this.mLoadFilesTask = null;
                if (FileListFragment.this.mLoadingDialogFragment != null) {
                    FileListFragment.this.mLoadingDialogFragment.dismiss();
                }
                super.onCancelled();
            }

            protected void onPostExecute(List<FileInfo> fileInfos) {
                FileListFragment.this.mFileLoadingLinearLayout.setVisibility(8);
                FileListFragment.this.mFilesListView.setVisibility(0);
                FileListFragment.this.mLoadFilesTask = null;
                try {
                    FileListFragment.this.mFilesList = fileInfos;
                    if (FileListFragment.this.mFilesList.isEmpty()) {
                        FileListFragment.this.showNoFileMessage(FileListFragment.this.mFileInfoMessage);
                        return;
                    }
                    FileListFragment.this.mFileListAdapter = new FileListAdapter((Context)FileListFragment.this.getActivity(), FileListFragment.this.mFilesList, FileListFragment.this.mSelectedFiles);
                    FileListFragment.this.setListViewAdapter(FileListFragment.this.mFileListAdapter);
                }
                catch (Exception e) {
                    FileListFragment.this.showNoFileMessage(e.getMessage());
                }
                super.onPostExecute(fileInfos);
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new File[]{this.currentDir}) : new AsyncTask<File, Void, List<FileInfo>>(){

            protected void onPreExecute() {
                if (FileListFragment.this.fileTraverseType == 200) {
                    FileListFragment.this.showLoadingFileView();
                }
                super.onPreExecute();
            }

            protected List<FileInfo> doInBackground(File ... params) {
                FileListFragment.this.mFileInfoMessage = "";
                try {
                    ArrayList<FileInfo> fileInfos = new ArrayList();
                    if (FileListFragment.this.fileTraverseType == 201) {
                        File[] files = params[0].listFiles(FileTypeUtils.ALL_FOLDER_AND_FILES_FILTER);
                        fileInfos = FileTypeUtils.getFileInfosFromFileArray(files);
                    } else if (FileListFragment.this.fileTraverseType == 200) {
                        switch (FileListFragment.this.fileFilterType) {
                            case 1: {
                                fileInfos = FileTypeUtils.getTextFilesInfo((Context)FileListFragment.this.getActivity(), FileListFragment.this.startDir);
                                FileListFragment.this.mFileInfoMessage = FileListFragment.this.getString(R.string.rc_fr_file_category_title_text);
                                break;
                            }
                            case 2: {
                                fileInfos = FileTypeUtils.getVideoFilesInfo(FileListFragment.this.getContext(), FileListFragment.this.startDir);
                                FileListFragment.this.mFileInfoMessage = FileListFragment.this.getString(R.string.rc_fr_file_category_title_video);
                                break;
                            }
                            case 3: {
                                fileInfos = FileTypeUtils.getAudioFilesInfo(FileListFragment.this.getContext(), FileListFragment.this.startDir);
                                FileListFragment.this.mFileInfoMessage = FileListFragment.this.getString(R.string.rc_fr_file_category_title_audio);
                                break;
                            }
                            case 4: {
                                fileInfos = FileTypeUtils.getOtherFilesInfo(FileListFragment.this.getContext(), FileListFragment.this.startDir);
                                FileListFragment.this.mFileInfoMessage = FileListFragment.this.getString(R.string.rc_fr_file_category_title_other);
                            }
                        }
                    }
                    if (fileInfos == null) {
                        return new ArrayList<FileInfo>();
                    }
                    if (this.isCancelled()) {
                        return new ArrayList<FileInfo>();
                    }
                    Collections.sort(fileInfos, new FileTypeUtils.FileNameComparator());
                    if (FileListFragment.this.mLoadingDialogFragment != null) {
                        FileListFragment.this.mLoadingDialogFragment.dismiss();
                    }
                    return fileInfos;
                }
                catch (Exception e) {
                    return new ArrayList<FileInfo>();
                }
            }

            protected void onCancelled() {
                FileListFragment.this.mLoadFilesTask = null;
                if (FileListFragment.this.mLoadingDialogFragment != null) {
                    FileListFragment.this.mLoadingDialogFragment.dismiss();
                }
                super.onCancelled();
            }

            protected void onPostExecute(List<FileInfo> fileInfos) {
                FileListFragment.this.mFileLoadingLinearLayout.setVisibility(8);
                FileListFragment.this.mFilesListView.setVisibility(0);
                FileListFragment.this.mLoadFilesTask = null;
                try {
                    FileListFragment.this.mFilesList = fileInfos;
                    if (FileListFragment.this.mFilesList.isEmpty()) {
                        FileListFragment.this.showNoFileMessage(FileListFragment.this.mFileInfoMessage);
                        return;
                    }
                    FileListFragment.this.mFileListAdapter = new FileListAdapter((Context)FileListFragment.this.getActivity(), FileListFragment.this.mFilesList, FileListFragment.this.mSelectedFiles);
                    FileListFragment.this.setListViewAdapter(FileListFragment.this.mFileListAdapter);
                }
                catch (Exception e) {
                    FileListFragment.this.showNoFileMessage(e.getMessage());
                }
                super.onPostExecute(fileInfos);
            }
        }.execute((Object[])new File[]{this.currentDir});
    }

    private void setListViewAdapter(FileListAdapter fileListAdapter) {
        this.mFileListAdapter = fileListAdapter;
        if (this.mFilesListView != null) {
            this.mFilesListView.setAdapter((ListAdapter)fileListAdapter);
        }
    }

    private void showLoadingFileView() {
        this.mFilesListView.setVisibility(8);
        this.mNoFileMessageTextView.setVisibility(8);
        this.mFileLoadingLinearLayout.setVisibility(0);
    }

    private void showNoFileMessage(String message) {
        this.mFilesListView.setVisibility(8);
        this.mFileLoadingLinearLayout.setVisibility(8);
        this.mNoFileMessageTextView.setVisibility(0);
        this.mNoFileMessageTextView.setText((CharSequence)this.getResources().getString(R.string.rc_fr_no_file_message, new Object[]{message}));
    }

    private void navigateTo(File folder) {
        FileListActivity activity = (FileListActivity)this.getActivity();
        FileListFragment fragment = new FileListFragment();
        Bundle args = new Bundle();
        args.putString(MOBILE_DIR, folder.getAbsolutePath());
        fragment.setArguments(args);
        if (activity != null) {
            activity.showFragment(fragment);
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object selectedObject = parent.getItemAtPosition(position);
        if (selectedObject instanceof FileInfo) {
            FileInfo selectedFile = (FileInfo)selectedObject;
            if (selectedFile.isDirectory()) {
                this.navigateTo(new File(selectedFile.getFilePath()));
            } else {
                int fileMaxSize = RongConfigurationManager.getInstance().getFileMaxSize((Context)this.getActivity());
                String unit = "MB";
                if (fileMaxSize >= 1024) {
                    unit = "GB";
                }
                if (selectedFile.getFileSize() > (long)fileMaxSize * 1024L * 1024L) {
                    if (unit.equals("GB")) {
                        fileMaxSize /= 1024;
                    }
                    Toast.makeText((Context)this.getActivity(), (CharSequence)String.format(this.getResources().getString(R.string.rc_fr_file_size_limit), fileMaxSize, unit), (int)0).show();
                    return;
                }
                if (this.mSelectedFiles.contains(selectedFile)) {
                    this.mSelectedFiles.remove(selectedFile);
                    this.mFileListAdapter.notifyDataSetChanged();
                } else if (!view.isSelected() && this.mSelectedFiles.size() < 20) {
                    this.mSelectedFiles.add(selectedFile);
                    this.mFileListAdapter.notifyDataSetChanged();
                } else {
                    Toast.makeText((Context)this.getActivity(), (CharSequence)this.getResources().getString(R.string.rc_fr_file_list_most_selected_files), (int)0).show();
                }
                if (this.mSelectedFiles.size() > 0) {
                    this.mFileSelectStateTextView.setClickable(true);
                    this.mFileSelectStateTextView.setSelected(true);
                    this.mFileSelectStateTextView.setText((CharSequence)this.getResources().getString(R.string.rc_ad_send_file_select_file, new Object[]{this.mSelectedFiles.size()}));
                } else {
                    this.mFileSelectStateTextView.setClickable(false);
                    this.mFileSelectStateTextView.setSelected(false);
                    this.mFileSelectStateTextView.setText((CharSequence)this.getResources().getString(R.string.rc_ad_send_file_no_select_file));
                }
            }
        }
    }

    public void onClick(View v) {
        if (this.getActivity() == null) {
            return;
        }
        if (v == this.mFileSelectStateTextView) {
            Intent intent = new Intent();
            intent.putExtra("selectedFiles", this.mSelectedFiles);
            this.getActivity().setResult(-1, intent);
            this.getActivity().finish();
        }
        if (v == this.mFileListTitleImageBack) {
            this.getActivity().finish();
        }
    }
}

