/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import io.rong.common.RLog;
import io.rong.eventbus.EventBus;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.fragment.IHistoryDataResultCallback;
import io.rong.imkit.fragment.UriFragment;
import io.rong.imkit.manager.InternalModuleManager;
import io.rong.imkit.model.Event;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.model.UIConversation;
import io.rong.imkit.utilities.OptionsPopupDialog;
import io.rong.imkit.voiceMessageDownload.AutoDownloadEntry;
import io.rong.imkit.voiceMessageDownload.HQVoiceMsgDownloadManager;
import io.rong.imkit.widget.RongSwipeRefreshLayout;
import io.rong.imkit.widget.adapter.ConversationListAdapter;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.ConversationStatus;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.UserInfo;
import io.rong.message.ReadReceiptMessage;
import io.rong.push.RongPushClient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConversationListFragment
extends UriFragment
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener,
ConversationListAdapter.OnPortraitItemClick,
RongSwipeRefreshLayout.OnLoadListener,
RongSwipeRefreshLayout.OnFlushListener {
    public static final String TAG = ConversationListFragment.class.getSimpleName();
    private List<ConversationConfig> mConversationsConfig;
    private ConversationListFragment mThis;
    private ConversationListAdapter mAdapter;
    private ListView mList;
    private RongSwipeRefreshLayout mRefreshLayout;
    private View netWorkBar;
    private View headerNetWorkView;
    private ImageView headerNetWorkImage;
    private TextView headerNetWorkText;
    private boolean isShowWithoutConnected = false;
    private int leftOfflineMsg = 0;
    private boolean enableAutomaticDownloadMsg;
    private long timestamp = 0L;
    private int pageSize = 100;
    private static final int REQUEST_MSG_DOWNLOAD_PERMISSION = 1001;
    private ArrayList<Message> cacheEventList = new ArrayList();

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mThis = this;
        this.mConversationsConfig = new ArrayList<ConversationConfig>();
        EventBus.getDefault().register(this);
        InternalModuleManager.getInstance().onLoaded();
    }

    @Override
    protected void initFragment(Uri uri) {
        RLog.d((String)TAG, (String)("initFragment " + uri));
        if (this.mConversationsConfig == null) {
            this.mConversationsConfig = new ArrayList<ConversationConfig>();
        }
        Conversation.ConversationType[] defConversationType = new Conversation.ConversationType[]{Conversation.ConversationType.PRIVATE, Conversation.ConversationType.GROUP, Conversation.ConversationType.DISCUSSION, Conversation.ConversationType.SYSTEM, Conversation.ConversationType.CUSTOMER_SERVICE, Conversation.ConversationType.CHATROOM, Conversation.ConversationType.PUBLIC_SERVICE, Conversation.ConversationType.APP_PUBLIC_SERVICE, Conversation.ConversationType.ENCRYPTED};
        this.timestamp = 0L;
        this.isShowWithoutConnected = false;
        this.leftOfflineMsg = 0;
        this.mConversationsConfig.clear();
        for (Conversation.ConversationType conversationType : defConversationType) {
            if (uri.getQueryParameter(conversationType.getName()) == null) continue;
            ConversationConfig config = new ConversationConfig();
            config.conversationType = conversationType;
            config.isGathered = "true".equals(uri.getQueryParameter(conversationType.getName()));
            this.mConversationsConfig.add(config);
        }
        if (this.mConversationsConfig.size() == 0) {
            String type = uri.getQueryParameter("type");
            for (Conversation.ConversationType conversationType : defConversationType) {
                if (!conversationType.getName().equals(type)) continue;
                ConversationConfig config = new ConversationConfig();
                config.conversationType = conversationType;
                config.isGathered = false;
                this.mConversationsConfig.add(config);
                break;
            }
        }
        this.mAdapter.clear();
        if (RongIMClient.getInstance().getCurrentConnectionStatus().equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.UNCONNECTED)) {
            RLog.d((String)TAG, (String)"RongCloud haven't been connected yet, so the conversation list display blank !!!");
            this.isShowWithoutConnected = true;
            return;
        }
        this.getConversationList(this.getConfigConversationTypes(), false);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.rc_fr_conversationlist, container, false);
        Object emptyView = this.findViewById(view, R.id.rc_conversation_list_empty_layout);
        TextView emptyText = (TextView)this.findViewById(view, R.id.rc_empty_tv);
        if (this.getActivity() != null) {
            emptyText.setText((CharSequence)this.getActivity().getResources().getString(R.string.rc_conversation_list_empty_prompt));
        }
        this.mList = (ListView)this.findViewById(view, R.id.rc_list);
        this.mRefreshLayout = (RongSwipeRefreshLayout)((Object)this.findViewById(view, R.id.rc_refresh));
        this.mList.setEmptyView(emptyView);
        this.inflateHeaderView();
        this.mList.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mList.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this);
        if (this.mAdapter == null) {
            this.mAdapter = this.onResolveAdapter((Context)this.getActivity());
        }
        this.mAdapter.setOnPortraitItemClick(this);
        this.mRefreshLayout.setCanRefresh(false);
        this.mRefreshLayout.setCanLoading(true);
        this.mRefreshLayout.setOnLoadListener(this);
        this.mRefreshLayout.setOnFlushListener(this);
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        if (this.getContext() != null) {
            Resources resources = this.getContext().getResources();
            this.enableAutomaticDownloadMsg = resources.getBoolean(R.bool.rc_enable_automatic_download_voice_msg);
        }
        this.headerNetWorkView = this.findViewById(view, R.id.rc_status_bar);
        this.headerNetWorkImage = (ImageView)this.findViewById(view, R.id.rc_status_bar_image);
        this.headerNetWorkText = (TextView)this.findViewById(view, R.id.rc_status_bar_text);
        return view;
    }

    @Override
    public void onResume() {
        super.onResume();
        RLog.d((String)TAG, (String)("onResume " + RongIM.getInstance().getCurrentConnectionStatus()));
        if (this.getResources().getBoolean(R.bool.rc_wipe_out_notification_message)) {
            RongPushClient.clearAllNotifications((Context)this.getActivity());
        }
        this.setNotificationBarVisibility(RongIM.getInstance().getCurrentConnectionStatus());
    }

    private void inflateHeaderView() {
        List<View> headerViews = this.onAddHeaderView();
        if (headerViews != null && headerViews.size() > 0) {
            for (View headerView : headerViews) {
                this.mList.addHeaderView(headerView);
            }
        }
    }

    private void getConversationList(Conversation.ConversationType[] conversationTypes, final boolean isLoadMore) {
        this.getConversationList(conversationTypes, new IHistoryDataResultCallback<List<Conversation>>(){

            @Override
            public void onResult(List<Conversation> data) {
                if (data != null && data.size() > 0) {
                    ConversationListFragment.this.makeUiConversationList(data);
                    RLog.d((String)TAG, (String)("getConversationList : listSize = " + data.size()));
                    ConversationListFragment.this.mAdapter.notifyDataSetChanged();
                    ConversationListFragment.this.onUnreadCountChanged();
                    ConversationListFragment.this.updateConversationReadReceipt(ConversationListFragment.this.cacheEventList);
                } else {
                    ConversationListFragment.this.isShowWithoutConnected = true;
                }
                ConversationListFragment.this.onFinishLoadConversationList(ConversationListFragment.this.leftOfflineMsg);
                if (!isLoadMore) {
                    ConversationListFragment.this.mRefreshLayout.setRefreshing(false);
                    return;
                }
                if (data == null) {
                    ConversationListFragment.this.mRefreshLayout.setLoadMoreFinish(false);
                } else if (data.size() > 0 && data.size() <= ConversationListFragment.this.pageSize) {
                    ConversationListFragment.this.mRefreshLayout.setLoadMoreFinish(false);
                } else if (data.size() == 0) {
                    ConversationListFragment.this.mRefreshLayout.setLoadMoreFinish(false);
                    ConversationListFragment.this.mRefreshLayout.setCanLoading(false);
                } else {
                    ConversationListFragment.this.mRefreshLayout.setLoadMoreFinish(false);
                }
            }

            @Override
            public void onError() {
                RLog.e((String)TAG, (String)"getConversationList Error");
                ConversationListFragment.this.onFinishLoadConversationList(ConversationListFragment.this.leftOfflineMsg);
                ConversationListFragment.this.isShowWithoutConnected = true;
                ConversationListFragment.this.mRefreshLayout.setLoadMoreFinish(false);
            }
        }, isLoadMore);
    }

    public void getConversationList(Conversation.ConversationType[] conversationTypes, final IHistoryDataResultCallback<List<Conversation>> callback, boolean isLoadMore) {
        long lTimestamp = isLoadMore ? this.timestamp : 0L;
        RongIMClient.getInstance().getConversationListByPage((RongIMClient.ResultCallback)new RongIMClient.ResultCallback<List<Conversation>>(){

            public void onSuccess(List<Conversation> conversations) {
                if (ConversationListFragment.this.getActivity() == null || ConversationListFragment.this.getActivity().isFinishing()) {
                    return;
                }
                if (callback != null) {
                    ArrayList<Conversation> resultConversations = new ArrayList<Conversation>();
                    if (conversations != null) {
                        ConversationListFragment.this.timestamp = conversations.get(conversations.size() - 1).getSentTime();
                        for (Conversation conversation : conversations) {
                            if (ConversationListFragment.this.shouldFilterConversation(conversation.getConversationType(), conversation.getTargetId())) continue;
                            resultConversations.add(conversation);
                        }
                    }
                    callback.onResult(resultConversations);
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError();
                }
            }
        }, lTimestamp, this.pageSize, conversationTypes);
    }

    public void focusUnreadItem() {
        int index;
        if (this.mList == null || this.mAdapter == null) {
            return;
        }
        int first = this.mList.getFirstVisiblePosition();
        int last = this.mList.getLastVisiblePosition();
        int count = this.mAdapter.getCount();
        first = Math.max(0, first - this.mList.getHeaderViewsCount());
        last -= this.mList.getHeaderViewsCount();
        int visibleCount = (last = Math.min(count - 1, last)) - first + 1;
        if (visibleCount < count && !this.selectNextUnReadItem(index = last < count - 1 ? first + 1 : 0, count)) {
            this.selectNextUnReadItem(0, count);
        }
    }

    private boolean selectNextUnReadItem(int startIndex, int totalCount) {
        int index = -1;
        for (int i = startIndex; i < totalCount; ++i) {
            UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(i);
            if (uiConversation != null && uiConversation.getUnReadMessageCount() <= 0) continue;
            index = i;
            break;
        }
        if (index >= 0 && index < totalCount) {
            this.mList.setSelection(index + this.mList.getHeaderViewsCount());
            return true;
        }
        return false;
    }

    private void setNotificationBarVisibility(RongIMClient.ConnectionStatusListener.ConnectionStatus status) {
        if (!this.getResources().getBoolean(R.bool.rc_is_show_warning_notification)) {
            RLog.e((String)TAG, (String)"rc_is_show_warning_notification is disabled.");
            return;
        }
        String content = null;
        if (status.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE)) {
            content = this.getResources().getString(R.string.rc_notice_network_unavailable);
        } else if (status.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.KICKED_OFFLINE_BY_OTHER_CLIENT)) {
            content = this.getResources().getString(R.string.rc_notice_tick);
        } else if (status.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED)) {
            this.headerNetWorkView.setVisibility(8);
        } else if (status.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.UNCONNECTED)) {
            content = this.getResources().getString(R.string.rc_notice_disconnect);
        } else if (status.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTING) || status.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.SUSPEND)) {
            content = this.getResources().getString(R.string.rc_notice_connecting);
        }
        if (content != null && this.headerNetWorkView != null) {
            if (this.headerNetWorkView.getVisibility() == 8) {
                final String text = content;
                this.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (!RongIMClient.getInstance().getCurrentConnectionStatus().equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED)) {
                            ConversationListFragment.this.headerNetWorkView.setVisibility(0);
                            ConversationListFragment.this.headerNetWorkText.setText((CharSequence)text);
                            if (RongIMClient.getInstance().getCurrentConnectionStatus().equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTING) || RongIMClient.getInstance().getCurrentConnectionStatus().equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.SUSPEND)) {
                                ConversationListFragment.this.headerNetWorkImage.setImageResource(R.drawable.rc_notification_connecting_animated);
                            } else {
                                ConversationListFragment.this.headerNetWorkImage.setImageResource(R.drawable.rc_notification_network_available);
                            }
                        }
                    }
                }, 4000L);
            } else {
                this.headerNetWorkText.setText((CharSequence)content);
                if (RongIMClient.getInstance().getCurrentConnectionStatus().equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTING) || RongIMClient.getInstance().getCurrentConnectionStatus().equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.SUSPEND)) {
                    this.headerNetWorkImage.setImageResource(R.drawable.rc_notification_connecting_animated);
                } else {
                    this.headerNetWorkImage.setImageResource(R.drawable.rc_notification_network_available);
                }
            }
        }
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    protected List<View> onAddHeaderView() {
        ArrayList<View> headerViews = new ArrayList<View>();
        return headerViews;
    }

    @Deprecated
    public void setAdapter(ConversationListAdapter adapter) {
        this.mAdapter = adapter;
        if (this.mList != null) {
            this.mList.setAdapter((ListAdapter)adapter);
        }
    }

    public ConversationListAdapter onResolveAdapter(Context context) {
        this.mAdapter = new ConversationListAdapter(context);
        return this.mAdapter;
    }

    public void onEventMainThread(Event.SyncReadStatusEvent event) {
        Conversation.ConversationType conversationType = event.getConversationType();
        String targetId = event.getTargetId();
        RLog.d((String)TAG, (String)("SyncReadStatusEvent " + conversationType + " " + targetId));
        int position = this.getGatherState(conversationType) ? this.mAdapter.findGatheredItem(conversationType) : this.mAdapter.findPosition(conversationType, targetId);
        if (position >= 0) {
            UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(position);
            uiConversation.clearUnRead(conversationType, targetId);
            this.mAdapter.notifyDataSetChanged();
        }
        this.onUnreadCountChanged();
    }

    public void onEventMainThread(Event.ReadReceiptEvent event) {
        Conversation.ConversationType conversationType = event.getMessage().getConversationType();
        String targetId = event.getMessage().getTargetId();
        int originalIndex = this.mAdapter.findPosition(conversationType, targetId);
        boolean gatherState = this.getGatherState(conversationType);
        RLog.d((String)TAG, (String)("ReadReceiptEvent. targetId:" + event.getMessage().getTargetId() + ";originalIndex:" + originalIndex));
        if (!gatherState) {
            if (originalIndex >= 0) {
                UIConversation conversation = (UIConversation)this.mAdapter.getItem(originalIndex);
                ReadReceiptMessage content = (ReadReceiptMessage)event.getMessage().getContent();
                if (content.getLastMessageSendTime() >= conversation.getSyncReadReceiptTime() && conversation.getConversationSenderId().equals(RongIMClient.getInstance().getCurrentUserId())) {
                    conversation.setSentStatus(Message.SentStatus.READ);
                    conversation.setSyncReadReceiptTime(event.getMessage().getSentTime());
                    this.mAdapter.getView(originalIndex, this.mList.getChildAt(originalIndex - this.mList.getFirstVisiblePosition() + this.mList.getHeaderViewsCount()), (ViewGroup)this.mList);
                    return;
                }
            }
            this.cacheEventList.add(event.getMessage());
        }
    }

    private void updateConversationReadReceipt(ArrayList<Message> cacheEventList) {
        Iterator<Message> iterator = cacheEventList.iterator();
        while (iterator.hasNext()) {
            Message message = iterator.next();
            Conversation.ConversationType conversationType = message.getConversationType();
            String targetId = message.getTargetId();
            int originalIndex = this.mAdapter.findPosition(conversationType, targetId);
            boolean gatherState = this.getGatherState(conversationType);
            if (gatherState || originalIndex < 0) continue;
            UIConversation conversation = (UIConversation)this.mAdapter.getItem(originalIndex);
            ReadReceiptMessage content = (ReadReceiptMessage)message.getContent();
            if (content.getLastMessageSendTime() >= conversation.getSyncReadReceiptTime() && conversation.getConversationSenderId().equals(RongIMClient.getInstance().getCurrentUserId())) {
                conversation.setSentStatus(Message.SentStatus.READ);
                conversation.setSyncReadReceiptTime(content.getLastMessageSendTime());
                this.mAdapter.getView(originalIndex, this.mList.getChildAt(originalIndex - this.mList.getFirstVisiblePosition() + this.mList.getHeaderViewsCount()), (ViewGroup)this.mList);
                iterator.remove();
                continue;
            }
            if (content.getLastMessageSendTime() >= conversation.getUIConversationTime()) continue;
            RLog.d((String)TAG, (String)("remove cache event. id:" + message.getTargetId()));
            iterator.remove();
        }
    }

    public void onEventMainThread(Event.AudioListenedEvent event) {
        Message message = event.getMessage();
        Conversation.ConversationType conversationType = message.getConversationType();
        String targetId = message.getTargetId();
        RLog.d((String)TAG, (String)("Message: " + message.getObjectName() + " " + conversationType + " " + message.getSentStatus()));
        if (this.isConfigured(conversationType)) {
            int position;
            boolean gathered = this.getGatherState(conversationType);
            int n = position = gathered ? this.mAdapter.findGatheredItem(conversationType) : this.mAdapter.findPosition(conversationType, targetId);
            if (position >= 0) {
                UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(position);
                if (message.getMessageId() == uiConversation.getLatestMessageId()) {
                    uiConversation.updateConversation(this.getContext(), message, gathered);
                    this.mAdapter.getView(position, this.mList.getChildAt(position - this.mList.getFirstVisiblePosition() + this.mList.getHeaderViewsCount()), (ViewGroup)this.mList);
                }
            }
        }
    }

    public boolean shouldUpdateConversation(Message message, int left) {
        return true;
    }

    public boolean shouldFilterConversation(Conversation.ConversationType type, String targetId) {
        return false;
    }

    public void onUnreadCountChanged() {
    }

    public void onFinishLoadConversationList(int leftOfflineMsg) {
    }

    public void onUIConversationCreated(UIConversation uiConversation) {
    }

    public void updateListItem(UIConversation uiConversation) {
        int position = this.mAdapter.findPosition(uiConversation.getConversationType(), uiConversation.getConversationTargetId());
        if (position >= 0) {
            this.mAdapter.getView(position, this.mList.getChildAt(position - this.mList.getFirstVisiblePosition() + this.mList.getHeaderViewsCount()), (ViewGroup)this.mList);
        }
    }

    public void onEventMainThread(Event.OnReceiveMessageEvent event) {
        if (event.isOffline()) {
            if (event.getLeft() == 0) {
                this.getConversationList(this.getConfigConversationTypes(), false);
            }
            return;
        }
        this.leftOfflineMsg = event.getLeft();
        Message message = event.getMessage();
        String targetId = message.getTargetId();
        Conversation.ConversationType conversationType = message.getConversationType();
        if (this.shouldFilterConversation(conversationType, targetId)) {
            return;
        }
        if (event.getLeft() == 0 && !event.hasPackage() && this.enableAutomaticDownloadMsg) {
            HQVoiceMsgDownloadManager.getInstance().enqueue(this, new AutoDownloadEntry(message, AutoDownloadEntry.DownloadPriority.NORMAL));
        }
        RLog.d((String)TAG, (String)("OnReceiveMessageEvent: " + message.getObjectName() + " " + event.getLeft() + " " + conversationType + " " + targetId));
        if (this.isConfigured(message.getConversationType()) && this.shouldUpdateConversation(event.getMessage(), event.getLeft())) {
            if (message.getMessageId() > 0) {
                UIConversation uiConversation;
                boolean gathered = this.getGatherState(conversationType);
                int position = gathered ? this.mAdapter.findGatheredItem(conversationType) : this.mAdapter.findPosition(conversationType, targetId);
                if (position < 0) {
                    uiConversation = UIConversation.obtain((Context)this.getActivity(), message, gathered);
                    this.onUIConversationCreated(uiConversation);
                    int index = this.getPosition(uiConversation);
                    this.mAdapter.add(uiConversation, index);
                    this.mAdapter.notifyDataSetChanged();
                } else {
                    uiConversation = (UIConversation)this.mAdapter.getItem(position);
                    if (event.getMessage().getSentTime() > uiConversation.getUIConversationTime()) {
                        uiConversation.updateConversation(this.getContext(), message, gathered);
                        this.mAdapter.remove(position);
                        int index = this.getPosition(uiConversation);
                        this.mAdapter.add(uiConversation, index);
                        this.mAdapter.notifyDataSetChanged();
                    } else {
                        RLog.i((String)TAG, (String)("ignore update message " + event.getMessage().getObjectName()));
                    }
                }
                RLog.i((String)TAG, (String)("conversation unread count : " + uiConversation.getUnReadMessageCount() + " " + conversationType + " " + targetId));
            }
            if (event.getLeft() == 0) {
                this.syncUnreadCount();
            }
            this.updateConversationReadReceipt(this.cacheEventList);
        }
    }

    public void onEventMainThread(Event.MessageLeftEvent event) {
        if (event.left == 0) {
            this.syncUnreadCount();
            RLog.d((String)TAG, (String)"reload list by left event ");
            this.getConversationList(this.getConfigConversationTypes(), false);
        }
    }

    private void syncUnreadCount() {
        if (this.mAdapter.getCount() > 0) {
            for (int i = 0; i < this.mAdapter.getCount(); ++i) {
                int position;
                final UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(i);
                Conversation.ConversationType conversationType = uiConversation.getConversationType();
                String targetId = uiConversation.getConversationTargetId();
                if (this.getGatherState(conversationType)) {
                    position = this.mAdapter.findGatheredItem(conversationType);
                    RongIMClient.getInstance().getUnreadCount((RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Integer>(){

                        public void onSuccess(Integer integer2) {
                            uiConversation.setUnReadMessageCount(integer2);
                            ConversationListFragment.this.mAdapter.notifyDataSetChanged();
                            ConversationListFragment.this.onUnreadCountChanged();
                        }

                        public void onError(RongIMClient.ErrorCode e) {
                        }
                    }, new Conversation.ConversationType[]{conversationType});
                    continue;
                }
                position = this.mAdapter.findPosition(conversationType, targetId);
                RongIMClient.getInstance().getUnreadCount(conversationType, targetId, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Integer>(){

                    public void onSuccess(Integer integer2) {
                        uiConversation.setUnReadMessageCount(integer2);
                        ConversationListFragment.this.mAdapter.notifyDataSetChanged();
                        ConversationListFragment.this.onUnreadCountChanged();
                    }

                    public void onError(RongIMClient.ErrorCode e) {
                    }
                });
            }
        }
    }

    public void onEventMainThread(Event.MessageRecallEvent event) {
        RLog.d((String)TAG, (String)"MessageRecallEvent");
        int count = this.mAdapter.getCount();
        for (int i = 0; i < count; ++i) {
            UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(i);
            if (event.getMessageId() != uiConversation.getLatestMessageId()) continue;
            boolean gatherState = ((UIConversation)this.mAdapter.getItem(i)).getConversationGatherState();
            int index = i;
            final String targetId = ((UIConversation)this.mAdapter.getItem(i)).getConversationTargetId();
            if (gatherState) {
                RongIM.getInstance().getConversationList(new RongIMClient.ResultCallback<List<Conversation>>(){

                    public void onSuccess(List<Conversation> conversationList) {
                        if (ConversationListFragment.this.getActivity() == null || ConversationListFragment.this.getActivity().isFinishing()) {
                            return;
                        }
                        if (conversationList != null && conversationList.size() > 0) {
                            UIConversation uiConversation = ConversationListFragment.this.makeUIConversation(conversationList);
                            int oldPos = ConversationListFragment.this.mAdapter.findPosition(uiConversation.getConversationType(), targetId);
                            if (oldPos >= 0) {
                                UIConversation originalConversation = (UIConversation)ConversationListFragment.this.mAdapter.getItem(oldPos);
                                uiConversation.setExtra(originalConversation.getExtra());
                                ConversationListFragment.this.mAdapter.remove(oldPos);
                            }
                            int newIndex = ConversationListFragment.this.getPosition(uiConversation);
                            ConversationListFragment.this.mAdapter.add(uiConversation, newIndex);
                            ConversationListFragment.this.mAdapter.notifyDataSetChanged();
                        }
                    }

                    public void onError(RongIMClient.ErrorCode e) {
                    }
                }, uiConversation.getConversationType());
                break;
            }
            RongIM.getInstance().getConversation(uiConversation.getConversationType(), uiConversation.getConversationTargetId(), new RongIMClient.ResultCallback<Conversation>(){

                public void onSuccess(Conversation conversation) {
                    if (conversation != null) {
                        UIConversation uiConversation = UIConversation.obtain((Context)ConversationListFragment.this.getActivity(), conversation, false);
                        int pos = ConversationListFragment.this.mAdapter.findPosition(conversation.getConversationType(), conversation.getTargetId());
                        if (pos >= 0) {
                            UIConversation originalConversation = (UIConversation)ConversationListFragment.this.mAdapter.getItem(pos);
                            uiConversation.setExtra(originalConversation.getExtra());
                            ConversationListFragment.this.mAdapter.remove(pos);
                        }
                        int newPosition = ConversationListFragment.this.getPosition(uiConversation);
                        ConversationListFragment.this.mAdapter.add(uiConversation, newPosition);
                        ConversationListFragment.this.mAdapter.notifyDataSetChanged();
                    }
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            });
            break;
        }
    }

    public void onEventMainThread(Event.RemoteMessageRecallEvent event) {
        RLog.d((String)TAG, (String)"RemoteMessageRecallEvent");
        Conversation.ConversationType conversationType = event.getConversationType();
        final String targetId = event.getTargetId();
        int position = this.mAdapter.findPosition(conversationType, targetId);
        if (position == -1) {
            RLog.d((String)TAG, (String)"ConversationListFragment UI unprepared!");
            return;
        }
        UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(position);
        boolean gatherState = uiConversation.getConversationGatherState();
        if (gatherState) {
            RongIM.getInstance().getConversationList(new RongIMClient.ResultCallback<List<Conversation>>(){

                public void onSuccess(List<Conversation> conversationList) {
                    if (ConversationListFragment.this.getActivity() == null || ConversationListFragment.this.getActivity().isFinishing()) {
                        return;
                    }
                    if (conversationList != null && conversationList.size() > 0) {
                        UIConversation uiConversation = ConversationListFragment.this.makeUIConversation(conversationList);
                        int oldPos = ConversationListFragment.this.mAdapter.findPosition(uiConversation.getConversationType(), targetId);
                        if (oldPos >= 0) {
                            UIConversation originalConversation = (UIConversation)ConversationListFragment.this.mAdapter.getItem(oldPos);
                            uiConversation.setExtra(originalConversation.getExtra());
                            ConversationListFragment.this.mAdapter.remove(oldPos);
                        }
                        int newIndex = ConversationListFragment.this.getPosition(uiConversation);
                        ConversationListFragment.this.mAdapter.add(uiConversation, newIndex);
                        ConversationListFragment.this.mAdapter.notifyDataSetChanged();
                        ConversationListFragment.this.onUnreadCountChanged();
                    }
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            }, ((UIConversation)this.mAdapter.getItem(position)).getConversationType());
        } else {
            RongIM.getInstance().getConversation(uiConversation.getConversationType(), uiConversation.getConversationTargetId(), new RongIMClient.ResultCallback<Conversation>(){

                public void onSuccess(Conversation conversation) {
                    if (conversation != null) {
                        UIConversation newConversation = UIConversation.obtain((Context)ConversationListFragment.this.getActivity(), conversation, false);
                        int pos = ConversationListFragment.this.mAdapter.findPosition(conversation.getConversationType(), conversation.getTargetId());
                        if (pos >= 0) {
                            UIConversation originalConversation = (UIConversation)ConversationListFragment.this.mAdapter.getItem(pos);
                            newConversation.setExtra(originalConversation.getExtra());
                            ConversationListFragment.this.mAdapter.remove(pos);
                        }
                        int newPosition = ConversationListFragment.this.getPosition(newConversation);
                        ConversationListFragment.this.mAdapter.add(newConversation, newPosition);
                        ConversationListFragment.this.mAdapter.notifyDataSetChanged();
                        ConversationListFragment.this.onUnreadCountChanged();
                    }
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            });
        }
    }

    public void onEventMainThread(Message message) {
        Conversation.ConversationType conversationType = message.getConversationType();
        String targetId = message.getTargetId();
        RLog.d((String)TAG, (String)("Message: " + message.getObjectName() + " " + message.getMessageId() + " " + conversationType + " " + message.getSentStatus()));
        if (this.shouldFilterConversation(conversationType, targetId)) {
            return;
        }
        boolean gathered = this.getGatherState(conversationType);
        if (this.isConfigured(conversationType) && message.getMessageId() > 0) {
            int position;
            int n = position = gathered ? this.mAdapter.findGatheredItem(conversationType) : this.mAdapter.findPosition(conversationType, targetId);
            if (position < 0) {
                UIConversation uiConversation = UIConversation.obtain((Context)this.getActivity(), message, gathered);
                this.onUIConversationCreated(uiConversation);
                int index = this.getPosition(uiConversation);
                this.mAdapter.add(uiConversation, index);
                this.mAdapter.notifyDataSetChanged();
            } else {
                UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(position);
                long covTime = uiConversation.getUIConversationTime();
                if (uiConversation.getLatestMessageId() == message.getMessageId() && uiConversation.getSentStatus() == Message.SentStatus.SENDING && message.getSentStatus() == Message.SentStatus.SENT && message.getMessageDirection() == Message.MessageDirection.SEND) {
                    covTime -= RongIMClient.getInstance().getDeltaTime();
                }
                if (covTime <= message.getSentTime() || uiConversation.getLatestMessageId() < 0) {
                    this.mAdapter.remove(position);
                    uiConversation.updateConversation(this.getContext(), message, gathered);
                    int index = this.getPosition(uiConversation);
                    this.mAdapter.add(uiConversation, index);
                    if (position == index) {
                        this.mAdapter.getView(index, this.mList.getChildAt(index - this.mList.getFirstVisiblePosition() + this.mList.getHeaderViewsCount()), (ViewGroup)this.mList);
                    } else {
                        this.mAdapter.notifyDataSetChanged();
                    }
                }
            }
        }
    }

    public void onEventMainThread(Event.MessageSentStatusUpdateEvent event) {
        Message message = event.getMessage();
        if (message == null || message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
            RLog.e((String)TAG, (String)"MessageSentStatusUpdateEvent message is null or direction is RECEIVE");
            return;
        }
        Conversation.ConversationType conversationType = message.getConversationType();
        String targetId = message.getTargetId();
        RLog.d((String)TAG, (String)("MessageSentStatusUpdateEvent: " + event.getMessage().getTargetId() + " " + conversationType + " " + event.getSentStatus()));
        boolean gathered = this.getGatherState(conversationType);
        if (gathered) {
            return;
        }
        if (this.isConfigured(conversationType) && message.getMessageId() > 0) {
            int position = this.mAdapter.findPosition(conversationType, targetId);
            UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(position);
            if (message.getMessageId() == uiConversation.getLatestMessageId()) {
                this.mAdapter.remove(position);
                uiConversation.updateConversation(this.getContext(), message, gathered);
                int index = this.getPosition(uiConversation);
                this.mAdapter.add(uiConversation, index);
                if (position == index) {
                    this.mAdapter.getView(index, this.mList.getChildAt(index - this.mList.getFirstVisiblePosition() + this.mList.getHeaderViewsCount()), (ViewGroup)this.mList);
                } else {
                    this.mAdapter.notifyDataSetChanged();
                }
            }
        }
    }

    public void onEventMainThread(RongIMClient.ConnectionStatusListener.ConnectionStatus status) {
        RLog.d((String)TAG, (String)("ConnectionStatus, " + status.toString()));
        this.setNotificationBarVisibility(status);
        if (status.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED) && this.isShowWithoutConnected) {
            this.getConversationList(this.getConfigConversationTypes(), false);
            this.isShowWithoutConnected = false;
        }
    }

    public void onEventMainThread(Event.ConnectEvent event) {
        RLog.d((String)TAG, (String)("ConnectEvent :" + RongIMClient.getInstance().getCurrentConnectionStatus()));
        if (this.isShowWithoutConnected) {
            this.getConversationList(this.getConfigConversationTypes(), false);
            this.isShowWithoutConnected = false;
        }
    }

    public void onEventMainThread(final Event.CreateDiscussionEvent createDiscussionEvent) {
        RLog.d((String)TAG, (String)"createDiscussionEvent");
        final String targetId = createDiscussionEvent.getDiscussionId();
        if (this.isConfigured(Conversation.ConversationType.DISCUSSION)) {
            RongIMClient.getInstance().getConversation(Conversation.ConversationType.DISCUSSION, targetId, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Conversation>(){

                public void onSuccess(Conversation conversation) {
                    if (conversation != null) {
                        int position = ConversationListFragment.this.getGatherState(Conversation.ConversationType.DISCUSSION) ? ConversationListFragment.this.mAdapter.findGatheredItem(Conversation.ConversationType.DISCUSSION) : ConversationListFragment.this.mAdapter.findPosition(Conversation.ConversationType.DISCUSSION, targetId);
                        conversation.setConversationTitle(createDiscussionEvent.getDiscussionName());
                        if (position < 0) {
                            UIConversation uiConversation = UIConversation.obtain((Context)ConversationListFragment.this.getActivity(), conversation, ConversationListFragment.this.getGatherState(Conversation.ConversationType.DISCUSSION));
                            ConversationListFragment.this.onUIConversationCreated(uiConversation);
                            int index = ConversationListFragment.this.getPosition(uiConversation);
                            ConversationListFragment.this.mAdapter.add(uiConversation, index);
                            ConversationListFragment.this.mAdapter.notifyDataSetChanged();
                        } else {
                            UIConversation uiConversation = (UIConversation)ConversationListFragment.this.mAdapter.getItem(position);
                            uiConversation.updateConversation(ConversationListFragment.this.getContext(), conversation, ConversationListFragment.this.getGatherState(Conversation.ConversationType.DISCUSSION));
                            ConversationListFragment.this.mAdapter.getView(position, ConversationListFragment.this.mList.getChildAt(position - ConversationListFragment.this.mList.getFirstVisiblePosition() + ConversationListFragment.this.mList.getHeaderViewsCount()), (ViewGroup)ConversationListFragment.this.mList);
                        }
                    }
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            });
        }
    }

    public void onEventMainThread(Event.DraftEvent draft) {
        final Conversation.ConversationType conversationType = draft.getConversationType();
        final String targetId = draft.getTargetId();
        RLog.i((String)TAG, (String)("Draft : " + conversationType));
        RongIMClient.getInstance().getConversation(draft.getConversationType(), draft.getTargetId(), (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Conversation>(){

            public void onSuccess(Conversation conversation) {
                int position = ConversationListFragment.this.mAdapter.findPosition(conversationType, targetId);
                if (position >= 0 && !ConversationListFragment.this.getGatherState(conversationType)) {
                    ConversationListFragment.this.mAdapter.remove(position);
                    UIConversation newUiConversation = UIConversation.obtain((Context)ConversationListFragment.this.getActivity(), conversation, false);
                    int index = ConversationListFragment.this.getPosition(newUiConversation);
                    ConversationListFragment.this.mAdapter.add(newUiConversation, index);
                    if (index == position) {
                        ConversationListFragment.this.mAdapter.getView(index, ConversationListFragment.this.mList.getChildAt(index - ConversationListFragment.this.mList.getFirstVisiblePosition() + ConversationListFragment.this.mList.getHeaderViewsCount()), (ViewGroup)ConversationListFragment.this.mList);
                    } else {
                        ConversationListFragment.this.mAdapter.notifyDataSetChanged();
                    }
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
            }
        });
    }

    public void onEventMainThread(Group groupInfo) {
        RLog.d((String)TAG, (String)("Group: " + groupInfo.getName() + " " + groupInfo.getId()));
        int count = this.mAdapter.getCount();
        if (groupInfo.getName() == null) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(i);
            uiConversation.updateConversation(this.getContext(), groupInfo);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void onEventMainThread(Discussion discussion) {
        int position;
        RLog.d((String)TAG, (String)("Discussion: " + discussion.getName() + " " + discussion.getId()));
        if (this.isConfigured(Conversation.ConversationType.DISCUSSION) && (position = this.getGatherState(Conversation.ConversationType.DISCUSSION) ? this.mAdapter.findGatheredItem(Conversation.ConversationType.DISCUSSION) : this.mAdapter.findPosition(Conversation.ConversationType.DISCUSSION, discussion.getId())) >= 0) {
            for (int i = 0; i <= position; ++i) {
                UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(i);
                uiConversation.updateConversation(this.getContext(), discussion);
            }
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onEventMainThread(GroupUserInfo groupUserInfo) {
        RLog.d((String)TAG, (String)("GroupUserInfo " + groupUserInfo.getGroupId() + " " + groupUserInfo.getUserId() + " " + groupUserInfo.getNickname()));
        if (groupUserInfo.getNickname() == null || groupUserInfo.getGroupId() == null) {
            return;
        }
        int count = this.mAdapter.getCount();
        for (int i = 0; i < count; ++i) {
            UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(i);
            if (this.getGatherState(Conversation.ConversationType.GROUP) || !uiConversation.getConversationTargetId().equals(groupUserInfo.getGroupId()) || !uiConversation.getConversationSenderId().equals(groupUserInfo.getUserId())) continue;
            uiConversation.updateConversation(this.getContext(), groupUserInfo);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void onEventMainThread(UserInfo userInfo) {
        RLog.i((String)TAG, (String)("UserInfo " + userInfo.getUserId() + " " + userInfo.getName()));
        int count = this.mAdapter.getCount();
        for (int i = 0; i < count && userInfo.getName() != null; ++i) {
            UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(i);
            if (uiConversation.hasNickname(userInfo.getUserId())) {
                RLog.i((String)TAG, (String)"has nick name");
                continue;
            }
            uiConversation.updateConversation(this.getContext(), userInfo);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void onEventMainThread(PublicServiceProfile profile) {
        RLog.d((String)TAG, (String)"PublicServiceProfile");
        int count = this.mAdapter.getCount();
        boolean gatherState = this.getGatherState(profile.getConversationType());
        for (int i = 0; i < count; ++i) {
            UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(i);
            if (!uiConversation.getConversationType().equals((Object)profile.getConversationType()) || !uiConversation.getConversationTargetId().equals(profile.getTargetId()) || gatherState) continue;
            uiConversation.setUIConversationTitle(profile.getName());
            uiConversation.setIconUrl(profile.getPortraitUri());
            this.mAdapter.getView(i, this.mList.getChildAt(i - this.mList.getFirstVisiblePosition() + this.mList.getHeaderViewsCount()), (ViewGroup)this.mList);
            break;
        }
    }

    public void onEventMainThread(Event.PublicServiceFollowableEvent event) {
        int originalIndex;
        RLog.d((String)TAG, (String)"PublicServiceFollowableEvent");
        if (!event.isFollow() && (originalIndex = this.mAdapter.findPosition(event.getConversationType(), event.getTargetId())) >= 0) {
            this.mAdapter.remove(originalIndex);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onEventMainThread(Event.ConversationUnreadEvent unreadEvent) {
        int position;
        RLog.d((String)TAG, (String)"ConversationUnreadEvent");
        Conversation.ConversationType conversationType = unreadEvent.getType();
        String targetId = unreadEvent.getTargetId();
        int n = position = this.getGatherState(conversationType) ? this.mAdapter.findGatheredItem(conversationType) : this.mAdapter.findPosition(conversationType, targetId);
        if (position >= 0) {
            UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(position);
            uiConversation.clearUnRead(conversationType, targetId);
            this.mAdapter.notifyDataSetChanged();
        }
        this.onUnreadCountChanged();
    }

    public void onEventMainThread(Event.ConversationTopEvent setTopEvent) {
        UIConversation uiConversation;
        RLog.d((String)TAG, (String)"ConversationTopEvent");
        Conversation.ConversationType conversationType = setTopEvent.getConversationType();
        String targetId = setTopEvent.getTargetId();
        int position = this.mAdapter.findPosition(conversationType, targetId);
        if (position >= 0 && !this.getGatherState(conversationType) && (uiConversation = (UIConversation)this.mAdapter.getItem(position)).isTop() != setTopEvent.isTop()) {
            uiConversation.setTop(!uiConversation.isTop());
            this.mAdapter.remove(position);
            int index = this.getPosition(uiConversation);
            this.mAdapter.add(uiConversation, index);
            if (index == position) {
                this.mAdapter.getView(index, this.mList.getChildAt(index - this.mList.getFirstVisiblePosition() + this.mList.getHeaderViewsCount()), (ViewGroup)this.mList);
            } else {
                this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    public void onEventMainThread(Event.ConversationRemoveEvent removeEvent) {
        RLog.d((String)TAG, (String)"ConversationRemoveEvent");
        Conversation.ConversationType conversationType = removeEvent.getType();
        this.removeConversation(conversationType, removeEvent.getTargetId());
    }

    public void onEventMainThread(Event.ClearConversationEvent clearConversationEvent) {
        RLog.d((String)TAG, (String)"ClearConversationEvent");
        List<Conversation.ConversationType> typeList = clearConversationEvent.getTypes();
        for (int i = this.mAdapter.getCount() - 1; i >= 0; --i) {
            if (typeList.indexOf(((UIConversation)this.mAdapter.getItem(i)).getConversationType()) < 0) continue;
            this.mAdapter.remove(i);
        }
        this.mAdapter.notifyDataSetChanged();
        this.onUnreadCountChanged();
    }

    public void onEventMainThread(Event.MessageDeleteEvent event) {
        RLog.d((String)TAG, (String)"MessageDeleteEvent");
        int count = this.mAdapter.getCount();
        for (int i = 0; i < count; ++i) {
            if (!event.getMessageIds().contains(((UIConversation)this.mAdapter.getItem(i)).getLatestMessageId())) continue;
            boolean gatherState = ((UIConversation)this.mAdapter.getItem(i)).getConversationGatherState();
            final String targetId = ((UIConversation)this.mAdapter.getItem(i)).getConversationTargetId();
            if (gatherState) {
                RongIM.getInstance().getConversationList(new RongIMClient.ResultCallback<List<Conversation>>(){

                    public void onSuccess(List<Conversation> conversationList) {
                        if (ConversationListFragment.this.getActivity() == null || ConversationListFragment.this.getActivity().isFinishing()) {
                            return;
                        }
                        if (conversationList == null || conversationList.size() == 0) {
                            return;
                        }
                        UIConversation uiConversation = ConversationListFragment.this.makeUIConversation(conversationList);
                        int oldPos = ConversationListFragment.this.mAdapter.findPosition(uiConversation.getConversationType(), targetId);
                        if (oldPos >= 0) {
                            UIConversation originalConversation = (UIConversation)ConversationListFragment.this.mAdapter.getItem(oldPos);
                            uiConversation.setExtra(originalConversation.getExtra());
                            ConversationListFragment.this.mAdapter.remove(oldPos);
                        }
                        int newIndex = ConversationListFragment.this.getPosition(uiConversation);
                        ConversationListFragment.this.mAdapter.add(uiConversation, newIndex);
                        ConversationListFragment.this.mAdapter.notifyDataSetChanged();
                    }

                    public void onError(RongIMClient.ErrorCode e) {
                    }
                }, ((UIConversation)this.mAdapter.getItem(i)).getConversationType());
                break;
            }
            RongIM.getInstance().getConversation(((UIConversation)this.mAdapter.getItem(i)).getConversationType(), ((UIConversation)this.mAdapter.getItem(i)).getConversationTargetId(), new RongIMClient.ResultCallback<Conversation>(){

                public void onSuccess(Conversation conversation) {
                    if (conversation == null) {
                        RLog.d((String)TAG, (String)"onEventMainThread getConversation : onSuccess, conversation = null");
                        return;
                    }
                    UIConversation uiConversation = UIConversation.obtain((Context)ConversationListFragment.this.getActivity(), conversation, false);
                    int pos = ConversationListFragment.this.mAdapter.findPosition(conversation.getConversationType(), conversation.getTargetId());
                    if (pos >= 0) {
                        UIConversation originalConversation = (UIConversation)ConversationListFragment.this.mAdapter.getItem(pos);
                        uiConversation.setExtra(originalConversation.getExtra());
                        ConversationListFragment.this.mAdapter.remove(pos);
                    }
                    int newIndex = ConversationListFragment.this.getPosition(uiConversation);
                    ConversationListFragment.this.mAdapter.add(uiConversation, newIndex);
                    ConversationListFragment.this.mAdapter.notifyDataSetChanged();
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            });
            break;
        }
    }

    public void onEventMainThread(Event.ConversationNotificationEvent notificationEvent) {
        int originalIndex = this.mAdapter.findPosition(notificationEvent.getConversationType(), notificationEvent.getTargetId());
        if (originalIndex >= 0) {
            UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(originalIndex);
            if (!uiConversation.getNotificationStatus().equals((Object)notificationEvent.getStatus())) {
                uiConversation.setNotificationStatus(notificationEvent.getStatus());
                this.mAdapter.getView(originalIndex, this.mList.getChildAt(originalIndex - this.mList.getFirstVisiblePosition() + this.mList.getHeaderViewsCount()), (ViewGroup)this.mList);
            }
            this.onUnreadCountChanged();
        }
    }

    public void onEventMainThread(Event.MessagesClearEvent clearMessagesEvent) {
        int position;
        RLog.d((String)TAG, (String)"MessagesClearEvent");
        Conversation.ConversationType conversationType = clearMessagesEvent.getType();
        String targetId = clearMessagesEvent.getTargetId();
        int n = position = this.getGatherState(conversationType) ? this.mAdapter.findGatheredItem(conversationType) : this.mAdapter.findPosition(conversationType, targetId);
        if (position >= 0) {
            UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(position);
            uiConversation.clearLastMessage();
            this.mAdapter.getView(position, this.mList.getChildAt(position - this.mList.getFirstVisiblePosition() + this.mList.getHeaderViewsCount()), (ViewGroup)this.mList);
        }
    }

    public void onEventMainThread(Event.OnMessageSendErrorEvent sendErrorEvent) {
        Message message = sendErrorEvent.getMessage();
        Conversation.ConversationType conversationType = message.getConversationType();
        String targetId = message.getTargetId();
        if (this.isConfigured(conversationType)) {
            int index;
            boolean gathered = this.getGatherState(conversationType);
            int n = index = gathered ? this.mAdapter.findGatheredItem(conversationType) : this.mAdapter.findPosition(conversationType, targetId);
            if (index >= 0) {
                UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(index);
                message.setSentStatus(Message.SentStatus.FAILED);
                uiConversation.updateConversation(this.getContext(), message, gathered);
                this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    public void onEventMainThread(Event.QuitDiscussionEvent event) {
        RLog.d((String)TAG, (String)"QuitDiscussionEvent");
        this.removeConversation(Conversation.ConversationType.DISCUSSION, event.getDiscussionId());
    }

    public void onEventMainThread(Event.QuitGroupEvent event) {
        RLog.d((String)TAG, (String)"QuitGroupEvent");
        this.removeConversation(Conversation.ConversationType.GROUP, event.getGroupId());
    }

    private void removeConversation(final Conversation.ConversationType conversationType, String targetId) {
        boolean gathered = this.getGatherState(conversationType);
        if (gathered) {
            int index = this.mAdapter.findGatheredItem(conversationType);
            if (index >= 0) {
                RongIM.getInstance().getConversationList(new RongIMClient.ResultCallback<List<Conversation>>(){

                    public void onSuccess(List<Conversation> conversationList) {
                        if (ConversationListFragment.this.getActivity() == null || ConversationListFragment.this.getActivity().isFinishing()) {
                            return;
                        }
                        int oldPos = ConversationListFragment.this.mAdapter.findGatheredItem(conversationType);
                        if (oldPos >= 0) {
                            ConversationListFragment.this.mAdapter.remove(oldPos);
                            if (conversationList != null && conversationList.size() > 0) {
                                UIConversation uiConversation = ConversationListFragment.this.makeUIConversation(conversationList);
                                int newIndex = ConversationListFragment.this.getPosition(uiConversation);
                                ConversationListFragment.this.mAdapter.add(uiConversation, newIndex);
                            }
                            ConversationListFragment.this.mAdapter.notifyDataSetChanged();
                            ConversationListFragment.this.onUnreadCountChanged();
                        }
                    }

                    public void onError(RongIMClient.ErrorCode e) {
                    }
                }, conversationType);
            }
        } else {
            int index = this.mAdapter.findPosition(conversationType, targetId);
            if (index >= 0) {
                this.mAdapter.remove(index);
                this.mAdapter.notifyDataSetChanged();
                this.onUnreadCountChanged();
            }
        }
    }

    @Override
    public void onPortraitItemClick(View v, UIConversation data) {
        Conversation.ConversationType type = data.getConversationType();
        if (this.getGatherState(type)) {
            RongIM.getInstance().startSubConversationList((Context)this.getActivity(), type);
        } else {
            boolean isDefault;
            if (RongContext.getInstance().getConversationListBehaviorListener() != null && (isDefault = RongContext.getInstance().getConversationListBehaviorListener().onConversationPortraitClick((Context)this.getActivity(), type, data.getConversationTargetId()))) {
                return;
            }
            data.setUnReadMessageCount(0);
            RongIM.getInstance().startConversation((Context)this.getActivity(), type, data.getConversationTargetId(), data.getUIConversationTitle());
        }
    }

    @Override
    public boolean onPortraitItemLongClick(View v, UIConversation data) {
        boolean isDealt;
        Conversation.ConversationType type = data.getConversationType();
        if (RongContext.getInstance().getConversationListBehaviorListener() != null && (isDealt = RongContext.getInstance().getConversationListBehaviorListener().onConversationPortraitLongClick((Context)this.getActivity(), type, data.getConversationTargetId()))) {
            return true;
        }
        if (!this.getGatherState(type)) {
            this.buildMultiDialog(data);
            return true;
        }
        this.buildSingleDialog(data);
        return true;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        int realPosition;
        Long previousClickTimestamp = (Long)view.getTag(R.id.rc_debounceClick_last_timestamp);
        long currentTimestamp = SystemClock.uptimeMillis();
        view.setTag(R.id.rc_debounceClick_last_timestamp, (Object)currentTimestamp);
        if ((previousClickTimestamp == null || Math.abs(currentTimestamp - previousClickTimestamp) > 1000L) && (realPosition = position - this.mList.getHeaderViewsCount()) >= 0 && realPosition < this.mAdapter.getCount()) {
            UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(realPosition);
            Conversation.ConversationType conversationType = uiConversation.getConversationType();
            if (this.getGatherState(conversationType)) {
                RongIM.getInstance().startSubConversationList((Context)this.getActivity(), conversationType);
            } else {
                if (RongContext.getInstance().getConversationListBehaviorListener() != null && RongContext.getInstance().getConversationListBehaviorListener().onConversationClick((Context)this.getActivity(), view, uiConversation)) {
                    return;
                }
                uiConversation.setUnReadMessageCount(0);
                RongIM.getInstance().startConversation((Context)this.getActivity(), conversationType, uiConversation.getConversationTargetId(), uiConversation.getUIConversationTitle());
            }
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        int realPosition = position - this.mList.getHeaderViewsCount();
        if (realPosition >= 0 && realPosition < this.mAdapter.getCount()) {
            boolean isDealt;
            UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(realPosition);
            if (RongContext.getInstance().getConversationListBehaviorListener() != null && (isDealt = RongContext.getInstance().getConversationListBehaviorListener().onConversationLongClick((Context)this.getActivity(), view, uiConversation))) {
                return true;
            }
            if (!this.getGatherState(uiConversation.getConversationType())) {
                this.buildMultiDialog(uiConversation);
                return true;
            }
            this.buildSingleDialog(uiConversation);
            return true;
        }
        return false;
    }

    private void buildMultiDialog(final UIConversation uiConversation) {
        final Context context = this.getContext();
        if (context == null) {
            return;
        }
        String[] items = new String[]{uiConversation.isTop() ? context.getString(R.string.rc_conversation_list_dialog_cancel_top) : context.getString(R.string.rc_conversation_list_dialog_set_top), context.getString(R.string.rc_conversation_list_dialog_remove)};
        OptionsPopupDialog.newInstance((Context)this.getActivity(), items).setOptionsPopupDialogListener(new OptionsPopupDialog.OnOptionsItemClickedListener(){

            @Override
            public void onOptionsItemClicked(int which) {
                if (which == 0) {
                    RongIM.getInstance().setConversationToTop(uiConversation.getConversationType(), uiConversation.getConversationTargetId(), !uiConversation.isTop(), new RongIMClient.ResultCallback<Boolean>(){

                        public void onSuccess(Boolean aBoolean) {
                            if (uiConversation.isTop()) {
                                Toast.makeText((Context)context, (CharSequence)ConversationListFragment.this.getString(R.string.rc_conversation_list_popup_cancel_top), (int)0).show();
                            } else {
                                Toast.makeText((Context)context, (CharSequence)ConversationListFragment.this.getString(R.string.rc_conversation_list_dialog_set_top), (int)0).show();
                            }
                        }

                        public void onError(RongIMClient.ErrorCode e) {
                        }
                    });
                } else if (which == 1) {
                    RongIM.getInstance().removeConversation(uiConversation.getConversationType(), uiConversation.getConversationTargetId(), null);
                }
            }
        }).show();
    }

    private void buildSingleDialog(final UIConversation uiConversation) {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        String[] items = new String[]{context.getString(R.string.rc_conversation_list_dialog_remove)};
        OptionsPopupDialog.newInstance((Context)this.getActivity(), items).setOptionsPopupDialogListener(new OptionsPopupDialog.OnOptionsItemClickedListener(){

            @Override
            public void onOptionsItemClicked(int which) {
                RongIM.getInstance().getConversationList(new RongIMClient.ResultCallback<List<Conversation>>(){

                    public void onSuccess(List<Conversation> conversations) {
                        if (conversations != null && conversations.size() > 0) {
                            for (Conversation conversation : conversations) {
                                RongIM.getInstance().removeConversation(conversation.getConversationType(), conversation.getTargetId(), null);
                            }
                        }
                    }

                    public void onError(RongIMClient.ErrorCode errorCode) {
                    }
                }, uiConversation.getConversationType());
                int position = ConversationListFragment.this.mAdapter.findGatheredItem(uiConversation.getConversationType());
                ConversationListFragment.this.mAdapter.remove(position);
                ConversationListFragment.this.mAdapter.notifyDataSetChanged();
            }
        }).show();
    }

    private void makeUiConversationList(List<Conversation> conversationList) {
        for (Conversation conversation : conversationList) {
            int index;
            UIConversation uiConversation;
            int originalIndex;
            Conversation.ConversationType conversationType = conversation.getConversationType();
            String targetId = conversation.getTargetId();
            boolean gatherState = this.getGatherState(conversationType);
            if (gatherState) {
                originalIndex = this.mAdapter.findGatheredItem(conversationType);
                if (originalIndex >= 0) {
                    uiConversation = (UIConversation)this.mAdapter.getItem(originalIndex);
                    uiConversation.updateConversation(this.getContext(), conversation, true);
                    continue;
                }
                uiConversation = UIConversation.obtain((Context)this.getActivity(), conversation, true);
                this.onUIConversationCreated(uiConversation);
                this.mAdapter.add(uiConversation);
                continue;
            }
            originalIndex = this.mAdapter.findPosition(conversationType, targetId);
            if (originalIndex < 0) {
                uiConversation = UIConversation.obtain((Context)this.getActivity(), conversation, false);
                this.onUIConversationCreated(uiConversation);
                index = this.getPosition(uiConversation);
                this.mAdapter.add(uiConversation, index);
                continue;
            }
            uiConversation = (UIConversation)this.mAdapter.getItem(originalIndex);
            if (uiConversation.getUIConversationTime() <= conversation.getSentTime()) {
                this.mAdapter.remove(originalIndex);
                uiConversation.updateConversation(this.getContext(), conversation, false);
                index = this.getPosition(uiConversation);
                this.mAdapter.add(uiConversation, index);
                continue;
            }
            uiConversation.setUnReadMessageCount(conversation.getUnreadMessageCount());
        }
    }

    private UIConversation makeUIConversation(List<Conversation> conversations) {
        int unreadCount = 0;
        boolean isMentioned = false;
        Conversation newest = conversations.get(0);
        for (Conversation conversation : conversations) {
            if (newest.isTop()) {
                if (conversation.isTop() && conversation.getSentTime() > newest.getSentTime()) {
                    newest = conversation;
                }
            } else if (conversation.isTop() || conversation.getSentTime() > newest.getSentTime()) {
                newest = conversation;
            }
            if (conversation.getMentionedCount() > 0) {
                isMentioned = true;
            }
            unreadCount += conversation.getUnreadMessageCount();
        }
        UIConversation uiConversation = UIConversation.obtain((Context)this.getActivity(), newest, this.getGatherState(newest.getConversationType()));
        uiConversation.setUnReadMessageCount(unreadCount);
        uiConversation.setTop(false);
        uiConversation.setMentionedFlag(isMentioned);
        return uiConversation;
    }

    private int getPosition(UIConversation uiConversation) {
        int count = this.mAdapter.getCount();
        int position = 0;
        for (int i = 0; i < count; ++i) {
            if (uiConversation.isTop()) {
                if (!((UIConversation)this.mAdapter.getItem(i)).isTop() || ((UIConversation)this.mAdapter.getItem(i)).getUIConversationTime() <= uiConversation.getUIConversationTime()) break;
                ++position;
                continue;
            }
            if (!((UIConversation)this.mAdapter.getItem(i)).isTop() && ((UIConversation)this.mAdapter.getItem(i)).getUIConversationTime() <= uiConversation.getUIConversationTime()) break;
            ++position;
        }
        return position;
    }

    private boolean isConfigured(Conversation.ConversationType conversationType) {
        for (int i = 0; i < this.mConversationsConfig.size(); ++i) {
            if (!conversationType.equals((Object)this.mConversationsConfig.get((int)i).conversationType)) continue;
            return true;
        }
        return false;
    }

    public boolean getGatherState(Conversation.ConversationType conversationType) {
        for (ConversationConfig config : this.mConversationsConfig) {
            if (!config.conversationType.equals((Object)conversationType)) continue;
            return config.isGathered;
        }
        return false;
    }

    private Conversation.ConversationType[] getConfigConversationTypes() {
        Conversation.ConversationType[] conversationTypes = new Conversation.ConversationType[this.mConversationsConfig.size()];
        for (int i = 0; i < this.mConversationsConfig.size(); ++i) {
            conversationTypes[i] = this.mConversationsConfig.get((int)i).conversationType;
        }
        return conversationTypes;
    }

    @Override
    public void onLoad() {
        this.getConversationList(this.getConfigConversationTypes(), true);
    }

    @Override
    public void onFlush() {
        this.getConversationList(this.getConfigConversationTypes(), false);
    }

    @Override
    public void onDestroy() {
        EventBus.getDefault().unregister(this.mThis);
        this.cacheEventList.clear();
        super.onDestroy();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1001 && grantResults.length > 0 && grantResults[0] == 0) {
            HQVoiceMsgDownloadManager.getInstance().resumeDownloadService();
        }
    }

    public void onEventMainThread(ConversationStatus[] conversationStatus) {
        RLog.i((String)TAG, (String)("onEventMainThread conversationStatus " + conversationStatus.length));
        if (conversationStatus.length == 1) {
            String conversationId = conversationStatus[0].getTargetId();
            Conversation.ConversationType conversationType = conversationStatus[0].getConversationType();
            int position = this.mAdapter.findPosition(conversationType, conversationId);
            if (!this.getGatherState(conversationType)) {
                if (position >= 0) {
                    UIConversation uiConversation = (UIConversation)this.mAdapter.getItem(position);
                    uiConversation.setNotificationStatus(conversationStatus[0].getNotifyStatus());
                    this.onEventMainThread(new Event.ConversationTopEvent(conversationType, conversationId, conversationStatus[0].isTop()));
                    this.updateListItem(uiConversation);
                } else {
                    this.getConversationList(this.getConfigConversationTypes(), false);
                }
            }
        } else {
            this.getConversationList(this.getConfigConversationTypes(), false);
        }
    }

    private class ConversationConfig {
        Conversation.ConversationType conversationType;
        boolean isGathered;

        private ConversationConfig() {
        }
    }
}

