/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.fragment.BaseFragment;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.widget.adapter.ConversationAddMemberAdapter;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.UserInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ConversationAddMemberFragment
extends BaseFragment
implements AdapterView.OnItemClickListener,
ConversationAddMemberAdapter.OnDeleteIconListener {
    static final int PREPARE_LIST = 1;
    static final int REMOVE_ITEM = 2;
    static final int SHOW_TOAST = 3;
    private Conversation.ConversationType mConversationType;
    private String mTargetId;
    private ConversationAddMemberAdapter mAdapter;
    private List<String> mIdList = new ArrayList<String>();
    private ArrayList<UserInfo> mMembers = new ArrayList();
    private GridView mGridList;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        Intent intent;
        super.onCreate(savedInstanceState);
        RongContext.getInstance().getEventBus().register(this);
        if (this.getActivity() != null && (intent = this.getActivity().getIntent()).getData() != null) {
            String pathSeg = intent.getData().getLastPathSegment();
            if (pathSeg != null) {
                this.mConversationType = Conversation.ConversationType.valueOf((String)pathSeg.toUpperCase(Locale.US));
            }
            this.mTargetId = intent.getData().getQueryParameter("targetId");
        }
        this.mAdapter = new ConversationAddMemberAdapter((Context)this.getActivity());
        this.mAdapter.setDeleteIconListener(this);
        this.initData();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.rc_fr_conversation_member_list, null);
        this.mGridList = (GridView)this.findViewById(view, R.id.rc_list);
        return view;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mGridList.setAdapter((ListAdapter)this.mAdapter);
        this.mGridList.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mGridList.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (1 == event.getAction() && ConversationAddMemberFragment.this.mAdapter.isDeleteState()) {
                    UserInfo addBtn = new UserInfo("RongAddBtn", null, null);
                    ConversationAddMemberFragment.this.mAdapter.add(addBtn);
                    String curUserId = RongIM.getInstance().getCurrentUserId();
                    if (ConversationAddMemberFragment.this.mAdapter.getCreatorId() != null && ConversationAddMemberFragment.this.mConversationType.equals((Object)Conversation.ConversationType.DISCUSSION) && curUserId.equals(ConversationAddMemberFragment.this.mAdapter.getCreatorId())) {
                        UserInfo deleteBtn = new UserInfo("RongDelBtn", null, null);
                        ConversationAddMemberFragment.this.mAdapter.add(deleteBtn);
                    }
                    ConversationAddMemberFragment.this.mAdapter.setDeleteState(false);
                    ConversationAddMemberFragment.this.mAdapter.notifyDataSetChanged();
                    return true;
                }
                return false;
            }
        });
    }

    private void initData() {
        if (this.mConversationType.equals((Object)Conversation.ConversationType.DISCUSSION)) {
            RongIM.getInstance().getDiscussion(this.mTargetId, new RongIMClient.ResultCallback<Discussion>(){

                public void onSuccess(Discussion discussion) {
                    ConversationAddMemberFragment.this.mIdList = discussion.getMemberIdList();
                    ConversationAddMemberFragment.this.mAdapter.setCreatorId(discussion.getCreatorId());
                    Message msg = new Message();
                    msg.what = 1;
                    msg.obj = ConversationAddMemberFragment.this.mIdList;
                    ConversationAddMemberFragment.this.getHandler().sendMessage(msg);
                }

                public void onError(RongIMClient.ErrorCode errorCode) {
                    ConversationAddMemberFragment.this.getHandler().sendEmptyMessage(3);
                }
            });
        } else if (this.mConversationType.equals((Object)Conversation.ConversationType.PRIVATE)) {
            this.mIdList.add(this.mTargetId);
            Message msg = new Message();
            msg.what = 1;
            msg.obj = this.mIdList;
            this.getHandler().sendMessage(msg);
        }
    }

    public void onEventMainThread(UserInfo userInfo) {
        int count = this.mAdapter.getCount();
        for (int i = 0; i < count; ++i) {
            UserInfo temp = (UserInfo)this.mAdapter.getItem(i);
            if (!userInfo.getUserId().equals(temp.getUserId())) continue;
            temp.setName(userInfo.getName());
            temp.setPortraitUri(userInfo.getPortraitUri());
            this.mAdapter.getView(i, this.mGridList.getChildAt(i - this.mGridList.getFirstVisiblePosition()), (ViewGroup)this.mGridList);
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        UserInfo userInfo = (UserInfo)this.mAdapter.getItem(position);
        if (userInfo.getUserId().equals("RongDelBtn")) {
            this.mAdapter.setDeleteState(true);
            int count = this.mAdapter.getCount();
            this.mAdapter.remove(count - 1);
            this.mAdapter.remove(count - 2);
            this.mAdapter.notifyDataSetChanged();
        } else if (userInfo.getUserId().equals("RongAddBtn")) {
            if (RongContext.getInstance().getMemberSelectListener() == null) {
                throw new ExceptionInInitializerError("The OnMemberSelectListener hasn't been set!");
            }
            RongContext.getInstance().getMemberSelectListener().startSelectMember((Context)this.getActivity(), this.mConversationType, this.mTargetId);
        }
    }

    @Override
    public void onDeleteIconClick(View view, final int position) {
        UserInfo temp = (UserInfo)this.mAdapter.getItem(position);
        RongIM.getInstance().removeMemberFromDiscussion(this.mTargetId, temp.getUserId(), new RongIMClient.OperationCallback(){

            public void onSuccess() {
                Message msg = new Message();
                msg.what = 2;
                msg.obj = position;
                ConversationAddMemberFragment.this.getHandler().sendMessage(msg);
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                ConversationAddMemberFragment.this.getHandler().sendEmptyMessage(3);
            }
        });
    }

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                List mMemberInfo = (List)msg.obj;
                int i = 0;
                for (String id2 : mMemberInfo) {
                    if (i >= 50) break;
                    UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(id2);
                    if (userInfo == null) {
                        this.mMembers.add(new UserInfo(id2, null, null));
                    } else {
                        this.mMembers.add(userInfo);
                    }
                    ++i;
                }
                UserInfo addBtn = new UserInfo("RongAddBtn", null, null);
                this.mMembers.add(addBtn);
                String curUserId = RongIM.getInstance().getCurrentUserId();
                if (this.mAdapter.getCreatorId() != null && this.mConversationType.equals((Object)Conversation.ConversationType.DISCUSSION) && curUserId.equals(this.mAdapter.getCreatorId())) {
                    UserInfo deleteBtn = new UserInfo("RongDelBtn", null, null);
                    this.mMembers.add(deleteBtn);
                }
                this.mAdapter.addCollection(this.mMembers);
                this.mAdapter.notifyDataSetChanged();
                break;
            }
            case 2: {
                int position = (Integer)msg.obj;
                this.mAdapter.remove(position);
                this.mAdapter.notifyDataSetChanged();
                break;
            }
        }
        return true;
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    @Override
    public void onRestoreUI() {
        this.initData();
    }
}

