/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.fragment.BaseFragment;
import io.rong.imlib.model.Conversation;
import java.util.Locale;

public abstract class BaseSettingFragment
extends BaseFragment
implements View.OnClickListener {
    TextView mTextView;
    CheckBox mCheckBox;
    RelativeLayout mSettingItem;
    String mTargetId;
    Conversation.ConversationType mConversationType;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        Intent intent;
        super.onCreate(savedInstanceState);
        if (this.getActivity() != null && (intent = this.getActivity().getIntent()).getData() != null) {
            String pathSeg = intent.getData().getLastPathSegment();
            if (pathSeg != null) {
                this.mConversationType = Conversation.ConversationType.valueOf((String)pathSeg.toUpperCase(Locale.US));
            }
            this.mTargetId = intent.getData().getQueryParameter("targetId");
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.rc_fragment_base_setting, container, false);
        this.mTextView = (TextView)view.findViewById(R.id.rc_title);
        this.mCheckBox = (CheckBox)view.findViewById(R.id.rc_checkbox);
        this.mSettingItem = (RelativeLayout)view.findViewById(R.id.rc_setting_item);
        return view;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        this.mTextView.setText((CharSequence)this.setTitle());
        this.mCheckBox.setEnabled(this.setSwitchButtonEnabled());
        if (8 == this.setSwitchBtnVisibility()) {
            this.mCheckBox.setVisibility(8);
        } else if (0 == this.setSwitchBtnVisibility()) {
            this.mCheckBox.setVisibility(0);
        }
        this.mCheckBox.setOnClickListener((View.OnClickListener)this);
        this.mSettingItem.setOnClickListener((View.OnClickListener)this);
        this.initData();
        super.onActivityCreated(savedInstanceState);
    }

    public void onClick(View v) {
        if (v == this.mSettingItem) {
            this.onSettingItemClick(v);
        } else if (v == this.mCheckBox) {
            this.toggleSwitch(this.mCheckBox.isChecked());
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RongContext.getInstance().getEventBus().unregister((Object)this);
    }

    protected Conversation.ConversationType getConversationType() {
        return this.mConversationType;
    }

    protected String getTargetId() {
        return this.mTargetId;
    }

    protected abstract String setTitle();

    protected abstract boolean setSwitchButtonEnabled();

    protected abstract int setSwitchBtnVisibility();

    protected abstract void onSettingItemClick(View var1);

    protected abstract void toggleSwitch(boolean var1);

    protected abstract void initData();

    protected void setSwitchBtnStatus(boolean status) {
        this.mCheckBox.setChecked(status);
    }

    protected boolean getSwitchBtnStatus() {
        return this.mCheckBox.isChecked();
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    @Override
    public void onRestoreUI() {
        this.initData();
    }
}

