/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import android.widget.Toast;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.utilities.RongUtils;

public class ImageVideoDialogFragment
extends DialogFragment
implements View.OnClickListener {
    private static final String TAG = "ImageVideoDialogFragment";
    protected Dialog mDialog;
    protected View mRootView;
    private boolean hasSight;
    private boolean hasImage;
    private ImageVideoDialogListener mListener;

    public void setHasSight(boolean pHasSight) {
        this.hasSight = pHasSight;
    }

    public void setHasImage(boolean pHasImage) {
        this.hasImage = pHasImage;
    }

    public void setImageVideoDialogListener(ImageVideoDialogListener pListener) {
        this.mListener = pListener;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, 16973940);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.rc_dialog_video_image, container, false);
        this.initView();
        return this.mRootView;
    }

    protected void initView() {
        TextView mSight = (TextView)this.mRootView.findViewById(R.id.tv_sight);
        TextView mCancel = (TextView)this.mRootView.findViewById(R.id.tv_cancel);
        View mLine = this.mRootView.findViewById(R.id.view_horizontal);
        TextView mAlbum = (TextView)this.mRootView.findViewById(R.id.tv_album);
        if (!this.hasSight) {
            mSight.setVisibility(8);
            mLine.setVisibility(8);
        }
        if (!this.hasImage) {
            mAlbum.setVisibility(8);
            mLine.setVisibility(8);
        }
        mSight.setOnClickListener((View.OnClickListener)this);
        mCancel.setOnClickListener((View.OnClickListener)this);
        mAlbum.setOnClickListener((View.OnClickListener)this);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mDialog = this.getDialog();
        if (this.mDialog != null) {
            Window dialogWindow = this.mDialog.getWindow();
            if (dialogWindow == null) {
                return;
            }
            dialogWindow.setBackgroundDrawableResource(17170445);
            DisplayMetrics dm = new DisplayMetrics();
            if (this.getActivity() != null) {
                this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
            }
            dialogWindow.setLayout((int)((float)dm.widthPixels * this.getScreenWidthProportion()), -2);
            WindowManager.LayoutParams attributes = dialogWindow.getAttributes();
            attributes.gravity = this.getGravity();
            attributes.x = -RongUtils.dip2px(this.getHorizontalMovement());
            attributes.y = RongUtils.dip2px(this.getVerticalMovement());
            dialogWindow.setAttributes(attributes);
        }
    }

    protected int getGravity() {
        return 80;
    }

    protected float getScreenWidthProportion() {
        return 1.0f;
    }

    protected float getVerticalMovement() {
        return 0.0f;
    }

    protected float getHorizontalMovement() {
        return 0.0f;
    }

    public void show(FragmentManager manager) {
        if (!this.hasSight && !this.hasImage) {
            if (this.getContext() != null) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getResources().getString(R.string.rc_no_plugin), (int)0).show();
            }
            return;
        }
        try {
            this.show(manager, "");
            this.setCancelable(true);
            if (this.mDialog != null) {
                this.mDialog.setCanceledOnTouchOutside(true);
            }
        }
        catch (IllegalStateException e) {
            RLog.e((String)TAG, (String)"show", (Throwable)e);
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.tv_sight) {
            if (this.mListener != null) {
                this.mListener.onSightClick(v);
            }
        } else if (i == R.id.tv_album && this.mListener != null) {
            this.mListener.onImageClick(v);
        }
        this.hideDialog();
    }

    public void hideDialog() {
        this.dismissAllowingStateLoss();
    }

    public static interface ImageVideoDialogListener {
        public void onSightClick(View var1);

        public void onImageClick(View var1);
    }
}

