/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imlib.common.SharedPreferencesUtils;

public class BurnHintDialog
extends DialogFragment
implements View.OnClickListener {
    private static final String TAG = "BurnHintDialog";
    protected Dialog mDialog;
    protected View mRootView;
    private static boolean isFirstClick = false;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, 16973940);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.rc_dialog_fire_hint, container, false);
        this.initView();
        return this.mRootView;
    }

    protected void initView() {
        TextView mConfirm = (TextView)this.mRootView.findViewById(R.id.tv_confirm);
        mConfirm.setOnClickListener((View.OnClickListener)this);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mDialog = this.getDialog();
        if (this.mDialog != null) {
            Window dialogWindow = this.mDialog.getWindow();
            if (dialogWindow == null) {
                return;
            }
            dialogWindow.setBackgroundDrawableResource(17170445);
            DisplayMetrics dm = new DisplayMetrics();
            if (this.getActivity() != null) {
                this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
            }
            dialogWindow.setLayout((int)((float)dm.widthPixels * this.getScreenWidthProportion()), -2);
            WindowManager.LayoutParams attributes = dialogWindow.getAttributes();
            attributes.gravity = this.getGravity();
            attributes.x = -RongUtils.dip2px(this.getHorizontalMovement());
            attributes.y = RongUtils.dip2px(this.getVerticalMovement());
            dialogWindow.setAttributes(attributes);
        }
    }

    protected int getGravity() {
        return 17;
    }

    protected float getScreenWidthProportion() {
        return 0.75f;
    }

    protected float getVerticalMovement() {
        return 0.0f;
    }

    protected float getHorizontalMovement() {
        return 0.0f;
    }

    public void show(FragmentManager manager) {
        try {
            this.show(manager, "");
            this.setCancelable(false);
            if (this.mDialog != null) {
                this.mDialog.setCanceledOnTouchOutside(false);
            }
        }
        catch (IllegalStateException e) {
            RLog.e((String)TAG, (String)"show", (Throwable)e);
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.tv_confirm) {
            SharedPreferences sp = SharedPreferencesUtils.get((Context)v.getContext(), (String)"RongKitConfig", (int)0);
            sp.edit().putBoolean("isFirstUseBurn", true).apply();
            this.hideDialog();
        }
    }

    public void hideDialog() {
        this.dismissAllowingStateLoss();
    }

    public static boolean isFirstClick(Context pContext) {
        if (!isFirstClick) {
            SharedPreferences sp = SharedPreferencesUtils.get((Context)pContext, (String)"RongKitConfig", (int)0);
            isFirstClick = sp.getBoolean("isFirstUseBurn", false);
        }
        return isFirstClick;
    }
}

