/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.destruct;

import io.rong.eventbus.EventBus;
import io.rong.imkit.model.Event;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.destruct.DestructionTaskManager;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import java.util.HashMap;
import java.util.Map;

public class DestructManager {
    private Map<String, Map<String, RongIMClient.DestructCountDownTimerListener>> mMap = new HashMap<String, Map<String, RongIMClient.DestructCountDownTimerListener>>();
    private Map<String, String> mUnFinishTimes = new HashMap<String, String>();

    private DestructManager() {
    }

    public void addListener(String pUId, RongIMClient.DestructCountDownTimerListener pDestructListener, String pTag) {
        if (this.mMap.containsKey(pUId)) {
            Map<String, RongIMClient.DestructCountDownTimerListener> map = this.mMap.get(pUId);
            if (map != null) {
                map.put(pTag, pDestructListener);
            }
        } else {
            HashMap<String, RongIMClient.DestructCountDownTimerListener> map = new HashMap<String, RongIMClient.DestructCountDownTimerListener>();
            map.put(pTag, pDestructListener);
            this.mMap.put(pUId, map);
        }
    }

    public void deleteMessage(Message pMessage) {
        DestructionTaskManager.getInstance().deleteMessage(pMessage);
    }

    public void deleteMessages(Conversation.ConversationType pConversationType, String pTargetId, Message[] pDeleteMessages) {
        DestructionTaskManager.getInstance().deleteMessages(pConversationType, pTargetId, pDeleteMessages);
    }

    public static DestructManager getInstance() {
        return DestructManagerHolder.instance;
    }

    public String getUnFinishTime(String pMessageId) {
        return this.mUnFinishTimes.get(pMessageId);
    }

    public void startDestruct(final Message pMessage) {
        RongIMClient.getInstance().beginDestructMessage(pMessage, new RongIMClient.DestructCountDownTimerListener(){

            public void onTick(long untilFinished, String messageId) {
                if (DestructManager.this.mMap.containsKey(messageId)) {
                    Map map = (Map)DestructManager.this.mMap.get(messageId);
                    if (map != null) {
                        for (String key : map.keySet()) {
                            RongIMClient.DestructCountDownTimerListener destructCountDownTimerListener = (RongIMClient.DestructCountDownTimerListener)map.get(key);
                            if (destructCountDownTimerListener == null) continue;
                            destructCountDownTimerListener.onTick(untilFinished, messageId);
                        }
                    }
                    if (untilFinished == 0L) {
                        if (map != null) {
                            map.clear();
                        }
                        DestructManager.this.mMap.remove(messageId);
                        DestructManager.this.mUnFinishTimes.remove(messageId);
                        EventBus.getDefault().post(new Event.MessageDeleteEvent(pMessage.getMessageId()));
                    } else {
                        DestructManager.this.mUnFinishTimes.put(messageId, String.valueOf(untilFinished));
                    }
                }
            }

            public void onStop(String messageId) {
                if (DestructManager.this.mMap.containsKey(messageId)) {
                    Map map = (Map)DestructManager.this.mMap.get(messageId);
                    if (map != null) {
                        for (String key : map.keySet()) {
                            RongIMClient.DestructCountDownTimerListener destructCountDownTimerListener = (RongIMClient.DestructCountDownTimerListener)map.get(key);
                            if (destructCountDownTimerListener == null) continue;
                            destructCountDownTimerListener.onStop(messageId);
                        }
                    }
                    DestructManager.this.mUnFinishTimes.remove(messageId);
                }
            }
        });
    }

    public void stopDestruct(Message pMessage) {
        RongIMClient.getInstance().stopDestructMessage(pMessage);
    }

    private static class DestructManagerHolder {
        private static DestructManager instance = new DestructManager();

        private DestructManagerHolder() {
        }
    }
}

