/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.RongBaseNoActionbarActivity;
import io.rong.imkit.RongContext;
import io.rong.imkit.fragment.IHistoryDataResultCallback;
import io.rong.imkit.utils.ForwardManager;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.RongSwipeRefreshLayout;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import java.util.ArrayList;
import java.util.List;

public class SelectConversationActivity
extends RongBaseNoActionbarActivity
implements View.OnClickListener,
RongSwipeRefreshLayout.OnLoadListener {
    private static final String TAG = SelectConversationActivity.class.getSimpleName();
    private TextView btOK;
    private ListAdapter mAdapter;
    private RongSwipeRefreshLayout mRefreshLayout;
    private ArrayList<Conversation> selectedMember = new ArrayList();
    private static final Conversation.ConversationType[] defConversationType = new Conversation.ConversationType[]{Conversation.ConversationType.PRIVATE, Conversation.ConversationType.GROUP};
    private long timestamp = 0L;
    private int pageSize = 100;

    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.getWindow().setFlags(2048, 2048);
        this.setContentView(R.layout.rc_activity_forward_select);
        this.btOK = (TextView)this.findViewById(R.id.rc_btn_ok);
        TextView btCancel = (TextView)this.findViewById(R.id.rc_btn_cancel);
        this.mRefreshLayout = (RongSwipeRefreshLayout)this.findViewById(R.id.rc_refresh);
        ListView listView = (ListView)this.findViewById(R.id.rc_list);
        this.btOK.setEnabled(false);
        this.btOK.setOnClickListener((View.OnClickListener)this);
        btCancel.setOnClickListener((View.OnClickListener)this);
        this.mRefreshLayout.setCanRefresh(false);
        this.mRefreshLayout.setCanLoading(true);
        this.mRefreshLayout.setOnLoadListener(this);
        this.mAdapter = new ListAdapter((Activity)this);
        listView.setAdapter((android.widget.ListAdapter)this.mAdapter);
        listView.setOnItemClickListener((AdapterView.OnItemClickListener)new ForwardItemClickListener());
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        this.getConversationList(false);
    }

    private void getConversationList(boolean isLoadMore) {
        this.getConversationList(defConversationType, new IHistoryDataResultCallback<List<Conversation>>(){

            @Override
            public void onResult(List<Conversation> data) {
                if (data != null && data.size() > 0) {
                    SelectConversationActivity.this.mAdapter.setAllMembers(data);
                    SelectConversationActivity.this.mAdapter.notifyDataSetChanged();
                }
                if (data == null) {
                    SelectConversationActivity.this.mRefreshLayout.setLoadMoreFinish(false);
                } else if (data.size() > 0 && data.size() <= SelectConversationActivity.this.pageSize) {
                    SelectConversationActivity.this.mRefreshLayout.setLoadMoreFinish(false);
                } else if (data.size() == 0) {
                    SelectConversationActivity.this.mRefreshLayout.setLoadMoreFinish(false);
                    SelectConversationActivity.this.mRefreshLayout.setCanLoading(false);
                } else {
                    SelectConversationActivity.this.mRefreshLayout.setLoadMoreFinish(false);
                }
            }

            @Override
            public void onError() {
                SelectConversationActivity.this.mRefreshLayout.setLoadMoreFinish(false);
            }
        }, isLoadMore);
    }

    public void getConversationList(Conversation.ConversationType[] conversationTypes, final IHistoryDataResultCallback<List<Conversation>> callback, boolean isLoadMore) {
        long lTimestamp = isLoadMore ? this.timestamp : 0L;
        RongIMClient.getInstance().getConversationListByPage((RongIMClient.ResultCallback)new RongIMClient.ResultCallback<List<Conversation>>(){

            public void onSuccess(List<Conversation> conversations) {
                if (SelectConversationActivity.this.isFinishing()) {
                    return;
                }
                if (callback != null) {
                    if (conversations != null) {
                        SelectConversationActivity.this.timestamp = conversations.get(conversations.size() - 1).getSentTime();
                    }
                    callback.onResult(conversations);
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError();
                }
            }
        }, lTimestamp, this.pageSize, conversationTypes);
    }

    @Override
    public void onLoad() {
        this.getConversationList(true);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.rc_btn_ok) {
            this.showSendDialog();
        } else if (id2 == R.id.rc_btn_cancel) {
            this.finish();
        }
    }

    private void showSendDialog() {
        if (this.isFinishing()) {
            return;
        }
        ForwardManager.forwardMessage((Activity)this, this.selectedMember);
    }

    private class ViewHolder {
        ImageView checkbox;
        AsyncImageView portrait;
        TextView name;

        private ViewHolder() {
        }
    }

    private class ListAdapter
    extends BaseAdapter {
        private Activity activity;
        private List<Conversation> allMembers;

        ListAdapter(Activity activity) {
            this.activity = activity;
        }

        void setAllMembers(List<Conversation> allMembers) {
            this.allMembers = allMembers;
        }

        public int getCount() {
            if (this.allMembers == null) {
                return 0;
            }
            return this.allMembers.size();
        }

        public Object getItem(int position) {
            if (this.allMembers == null) {
                return null;
            }
            return this.allMembers.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        @SuppressLint(value={"InflateParams"})
        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                holder = new ViewHolder();
                convertView = LayoutInflater.from((Context)this.activity).inflate(R.layout.rc_listitem_forward_select_member, null);
                holder.checkbox = (ImageView)convertView.findViewById(R.id.rc_checkbox);
                holder.portrait = (AsyncImageView)convertView.findViewById(R.id.rc_user_portrait);
                holder.name = (TextView)convertView.findViewById(R.id.rc_user_name);
                convertView.setTag((Object)holder);
            }
            holder = (ViewHolder)convertView.getTag();
            holder.checkbox.setTag((Object)this.allMembers.get(position));
            holder.checkbox.setClickable(false);
            holder.checkbox.setImageResource(R.drawable.rc_select_conversation_checkbox);
            holder.checkbox.setEnabled(true);
            Conversation conversation = this.allMembers.get(position);
            holder.checkbox.setSelected(SelectConversationActivity.this.selectedMember.contains(conversation));
            String title = conversation.getConversationTitle();
            String portrait = conversation.getPortraitUrl();
            if (TextUtils.isEmpty((CharSequence)title)) {
                title = RongContext.getInstance().getConversationTemplate(conversation.getConversationType().getName()).getTitle(conversation.getTargetId());
            }
            if (TextUtils.isEmpty((CharSequence)portrait)) {
                Uri url = RongContext.getInstance().getConversationTemplate(conversation.getConversationType().getName()).getPortraitUri(conversation.getTargetId());
                String string2 = portrait = url != null ? url.toString() : "";
            }
            if (!TextUtils.isEmpty((CharSequence)portrait)) {
                holder.portrait.setAvatar(Uri.parse((String)portrait));
            }
            if (!TextUtils.isEmpty((CharSequence)title)) {
                holder.name.setText((CharSequence)title);
            }
            return convertView;
        }
    }

    private class ForwardItemClickListener
    implements AdapterView.OnItemClickListener {
        private ForwardItemClickListener() {
        }

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            View v = view.findViewById(R.id.rc_checkbox);
            Conversation member = (Conversation)v.getTag();
            SelectConversationActivity.this.selectedMember.remove(member);
            v.setSelected(!v.isSelected());
            if (v.isSelected()) {
                SelectConversationActivity.this.selectedMember.add(member);
            }
            if (SelectConversationActivity.this.selectedMember.size() > 0) {
                SelectConversationActivity.this.btOK.setEnabled(true);
            } else {
                SelectConversationActivity.this.btOK.setEnabled(false);
            }
        }
    }
}

