/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.eventbus.EventBus;
import io.rong.imageloader.core.DisplayImageOptions;
import io.rong.imageloader.core.ImageLoader;
import io.rong.imageloader.core.assist.FailReason;
import io.rong.imageloader.core.assist.ImageScaleType;
import io.rong.imageloader.core.listener.ImageLoadingListener;
import io.rong.imageloader.core.listener.ImageLoadingProgressListener;
import io.rong.imkit.R;
import io.rong.imkit.RongBaseNoActionbarActivity;
import io.rong.imkit.destruct.DestructManager;
import io.rong.imkit.model.Event;
import io.rong.imkit.plugin.image.HackyViewPager;
import io.rong.imkit.utilities.KitStorageUtils;
import io.rong.imkit.utilities.OptionsPopupDialog;
import io.rong.imkit.utilities.PermissionCheckUtil;
import io.rong.imkit.utils.ImageDownloadManager;
import io.rong.imlib.RongCommonDefine;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.message.ImageMessage;
import io.rong.message.ReferenceMessage;
import io.rong.subscaleview.ImageSource;
import io.rong.subscaleview.SubsamplingScaleImageView;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PicturePagerActivity
extends RongBaseNoActionbarActivity
implements View.OnLongClickListener {
    private static final String TAG = "PicturePagerActivity";
    private static final int IMAGE_MESSAGE_COUNT = 10;
    protected HackyViewPager mViewPager;
    protected ImageMessage mCurrentImageMessage;
    protected Message mMessage;
    protected Conversation.ConversationType mConversationType;
    protected int mCurrentMessageId;
    protected String mTargetId = null;
    private int mCurrentIndex = 0;
    protected ImageAdapter mImageAdapter;
    protected boolean isFirstTime = false;
    protected ViewPager.OnPageChangeListener mPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            RLog.i((String)PicturePagerActivity.TAG, (String)("onPageSelected. position:" + position));
            PicturePagerActivity.this.mCurrentIndex = position;
            View view = PicturePagerActivity.this.mViewPager.findViewById(position);
            if (view != null) {
                PicturePagerActivity.this.mImageAdapter.updatePhotoView(position, view);
            }
            if (position == PicturePagerActivity.this.mImageAdapter.getCount() - 1) {
                PicturePagerActivity.this.getConversationImageUris(PicturePagerActivity.this.mImageAdapter.getItem(position).getMessageId().getMessageId(), RongCommonDefine.GetMessageDirection.BEHIND);
            } else if (position == 0) {
                PicturePagerActivity.this.getConversationImageUris(PicturePagerActivity.this.mImageAdapter.getItem(position).getMessageId().getMessageId(), RongCommonDefine.GetMessageDirection.FRONT);
            }
        }

        public void onPageScrollStateChanged(int state) {
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        Message currentMessage;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rc_fr_photo);
        this.mMessage = currentMessage = (Message)this.getIntent().getParcelableExtra("message");
        if (currentMessage.getContent() instanceof ReferenceMessage) {
            ReferenceMessage referenceMessage = (ReferenceMessage)currentMessage.getContent();
            this.mCurrentImageMessage = (ImageMessage)referenceMessage.getReferenceContent();
        } else {
            this.mCurrentImageMessage = (ImageMessage)currentMessage.getContent();
        }
        this.mConversationType = currentMessage.getConversationType();
        this.mCurrentMessageId = currentMessage.getMessageId();
        this.mTargetId = currentMessage.getTargetId();
        this.mViewPager = (HackyViewPager)this.findViewById(R.id.viewpager);
        this.mViewPager.setOnPageChangeListener(this.mPageChangeListener);
        this.mImageAdapter = new ImageAdapter();
        this.isFirstTime = true;
        if (!this.mMessage.getContent().isDestruct() && !(this.mMessage.getContent() instanceof ReferenceMessage)) {
            this.getConversationImageUris(this.mCurrentMessageId, RongCommonDefine.GetMessageDirection.FRONT);
            this.getConversationImageUris(this.mCurrentMessageId, RongCommonDefine.GetMessageDirection.BEHIND);
        } else {
            ArrayList<ImageInfo> lists = new ArrayList<ImageInfo>();
            lists.add(new ImageInfo(this.mMessage, this.mCurrentImageMessage.getThumUri(), this.mCurrentImageMessage.getLocalUri() == null ? this.mCurrentImageMessage.getRemoteUri() : this.mCurrentImageMessage.getLocalUri()));
            this.mImageAdapter.addData(lists, true);
            this.mViewPager.setAdapter(this.mImageAdapter);
        }
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    public void onEventMainThread(Event.RemoteMessageRecallEvent event) {
        if (this.mCurrentMessageId == event.getMessageId()) {
            new AlertDialog.Builder((Context)this, 5).setMessage((CharSequence)this.getString(R.string.rc_recall_success)).setPositiveButton((CharSequence)this.getString(R.string.rc_dialog_ok), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PicturePagerActivity.this.finish();
                }
            }).setCancelable(false).show();
        } else {
            String objName = event.getRecallNotificationMessage().getOriginalObjectName();
            if (!"RC:ImgMsg".equals(objName)) {
                return;
            }
            this.mImageAdapter.removeRecallItem(event.getMessageId());
            this.mImageAdapter.notifyDataSetChanged();
            if (this.mImageAdapter.getCount() == 0) {
                this.finish();
            }
        }
    }

    public void onEventMainThread(Event.MessageDeleteEvent deleteEvent) {
        RLog.d((String)TAG, (String)"MessageDeleteEvent");
        if (deleteEvent.getMessageIds() != null) {
            for (int messageId : deleteEvent.getMessageIds()) {
                this.mImageAdapter.removeRecallItem(messageId);
            }
            this.mImageAdapter.notifyDataSetChanged();
            if (this.mImageAdapter.getCount() == 0) {
                this.finish();
            }
        }
    }

    private void getConversationImageUris(int mesageId, final RongCommonDefine.GetMessageDirection direction) {
        if (this.mConversationType != null && !TextUtils.isEmpty((CharSequence)this.mTargetId)) {
            RongIMClient.getInstance().getHistoryMessages(this.mConversationType, this.mTargetId, "RC:ImgMsg", mesageId, 10, direction, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<List<Message>>(){

                public void onSuccess(List<Message> messages) {
                    ArrayList<ImageInfo> lists = new ArrayList<ImageInfo>();
                    if (messages != null) {
                        if (direction.equals((Object)RongCommonDefine.GetMessageDirection.FRONT)) {
                            Collections.reverse(messages);
                        }
                        for (int i = 0; i < messages.size(); ++i) {
                            Uri largeImageUri;
                            Message message = messages.get(i);
                            if (!(message.getContent() instanceof ImageMessage) || message.getContent().isDestruct()) continue;
                            ImageMessage imageMessage = (ImageMessage)message.getContent();
                            Uri uri = largeImageUri = imageMessage.getLocalUri() == null ? imageMessage.getRemoteUri() : imageMessage.getLocalUri();
                            if (imageMessage.getThumUri() == null || largeImageUri == null) continue;
                            lists.add(new ImageInfo(message, imageMessage.getThumUri(), largeImageUri));
                        }
                    }
                    if (direction.equals((Object)RongCommonDefine.GetMessageDirection.FRONT) && PicturePagerActivity.this.isFirstTime) {
                        lists.add(new ImageInfo(PicturePagerActivity.this.mMessage, PicturePagerActivity.this.mCurrentImageMessage.getThumUri(), PicturePagerActivity.this.mCurrentImageMessage.getLocalUri() == null ? PicturePagerActivity.this.mCurrentImageMessage.getRemoteUri() : PicturePagerActivity.this.mCurrentImageMessage.getLocalUri()));
                        PicturePagerActivity.this.mImageAdapter.addData(lists, direction.equals((Object)RongCommonDefine.GetMessageDirection.FRONT));
                        PicturePagerActivity.this.mViewPager.setAdapter(PicturePagerActivity.this.mImageAdapter);
                        PicturePagerActivity.this.isFirstTime = false;
                        PicturePagerActivity.this.mViewPager.setCurrentItem(lists.size() - 1);
                        PicturePagerActivity.this.mCurrentIndex = lists.size() - 1;
                    } else if (lists.size() > 0) {
                        PicturePagerActivity.this.mImageAdapter.addData(lists, direction.equals((Object)RongCommonDefine.GetMessageDirection.FRONT));
                        PicturePagerActivity.this.mImageAdapter.notifyDataSetChanged();
                        if (direction.equals((Object)RongCommonDefine.GetMessageDirection.FRONT)) {
                            PicturePagerActivity.this.mViewPager.setCurrentItem(lists.size());
                            PicturePagerActivity.this.mCurrentIndex = lists.size();
                        }
                    }
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            });
        }
    }

    protected void onPause() {
        super.onPause();
    }

    protected void onDestroy() {
        ImageLoader.getInstance().clearMemoryCache();
        super.onDestroy();
        EventBus.getDefault().unregister((Object)this);
    }

    public boolean onPictureLongClick(View v, Uri thumbUri, Uri largeImageUri) {
        return false;
    }

    public boolean onLongClick(View v) {
        if (this.mCurrentImageMessage.isDestruct()) {
            return false;
        }
        ImageInfo imageInfo = this.mImageAdapter.getImageInfo(this.mCurrentIndex);
        if (imageInfo != null) {
            File file;
            Uri largeImageUri;
            Uri thumbUri = imageInfo.getThumbUri();
            if (this.onPictureLongClick(v, thumbUri, largeImageUri = imageInfo.getLargeImageUri())) {
                return true;
            }
            if (largeImageUri != null) {
                file = largeImageUri.getScheme().startsWith("http") || largeImageUri.getScheme().startsWith("https") ? ImageLoader.getInstance().getDiskCache().get(largeImageUri.toString()) : new File(largeImageUri.getPath());
            } else {
                return false;
            }
            if (file == null || !file.exists()) {
                return false;
            }
            String[] items = new String[]{this.getString(R.string.rc_save_picture)};
            OptionsPopupDialog.newInstance((Context)this, items).setOptionsPopupDialogListener(new OptionsPopupDialog.OnOptionsItemClickedListener(){

                @Override
                public void onOptionsItemClicked(int which) {
                    if (which == 0) {
                        String[] permissions = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
                        if (!PermissionCheckUtil.requestPermissions((Activity)PicturePagerActivity.this, permissions)) {
                            return;
                        }
                        if (file != null && file.exists()) {
                            KitStorageUtils.saveMediaToPublicDir((Context)PicturePagerActivity.this, file, "image");
                            Toast.makeText((Context)PicturePagerActivity.this, (CharSequence)PicturePagerActivity.this.getString(R.string.rc_save_picture_at), (int)0).show();
                        } else {
                            Toast.makeText((Context)PicturePagerActivity.this, (CharSequence)PicturePagerActivity.this.getString(R.string.rc_src_file_not_found), (int)0).show();
                        }
                    }
                }
            }).show();
        }
        return true;
    }

    private static class DestructListener
    implements RongIMClient.DestructCountDownTimerListener {
        private WeakReference<ImageAdapter.ViewHolder> mHolder;
        private String mMessageId;

        public DestructListener(ImageAdapter.ViewHolder pHolder, String pMessageId) {
            this.mHolder = new WeakReference<ImageAdapter.ViewHolder>(pHolder);
            this.mMessageId = pMessageId;
        }

        public void onTick(long millisUntilFinished, String pMessageId) {
            ImageAdapter.ViewHolder viewHolder;
            if (this.mMessageId.equals(pMessageId) && (viewHolder = (ImageAdapter.ViewHolder)this.mHolder.get()) != null) {
                viewHolder.mCountDownView.setVisibility(0);
                viewHolder.mCountDownView.setText((CharSequence)String.valueOf(Math.max(millisUntilFinished, 1L)));
            }
        }

        public void onStop(String messageId) {
            ImageAdapter.ViewHolder viewHolder;
            if (this.mMessageId.equals(messageId) && (viewHolder = (ImageAdapter.ViewHolder)this.mHolder.get()) != null) {
                viewHolder.mCountDownView.setVisibility(8);
            }
        }
    }

    protected class ImageInfo {
        private Message message;
        private Uri thumbUri;
        private Uri largeImageUri;

        ImageInfo(Message message, Uri thumbnail, Uri largeImageUri) {
            this.message = message;
            this.thumbUri = thumbnail;
            this.largeImageUri = largeImageUri;
        }

        public Message getMessageId() {
            return this.message;
        }

        public Uri getLargeImageUri() {
            return this.largeImageUri;
        }

        public Uri getThumbUri() {
            return this.thumbUri;
        }
    }

    protected class ImageAdapter
    extends PagerAdapter {
        private ArrayList<ImageInfo> mImageList = new ArrayList();

        protected ImageAdapter() {
        }

        private View newView(Context context, ImageInfo imageInfo) {
            View result = LayoutInflater.from((Context)context).inflate(R.layout.rc_fr_image, null);
            ViewHolder holder = new ViewHolder();
            holder.progressBar = (ProgressBar)result.findViewById(R.id.rc_progress);
            holder.progressText = (TextView)result.findViewById(R.id.rc_txt);
            holder.photoView = (SubsamplingScaleImageView)result.findViewById(R.id.rc_photoView);
            holder.mCountDownView = (TextView)result.findViewById(R.id.rc_count_down);
            holder.photoView.setOnLongClickListener(PicturePagerActivity.this);
            holder.photoView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Window window = PicturePagerActivity.this.getWindow();
                    if (window != null) {
                        window.setFlags(2048, 2048);
                    }
                    PicturePagerActivity.this.finish();
                }
            });
            result.setTag((Object)holder);
            return result;
        }

        public void addData(ArrayList<ImageInfo> newImages, boolean direction) {
            if (newImages == null || newImages.size() == 0) {
                return;
            }
            if (this.mImageList.size() == 0) {
                this.mImageList.addAll(newImages);
            } else if (direction && !PicturePagerActivity.this.isFirstTime && !this.isDuplicate(newImages.get(0).getMessageId().getMessageId())) {
                ArrayList<ImageInfo> temp = new ArrayList<ImageInfo>();
                temp.addAll(this.mImageList);
                this.mImageList.clear();
                this.mImageList.addAll(newImages);
                this.mImageList.addAll(this.mImageList.size(), temp);
            } else if (!PicturePagerActivity.this.isFirstTime && !this.isDuplicate(newImages.get(0).getMessageId().getMessageId())) {
                this.mImageList.addAll(this.mImageList.size(), newImages);
            }
        }

        private boolean isDuplicate(int messageId) {
            for (ImageInfo info : this.mImageList) {
                if (info.getMessageId().getMessageId() != messageId) continue;
                return true;
            }
            return false;
        }

        public ImageInfo getItem(int index) {
            return this.mImageList.get(index);
        }

        public int getItemPosition(Object object) {
            return -2;
        }

        public int getCount() {
            return this.mImageList.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            RLog.i((String)PicturePagerActivity.TAG, (String)("instantiateItem.position:" + position));
            View imageView = this.newView(container.getContext(), this.mImageList.get(position));
            this.updatePhotoView(position, imageView);
            imageView.setId(position);
            container.addView(imageView);
            return imageView;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            RLog.i((String)PicturePagerActivity.TAG, (String)("destroyItem.position:" + position));
            container.removeView((View)object);
        }

        private void removeRecallItem(int messageId) {
            for (int i = this.mImageList.size() - 1; i >= 0; --i) {
                if (this.mImageList.get(i).message.getMessageId() != messageId) continue;
                this.mImageList.remove(i);
                break;
            }
        }

        private void updatePhotoView(final int position, View view) {
            File file;
            final ViewHolder holder = (ViewHolder)view.getTag();
            Uri originalUri = this.mImageList.get(position).getLargeImageUri();
            final Uri thumbUri = this.mImageList.get(position).getThumbUri();
            if (originalUri == null || thumbUri == null) {
                RLog.e((String)PicturePagerActivity.TAG, (String)"large uri and thumbnail uri of the image should not be null.");
                return;
            }
            if (PicturePagerActivity.this.mCurrentImageMessage.isDestruct() && PicturePagerActivity.this.mMessage.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                DestructManager.getInstance().addListener(PicturePagerActivity.this.mMessage.getUId(), new DestructListener(holder, PicturePagerActivity.this.mMessage.getUId()), PicturePagerActivity.TAG);
            }
            if ((file = ImageLoader.getInstance().getDiskCache().get(originalUri.toString())) != null && file.exists()) {
                Uri resultUri = Uri.fromFile((File)file);
                String path = "";
                if (!resultUri.equals((Object)holder.photoView.getUri())) {
                    if (resultUri.getScheme().equals("file")) {
                        path = resultUri.toString().substring(5);
                    } else if (resultUri.getScheme().equals("content")) {
                        Cursor cursor = PicturePagerActivity.this.getApplicationContext().getContentResolver().query(resultUri, new String[]{"_data"}, null, null, null);
                        cursor.moveToFirst();
                        path = cursor.getString(0);
                        cursor.close();
                    }
                    holder.photoView.setOrientation(FileUtils.readPictureDegree((Context)PicturePagerActivity.this, (String)path));
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                    holder.photoView.suitMaxScaleWithSize(options.outWidth, options.outHeight);
                    holder.photoView.setImage(ImageSource.uri(resultUri));
                }
                return;
            }
            DisplayImageOptions options = new DisplayImageOptions.Builder().cacheInMemory(true).cacheOnDisk(true).imageScaleType(ImageScaleType.NONE).bitmapConfig(Bitmap.Config.RGB_565).considerExifParams(true).build();
            ImageLoader.getInstance().loadImage(originalUri.toString(), null, options, new ImageLoadingListener(){

                @Override
                public void onLoadingStarted(String imageUri, View view) {
                    String thumbPath = null;
                    Bitmap thumbBitmap = null;
                    if ("file".equals(thumbUri.getScheme())) {
                        thumbPath = thumbUri.toString().substring(5);
                    }
                    if (thumbPath != null) {
                        thumbBitmap = BitmapFactory.decodeFile(thumbPath);
                    }
                    holder.photoView.setBitmapAndFileUri(thumbBitmap, null);
                    holder.progressText.setVisibility(0);
                    holder.progressBar.setVisibility(0);
                    holder.progressText.setText((CharSequence)"0%");
                }

                @Override
                public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                    if (imageUri.startsWith("file://")) {
                        holder.progressText.setVisibility(8);
                        holder.progressBar.setVisibility(8);
                    } else {
                        String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
                        if (!PermissionCheckUtil.requestPermissions((Activity)PicturePagerActivity.this, permissions)) {
                            holder.progressText.setVisibility(8);
                            holder.progressBar.setVisibility(8);
                            return;
                        }
                        ImageDownloadManager.getInstance().downloadImage(imageUri, new ImageDownloadManager.DownloadStatusListener(){

                            @Override
                            public void downloadSuccess(String localPath, Bitmap bitmap) {
                                holder.photoView.setImage(ImageSource.uri(localPath));
                                holder.progressText.setVisibility(8);
                                holder.progressBar.setVisibility(8);
                            }

                            @Override
                            public void downloadFailed(ImageDownloadManager.DownloadStatusError error) {
                                holder.progressText.setVisibility(8);
                                holder.progressBar.setVisibility(8);
                            }
                        });
                    }
                }

                @Override
                public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                    ViewHolder inPagerHolder;
                    if (PicturePagerActivity.this.mCurrentImageMessage.isDestruct() && PicturePagerActivity.this.mMessage.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                        DestructManager.getInstance().startDestruct(PicturePagerActivity.this.mMessage);
                        EventBus.getDefault().post(new Event.changeDestructionReadTimeEvent(PicturePagerActivity.this.mMessage));
                    }
                    holder.progressText.setVisibility(8);
                    holder.progressBar.setVisibility(8);
                    File file = ImageLoader.getInstance().getDiskCache().get(imageUri);
                    Uri resultUri = null;
                    if (file != null) {
                        resultUri = Uri.fromFile((File)file);
                    }
                    if (resultUri == null) {
                        this.onLoadingFailed(imageUri, view, new FailReason(FailReason.FailType.IO_ERROR, new IllegalStateException("load complete but not in cache.")));
                        return;
                    }
                    holder.photoView.suitMaxScaleWithSize(loadedImage.getWidth(), loadedImage.getHeight());
                    holder.photoView.setImage(ImageSource.uri(resultUri));
                    View inPagerView = PicturePagerActivity.this.mViewPager.findViewById(position);
                    if (inPagerView != null && (inPagerHolder = (ViewHolder)inPagerView.getTag()) != holder) {
                        inPagerHolder.progressText.setVisibility(8);
                        inPagerHolder.progressBar.setVisibility(8);
                        PicturePagerActivity.this.mImageAdapter.updatePhotoView(position, inPagerView);
                    }
                }

                @Override
                public void onLoadingCancelled(String imageUri, View view) {
                    holder.progressText.setVisibility(8);
                    holder.progressText.setVisibility(8);
                }
            }, new ImageLoadingProgressListener(){

                @Override
                public void onProgressUpdate(String imageUri, View view, int current, int total) {
                    holder.progressText.setText((CharSequence)(current * 100 / total + "%"));
                    if (current == total) {
                        holder.progressText.setVisibility(8);
                        holder.progressBar.setVisibility(8);
                    } else {
                        holder.progressText.setVisibility(0);
                        holder.progressBar.setVisibility(0);
                    }
                }
            });
        }

        public ImageInfo getImageInfo(int position) {
            return this.mImageList.get(position);
        }

        public class ViewHolder {
            ProgressBar progressBar;
            TextView progressText;
            SubsamplingScaleImageView photoView;
            TextView mCountDownView;
        }
    }
}

