/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.actions;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.rong.imkit.R;
import io.rong.imkit.actions.IClickActions;
import io.rong.imkit.actions.IMoreClickAdapter;
import io.rong.imkit.actions.MoreActionLayout;
import java.util.List;

public class MoreClickAdapter
implements IMoreClickAdapter {
    private MoreActionLayout moreActionLayout;

    @Override
    public void bindView(ViewGroup viewGroup, Fragment fragment, List<IClickActions> actions) {
        if (this.moreActionLayout == null) {
            Context context = viewGroup.getContext();
            this.moreActionLayout = (MoreActionLayout)LayoutInflater.from((Context)context).inflate(R.layout.rc_ext_actions_container, null);
            this.moreActionLayout.setFragment(fragment);
            this.moreActionLayout.addActions(actions);
            int height = context.getResources().getDimensionPixelOffset(R.dimen.rc_ext_more_layout_height);
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, height);
            this.moreActionLayout.setLayoutParams(params);
            viewGroup.addView((View)this.moreActionLayout);
        }
        this.moreActionLayout.setVisibility(0);
    }

    @Override
    public void hideMoreActionLayout() {
        if (this.moreActionLayout != null) {
            this.moreActionLayout.setVisibility(8);
        }
    }

    @Override
    public void setMoreActionEnable(boolean enable) {
        if (this.moreActionLayout != null) {
            this.moreActionLayout.refreshView(enable);
        }
    }

    @Override
    public boolean isMoreActionShown() {
        return this.moreActionLayout != null && this.moreActionLayout.getVisibility() == 0;
    }
}

