/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.content.Context;
import android.text.Spannable;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.model.ConversationKey;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.MentionedInfo;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessagePushConfig;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.UserInfo;
import io.rong.message.RecallNotificationMessage;
import io.rong.push.RongPushClient;
import io.rong.push.common.PushCacheHelper;
import io.rong.push.notification.PushNotificationMessage;
import java.util.concurrent.ConcurrentHashMap;

public class RongNotificationManager {
    private static final String TAG = "RongNotificationManager";
    private static RongNotificationManager sS = new RongNotificationManager();
    Context mContext;
    ConcurrentHashMap<String, Message> messageMap = new ConcurrentHashMap();

    private RongNotificationManager() {
    }

    public void init(Context context) {
        this.mContext = context;
        this.messageMap.clear();
        if (!RongContext.getInstance().getEventBus().isRegistered(this)) {
            RongContext.getInstance().getEventBus().register(this);
        }
    }

    public static RongNotificationManager getInstance() {
        if (sS == null) {
            sS = new RongNotificationManager();
        }
        return sS;
    }

    public void onReceiveMessageFromApp(Message message) {
        this.onReceiveMessageFromApp(message, 0);
    }

    public void onReceiveMessageFromApp(Message message, int left) {
        Conversation.ConversationType type = message.getConversationType();
        String targetName = null;
        String userName = "";
        IContainerItemProvider.MessageProvider provider = RongContext.getInstance().getMessageTemplate(message.getContent().getClass());
        if (provider == null) {
            return;
        }
        Spannable content = provider.getContentSummary(this.mContext, message.getContent());
        ConversationKey targetKey = ConversationKey.obtain(message.getTargetId(), message.getConversationType());
        if (targetKey == null) {
            RLog.e((String)TAG, (String)"onReceiveMessageFromApp targetKey is null");
        }
        RLog.i((String)TAG, (String)("onReceiveMessageFromApp. conversationType:" + type));
        if (content == null) {
            RLog.e((String)TAG, (String)"onReceiveMessageFromApp Content is null. Return directly.");
            return;
        }
        if (type.equals((Object)Conversation.ConversationType.PRIVATE) || type.equals((Object)Conversation.ConversationType.CUSTOMER_SERVICE) || type.equals((Object)Conversation.ConversationType.CHATROOM) || type.equals((Object)Conversation.ConversationType.SYSTEM)) {
            UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(message.getTargetId());
            if (message.getMessagePushConfig() != null && !TextUtils.isEmpty((CharSequence)message.getMessagePushConfig().getPushTitle())) {
                targetName = message.getMessagePushConfig().getPushTitle();
            } else if (userInfo != null) {
                targetName = userInfo.getName();
            }
            if (!TextUtils.isEmpty(targetName)) {
                PushNotificationMessage pushMsg = this.transformToPushMessage(message, content.toString(), targetName, targetName);
                RongPushClient.sendNotification((Context)this.mContext, (PushNotificationMessage)pushMsg, (int)left);
            } else {
                if (targetKey != null) {
                    this.messageMap.put(targetKey.getKey(), message);
                }
                RLog.e((String)TAG, (String)"No popup notification cause of the sender name is null, please set UserInfoProvider");
            }
        } else if (type.equals((Object)Conversation.ConversationType.GROUP)) {
            Group groupInfo = RongUserInfoManager.getInstance().getGroupInfo(message.getTargetId());
            UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
            GroupUserInfo groupUserInfo = RongUserInfoManager.getInstance().getGroupUserInfo(message.getTargetId(), message.getSenderUserId());
            if (groupInfo != null) {
                targetName = groupInfo.getName();
            }
            if (groupUserInfo != null) {
                userName = groupUserInfo.getNickname();
            }
            if (TextUtils.isEmpty((CharSequence)userName) && userInfo != null) {
                userName = userInfo.getName();
                RLog.d((String)TAG, (String)"onReceiveMessageFromApp the nickName of group user is null");
            }
            if (!TextUtils.isEmpty((CharSequence)targetName) && !TextUtils.isEmpty((CharSequence)userName)) {
                String notificationContent = this.isMentionedMessage(message) ? (TextUtils.isEmpty((CharSequence)message.getContent().getMentionedInfo().getMentionedContent()) ? this.mContext.getString(R.string.rc_message_content_mentioned) + userName + " : " + content.toString() : message.getContent().getMentionedInfo().getMentionedContent()) : (message.getContent() instanceof RecallNotificationMessage ? content.toString() : userName + " : " + content.toString());
                PushNotificationMessage pushMsg = this.transformToPushMessage(message, notificationContent, targetName, "");
                RongPushClient.sendNotification((Context)this.mContext, (PushNotificationMessage)pushMsg, (int)left);
            } else {
                if (TextUtils.isEmpty((CharSequence)targetName) && targetKey != null) {
                    this.messageMap.put(targetKey.getKey(), message);
                }
                if (TextUtils.isEmpty((CharSequence)userName)) {
                    ConversationKey senderKey = ConversationKey.obtain(message.getSenderUserId(), type);
                    if (senderKey != null) {
                        this.messageMap.put(senderKey.getKey(), message);
                    } else {
                        RLog.e((String)TAG, (String)"onReceiveMessageFromApp senderKey is null");
                    }
                }
                RLog.e((String)TAG, (String)"No popup notification cause of the sender name is null, please set UserInfoProvider");
            }
        } else if (type.equals((Object)Conversation.ConversationType.DISCUSSION)) {
            Discussion discussionInfo = RongUserInfoManager.getInstance().getDiscussionInfo(message.getTargetId());
            UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
            if (discussionInfo != null) {
                targetName = discussionInfo.getName();
            }
            if (userInfo != null) {
                userName = userInfo.getName();
            }
            if (!TextUtils.isEmpty((CharSequence)targetName) && !TextUtils.isEmpty((CharSequence)userName)) {
                String notificationContent = this.isMentionedMessage(message) ? (TextUtils.isEmpty((CharSequence)message.getContent().getMentionedInfo().getMentionedContent()) ? this.mContext.getString(R.string.rc_message_content_mentioned) + userName + " : " + content.toString() : message.getContent().getMentionedInfo().getMentionedContent()) : userName + " : " + content.toString();
                PushNotificationMessage pushMsg = this.transformToPushMessage(message, notificationContent, targetName, "");
                RongPushClient.sendNotification((Context)this.mContext, (PushNotificationMessage)pushMsg, (int)left);
            } else {
                if (TextUtils.isEmpty((CharSequence)targetName) && targetKey != null) {
                    this.messageMap.put(targetKey.getKey(), message);
                }
                if (TextUtils.isEmpty((CharSequence)userName)) {
                    ConversationKey senderKey = ConversationKey.obtain(message.getSenderUserId(), type);
                    if (senderKey != null) {
                        this.messageMap.put(senderKey.getKey(), message);
                    } else {
                        RLog.e((String)TAG, (String)"onReceiveMessageFromApp senderKey is null");
                    }
                }
                RLog.e((String)TAG, (String)"No popup notification cause of the sender name is null, please set UserInfoProvider");
            }
        } else if (type.equals((Object)Conversation.ConversationType.PUBLIC_SERVICE) || type.getName().equals(Conversation.PublicServiceType.APP_PUBLIC_SERVICE.getName())) {
            PublicServiceProfile info;
            if (targetKey != null && (info = RongContext.getInstance().getPublicServiceInfoFromCache(targetKey.getKey())) != null) {
                targetName = info.getName();
            }
            if (!TextUtils.isEmpty((CharSequence)targetName)) {
                PushNotificationMessage pushMsg = this.transformToPushMessage(message, content.toString(), targetName, "");
                RongPushClient.sendNotification((Context)this.mContext, (PushNotificationMessage)pushMsg, (int)left);
            } else {
                if (targetKey != null) {
                    this.messageMap.put(targetKey.getKey(), message);
                }
                RLog.e((String)TAG, (String)"No popup notification cause of the sender name is null, please set UserInfoProvider");
            }
        } else if (type.equals((Object)Conversation.ConversationType.ENCRYPTED)) {
            String[] ids = message.getTargetId().split(";;;");
            if (ids.length < 2) {
                RLog.e((String)TAG, (String)"Error targetId for encrypted conversation.");
                return;
            }
            String realId = ids[1];
            UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(realId);
            if (userInfo != null && !TextUtils.isEmpty((CharSequence)userInfo.getName())) {
                PushNotificationMessage pushMsg = this.transformToPushMessage(message, this.mContext.getString(R.string.rc_receive_new_message), userInfo.getName(), userInfo.getName());
                RongPushClient.sendNotification((Context)this.mContext, (PushNotificationMessage)pushMsg, (int)left);
            } else {
                targetKey = ConversationKey.obtain(realId, message.getConversationType());
                if (targetKey != null) {
                    this.messageMap.put(targetKey.getKey(), message);
                }
                RLog.e((String)TAG, (String)"No popup notification cause of the sender name is null, please set UserInfoProvider");
            }
        }
    }

    public void onEventMainThread(UserInfo userInfo) {
        Conversation.ConversationType[] types = new Conversation.ConversationType[]{Conversation.ConversationType.PRIVATE, Conversation.ConversationType.GROUP, Conversation.ConversationType.DISCUSSION, Conversation.ConversationType.CUSTOMER_SERVICE, Conversation.ConversationType.CHATROOM, Conversation.ConversationType.SYSTEM};
        RLog.i((String)TAG, (String)("onEventMainThread. userInfo" + userInfo));
        for (Conversation.ConversationType type : types) {
            String key = ConversationKey.obtain(userInfo.getUserId(), type).getKey();
            if (!this.messageMap.containsKey(key)) continue;
            Message message = this.messageMap.get(key);
            String targetName = "";
            String notificationContent = "";
            Spannable content = RongContext.getInstance().getMessageTemplate(message.getContent().getClass()).getContentSummary(this.mContext, message.getContent());
            this.messageMap.remove(key);
            if (type.equals((Object)Conversation.ConversationType.GROUP)) {
                Group groupInfo = RongUserInfoManager.getInstance().getGroupInfo(message.getTargetId());
                GroupUserInfo groupUserInfo = RongUserInfoManager.getInstance().getGroupUserInfo(message.getTargetId(), message.getSenderUserId());
                String userName = "";
                if (groupInfo == null) {
                    RLog.e((String)TAG, (String)"onEventMainThread userInfo : groupInfo is null, return directly");
                    return;
                }
                targetName = groupInfo.getName();
                if (groupUserInfo != null) {
                    userName = groupUserInfo.getNickname();
                }
                if (TextUtils.isEmpty((CharSequence)userName) && userInfo != null) {
                    userName = userInfo.getName();
                    RLog.d((String)TAG, (String)"onReceiveMessageFromApp the nickName of group user is null");
                }
                notificationContent = this.isMentionedMessage(message) ? (TextUtils.isEmpty((CharSequence)message.getContent().getMentionedInfo().getMentionedContent()) ? this.mContext.getString(R.string.rc_message_content_mentioned) + userName + " : " + content.toString() : message.getContent().getMentionedInfo().getMentionedContent()) : userName + " : " + content.toString();
            } else if (type.equals((Object)Conversation.ConversationType.DISCUSSION)) {
                Discussion discussion = RongUserInfoManager.getInstance().getDiscussionInfo(message.getTargetId());
                if (discussion != null) {
                    targetName = discussion.getName();
                }
                notificationContent = this.isMentionedMessage(message) ? (TextUtils.isEmpty((CharSequence)message.getContent().getMentionedInfo().getMentionedContent()) ? this.mContext.getString(R.string.rc_message_content_mentioned) + userInfo.getName() + " : " + content.toString() : message.getContent().getMentionedInfo().getMentionedContent()) : userInfo.getName() + " : " + content.toString();
            } else if (type.equals((Object)Conversation.ConversationType.ENCRYPTED)) {
                targetName = userInfo.getName();
                notificationContent = this.mContext.getString(R.string.rc_receive_new_message);
            } else {
                targetName = userInfo.getName();
                notificationContent = content.toString();
            }
            if (TextUtils.isEmpty((CharSequence)targetName)) {
                return;
            }
            PushNotificationMessage pushMsg = this.transformToPushMessage(message, notificationContent, targetName, "");
            RongPushClient.sendNotification((Context)this.mContext, (PushNotificationMessage)pushMsg);
        }
    }

    public void onEventMainThread(Group groupInfo) {
        String key = ConversationKey.obtain(groupInfo.getId(), Conversation.ConversationType.GROUP).getKey();
        RLog.i((String)TAG, (String)("onEventMainThread. groupInfo" + groupInfo));
        if (this.messageMap.containsKey(key)) {
            Message message = this.messageMap.get(key);
            String userName = "";
            Spannable content = RongContext.getInstance().getMessageTemplate(message.getContent().getClass()).getContentSummary(this.mContext, message.getContent());
            this.messageMap.remove(key);
            UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
            if (userInfo != null) {
                userName = userInfo.getName();
                if (TextUtils.isEmpty((CharSequence)userName)) {
                    RLog.e((String)TAG, (String)"onEventMainThread Group : userName is empty, return directly");
                    return;
                }
            } else {
                RLog.e((String)TAG, (String)"onEventMainThread Group : userInfo is null, return directly");
                return;
            }
            String pushContent = userName + " : " + content.toString();
            PushNotificationMessage pushMsg = this.transformToPushMessage(message, pushContent, groupInfo.getName(), "");
            RongPushClient.sendNotification((Context)this.mContext, (PushNotificationMessage)pushMsg);
        }
    }

    public void onEventMainThread(Discussion discussion) {
        String key = ConversationKey.obtain(discussion.getId(), Conversation.ConversationType.DISCUSSION).getKey();
        if (this.messageMap.containsKey(key)) {
            String userName = "";
            Message message = this.messageMap.get(key);
            Spannable content = RongContext.getInstance().getMessageTemplate(message.getContent().getClass()).getContentSummary(this.mContext, message.getContent());
            this.messageMap.remove(key);
            UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
            if (userInfo != null && TextUtils.isEmpty((CharSequence)(userName = userInfo.getName()))) {
                return;
            }
            String pushContent = userName + " : " + content.toString();
            PushNotificationMessage pushMsg = this.transformToPushMessage(message, pushContent, discussion.getName(), "");
            RongPushClient.sendNotification((Context)this.mContext, (PushNotificationMessage)pushMsg);
        }
    }

    public void onEventMainThread(PublicServiceProfile info) {
        String key = ConversationKey.obtain(info.getTargetId(), info.getConversationType()).getKey();
        if (this.messageMap.containsKey(key)) {
            Message message = this.messageMap.get(key);
            Spannable content = RongContext.getInstance().getMessageTemplate(message.getContent().getClass()).getContentSummary(this.mContext, message.getContent());
            PushNotificationMessage pushMsg = this.transformToPushMessage(message, content.toString(), info.getName(), "");
            RongPushClient.sendNotification((Context)this.mContext, (PushNotificationMessage)pushMsg);
            this.messageMap.remove(key);
        }
    }

    private boolean isMentionedMessage(Message message) {
        MentionedInfo mentionedInfo = message.getContent().getMentionedInfo();
        return mentionedInfo != null && (mentionedInfo.getType().equals((Object)MentionedInfo.MentionedType.ALL) || mentionedInfo.getType().equals((Object)MentionedInfo.MentionedType.PART) && mentionedInfo.getMentionedUserIdList() != null && mentionedInfo.getMentionedUserIdList().contains(RongIMClient.getInstance().getCurrentUserId()));
    }

    private PushNotificationMessage transformToPushMessage(Message message, String content, String targetUserName, String senderName) {
        PushNotificationMessage pushMsg = new PushNotificationMessage();
        MessagePushConfig messagePushConfig = message.getMessagePushConfig();
        boolean isShowDetail = true;
        if (messagePushConfig != null) {
            if (!messagePushConfig.isForceShowDetailContent() && !PushCacheHelper.getInstance().getPushContentShowStatus(this.mContext)) {
                pushMsg.setPushContent(this.mContext.getString(R.string.rc_receive_new_message));
                isShowDetail = false;
            } else if (!TextUtils.isEmpty((CharSequence)messagePushConfig.getPushContent())) {
                pushMsg.setPushContent(messagePushConfig.getPushContent());
            } else {
                if (message.getContent() instanceof RecallNotificationMessage && message.getConversationType().equals((Object)Conversation.ConversationType.PRIVATE)) {
                    content = this.mContext.getString(R.string.rc_recalled_a_message).trim();
                }
                pushMsg.setPushContent(content);
            }
            if (messagePushConfig.getAndroidConfig() != null) {
                String notificationId = messagePushConfig.getAndroidConfig().getNotificationId();
                if (!TextUtils.isEmpty((CharSequence)notificationId)) {
                    pushMsg.setNotificationId(notificationId);
                }
                pushMsg.setChannelIdHW(messagePushConfig.getAndroidConfig().getChannelIdHW());
                pushMsg.setChannelIdMi(messagePushConfig.getAndroidConfig().getChannelIdMi());
                pushMsg.setChannelIdOPPO(messagePushConfig.getAndroidConfig().getChannelIdOPPO());
            }
            if (!TextUtils.isEmpty((CharSequence)messagePushConfig.getPushTitle())) {
                pushMsg.setPushTitle(messagePushConfig.getPushTitle());
            }
            if (!TextUtils.isEmpty((CharSequence)messagePushConfig.getPushData())) {
                pushMsg.setPushData(messagePushConfig.getPushData());
            }
        } else if (!PushCacheHelper.getInstance().getPushContentShowStatus(this.mContext)) {
            pushMsg.setPushContent(this.mContext.getString(R.string.rc_receive_new_message));
            isShowDetail = false;
        } else {
            if (message.getContent() instanceof RecallNotificationMessage && message.getConversationType().equals((Object)Conversation.ConversationType.PRIVATE)) {
                content = this.mContext.getString(R.string.rc_recalled_a_message).trim();
            }
            pushMsg.setPushContent(content);
        }
        if (message.getContent() instanceof RecallNotificationMessage) {
            pushMsg.setObjectName("RC:RcNtf");
        } else {
            pushMsg.setObjectName(message.getObjectName());
        }
        pushMsg.setShowDetail(isShowDetail);
        pushMsg.setConversationType(RongPushClient.ConversationType.setValue((int)message.getConversationType().getValue()));
        pushMsg.setTargetId(message.getTargetId());
        pushMsg.setTargetUserName(targetUserName);
        pushMsg.setSenderId(message.getSenderUserId());
        pushMsg.setSenderName(senderName);
        pushMsg.setPushFlag("false");
        pushMsg.setToId(RongIMClient.getInstance().getCurrentUserId());
        pushMsg.setSourceType(PushNotificationMessage.PushSourceType.LOCAL_MESSAGE);
        pushMsg.setPushId(message.getUId());
        return pushMsg;
    }
}

