/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.app.AlertDialog;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.widget.Toast;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongIM;
import io.rong.imkit.manager.AudioPlayManager;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.utilities.OptionsPopupDialog;
import io.rong.imkit.widget.provider.MessageItemLongClickAction;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.location.message.RealTimeLocationStartMessage;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.UnknownMessage;
import io.rong.imlib.model.UserInfo;
import io.rong.message.HandshakeMessage;
import io.rong.message.NotificationMessage;
import io.rong.message.PublicServiceMultiRichContentMessage;
import io.rong.message.PublicServiceRichContentMessage;
import io.rong.message.RecallNotificationMessage;
import io.rong.message.ReferenceMessage;
import io.rong.message.TextMessage;
import io.rong.message.VoiceMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RongMessageItemLongClickActionManager {
    private static final String TAG = RongMessageItemLongClickActionManager.class.getSimpleName();
    private OptionsPopupDialog mDialog;
    private Message mLongClickMessage;
    private List<MessageItemLongClickAction> messageItemLongClickActions = new ArrayList<MessageItemLongClickAction>();

    public static RongMessageItemLongClickActionManager getInstance() {
        return Holder.instance;
    }

    private RongMessageItemLongClickActionManager() {
    }

    public void init() {
        this.messageItemLongClickActions.clear();
        this.initCommonMessageItemLongClickActions();
    }

    public void setLongClickMessage(Message message) {
        this.mLongClickMessage = message;
    }

    public Message getLongClickMessage() {
        return this.mLongClickMessage;
    }

    public void setLongClickDialog(OptionsPopupDialog dialog) {
        this.mDialog = dialog;
    }

    public OptionsPopupDialog getLongClickDialog() {
        return this.mDialog;
    }

    public List<MessageItemLongClickAction> getMessageItemLongClickActions() {
        return this.messageItemLongClickActions;
    }

    public void addMessageItemLongClickAction(MessageItemLongClickAction action) {
        this.addMessageItemLongClickAction(action, -1);
    }

    public void addMessageItemLongClickAction(MessageItemLongClickAction action, int index) {
        if (this.messageItemLongClickActions.contains(action)) {
            this.messageItemLongClickActions.remove(action);
        }
        if (index < 0) {
            this.messageItemLongClickActions.add(action);
        } else {
            this.messageItemLongClickActions.add(index, action);
        }
    }

    public void removeMessageItemLongClickAction(MessageItemLongClickAction action) {
        this.messageItemLongClickActions.remove(action);
    }

    public List<MessageItemLongClickAction> getMessageItemLongClickActions(UIMessage uiMessage) {
        ArrayList<MessageItemLongClickAction> actions = new ArrayList<MessageItemLongClickAction>();
        for (MessageItemLongClickAction action : this.messageItemLongClickActions) {
            if (!action.filter(uiMessage)) continue;
            actions.add(action);
        }
        Collections.sort(actions, new Comparator<MessageItemLongClickAction>(){

            @Override
            public int compare(MessageItemLongClickAction t1, MessageItemLongClickAction t2) {
                if (t1.priority > t2.priority) {
                    return 1;
                }
                if (t1.priority == t2.priority) {
                    return 0;
                }
                return -1;
            }
        });
        return actions;
    }

    private void initCommonMessageItemLongClickActions() {
        MessageItemLongClickAction messageItemLongClickAction = new MessageItemLongClickAction.Builder().titleResId(R.string.rc_dialog_item_message_copy).actionListener(new MessageItemLongClickAction.MessageItemLongClickListener(){

            @Override
            public boolean onMessageItemLongClick(Context context, UIMessage message) {
                ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
                if (message.getContent() instanceof RecallNotificationMessage) {
                    return false;
                }
                if (message.getContent() instanceof TextMessage) {
                    if (clipboard != null) {
                        clipboard.setText((CharSequence)((TextMessage)message.getContent()).getContent());
                    }
                } else if (message.getContent() instanceof ReferenceMessage) {
                    ReferenceMessage referenceMessage = (ReferenceMessage)message.getContent();
                    if (referenceMessage == null) {
                        return false;
                    }
                    if (clipboard != null) {
                        clipboard.setText((CharSequence)referenceMessage.getEditSendText());
                    }
                }
                return true;
            }
        }).showFilter(new MessageItemLongClickAction.Filter(){

            @Override
            public boolean filter(UIMessage message) {
                return (message.getContent() instanceof TextMessage || message.getContent() instanceof ReferenceMessage) && !message.getConversationType().equals((Object)Conversation.ConversationType.ENCRYPTED) && !message.getContent().isDestruct();
            }
        }).build();
        this.addMessageItemLongClickAction(messageItemLongClickAction);
        messageItemLongClickAction = new MessageItemLongClickAction.Builder().titleResId(R.string.rc_dialog_item_message_delete).actionListener(new MessageItemLongClickAction.MessageItemLongClickListener(){

            @Override
            public boolean onMessageItemLongClick(Context context, UIMessage message) {
                if (message.getMessage().getContent() instanceof VoiceMessage) {
                    Uri uri = ((VoiceMessage)message.getMessage().getContent()).getUri();
                    Uri playingUri = AudioPlayManager.getInstance().getPlayingUri();
                    if (playingUri != null && playingUri == uri) {
                        AudioPlayManager.getInstance().stopPlay();
                    }
                }
                RongIM.getInstance().deleteMessages(new int[]{message.getMessageId()}, null);
                return true;
            }
        }).build();
        this.addMessageItemLongClickAction(messageItemLongClickAction);
        messageItemLongClickAction = new MessageItemLongClickAction.Builder().titleResId(R.string.rc_dialog_item_message_recall).actionListener(new MessageItemLongClickAction.MessageItemLongClickListener(){

            @Override
            public boolean onMessageItemLongClick(Context context, UIMessage message) {
                if (RongIM.getInstance().getCurrentConnectionStatus() == RongIMClient.ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE) {
                    Toast.makeText((Context)context, (CharSequence)context.getResources().getString(R.string.rc_recall_failed_for_network_unavailable), (int)0).show();
                    return true;
                }
                long deltaTime = RongIM.getInstance().getDeltaTime();
                long normalTime = System.currentTimeMillis() - deltaTime;
                int messageRecallInterval = -1;
                boolean needRecall = false;
                try {
                    messageRecallInterval = context.getResources().getInteger(R.integer.rc_message_recall_interval);
                }
                catch (Resources.NotFoundException e) {
                    RLog.e((String)TAG, (String)"rc_message_recall_interval not configure in rc_config.xml");
                    e.printStackTrace();
                }
                boolean bl = needRecall = normalTime - message.getSentTime() <= (long)(messageRecallInterval * 1000);
                if (needRecall) {
                    RongIM.getInstance().recallMessage(message.getMessage(), null);
                } else {
                    new AlertDialog.Builder(context).setMessage(R.string.rc_recall_overtime).setPositiveButton(R.string.rc_confirm, null).setCancelable(false).create().show();
                    RLog.e((String)TAG, (String)"\u64a4\u56de\u6d88\u606f\u5931\u8d25");
                }
                return true;
            }
        }).showFilter(new MessageItemLongClickAction.Filter(){

            @Override
            public boolean filter(UIMessage message) {
                if (message.getContent() instanceof NotificationMessage || message.getContent() instanceof HandshakeMessage || message.getContent() instanceof PublicServiceRichContentMessage || message.getContent() instanceof RealTimeLocationStartMessage || message.getContent() instanceof UnknownMessage || message.getContent() instanceof PublicServiceMultiRichContentMessage || message.getSentStatus().equals((Object)Message.SentStatus.CANCELED) || message.getConversationType().equals((Object)Conversation.ConversationType.ENCRYPTED)) {
                    return false;
                }
                long deltaTime = RongIM.getInstance().getDeltaTime();
                long normalTime = System.currentTimeMillis() - deltaTime;
                boolean enableMessageRecall = false;
                int messageRecallInterval = -1;
                boolean hasSent = !message.getSentStatus().equals((Object)Message.SentStatus.SENDING) && !message.getSentStatus().equals((Object)Message.SentStatus.FAILED);
                try {
                    enableMessageRecall = RongIM.getInstance().getApplicationContext().getResources().getBoolean(R.bool.rc_enable_message_recall);
                    messageRecallInterval = RongIM.getInstance().getApplicationContext().getResources().getInteger(R.integer.rc_message_recall_interval);
                }
                catch (Exception e) {
                    RLog.e((String)TAG, (String)"rc_message_recall_interval not configure in rc_config.xml");
                    e.printStackTrace();
                }
                return hasSent && enableMessageRecall && normalTime - message.getSentTime() <= (long)(messageRecallInterval * 1000) && message.getSenderUserId().equals(RongIM.getInstance().getCurrentUserId()) && !message.getConversationType().equals((Object)Conversation.ConversationType.CUSTOMER_SERVICE) && !message.getConversationType().equals((Object)Conversation.ConversationType.APP_PUBLIC_SERVICE) && !message.getConversationType().equals((Object)Conversation.ConversationType.PUBLIC_SERVICE) && !message.getConversationType().equals((Object)Conversation.ConversationType.SYSTEM) && !message.getConversationType().equals((Object)Conversation.ConversationType.CHATROOM);
            }
        }).build();
        this.addMessageItemLongClickAction(messageItemLongClickAction);
    }

    private String getPushContent(Context context, UIMessage message) {
        String userName = "";
        UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
        if (userInfo != null) {
            userName = userInfo.getName();
        }
        return context.getString(R.string.rc_user_recalled_message, new Object[]{userName});
    }

    private static class Holder {
        static RongMessageItemLongClickActionManager instance = new RongMessageItemLongClickActionManager();

        private Holder() {
        }
    }
}

