/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import io.rong.common.RLog;
import io.rong.common.SystemUtils;
import io.rong.eventbus.EventBus;
import io.rong.imageloader.core.ImageLoader;
import io.rong.imageloader.core.assist.FailReason;
import io.rong.imageloader.core.listener.ImageLoadingListener;
import io.rong.imageloader.core.listener.ImageLoadingProgressListener;
import io.rong.imkit.DefaultExtensionModule;
import io.rong.imkit.IPublicServiceMenuClickListener;
import io.rong.imkit.R;
import io.rong.imkit.RongConfigurationManager;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongExtensionManager;
import io.rong.imkit.RongMessageItemLongClickActionManager;
import io.rong.imkit.RongNotificationManager;
import io.rong.imkit.RongUserCacheListener;
import io.rong.imkit.manager.AudioRecordManager;
import io.rong.imkit.manager.IUnReadMessageObserver;
import io.rong.imkit.manager.InternalModuleManager;
import io.rong.imkit.manager.SendImageManager;
import io.rong.imkit.manager.SendMediaManager;
import io.rong.imkit.manager.UnReadMessageManager;
import io.rong.imkit.mention.RongMentionManager;
import io.rong.imkit.message.CombineMessage;
import io.rong.imkit.model.ConversationKey;
import io.rong.imkit.model.Event;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.model.UIConversation;
import io.rong.imkit.notification.MessageNotificationManager;
import io.rong.imkit.plugin.image.AlbumBitmapCacheHelper;
import io.rong.imkit.reference.ReferenceMessageItemProvider;
import io.rong.imkit.resend.ResendManager;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.utils.ImageDownloadManager;
import io.rong.imkit.voiceMessageDownload.HQVoiceMsgDownloadManager;
import io.rong.imkit.widget.provider.CSPullLeaveMsgItemProvider;
import io.rong.imkit.widget.provider.CombineMessageItemProvider;
import io.rong.imkit.widget.provider.DiscussionNotificationMessageItemProvider;
import io.rong.imkit.widget.provider.FileMessageItemProvider;
import io.rong.imkit.widget.provider.GIFMessageItemProvider;
import io.rong.imkit.widget.provider.GroupNotificationMessageItemProvider;
import io.rong.imkit.widget.provider.HQVoiceMessageItemProvider;
import io.rong.imkit.widget.provider.HandshakeMessageItemProvider;
import io.rong.imkit.widget.provider.HistoryDividerMessageProvider;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imkit.widget.provider.ImageMessageItemProvider;
import io.rong.imkit.widget.provider.InfoNotificationMsgItemProvider;
import io.rong.imkit.widget.provider.LocationMessageItemProvider;
import io.rong.imkit.widget.provider.PublicServiceMultiRichContentMessageProvider;
import io.rong.imkit.widget.provider.PublicServiceRichContentMessageProvider;
import io.rong.imkit.widget.provider.RealTimeLocationMessageProvider;
import io.rong.imkit.widget.provider.RecallMessageItemProvider;
import io.rong.imkit.widget.provider.RichContentMessageItemProvider;
import io.rong.imkit.widget.provider.TextMessageItemProvider;
import io.rong.imkit.widget.provider.UnknownMessageItemProvider;
import io.rong.imkit.widget.provider.VoiceMessageItemProvider;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.common.SharedPreferencesUtils;
import io.rong.imlib.model.CSCustomServiceInfo;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.ConversationStatus;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageConfig;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.PublicServiceProfileList;
import io.rong.imlib.model.RCEncryptedSession;
import io.rong.imlib.model.RemoteHistoryMsgOption;
import io.rong.imlib.model.SendMessageOption;
import io.rong.imlib.model.UserInfo;
import io.rong.message.GIFMessage;
import io.rong.message.InformationNotificationMessage;
import io.rong.message.LocationMessage;
import io.rong.message.RecallNotificationMessage;
import io.rong.push.RongPushClient;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RongIM {
    private static final String TAG = RongIM.class.getSimpleName();
    public static final int ON_SUCCESS_CALLBACK = 100;
    public static final int ON_PROGRESS_CALLBACK = 101;
    public static final int ON_CANCEL_CALLBACK = 102;
    public static final int ON_ERROR_CALLBACK = 103;
    private Context mApplicationContext;
    private Handler mWorkHandler;
    static RongIMClient.OnReceiveMessageListener sMessageListener;
    static RongIMClient.ConnectionStatusListener sConnectionStatusListener;
    private static MessageInterceptor messageInterceptor;
    private static boolean notificationQuiteHoursConfigured;
    private List<RongIMClient.EncryptedSessionConnectionListener> mEncSessionListeners;
    private static RongIMClient.ConnectionStatusListener mConnectionStatusListener;
    private SamplingRate sampleRate = SamplingRate.RC_SAMPLE_RATE_8000;
    private VoiceMessageType voiceMessageType = VoiceMessageType.Ordinary;

    private RongIM() {
        this.mEncSessionListeners = new LinkedList<RongIMClient.EncryptedSessionConnectionListener>();
        HandlerThread workThread = new HandlerThread("KIT_WORK");
        workThread.start();
        this.mWorkHandler = new Handler(workThread.getLooper());
        RongIMClient.getInstance().setEncryptedSessionConnectionListener(new RongIMClient.EncryptedSessionConnectionListener(){

            public void onEncryptedSessionRequest(String targetId, boolean isSuccess) {
                RLog.d((String)TAG, (String)"\u53d1\u9001\u52a0\u5bc6\u4f1a\u8bdd\u8bf7\u6c42");
                if (RongIM.this.mEncSessionListeners != null) {
                    for (int i = 0; i < RongIM.this.mEncSessionListeners.size(); ++i) {
                        if (RongIM.this.mEncSessionListeners.get(i) == null) continue;
                        ((RongIMClient.EncryptedSessionConnectionListener)RongIM.this.mEncSessionListeners.get(i)).onEncryptedSessionRequest(targetId, isSuccess);
                    }
                }
            }

            public void onEncryptedSessionResponse(String targetId) {
                RLog.d((String)TAG, (String)"\u53d1\u9001\u52a0\u5bc6\u4f1a\u8bdd\u54cd\u5e94");
                if (RongIM.this.mEncSessionListeners != null) {
                    for (int i = 0; i < RongIM.this.mEncSessionListeners.size(); ++i) {
                        if (RongIM.this.mEncSessionListeners.get(i) == null) continue;
                        ((RongIMClient.EncryptedSessionConnectionListener)RongIM.this.mEncSessionListeners.get(i)).onEncryptedSessionResponse(targetId);
                    }
                }
            }

            public void onEncryptedSessionEstablished(String targetId) {
                RLog.d((String)TAG, (String)"\u52a0\u5bc6\u4f1a\u8bdd\u5efa\u7acb");
                if (targetId == null || targetId.length() == 0) {
                    RLog.e((String)TAG, (String)"encrypted session establish failed because the targetId is null or empty.");
                    return;
                }
                if (RongIM.this.mEncSessionListeners != null) {
                    for (int i = 0; i < RongIM.this.mEncSessionListeners.size(); ++i) {
                        if (RongIM.this.mEncSessionListeners.get(i) == null) continue;
                        ((RongIMClient.EncryptedSessionConnectionListener)RongIM.this.mEncSessionListeners.get(i)).onEncryptedSessionEstablished(targetId);
                    }
                }
            }

            public void onEncryptedSessionCanceled(String targetId) {
                RLog.d((String)TAG, (String)"\u53d6\u6d88\u52a0\u5bc6\u4f1a\u8bdd\u8bf7\u6c42");
                if (RongIM.this.mEncSessionListeners != null) {
                    for (int i = 0; i < RongIM.this.mEncSessionListeners.size(); ++i) {
                        if (RongIM.this.mEncSessionListeners.get(i) == null) continue;
                        ((RongIMClient.EncryptedSessionConnectionListener)RongIM.this.mEncSessionListeners.get(i)).onEncryptedSessionCanceled(targetId);
                    }
                }
            }

            public void onEncryptedSessionTerminated(String targetId) {
                RLog.d((String)TAG, (String)"\u7ed3\u675f\u52a0\u5bc6\u4f1a\u8bdd\u8bf7\u6c42");
                if (RongIM.this.mEncSessionListeners != null) {
                    for (int i = 0; i < RongIM.this.mEncSessionListeners.size(); ++i) {
                        if (RongIM.this.mEncSessionListeners.get(i) == null) continue;
                        ((RongIMClient.EncryptedSessionConnectionListener)RongIM.this.mEncSessionListeners.get(i)).onEncryptedSessionTerminated(targetId);
                    }
                }
            }
        });
    }

    public void registerEncSessionListener(RongIMClient.EncryptedSessionConnectionListener listener) {
        if (listener != null && !this.mEncSessionListeners.contains(listener)) {
            this.mEncSessionListeners.add(listener);
        }
    }

    public void unRegisterEncSessionListener(RongIMClient.EncryptedSessionConnectionListener listener) {
        if (listener != null) {
            this.mEncSessionListeners.remove(listener);
        }
    }

    public boolean isRegisted(RongIMClient.EncryptedSessionConnectionListener listener) {
        return this.mEncSessionListeners != null && this.mEncSessionListeners.contains(listener);
    }

    private void saveToken(String token) {
        SharedPreferences preferences = SharedPreferencesUtils.get((Context)this.mApplicationContext, (String)"RongKitConfig", (int)0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("token", token);
        editor.commit();
    }

    private void initSDK(Context context, String appKey, boolean enablePush) {
        this.mApplicationContext = context;
        String current = SystemUtils.getCurrentProcessName((Context)context);
        String mainProcessName = context.getPackageName();
        if (!TextUtils.isEmpty((CharSequence)current) && !mainProcessName.equals(current)) {
            RLog.w((String)TAG, (String)("Init. Current process : " + current));
            return;
        }
        RLog.i((String)TAG, (String)("init : " + current));
        RongContext.getInstance().initRegister();
        RongConfigurationManager.init(context);
        RongMessageItemLongClickActionManager.getInstance().init();
        this.initListener();
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            try {
                ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                appKey = applicationInfo.metaData.getString("RONG_CLOUD_APP_KEY");
                if (TextUtils.isEmpty((CharSequence)appKey) || !SystemUtils.isValidAppKey((String)appKey)) {
                    throw new IllegalArgumentException("can't find RONG_CLOUD_APP_KEY in AndroidManifest.xml.");
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                throw new ExceptionInInitializerError("can't find packageName!");
            }
        }
        RongUserInfoManager.getInstance().init(this.mApplicationContext, appKey, new RongUserCacheListener());
        RongIMClient.init((Context)context, (String)appKey, (boolean)enablePush);
        RongIM.registerMessageTemplate(new TextMessageItemProvider());
        RongIM.registerMessageTemplate(new ImageMessageItemProvider());
        RongIM.registerMessageTemplate(new GIFMessageItemProvider());
        RongIM.registerMessageTemplate(new LocationMessageItemProvider());
        RongIM.registerMessageTemplate(new VoiceMessageItemProvider(context));
        RongIM.registerMessageTemplate(new HQVoiceMessageItemProvider());
        RongIM.registerMessageTemplate(new DiscussionNotificationMessageItemProvider());
        RongIM.registerMessageTemplate(new InfoNotificationMsgItemProvider());
        RongIM.registerMessageTemplate(new RichContentMessageItemProvider());
        RongIM.registerMessageTemplate(new PublicServiceMultiRichContentMessageProvider());
        RongIM.registerMessageTemplate(new PublicServiceRichContentMessageProvider());
        RongIM.registerMessageTemplate(new HandshakeMessageItemProvider());
        RongIM.registerMessageTemplate(new RecallMessageItemProvider());
        RongIM.registerMessageTemplate(new FileMessageItemProvider());
        RongIM.registerMessageTemplate(new GroupNotificationMessageItemProvider());
        RongIM.registerMessageTemplate(new RealTimeLocationMessageProvider());
        RongIM.registerMessageTemplate(new UnknownMessageItemProvider());
        RongIM.registerMessageTemplate(new CSPullLeaveMsgItemProvider());
        RongIM.registerMessageTemplate(new HistoryDividerMessageProvider());
        RongIM.registerMessageTemplate(new CombineMessageItemProvider());
        RongIM.registerMessageTemplate(new ReferenceMessageItemProvider());
        RongIM.registerMessageType(CombineMessage.class);
        RongExtensionManager.init(context, appKey);
        RongExtensionManager.getInstance().registerExtensionModule(new DefaultExtensionModule(context));
        InternalModuleManager.init(context);
        InternalModuleManager.getInstance().onInitialized(appKey);
        AlbumBitmapCacheHelper.init(context);
        ImageDownloadManager.init(context);
        HQVoiceMsgDownloadManager.getInstance().init(context);
        RongNotificationManager.getInstance().init(this.mApplicationContext);
        ImageLoader.getInstance().init(RongContext.getInstance().getDefaultConfig(this.mApplicationContext));
    }

    public static void init(Application application, String appKey) {
        SingletonHolder.sRongIM.initSDK((Context)application, appKey, true);
    }

    public static void init(Context context, String appKey) {
        SingletonHolder.sRongIM.initSDK(context, appKey, true);
    }

    public static void init(Context context, String appKey, boolean enablePush) {
        SingletonHolder.sRongIM.initSDK(context, appKey, enablePush);
    }

    public static void init(Context context) {
        SingletonHolder.sRongIM.initSDK(context, null, true);
    }

    public static void initAsync(final Context context, final String appKey, final boolean enablePush, final AsyncInitListener asyncInitListener) {
        SingletonHolder.sRongIM.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (asyncInitListener != null) {
                    asyncInitListener.doBeforeInit();
                    SingletonHolder.sRongIM.initSDK(context, appKey, enablePush);
                    asyncInitListener.doAfterInit();
                } else {
                    SingletonHolder.sRongIM.initSDK(context, appKey, enablePush);
                }
            }
        });
    }

    public static void registerMessageType(Class<? extends MessageContent> messageContentClass) {
        if (RongContext.getInstance() != null) {
            RongIMClient.registerMessageType(messageContentClass);
        }
    }

    public static void registerMessageTemplate(IContainerItemProvider.MessageProvider provider) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().registerMessageTemplate(provider);
        }
    }

    public void setCurrentUserInfo(UserInfo userInfo) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setCurrentUserInfo(userInfo);
        }
    }

    public static RongIM connect(String token, RongIMClient.ConnectCallback connectCallback) {
        return RongIM.connect(token, -1, connectCallback);
    }

    public static RongIM connect(final String token, int timeLimit, final RongIMClient.ConnectCallback connectCallback) {
        RongIMClient.connect((String)token, (int)timeLimit, (RongIMClient.ConnectCallback)new RongIMClient.ConnectCallback(){

            public void onSuccess(String userId) {
                RongIM.getInstance().saveToken(token);
                if (connectCallback != null) {
                    connectCallback.onSuccess(userId);
                }
                RongContext.getInstance().getEventBus().post(Event.ConnectEvent.obtain(true));
                RongExtensionManager.getInstance().connect(token);
                InternalModuleManager.getInstance().onConnected(token);
                if (!notificationQuiteHoursConfigured) {
                    SingletonHolder.sRongIM.getNotificationQuietHours(null);
                }
            }

            public void onError(RongIMClient.ConnectionErrorCode e) {
                if (connectCallback != null) {
                    connectCallback.onError(e);
                }
                RongExtensionManager.getInstance().connect(token);
                InternalModuleManager.getInstance().onConnected(token);
                if (RongContext.getInstance() == null) {
                    RLog.d((String)TAG, (String)"connect - onError. RongIM SDK not init, ConnectEvent do not post.");
                } else {
                    RongContext.getInstance().getEventBus().post(Event.ConnectEvent.obtain(false));
                }
            }

            public void onDatabaseOpened(RongIMClient.DatabaseOpenStatus code) {
                if (connectCallback != null) {
                    connectCallback.onDatabaseOpened(code);
                }
            }
        });
        return SingletonHolder.sRongIM;
    }

    private void initListener() {
        RongIMClient.setOnReceiveMessageListener((RongIMClient.OnReceiveMessageListener)new RongIMClient.OnReceiveMessageWrapperListener(){

            public boolean onReceived(Message message, int left, boolean hasPackage, boolean offline) {
                MessageTag msgTag;
                boolean isProcess = false;
                if (sMessageListener != null) {
                    isProcess = sMessageListener instanceof RongIMClient.OnReceiveMessageWrapperListener ? ((RongIMClient.OnReceiveMessageWrapperListener)sMessageListener).onReceived(message, left, hasPackage, offline) : sMessageListener.onReceived(message, left);
                }
                if ((msgTag = message.getContent().getClass().getAnnotation(MessageTag.class)) != null && (msgTag.flag() == 3 || msgTag.flag() == 1)) {
                    boolean msgRemove;
                    if (messageInterceptor != null && (msgRemove = messageInterceptor.intercept(message))) {
                        return true;
                    }
                    RongContext.getInstance().getEventBus().post(new Event.OnReceiveMessageEvent(message, left, hasPackage, offline));
                    if (message.getContent() != null && message.getContent().getUserInfo() != null) {
                        RongUserInfoManager.getInstance().setUserInfo(message.getContent().getUserInfo());
                    }
                    if (isProcess || message.getSenderUserId().equals(RongIM.getInstance().getCurrentUserId())) {
                        return true;
                    }
                    MessageConfig messageConfig = message.getMessageConfig();
                    boolean isDisableNotification = false;
                    if (messageConfig != null) {
                        isDisableNotification = messageConfig.isDisableNotification();
                    }
                    if (left == 0 && !hasPackage && !isDisableNotification) {
                        MessageNotificationManager.getInstance().notifyIfNeed(RongIM.this.mApplicationContext, message, left);
                        if (!notificationQuiteHoursConfigured) {
                            RLog.d((String)TAG, (String)"OnReceiveMessageListener not get notificationQuietHours get again");
                            SingletonHolder.sRongIM.getNotificationQuietHours(null);
                        }
                    }
                } else if (!isProcess) {
                    if (message.getMessageId() > 0) {
                        RongContext.getInstance().getEventBus().post(new Event.OnReceiveMessageEvent(message, left, hasPackage, offline));
                    } else {
                        RongContext.getInstance().getEventBus().post(new Event.MessageLeftEvent(left));
                    }
                }
                RongExtensionManager.getInstance().onReceivedMessage(message);
                return false;
            }
        });
        boolean readRec = false;
        try {
            readRec = this.mApplicationContext.getResources().getBoolean(R.bool.rc_read_receipt);
        }
        catch (Resources.NotFoundException e) {
            RLog.e((String)TAG, (String)"rc_read_receipt not configure in rc_config.xml");
            e.printStackTrace();
        }
        if (readRec) {
            RongIMClient.setReadReceiptListener((RongIMClient.ReadReceiptListener)new RongIMClient.ReadReceiptListener(){

                public void onReadReceiptReceived(Message message) {
                    RongContext.getInstance().getEventBus().post(new Event.ReadReceiptEvent(message));
                }

                public void onMessageReceiptRequest(Conversation.ConversationType type, String targetId, String messageUId) {
                    RongContext.getInstance().getEventBus().post(new Event.ReadReceiptRequestEvent(type, targetId, messageUId));
                }

                public void onMessageReceiptResponse(Conversation.ConversationType type, String targetId, String messageUId, HashMap<String, Long> respondUserIdList) {
                    RongContext.getInstance().getEventBus().post(new Event.ReadReceiptResponseEvent(type, targetId, messageUId, respondUserIdList));
                }
            });
        }
        boolean syncReadStatus = false;
        try {
            syncReadStatus = this.mApplicationContext.getResources().getBoolean(R.bool.rc_enable_sync_read_status);
        }
        catch (Resources.NotFoundException e) {
            RLog.e((String)TAG, (String)"rc_enable_sync_read_status not configure in rc_config.xml");
            e.printStackTrace();
        }
        if (syncReadStatus) {
            RongIMClient.getInstance().setSyncConversationReadStatusListener(new RongIMClient.SyncConversationReadStatusListener(){

                public void onSyncConversationReadStatus(Conversation.ConversationType type, String targetId) {
                    RongContext.getInstance().getEventBus().post(new Event.SyncReadStatusEvent(type, targetId));
                }
            });
        }
        RongIMClient.setOnRecallMessageListener((RongIMClient.OnRecallMessageListener)new RongIMClient.OnRecallMessageListener(){

            public boolean onMessageRecalled(Message message, RecallNotificationMessage recallNotificationMessage) {
                RongContext.getInstance().getEventBus().post(new Event.RemoteMessageRecallEvent(message.getMessageId(), message.getConversationType(), recallNotificationMessage, true, message.getTargetId()));
                if (recallNotificationMessage == null) {
                    RLog.i((String)TAG, (String)"Delete the recall message, recallNotificationMessage is null");
                    return true;
                }
                MessageTag msgTag = recallNotificationMessage.getClass().getAnnotation(MessageTag.class);
                if (msgTag != null && (msgTag.flag() == 3 || msgTag.flag() == 1) && notificationQuiteHoursConfigured) {
                    MessageNotificationManager.getInstance().notifyIfNeed(RongIM.this.mApplicationContext, message, 0);
                }
                return true;
            }
        });
        RongIMClient.getInstance().setOnReceiveDestructionMessageListener(new RongIMClient.OnReceiveDestructionMessageListener(){

            public void onReceive(Message message) {
                EventBus.getDefault().post(new Event.MessageDeleteEvent(message.getMessageId()));
            }
        });
        RongIMClient.setConnectionStatusListener((RongIMClient.ConnectionStatusListener)mConnectionStatusListener);
        RongIMClient.getInstance().setConversationStatusListener(new RongIMClient.ConversationStatusListener(){

            public void onStatusChanged(ConversationStatus[] conversationStatus) {
                if (conversationStatus.length == 0) {
                    RLog.i((String)TAG, (String)"length is 0");
                    return;
                }
                if (conversationStatus.length == 1) {
                    String conversationId = conversationStatus[0].getTargetId();
                    Conversation.ConversationType conversationType = conversationStatus[0].getConversationType();
                    RongContext.getInstance().setConversationNotifyStatusToCache(ConversationKey.obtain(conversationId, conversationType), conversationStatus[0].getNotifyStatus());
                }
                EventBus.getDefault().post(conversationStatus);
            }
        });
    }

    public static void setOnReceiveMessageListener(RongIMClient.OnReceiveMessageListener listener) {
        RLog.i((String)TAG, (String)"RongIM setOnReceiveMessageListener");
        sMessageListener = listener;
    }

    public static void setConnectionStatusListener(RongIMClient.ConnectionStatusListener listener) {
        sConnectionStatusListener = listener;
    }

    @Deprecated
    public void disconnect(boolean isReceivePush) {
        RongIMClient.getInstance().disconnect(isReceivePush);
    }

    public void logout() {
        if (this.mApplicationContext == null) {
            return;
        }
        String current = SystemUtils.getCurrentProcessName((Context)this.mApplicationContext);
        String mainProcessName = this.mApplicationContext.getPackageName();
        if (!mainProcessName.equals(current)) {
            RLog.w((String)TAG, (String)("only can logout in main progress! current process is:" + current));
            return;
        }
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"logout. RongIM SDK not init, please do after init.");
        } else {
            RongContext.getInstance().clearConversationNotifyStatusCache();
        }
        RongIMClient.getInstance().logout();
        RongUserInfoManager.getInstance().uninit();
        UnReadMessageManager.getInstance().clearObserver();
        RongExtensionManager.getInstance().disconnect();
        notificationQuiteHoursConfigured = false;
        MessageNotificationManager.getInstance().clearNotificationQuietHours();
    }

    public void setGroupMembersProvider(IGroupMembersProvider groupMembersProvider) {
        RongMentionManager.getInstance().setGroupMembersProvider(groupMembersProvider);
    }

    public static void setLocationProvider(LocationProvider locationProvider) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setLocationProvider(locationProvider);
        }
    }

    public void disconnect() {
        RongIMClient.getInstance().disconnect();
        RongExtensionManager.getInstance().disconnect();
    }

    public static RongIM getInstance() {
        return SingletonHolder.sRongIM;
    }

    @Deprecated
    public void startConversationList(Context context) {
        if (context == null) {
            RLog.e((String)TAG, (String)"startConversationList. context can not be empty!!!");
            return;
        }
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"startConversationList. RongIM SDK not init, please do after init.");
            return;
        }
        String packageName = context.getApplicationInfo().packageName;
        Uri uri = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("conversationlist").build();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.setPackage(packageName);
        context.startActivity(intent);
    }

    public void startConversationList(Context context, Map<String, Boolean> supportedConversation) {
        if (context == null) {
            RLog.e((String)TAG, (String)"startConversationList. context can not be empty!!!");
            return;
        }
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"startConversationList. RongIM SDK not init, please do after init.");
            return;
        }
        String packageName = context.getApplicationInfo().packageName;
        Uri.Builder builder = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("conversationlist");
        if (supportedConversation != null && supportedConversation.size() > 0) {
            Set<String> keys = supportedConversation.keySet();
            for (String key : keys) {
                builder.appendQueryParameter(key, supportedConversation.get(key) != false ? "true" : "false");
            }
        }
        Intent intent = new Intent("android.intent.action.VIEW", builder.build());
        intent.setPackage(packageName);
        context.startActivity(intent);
    }

    public void startSubConversationList(Context context, Conversation.ConversationType conversationType) {
        if (context == null) {
            RLog.e((String)TAG, (String)"startSubConversationList. context can not be empty!!!");
            return;
        }
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"startSubConversationList. RongIM SDK not init, please do after init.");
            return;
        }
        String packageName = context.getApplicationInfo().packageName;
        Uri uri = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("subconversationlist").appendQueryParameter("type", conversationType.getName()).build();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.setPackage(packageName);
        context.startActivity(intent);
    }

    public static void setConversationBehaviorListener(ConversationBehaviorListener listener) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setConversationBehaviorListener(listener);
        }
    }

    public static void setConversationClickListener(ConversationClickListener listener) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setConversationClickListener(listener);
        }
    }

    public static void setConversationListBehaviorListener(ConversationListBehaviorListener listener) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setConversationListBehaviorListener(listener);
        }
    }

    public static void setPublicServiceBehaviorListener(PublicServiceBehaviorListener listener) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setPublicServiceBehaviorListener(listener);
        }
    }

    public void startPrivateChat(Context context, String targetUserId, String title) {
        if (context == null || TextUtils.isEmpty((CharSequence)targetUserId)) {
            RLog.e((String)TAG, (String)"startPrivateChat. context or targetUserId can not be empty!!!");
            return;
        }
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"startPrivateChat. RongIM SDK not init, please do after init.");
            return;
        }
        String packageName = context.getApplicationInfo().packageName;
        Uri uri = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("conversation").appendPath(Conversation.ConversationType.PRIVATE.getName().toLowerCase(Locale.US)).appendQueryParameter("targetId", targetUserId).appendQueryParameter("title", title).build();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.setPackage(packageName);
        context.startActivity(intent);
    }

    public void startEncryptedSession(Context context, String targetId, String title) {
        RongIMClient.getInstance().startEncryptedSession(targetId);
    }

    public void quitEncryptedSession(String targetId) {
        RongIMClient.getInstance().quitEncryptedSession(targetId);
    }

    public void clearEncryptedConversations() {
        RongIMClient.getInstance().clearEncryptedConversations();
    }

    public int getEncryptedSessionStatus(Context context, String targetId) {
        return RongIMClient.getInstance().getEncryptedSessionStatus(targetId);
    }

    public List<RCEncryptedSession> getAllEncryptedConversations() {
        return RongIMClient.getInstance().getAllEncryptedConversations();
    }

    public void startConversation(Context context, Conversation.ConversationType conversationType, String targetId, String title) {
        if (context == null || TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e((String)TAG, (String)"startConversation. context, targetId or conversationType can not be empty!!!");
            return;
        }
        String packageName = context.getApplicationInfo().packageName;
        Uri uri = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("conversation").appendPath(conversationType.getName().toLowerCase(Locale.US)).appendQueryParameter("targetId", targetId).appendQueryParameter("title", title).build();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        if (!(context instanceof Activity)) {
            intent.setFlags(0x10000000);
        }
        intent.setPackage(packageName);
        context.startActivity(intent);
    }

    public void startConversation(Context context, Conversation.ConversationType conversationType, String targetId, String title, Bundle bundle) {
        if (context == null || TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e((String)TAG, (String)"startConversation. context, targetId or conversationType can not be empty!!!");
            return;
        }
        String packageName = context.getApplicationInfo().packageName;
        Uri uri = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("conversation").appendPath(conversationType.getName().toLowerCase(Locale.US)).appendQueryParameter("targetId", targetId).appendQueryParameter("title", title).build();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        if (!(context instanceof Activity)) {
            intent.setFlags(0x10000000);
        }
        intent.setPackage(packageName);
        context.startActivity(intent);
    }

    public void startConversation(Context context, Conversation.ConversationType conversationType, String targetId, String title, long fixedMsgSentTime) {
        if (context == null || TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e((String)TAG, (String)"startConversation. context, targetId or conversationType can not be empty!!!");
            return;
        }
        String packageName = context.getApplicationInfo().packageName;
        Uri uri = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("conversation").appendPath(conversationType.getName().toLowerCase(Locale.US)).appendQueryParameter("targetId", targetId).appendQueryParameter("title", title).build();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.putExtra("indexMessageTime", fixedMsgSentTime);
        intent.setPackage(packageName);
        if (!(context instanceof Activity)) {
            intent.setFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    public void createDiscussionChat(final Context context, final List<String> targetUserIds, final String title) {
        if (context == null || targetUserIds == null || targetUserIds.size() == 0) {
            RLog.e((String)TAG, (String)"createDiscussionChat. context, targetUserIds or targetUserIds.size can not be empty!!!");
            return;
        }
        RongIMClient.getInstance().createDiscussion(title, targetUserIds, new RongIMClient.CreateDiscussionCallback(){

            public void onSuccess(String targetId) {
                String packageName = context.getApplicationInfo().packageName;
                Uri uri = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("conversation").appendPath(Conversation.ConversationType.DISCUSSION.getName().toLowerCase(Locale.US)).appendQueryParameter("targetIds", TextUtils.join((CharSequence)",", (Iterable)targetUserIds)).appendQueryParameter("delimiter", ",").appendQueryParameter("targetId", targetId).appendQueryParameter("title", title).build();
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                intent.setPackage(packageName);
                context.startActivity(intent);
            }

            public void onError(RongIMClient.ErrorCode e) {
                RLog.d((String)TAG, (String)("createDiscussionChat createDiscussion not success." + e));
            }
        });
    }

    public void createDiscussionChat(final Context context, final List<String> targetUserIds, final String title, final RongIMClient.CreateDiscussionCallback callback) {
        if (context == null || targetUserIds == null || targetUserIds.size() == 0) {
            RLog.e((String)TAG, (String)"createDiscussionChat. context, targetUserIds or targetUserIds.size can not be empty!!!");
            return;
        }
        RongIMClient.getInstance().createDiscussion(title, targetUserIds, new RongIMClient.CreateDiscussionCallback(){

            public void onSuccess(String targetId) {
                String packageName = context.getApplicationInfo().packageName;
                Uri uri = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("conversation").appendPath(Conversation.ConversationType.DISCUSSION.getName().toLowerCase(Locale.US)).appendQueryParameter("targetIds", TextUtils.join((CharSequence)",", (Iterable)targetUserIds)).appendQueryParameter("delimiter", ",").appendQueryParameter("targetId", targetId).appendQueryParameter("title", title).build();
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                intent.setPackage(packageName);
                context.startActivity(intent);
                if (callback != null) {
                    callback.onSuccess((Object)targetId);
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                RLog.d((String)TAG, (String)("createDiscussionChat createDiscussion not success." + e));
                if (callback != null) {
                    callback.onError(e);
                }
            }
        });
    }

    public void startDiscussionChat(Context context, String targetDiscussionId, String title) {
        if (context == null || TextUtils.isEmpty((CharSequence)targetDiscussionId)) {
            RLog.e((String)TAG, (String)"startDiscussionChat. context or targetDiscussionId can not be empty!!!");
            return;
        }
        String packageName = context.getApplicationInfo().packageName;
        Uri uri = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("conversation").appendPath(Conversation.ConversationType.DISCUSSION.getName().toLowerCase(Locale.US)).appendQueryParameter("targetId", targetDiscussionId).appendQueryParameter("title", title).build();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.setPackage(packageName);
        context.startActivity(intent);
    }

    public void startGroupChat(Context context, String targetGroupId, String title) {
        if (context == null || TextUtils.isEmpty((CharSequence)targetGroupId)) {
            RLog.e((String)TAG, (String)"startGroupChat. context or targetGroupId can not be empty!!!");
            return;
        }
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"startGroupChat. RongIM SDK not init, please do after init.");
            return;
        }
        String packageName = context.getApplicationInfo().packageName;
        Uri uri = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("conversation").appendPath(Conversation.ConversationType.GROUP.getName().toLowerCase(Locale.US)).appendQueryParameter("targetId", targetGroupId).appendQueryParameter("title", title).build();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.setPackage(packageName);
        context.startActivity(intent);
    }

    public void startChatRoomChat(Context context, String chatRoomId, boolean createIfNotExist) {
        if (context == null || TextUtils.isEmpty((CharSequence)chatRoomId)) {
            RLog.e((String)TAG, (String)"startChatRoomChat. context or chatRoomId can not be empty!!!");
            return;
        }
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"startChatRoomChat. RongIM SDK not init, please do after init.");
            return;
        }
        String packageName = context.getApplicationInfo().packageName;
        Uri uri = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("conversation").appendPath(Conversation.ConversationType.CHATROOM.getName().toLowerCase(Locale.US)).appendQueryParameter("targetId", chatRoomId).build();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.setPackage(packageName);
        intent.putExtra("createIfNotExist", createIfNotExist);
        context.startActivity(intent);
    }

    public void startCustomerServiceChat(Context context, String customerServiceId, String title, CSCustomServiceInfo customServiceInfo) {
        if (context == null || TextUtils.isEmpty((CharSequence)customerServiceId)) {
            RLog.e((String)TAG, (String)"startCustomerServiceChat. context or customerServiceId can not be empty!!!");
            return;
        }
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"startCustomerServiceChat. RongIM SDK not init, please do after init.");
            return;
        }
        String packageName = context.getApplicationInfo().packageName;
        Uri uri = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("conversation").appendPath(Conversation.ConversationType.CUSTOMER_SERVICE.getName().toLowerCase(Locale.US)).appendQueryParameter("targetId", customerServiceId).appendQueryParameter("title", title).build();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.setPackage(packageName);
        intent.putExtra("customServiceInfo", (Parcelable)customServiceInfo);
        context.startActivity(intent);
    }

    public static void setUserInfoProvider(UserInfoProvider userInfoProvider, boolean isCacheUserInfo) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setGetUserInfoProvider(userInfoProvider, isCacheUserInfo);
        }
    }

    public static void setPublicServiceProfileProvider(PublicServiceProfileProvider publicServiceProfileProvider) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setPublicServiceProfileProvider(publicServiceProfileProvider);
        }
    }

    public static void setGroupUserInfoProvider(GroupUserInfoProvider userInfoProvider, boolean isCacheUserInfo) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setGroupUserInfoProvider(userInfoProvider, isCacheUserInfo);
        }
    }

    public static void setGroupInfoProvider(GroupInfoProvider groupInfoProvider, boolean isCacheGroupInfo) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setGetGroupInfoProvider(groupInfoProvider, isCacheGroupInfo);
        }
    }

    public void refreshDiscussionCache(Discussion discussion) {
        if (discussion == null) {
            return;
        }
        RongUserInfoManager.getInstance().setDiscussionInfo(discussion);
    }

    public void refreshUserInfoCache(UserInfo userInfo) {
        if (userInfo == null) {
            return;
        }
        RongUserInfoManager.getInstance().setUserInfo(userInfo);
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"refreshUserInfoCache. RongIM SDK not init, please do after init.");
            return;
        }
        UserInfo currentUserInfo = RongContext.getInstance().getCurrentUserInfo();
        if (currentUserInfo != null && currentUserInfo.getUserId().equals(userInfo.getUserId())) {
            RongContext.getInstance().setCurrentUserInfo(userInfo);
        }
    }

    public void refreshGroupUserInfoCache(GroupUserInfo groupUserInfo) {
        if (groupUserInfo == null) {
            return;
        }
        RongUserInfoManager.getInstance().setGroupUserInfo(groupUserInfo);
    }

    public void refreshGroupInfoCache(Group group) {
        if (group == null) {
            return;
        }
        RongUserInfoManager.getInstance().setGroupInfo(group);
    }

    public void refreshPublicServiceProfile(PublicServiceProfile publicServiceProfile) {
        if (publicServiceProfile == null) {
            return;
        }
        RongUserInfoManager.getInstance().setPublicServiceProfile(publicServiceProfile);
    }

    public void setSendMessageListener(OnSendMessageListener listener) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setOnSendMessageListener(listener);
        }
    }

    public void setMessageAttachedUserInfo(boolean state) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setUserInfoAttachedState(state);
        }
    }

    @Deprecated
    public void setOnReceiveUnreadCountChangedListener(final OnReceiveUnreadCountChangedListener listener, Conversation.ConversationType ... conversationTypes) {
        if (listener == null || conversationTypes == null || conversationTypes.length == 0) {
            RLog.w((String)TAG, (String)"setOnReceiveUnreadCountChangedListener Illegal argument");
            return;
        }
        UnReadMessageManager.getInstance().addObserver(conversationTypes, new IUnReadMessageObserver(){

            @Override
            public void onCountChanged(int count) {
                listener.onMessageIncreased(count);
            }
        });
    }

    public void addUnReadMessageCountChangedObserver(IUnReadMessageObserver observer, Conversation.ConversationType ... conversationTypes) {
        if (observer == null || conversationTypes == null || conversationTypes.length == 0) {
            RLog.w((String)TAG, (String)"addOnReceiveUnreadCountChangedListener Illegal argument");
            throw new IllegalArgumentException("observer must not be null and must include at least one conversationType");
        }
        UnReadMessageManager.getInstance().addObserver(conversationTypes, observer);
    }

    public void removeUnReadMessageCountChangedObserver(IUnReadMessageObserver observer) {
        if (observer == null) {
            RLog.w((String)TAG, (String)"removeOnReceiveUnreadCountChangedListener Illegal argument");
            return;
        }
        UnReadMessageManager.getInstance().removeObserver(observer);
    }

    public void startPublicServiceProfile(Context context, Conversation.ConversationType conversationType, String targetId) {
        if (context == null || conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            RLog.e((String)TAG, (String)"startPublicServiceProfile. context, conversationType or targetId can not be empty!!!");
            return;
        }
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"startPublicServiceProfile. RongIM SDK not init, please do after init.");
            return;
        }
        String packageName = context.getApplicationInfo().packageName;
        Uri uri = Uri.parse((String)("rong://" + packageName)).buildUpon().appendPath("publicServiceProfile").appendPath(conversationType.getName().toLowerCase(Locale.US)).appendQueryParameter("targetId", targetId).build();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.setFlags(0x10000000);
        intent.setPackage(packageName);
        context.startActivity(intent);
    }

    public void registerConversationTemplate(IContainerItemProvider.ConversationProvider provider) {
        if (RongContext.getInstance() != null) {
            if (provider == null) {
                throw new IllegalArgumentException();
            }
            RongContext.getInstance().registerConversationTemplate(provider);
        }
    }

    public void enableNewComingMessageIcon(boolean state) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().showNewMessageIcon(state);
        }
    }

    public void enableUnreadMessageIcon(boolean state) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().showUnreadMessageIcon(state);
        }
    }

    public void setMaxVoiceDurationg(int sec) {
        AudioRecordManager.getInstance().setMaxVoiceDuration(sec);
    }

    public RongIMClient.ConnectionStatusListener.ConnectionStatus getCurrentConnectionStatus() {
        return RongIMClient.getInstance().getCurrentConnectionStatus();
    }

    public void getConversationList(RongIMClient.ResultCallback<List<Conversation>> callback) {
        RongIMClient.getInstance().getConversationList(callback);
    }

    public void getConversationList(RongIMClient.ResultCallback<List<Conversation>> callback, Conversation.ConversationType ... types) {
        RongIMClient.getInstance().getConversationList(callback, types);
    }

    public void getConversation(Conversation.ConversationType type, String targetId, RongIMClient.ResultCallback<Conversation> callback) {
        RongIMClient.getInstance().getConversation(type, targetId, callback);
    }

    public void removeConversation(final Conversation.ConversationType type, final String targetId, final RongIMClient.ResultCallback<Boolean> callback) {
        RongIMClient.getInstance().removeConversation(type, targetId, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

            public void onSuccess(Boolean bool2) {
                if (callback != null) {
                    callback.onSuccess((Object)bool2);
                }
                if (bool2.booleanValue()) {
                    RongContext.getInstance().getEventBus().post(new Event.ConversationRemoveEvent(type, targetId));
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError(e);
                }
            }
        });
    }

    public void setConversationToTop(final Conversation.ConversationType type, final String id2, final boolean isTop, final RongIMClient.ResultCallback<Boolean> callback) {
        RongIMClient.getInstance().setConversationToTop(type, id2, isTop, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

            public void onSuccess(Boolean bool2) {
                if (callback != null) {
                    callback.onSuccess((Object)bool2);
                }
                if (bool2.booleanValue()) {
                    RongContext.getInstance().getEventBus().post(new Event.ConversationTopEvent(type, id2, isTop));
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError(e);
                }
            }
        });
    }

    public void setConversationToTop(final Conversation.ConversationType type, final String id2, final boolean isTop, final boolean needCreate, final RongIMClient.ResultCallback<Boolean> callback) {
        RongIMClient.getInstance().setConversationToTop(type, id2, isTop, needCreate, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

            public void onSuccess(Boolean bool2) {
                if (callback != null) {
                    callback.onSuccess((Object)bool2);
                }
                if (bool2.booleanValue() && (!isTop || needCreate)) {
                    RongContext.getInstance().getEventBus().post(new Event.ConversationTopEvent(type, id2, isTop));
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError(e);
                }
            }
        });
    }

    public void getTotalUnreadCount(final RongIMClient.ResultCallback<Integer> callback) {
        RongIMClient.getInstance().getTotalUnreadCount((RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Integer>(){

            public void onSuccess(Integer integer2) {
                if (callback != null) {
                    callback.onSuccess((Object)integer2);
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError(e);
                }
            }
        });
    }

    public void getUnreadCount(Conversation.ConversationType conversationType, String targetId, RongIMClient.ResultCallback<Integer> callback) {
        RongIMClient.getInstance().getUnreadCount(conversationType, targetId, callback);
    }

    public void getUnreadCount(RongIMClient.ResultCallback<Integer> callback, Conversation.ConversationType ... conversationTypes) {
        RongIMClient.getInstance().getUnreadCount(callback, conversationTypes);
    }

    public void getUnreadCount(Conversation.ConversationType[] conversationTypes, boolean containBlocked, RongIMClient.ResultCallback<Integer> callback) {
        RongIMClient.getInstance().getUnreadCount(conversationTypes, containBlocked, callback);
    }

    public void getUnreadCount(Conversation.ConversationType[] conversationTypes, RongIMClient.ResultCallback<Integer> callback) {
        RongIMClient.getInstance().getUnreadCount(conversationTypes, callback);
    }

    public void getLatestMessages(Conversation.ConversationType conversationType, String targetId, int count, RongIMClient.ResultCallback<List<Message>> callback) {
        RongIMClient.getInstance().getLatestMessages(conversationType, targetId, count, callback);
    }

    @Deprecated
    public List<Message> getHistoryMessages(Conversation.ConversationType conversationType, String targetId, int oldestMessageId, int count) {
        return RongIMClient.getInstance().getHistoryMessages(conversationType, targetId, oldestMessageId, count);
    }

    @Deprecated
    public List<Message> getHistoryMessages(Conversation.ConversationType conversationType, String targetId, String objectName, int oldestMessageId, int count) {
        return RongIMClient.getInstance().getHistoryMessages(conversationType, targetId, objectName, oldestMessageId, count);
    }

    public void getHistoryMessages(Conversation.ConversationType conversationType, String targetId, String objectName, int oldestMessageId, int count, RongIMClient.ResultCallback<List<Message>> callback) {
        RongIMClient.getInstance().getHistoryMessages(conversationType, targetId, objectName, oldestMessageId, count, callback);
    }

    public void getHistoryMessages(Conversation.ConversationType conversationType, String targetId, int oldestMessageId, int count, RongIMClient.ResultCallback<List<Message>> callback) {
        RongIMClient.getInstance().getHistoryMessages(conversationType, targetId, oldestMessageId, count, callback);
    }

    public void getRemoteHistoryMessages(Conversation.ConversationType conversationType, String targetId, long dataTime, int count, RongIMClient.ResultCallback<List<Message>> callback) {
        RongIMClient.getInstance().getRemoteHistoryMessages(conversationType, targetId, dataTime, count, callback);
    }

    public void getRemoteHistoryMessages(Conversation.ConversationType conversationType, String targetId, RemoteHistoryMsgOption remoteHistoryMsgOption, RongIMClient.ResultCallback<List<Message>> callback) {
        RongIMClient.getInstance().getRemoteHistoryMessages(conversationType, targetId, remoteHistoryMsgOption, callback);
    }

    public void deleteMessages(final int[] messageIds, final RongIMClient.ResultCallback<Boolean> callback) {
        RongIMClient.getInstance().deleteMessages(messageIds, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

            public void onSuccess(Boolean bool2) {
                if (bool2.booleanValue()) {
                    RongContext.getInstance().getEventBus().post(new Event.MessageDeleteEvent(messageIds));
                }
                if (callback != null) {
                    callback.onSuccess((Object)bool2);
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError(e);
                }
            }
        });
    }

    public void deleteMessages(final Conversation.ConversationType conversationType, final String targetId, final RongIMClient.ResultCallback<Boolean> callback) {
        RongIMClient.getInstance().deleteMessages(conversationType, targetId, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

            public void onSuccess(Boolean bool2) {
                if (bool2.booleanValue()) {
                    RongContext.getInstance().getEventBus().post(new Event.MessagesClearEvent(conversationType, targetId));
                }
                if (callback != null) {
                    callback.onSuccess((Object)bool2);
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError(e);
                }
            }
        });
    }

    public void deleteRemoteMessages(Conversation.ConversationType conversationType, String targetId, final Message[] messages, final RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().deleteRemoteMessages(conversationType, targetId, messages, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                int[] messageIds = new int[messages.length];
                for (int i = 0; i < messages.length; ++i) {
                    messageIds[i] = messages[i].getMessageId();
                }
                RongContext.getInstance().getEventBus().post(new Event.MessageDeleteEvent(messageIds));
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void clearMessages(final Conversation.ConversationType conversationType, final String targetId, final RongIMClient.ResultCallback<Boolean> callback) {
        RongIMClient.getInstance().clearMessages(conversationType, targetId, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

            public void onSuccess(Boolean bool2) {
                if (bool2.booleanValue()) {
                    RongContext.getInstance().getEventBus().post(new Event.MessagesClearEvent(conversationType, targetId));
                }
                if (callback != null) {
                    callback.onSuccess((Object)bool2);
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError(e);
                }
            }
        });
    }

    public void clearMessagesUnreadStatus(final Conversation.ConversationType conversationType, final String targetId, final RongIMClient.ResultCallback<Boolean> callback) {
        RongIMClient.getInstance().clearMessagesUnreadStatus(conversationType, targetId, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

            public void onSuccess(Boolean bool2) {
                if (callback != null) {
                    callback.onSuccess((Object)bool2);
                }
                RongContext.getInstance().getEventBus().post(new Event.ConversationUnreadEvent(conversationType, targetId));
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError(e);
                }
            }
        });
    }

    public void setMessageExtra(int messageId, String value, RongIMClient.ResultCallback<Boolean> callback) {
        RongIMClient.getInstance().setMessageExtra(messageId, value, callback);
    }

    public void setMessageReceivedStatus(int messageId, Message.ReceivedStatus receivedStatus, RongIMClient.ResultCallback<Boolean> callback) {
        RongIMClient.getInstance().setMessageReceivedStatus(messageId, receivedStatus, callback);
    }

    public void setMessageSentStatus(final Message message, final RongIMClient.ResultCallback<Boolean> callback) {
        if (message == null || message.getMessageId() <= 0) {
            RLog.e((String)TAG, (String)"setMessageSentStatus message is null or messageId <= 0");
            return;
        }
        RongIMClient.getInstance().setMessageSentStatus(message, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

            public void onSuccess(Boolean bool2) {
                if (callback != null) {
                    callback.onSuccess((Object)bool2);
                }
                if (bool2.booleanValue()) {
                    RongContext.getInstance().getEventBus().post(new Event.MessageSentStatusUpdateEvent(message, message.getSentStatus()));
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError(e);
                }
            }
        });
    }

    public void getTextMessageDraft(Conversation.ConversationType conversationType, String targetId, RongIMClient.ResultCallback<String> callback) {
        RongIMClient.getInstance().getTextMessageDraft(conversationType, targetId, callback);
    }

    public void saveTextMessageDraft(Conversation.ConversationType conversationType, String targetId, String content, RongIMClient.ResultCallback<Boolean> callback) {
        RongIMClient.getInstance().saveTextMessageDraft(conversationType, targetId, content, callback);
    }

    public void clearTextMessageDraft(Conversation.ConversationType conversationType, String targetId, RongIMClient.ResultCallback<Boolean> callback) {
        RongIMClient.getInstance().clearTextMessageDraft(conversationType, targetId, callback);
    }

    public void getDiscussion(String discussionId, RongIMClient.ResultCallback<Discussion> callback) {
        RongIMClient.getInstance().getDiscussion(discussionId, callback);
    }

    public void setDiscussionName(final String discussionId, final String name, final RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().setDiscussionName(discussionId, name, new RongIMClient.OperationCallback(){

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }

            public void onSuccess() {
                if (callback != null) {
                    RongUserInfoManager.getInstance().setDiscussionInfo(new Discussion(discussionId, name));
                    callback.onSuccess();
                }
            }
        });
    }

    public void createDiscussion(final String name, final List<String> userIdList, final RongIMClient.CreateDiscussionCallback callback) {
        RongIMClient.getInstance().createDiscussion(name, userIdList, new RongIMClient.CreateDiscussionCallback(){

            public void onSuccess(String discussionId) {
                RongContext.getInstance().getEventBus().post(new Event.CreateDiscussionEvent(discussionId, name, userIdList));
                if (callback != null) {
                    callback.onSuccess((Object)discussionId);
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void addMemberToDiscussion(final String discussionId, final List<String> userIdList, final RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().addMemberToDiscussion(discussionId, userIdList, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                RongContext.getInstance().getEventBus().post(new Event.AddMemberToDiscussionEvent(discussionId, userIdList));
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void removeMemberFromDiscussion(final String discussionId, final String userId, final RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().removeMemberFromDiscussion(discussionId, userId, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                RongContext.getInstance().getEventBus().post(new Event.RemoveMemberFromDiscussionEvent(discussionId, userId));
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void quitDiscussion(final String discussionId, final RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().quitDiscussion(discussionId, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                RongContext.getInstance().getEventBus().post(new Event.QuitDiscussionEvent(discussionId));
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void insertIncomingMessage(Conversation.ConversationType type, String targetId, String senderUserId, Message.ReceivedStatus receivedStatus, MessageContent content, RongIMClient.ResultCallback<Message> callback) {
        this.insertIncomingMessage(type, targetId, senderUserId, receivedStatus, content, System.currentTimeMillis(), callback);
    }

    public void insertIncomingMessage(Conversation.ConversationType type, String targetId, String senderUserId, Message.ReceivedStatus receivedStatus, MessageContent content, long sentTime, final RongIMClient.ResultCallback<Message> callback) {
        MessageTag tag = content.getClass().getAnnotation(MessageTag.class);
        if (tag != null && (tag.flag() & 1) == 1) {
            RongIMClient.getInstance().insertIncomingMessage(type, targetId, senderUserId, receivedStatus, content, sentTime, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Message>(){

                public void onSuccess(Message message) {
                    if (callback != null) {
                        callback.onSuccess((Object)message);
                    }
                    RongContext.getInstance().getEventBus().post(message);
                }

                public void onError(RongIMClient.ErrorCode e) {
                    if (callback != null) {
                        callback.onError(e);
                    }
                    if (RongContext.getInstance() == null) {
                        RLog.e((String)TAG, (String)"insertIncomingMessage. RongIM SDK not init, please do after init.");
                    } else {
                        RongContext.getInstance().getEventBus().post(e);
                    }
                }
            });
        } else {
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            RLog.e((String)TAG, (String)"insertMessage Message is missing MessageTag.ISPERSISTED");
        }
    }

    public void insertOutgoingMessage(Conversation.ConversationType type, String targetId, Message.SentStatus sentStatus, MessageContent content, RongIMClient.ResultCallback<Message> callback) {
        this.insertOutgoingMessage(type, targetId, sentStatus, content, System.currentTimeMillis(), callback);
    }

    public void insertOutgoingMessage(Conversation.ConversationType type, String targetId, Message.SentStatus sentStatus, MessageContent content, long sentTime, final RongIMClient.ResultCallback<Message> callback) {
        MessageTag tag = content.getClass().getAnnotation(MessageTag.class);
        if (tag != null && (tag.flag() & 1) == 1) {
            RongIMClient.getInstance().insertOutgoingMessage(type, targetId, sentStatus, content, sentTime, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Message>(){

                public void onSuccess(Message message) {
                    if (callback != null) {
                        callback.onSuccess((Object)message);
                    }
                    RongContext.getInstance().getEventBus().post(message);
                }

                public void onError(RongIMClient.ErrorCode e) {
                    if (callback != null) {
                        callback.onError(e);
                    }
                    if (RongContext.getInstance() == null) {
                        RLog.e((String)TAG, (String)"insertOutgoingMessage. RongIM SDK not init, please do after init.");
                    } else {
                        RongContext.getInstance().getEventBus().post(e);
                    }
                }
            });
        } else {
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            RLog.e((String)TAG, (String)"insertMessage Message is missing MessageTag.ISPERSISTED");
        }
    }

    public void sendMessage(Message message, String pushContent, String pushData, final IRongCallback.ISendMessageCallback callback) {
        Message filterMsg = this.filterSendMessage(message);
        if (filterMsg == null) {
            RLog.w((String)TAG, (String)"sendMessage: \u56e0\u5728 onSend \u4e2d\u6d88\u606f\u88ab\u8fc7\u6ee4\u4e3a null\uff0c\u53d6\u6d88\u53d1\u9001\u3002");
            return;
        }
        if (filterMsg != message) {
            message = filterMsg;
        }
        message.setContent(this.setMessageAttachedUserInfo(message.getContent()));
        RongIMClient.getInstance().sendMessage(message, pushContent, pushData, new IRongCallback.ISendMessageCallback(){

            public void onAttached(Message message) {
                MessageTag tag = message.getContent().getClass().getAnnotation(MessageTag.class);
                if (tag != null && (tag.flag() & 1) == 1) {
                    RongContext.getInstance().getEventBus().post(message);
                }
                if (callback != null) {
                    callback.onAttached(message);
                }
            }

            public void onSuccess(Message message) {
                RongIM.this.filterSentMessage(message, null);
                if (callback != null) {
                    callback.onSuccess(message);
                }
            }

            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RongIM.this.filterSentMessage(message, errorCode);
                if (callback != null) {
                    if (errorCode.equals((Object)RongIMClient.ErrorCode.RC_MSG_REPLACED_SENSITIVE_WORD)) {
                        callback.onSuccess(message);
                    } else {
                        callback.onError(message, errorCode);
                    }
                }
            }
        });
    }

    public void sendMessage(Message message, String pushContent, String pushData, SendMessageOption option, final IRongCallback.ISendMessageCallback callback) {
        Message filterMsg = this.filterSendMessage(message);
        if (filterMsg == null) {
            RLog.w((String)TAG, (String)"sendMessage: \u56e0\u5728 onSend \u4e2d\u6d88\u606f\u88ab\u8fc7\u6ee4\u4e3a null\uff0c\u53d6\u6d88\u53d1\u9001\u3002");
            return;
        }
        if (filterMsg != message) {
            message = filterMsg;
        }
        message.setContent(this.setMessageAttachedUserInfo(message.getContent()));
        RongIMClient.getInstance().sendMessage(message, pushContent, pushData, option, new IRongCallback.ISendMessageCallback(){

            public void onAttached(Message message) {
                MessageTag tag = message.getContent().getClass().getAnnotation(MessageTag.class);
                if (tag != null && (tag.flag() & 1) == 1) {
                    RongContext.getInstance().getEventBus().post(message);
                }
                if (callback != null) {
                    callback.onAttached(message);
                }
            }

            public void onSuccess(Message message) {
                RongIM.this.filterSentMessage(message, null);
                if (callback != null) {
                    callback.onSuccess(message);
                }
            }

            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RongIM.this.filterSentMessage(message, errorCode);
                if (callback != null) {
                    if (errorCode.equals((Object)RongIMClient.ErrorCode.RC_MSG_REPLACED_SENSITIVE_WORD)) {
                        callback.onSuccess(message);
                    } else {
                        callback.onError(message, errorCode);
                    }
                }
            }
        });
    }

    public void sendMessage(Conversation.ConversationType type, String targetId, MessageContent content, String pushContent, String pushData, IRongCallback.ISendMessageCallback callback) {
        Message message = Message.obtain((String)targetId, (Conversation.ConversationType)type, (MessageContent)content);
        this.sendMessage(message, pushContent, pushData, callback);
    }

    public void sendLocationMessage(Message message, String pushContent, String pushData, final IRongCallback.ISendMessageCallback sendMessageCallback) {
        Message filterMsg = this.filterSendMessage(message);
        if (filterMsg == null) {
            RLog.w((String)TAG, (String)"sendLocationMessage: \u56e0\u5728 onSend \u4e2d\u6d88\u606f\u88ab\u8fc7\u6ee4\u4e3a null\uff0c\u53d6\u6d88\u53d1\u9001\u3002");
            return;
        }
        if (filterMsg != message) {
            message = filterMsg;
        }
        message.setContent(this.setMessageAttachedUserInfo(message.getContent()));
        RongIMClient.getInstance().sendLocationMessage(message, pushContent, pushData, new IRongCallback.ISendMessageCallback(){

            public void onAttached(Message message) {
                MessageTag tag = message.getContent().getClass().getAnnotation(MessageTag.class);
                if (tag != null && (tag.flag() & 1) == 1) {
                    RongContext.getInstance().getEventBus().post(message);
                }
                if (sendMessageCallback != null) {
                    sendMessageCallback.onAttached(message);
                }
            }

            public void onSuccess(Message message) {
                RongIM.this.filterSentMessage(message, null);
                if (sendMessageCallback != null) {
                    sendMessageCallback.onSuccess(message);
                }
            }

            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RongIM.this.filterSentMessage(message, errorCode);
                if (sendMessageCallback != null) {
                    sendMessageCallback.onError(message, errorCode);
                }
            }
        });
    }

    public void sendImageMessage(Conversation.ConversationType type, String targetId, MessageContent content, String pushContent, String pushData, final RongIMClient.SendImageMessageCallback callback) {
        Message message = Message.obtain((String)targetId, (Conversation.ConversationType)type, (MessageContent)content);
        Message temp = this.filterSendMessage(message);
        if (temp == null) {
            return;
        }
        if (temp != message) {
            message = temp;
        }
        content = message.getContent();
        content = this.setMessageAttachedUserInfo(content);
        final RongIMClient.ResultCallback.Result result = new RongIMClient.ResultCallback.Result();
        result.t = new Event.OnReceiveMessageProgressEvent();
        RongIMClient.SendImageMessageCallback sendMessageCallback = new RongIMClient.SendImageMessageCallback(){

            public void onAttached(Message message) {
                RongContext.getInstance().getEventBus().post(message);
                if (callback != null) {
                    callback.onAttached(message);
                }
            }

            public void onProgress(Message message, int progress) {
                if (result.t == null) {
                    return;
                }
                ((Event.OnReceiveMessageProgressEvent)result.t).setMessage(message);
                ((Event.OnReceiveMessageProgressEvent)result.t).setProgress(progress);
                RongContext.getInstance().getEventBus().post(result.t);
                if (callback != null) {
                    callback.onProgress(message, progress);
                }
            }

            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RongIM.this.filterSentMessage(message, errorCode);
                if (callback != null) {
                    callback.onError(message, errorCode);
                }
            }

            public void onSuccess(Message message) {
                RongIM.this.filterSentMessage(message, null);
                if (callback != null) {
                    callback.onSuccess(message);
                }
            }
        };
        RongIMClient.getInstance().sendImageMessage(type, targetId, content, pushContent, pushData, sendMessageCallback);
    }

    public void sendImageMessage(Message message, String pushContent, String pushData, boolean filter, final RongIMClient.SendImageMessageCallback callback) {
        if (filter) {
            Message temp = this.filterSendMessage(message);
            if (temp == null) {
                return;
            }
            if (temp != message) {
                message = temp;
            }
        }
        this.setMessageAttachedUserInfo(message.getContent());
        final RongIMClient.ResultCallback.Result result = new RongIMClient.ResultCallback.Result();
        result.t = new Event.OnReceiveMessageProgressEvent();
        RongIMClient.SendImageMessageCallback sendMessageCallback = new RongIMClient.SendImageMessageCallback(){

            public void onAttached(Message message) {
                RongContext.getInstance().getEventBus().post(message);
                if (callback != null) {
                    callback.onAttached(message);
                }
            }

            public void onProgress(Message message, int progress) {
                if (result.t == null) {
                    return;
                }
                ((Event.OnReceiveMessageProgressEvent)result.t).setMessage(message);
                ((Event.OnReceiveMessageProgressEvent)result.t).setProgress(progress);
                RongContext.getInstance().getEventBus().post(result.t);
                if (callback != null) {
                    callback.onProgress(message, progress);
                }
            }

            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RongIM.this.filterSentMessage(message, errorCode);
                if (callback != null) {
                    callback.onError(message, errorCode);
                }
            }

            public void onSuccess(Message message) {
                RongIM.this.filterSentMessage(message, null);
                if (callback != null) {
                    callback.onSuccess(message);
                }
            }
        };
        RongIMClient.getInstance().sendImageMessage(message, pushContent, pushData, sendMessageCallback);
    }

    public void sendImageMessage(Message message, String pushContent, String pushData, RongIMClient.SendImageMessageCallback callback) {
        this.sendImageMessage(message, pushContent, pushData, true, callback);
    }

    public void sendImageMessage(Message message, String pushContent, String pushData, final RongIMClient.SendImageMessageWithUploadListenerCallback callback) {
        Message temp = this.filterSendMessage(message);
        if (temp == null) {
            return;
        }
        if (temp != message) {
            message = temp;
        }
        final RongIMClient.ResultCallback.Result result = new RongIMClient.ResultCallback.Result();
        result.t = new Event.OnReceiveMessageProgressEvent();
        RongIMClient.SendImageMessageWithUploadListenerCallback sendMessageCallback = new RongIMClient.SendImageMessageWithUploadListenerCallback(){

            public void onAttached(Message message, RongIMClient.UploadImageStatusListener listener) {
                RongContext.getInstance().getEventBus().post(message);
                if (callback != null) {
                    callback.onAttached(message, listener);
                }
            }

            public void onProgress(Message message, int progress) {
                if (result.t == null) {
                    return;
                }
                ((Event.OnReceiveMessageProgressEvent)result.t).setMessage(message);
                ((Event.OnReceiveMessageProgressEvent)result.t).setProgress(progress);
                RongContext.getInstance().getEventBus().post(result.t);
                if (callback != null) {
                    callback.onProgress(message, progress);
                }
            }

            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RongIM.this.filterSentMessage(message, errorCode);
                if (callback != null) {
                    callback.onError(message, errorCode);
                }
            }

            public void onSuccess(Message message) {
                RongIM.this.filterSentMessage(message, null);
                if (callback != null) {
                    callback.onSuccess(message);
                }
            }
        };
        RongIMClient.getInstance().sendImageMessage(message, pushContent, pushData, sendMessageCallback);
    }

    public void downloadMedia(Conversation.ConversationType conversationType, String targetId, RongIMClient.MediaType mediaType, String imageUrl, RongIMClient.DownloadMediaCallback callback) {
        RongIMClient.getInstance().downloadMedia(conversationType, targetId, mediaType, imageUrl, callback);
    }

    public void downloadMediaMessage(Message message, final IRongCallback.IDownloadMediaMessageCallback callback) {
        RongIMClient.getInstance().downloadMediaMessage(message, new IRongCallback.IDownloadMediaMessageCallback(){

            public void onSuccess(Message message) {
                Event.OnReceiveMessageProgressEvent result = new Event.OnReceiveMessageProgressEvent();
                message.getReceivedStatus().setDownload();
                result.setMessage(message);
                result.setProgress(100);
                EventBus.getDefault().post(result);
                EventBus.getDefault().post(new Event.FileMessageEvent(message, 100, 100, null));
                if (callback != null) {
                    callback.onSuccess(message);
                }
            }

            public void onProgress(Message message, int progress) {
                Event.OnReceiveMessageProgressEvent result = new Event.OnReceiveMessageProgressEvent();
                message.getReceivedStatus().setDownload();
                result.setMessage(message);
                result.setProgress(progress);
                EventBus.getDefault().post(result);
                EventBus.getDefault().post(new Event.FileMessageEvent(message, progress, 101, null));
                if (callback != null) {
                    callback.onProgress(message, progress);
                }
            }

            public void onError(Message message, RongIMClient.ErrorCode code) {
                Event.OnReceiveMessageProgressEvent result = new Event.OnReceiveMessageProgressEvent();
                result.setMessage(message);
                result.setProgress(-1);
                message.getReceivedStatus().isDownload();
                EventBus.getDefault().post(result);
                if (message.getContent() instanceof GIFMessage) {
                    EventBus.getDefault().post(new Event.FileMessageEvent(message, -1, 103, code));
                } else {
                    EventBus.getDefault().post(new Event.FileMessageEvent(message, 0, 103, code));
                }
                if (callback != null) {
                    callback.onError(message, code);
                }
            }

            public void onCanceled(Message message) {
                EventBus.getDefault().post(new Event.FileMessageEvent(message, 0, 102, null));
                if (callback != null) {
                    callback.onCanceled(message);
                }
            }
        });
    }

    public void downloadMediaFile(final String uid, String fileUrl, String fileName, String path, final IRongCallback.IDownloadMediaFileCallback callback) {
        RongIMClient.getInstance().downloadMediaFile(uid, fileUrl, fileName, path, new IRongCallback.IDownloadMediaFileCallback(){

            public void onFileNameChanged(String newFileName) {
                if (callback != null) {
                    callback.onFileNameChanged(newFileName);
                }
            }

            public void onSuccess() {
                EventBus.getDefault().post(new Event.MediaFileEvent(uid, 100, 100, null));
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onProgress(int progress) {
                EventBus.getDefault().post(new Event.MediaFileEvent(uid, progress, 101, null));
                if (callback != null) {
                    callback.onProgress(progress);
                }
            }

            public void onError(RongIMClient.ErrorCode code) {
                EventBus.getDefault().post(new Event.MediaFileEvent(uid, 0, 103, code));
                if (callback != null) {
                    callback.onError(code);
                }
            }

            public void onCanceled() {
                EventBus.getDefault().post(new Event.MediaFileEvent(uid, 0, 102, null));
                if (callback != null) {
                    callback.onCanceled();
                }
            }
        });
    }

    public void downloadMedia(String imageUrl, final RongIMClient.DownloadMediaCallback callback) {
        ImageLoader.getInstance().loadImage(imageUrl, null, null, new ImageLoadingListener(){

            @Override
            public void onLoadingStarted(String imageUri, View view) {
            }

            @Override
            public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                if (callback != null) {
                    callback.onError(RongIMClient.ErrorCode.RC_NET_UNAVAILABLE);
                }
            }

            @Override
            public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                if (callback != null) {
                    callback.onSuccess((Object)imageUri);
                }
            }

            @Override
            public void onLoadingCancelled(String imageUri, View view) {
            }
        }, new ImageLoadingProgressListener(){

            @Override
            public void onProgressUpdate(String imageUri, View view, int current, int total) {
                if (callback != null) {
                    callback.onProgress(current * 100 / total);
                }
            }
        });
    }

    public void getConversationNotificationStatus(final Conversation.ConversationType conversationType, final String targetId, final RongIMClient.ResultCallback<Conversation.ConversationNotificationStatus> callback) {
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"getConversationNotificationStatus. RongIM SDK not init, please do after init.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
            }
            return;
        }
        Conversation.ConversationNotificationStatus status = RongContext.getInstance().getConversationNotifyStatusFromCache(ConversationKey.obtain(targetId, conversationType));
        if (status != null) {
            callback.onSuccess((Object)status);
        } else {
            RongIMClient.getInstance().getConversationNotificationStatus(conversationType, targetId, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Conversation.ConversationNotificationStatus>(){

                public void onSuccess(Conversation.ConversationNotificationStatus status) {
                    RongContext.getInstance().setConversationNotifyStatusToCache(ConversationKey.obtain(targetId, conversationType), status);
                    if (callback != null) {
                        callback.onSuccess((Object)status);
                    }
                }

                public void onError(RongIMClient.ErrorCode e) {
                    if (callback != null) {
                        callback.onError(e);
                    }
                }
            });
        }
    }

    public void setConversationNotificationStatus(final Conversation.ConversationType conversationType, final String targetId, final Conversation.ConversationNotificationStatus notificationStatus, final RongIMClient.ResultCallback<Conversation.ConversationNotificationStatus> callback) {
        RongIMClient.getInstance().setConversationNotificationStatus(conversationType, targetId, notificationStatus, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Conversation.ConversationNotificationStatus>(){

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }

            public void onSuccess(Conversation.ConversationNotificationStatus status) {
                RongContext.getInstance().setConversationNotifyStatusToCache(ConversationKey.obtain(targetId, conversationType), status);
                RongContext.getInstance().getEventBus().post(new Event.ConversationNotificationEvent(targetId, conversationType, notificationStatus));
                if (callback != null) {
                    callback.onSuccess((Object)status);
                }
            }
        });
    }

    public void setDiscussionInviteStatus(final String discussionId, final RongIMClient.DiscussionInviteStatus status, final RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().setDiscussionInviteStatus(discussionId, status, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                RongContext.getInstance().getEventBus().post(new Event.DiscussionInviteStatusEvent(discussionId, status));
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public String getCurrentUserId() {
        return RongIMClient.getInstance().getCurrentUserId();
    }

    public long getDeltaTime() {
        return RongIMClient.getInstance().getDeltaTime();
    }

    public void joinChatRoom(final String chatroomId, final int defMessageCount, final RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().joinChatRoom(chatroomId, defMessageCount, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                RongContext.getInstance().getEventBus().post(new Event.JoinChatRoomEvent(chatroomId, defMessageCount));
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void joinExistChatRoom(final String chatroomId, final int defMessageCount, final RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().joinExistChatRoom(chatroomId, defMessageCount, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                RongContext.getInstance().getEventBus().post(new Event.JoinChatRoomEvent(chatroomId, defMessageCount));
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void quitChatRoom(final String chatroomId, final RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().quitChatRoom(chatroomId, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                RongContext.getInstance().getEventBus().post(new Event.QuitChatRoomEvent(chatroomId));
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void clearConversations(final RongIMClient.ResultCallback callback, final Conversation.ConversationType ... conversationTypes) {
        RongIMClient.getInstance().clearConversations(new RongIMClient.ResultCallback(){

            public void onSuccess(Object o) {
                RongContext.getInstance().getEventBus().post(Event.ClearConversationEvent.obtain(conversationTypes));
                if (callback != null) {
                    callback.onSuccess(o);
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError(e);
                }
            }
        }, conversationTypes);
    }

    public void addToBlacklist(final String userId, final RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().addToBlacklist(userId, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                RongContext.getInstance().getEventBus().post(new Event.AddToBlacklistEvent(userId));
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void removeFromBlacklist(final String userId, final RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().removeFromBlacklist(userId, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                RongContext.getInstance().getEventBus().post(new Event.RemoveFromBlacklistEvent(userId));
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void getBlacklistStatus(String userId, RongIMClient.ResultCallback<RongIMClient.BlacklistStatus> callback) {
        RongIMClient.getInstance().getBlacklistStatus(userId, callback);
    }

    public void getBlacklist(RongIMClient.GetBlacklistCallback callback) {
        RongIMClient.getInstance().getBlacklist(callback);
    }

    public void setNotificationQuietHours(final String startTime, final int spanMinutes, final RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().setNotificationQuietHours(startTime, spanMinutes, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                MessageNotificationManager.getInstance().setNotificationQuietHours(startTime, spanMinutes);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void removeNotificationQuietHours(final RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().removeNotificationQuietHours(new RongIMClient.OperationCallback(){

            public void onSuccess() {
                MessageNotificationManager.getInstance().setNotificationQuietHours(null, 0);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void getNotificationQuietHours(final RongIMClient.GetNotificationQuietHoursCallback callback) {
        RongIMClient.getInstance().getNotificationQuietHours(new RongIMClient.GetNotificationQuietHoursCallback(){

            public void onSuccess(String startTime, int spanMinutes) {
                MessageNotificationManager.getInstance().setNotificationQuietHours(startTime, spanMinutes);
                notificationQuiteHoursConfigured = true;
                if (callback != null) {
                    callback.onSuccess(startTime, spanMinutes);
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void getPublicServiceProfile(Conversation.PublicServiceType publicServiceType, String publicServiceId, RongIMClient.ResultCallback<PublicServiceProfile> callback) {
        RongIMClient.getInstance().getPublicServiceProfile(publicServiceType, publicServiceId, callback);
    }

    public void searchPublicService(RongIMClient.SearchType searchType, String keywords, RongIMClient.ResultCallback<PublicServiceProfileList> callback) {
        RongIMClient.getInstance().searchPublicService(searchType, keywords, callback);
    }

    public void searchPublicServiceByType(Conversation.PublicServiceType publicServiceType, RongIMClient.SearchType searchType, String keywords, RongIMClient.ResultCallback<PublicServiceProfileList> callback) {
        RongIMClient.getInstance().searchPublicServiceByType(publicServiceType, searchType, keywords, callback);
    }

    public void subscribePublicService(Conversation.PublicServiceType publicServiceType, String publicServiceId, RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().subscribePublicService(publicServiceType, publicServiceId, callback);
    }

    public void unsubscribePublicService(Conversation.PublicServiceType publicServiceType, String publicServiceId, RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().unsubscribePublicService(publicServiceType, publicServiceId, callback);
    }

    public void getPublicServiceList(RongIMClient.ResultCallback<PublicServiceProfileList> callback) {
        RongIMClient.getInstance().getPublicServiceList(callback);
    }

    @Deprecated
    public void setRequestPermissionListener(RequestPermissionsListener listener) {
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"setRequestPermissionListener. RongIM SDK not init, please do after init.");
        } else {
            RongContext.getInstance().setRequestPermissionListener(listener);
        }
    }

    public void recordNotificationEvent(String pushId) {
        RongPushClient.recordNotificationEvent((String)pushId);
    }

    private MessageContent setMessageAttachedUserInfo(MessageContent content) {
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"setMessageAttachedUserInfo. RongIM SDK not init, please do after init.");
            return content;
        }
        if (RongContext.getInstance().getUserInfoAttachedState() && content.getUserInfo() == null) {
            String userId = RongIM.getInstance().getCurrentUserId();
            UserInfo info = RongContext.getInstance().getCurrentUserInfo();
            if (info == null) {
                info = RongUserInfoManager.getInstance().getUserInfo(userId);
            }
            if (info != null) {
                content.setUserInfo(info);
            }
        }
        return content;
    }

    private Message filterSendMessage(Conversation.ConversationType conversationType, String targetId, MessageContent messageContent) {
        Message message = new Message();
        message.setConversationType(conversationType);
        message.setTargetId(targetId);
        message.setContent(messageContent);
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"filterSendMessage. RongIM SDK not init, please do after init.");
            return message;
        }
        if (RongContext.getInstance().getOnSendMessageListener() != null) {
            message = RongContext.getInstance().getOnSendMessageListener().onSend(message);
        }
        return message;
    }

    private Message filterSendMessage(Message message) {
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"filterSendMessage. RongIM SDK not init, please do after init.");
            return message;
        }
        if (RongContext.getInstance().getOnSendMessageListener() != null) {
            message = RongContext.getInstance().getOnSendMessageListener().onSend(message);
        }
        return message;
    }

    private void filterSentMessage(Message message, RongIMClient.ErrorCode errorCode) {
        SentMessageErrorCode sentMessageErrorCode = null;
        boolean isExecute = false;
        if (RongContext.getInstance() == null) {
            RLog.e((String)TAG, (String)"filterSendMessage. RongIM SDK not init, please do after init.");
        } else if (RongContext.getInstance().getOnSendMessageListener() != null) {
            if (errorCode != null) {
                sentMessageErrorCode = SentMessageErrorCode.setValue(errorCode.getValue());
            }
            isExecute = RongContext.getInstance().getOnSendMessageListener().onSent(message, sentMessageErrorCode);
        }
        if (errorCode != null && !isExecute && errorCode != RongIMClient.ErrorCode.RC_MSG_REPLACED_SENSITIVE_WORD) {
            MessageContent content;
            if (errorCode.equals((Object)RongIMClient.ErrorCode.NOT_IN_DISCUSSION) || errorCode.equals((Object)RongIMClient.ErrorCode.NOT_IN_GROUP) || errorCode.equals((Object)RongIMClient.ErrorCode.NOT_IN_CHATROOM) || errorCode.equals((Object)RongIMClient.ErrorCode.REJECTED_BY_BLACKLIST) || errorCode.equals((Object)RongIMClient.ErrorCode.FORBIDDEN_IN_GROUP) || errorCode.equals((Object)RongIMClient.ErrorCode.FORBIDDEN_IN_CHATROOM) || errorCode.equals((Object)RongIMClient.ErrorCode.KICKED_FROM_CHATROOM)) {
                InformationNotificationMessage informationMessage = null;
                if (errorCode.equals((Object)RongIMClient.ErrorCode.NOT_IN_DISCUSSION)) {
                    informationMessage = InformationNotificationMessage.obtain((String)this.mApplicationContext.getString(R.string.rc_info_not_in_discussion));
                } else if (errorCode.equals((Object)RongIMClient.ErrorCode.NOT_IN_GROUP)) {
                    informationMessage = InformationNotificationMessage.obtain((String)this.mApplicationContext.getString(R.string.rc_info_not_in_group));
                } else if (errorCode.equals((Object)RongIMClient.ErrorCode.NOT_IN_CHATROOM)) {
                    informationMessage = InformationNotificationMessage.obtain((String)this.mApplicationContext.getString(R.string.rc_info_not_in_chatroom));
                } else if (errorCode.equals((Object)RongIMClient.ErrorCode.REJECTED_BY_BLACKLIST)) {
                    informationMessage = InformationNotificationMessage.obtain((String)this.mApplicationContext.getString(R.string.rc_rejected_by_blacklist_prompt));
                } else if (errorCode.equals((Object)RongIMClient.ErrorCode.FORBIDDEN_IN_GROUP)) {
                    informationMessage = InformationNotificationMessage.obtain((String)this.mApplicationContext.getString(R.string.rc_info_forbidden_to_talk));
                } else if (errorCode.equals((Object)RongIMClient.ErrorCode.FORBIDDEN_IN_CHATROOM)) {
                    informationMessage = InformationNotificationMessage.obtain((String)this.mApplicationContext.getString(R.string.rc_forbidden_in_chatroom));
                } else if (errorCode.equals((Object)RongIMClient.ErrorCode.KICKED_FROM_CHATROOM)) {
                    informationMessage = InformationNotificationMessage.obtain((String)this.mApplicationContext.getString(R.string.rc_kicked_from_chatroom));
                }
                this.insertOutgoingMessage(message.getConversationType(), message.getTargetId(), null, (MessageContent)informationMessage, null);
            }
            if ((content = message.getContent()) == null) {
                RLog.e((String)TAG, (String)"filterSentMessage content is null");
                return;
            }
            MessageTag tag = content.getClass().getAnnotation(MessageTag.class);
            if (ResendManager.getInstance().isResendErrorCode(errorCode) && tag != null && (tag.flag() & 1) == 1) {
                ResendManager.getInstance().addResendMessage(message, errorCode, new ResendManager.AddResendMessageCallBack(){

                    @Override
                    public void onComplete(Message message, RongIMClient.ErrorCode errorCode) {
                        RongContext.getInstance().getEventBus().post(new Event.OnMessageSendErrorEvent(message, errorCode));
                    }
                });
            } else {
                RongContext.getInstance().getEventBus().post(new Event.OnMessageSendErrorEvent(message, errorCode));
            }
        } else if (message != null) {
            MessageContent content = message.getContent();
            MessageTag tag = content.getClass().getAnnotation(MessageTag.class);
            if (RongContext.getInstance() != null && tag != null && (tag.flag() & 1) == 1 && message.getSentStatus() != null && message.getSentStatus().getValue() != Message.SentStatus.CANCELED.getValue()) {
                RongContext.getInstance().getEventBus().post(message);
            }
        }
    }

    public static void setServerInfo(String naviServer, String fileServer) {
        if (TextUtils.isEmpty((CharSequence)naviServer)) {
            RLog.e((String)TAG, (String)"setServerInfo naviServer should not be null.");
            throw new IllegalArgumentException("naviServer should not be null.");
        }
        RongIMClient.setServerInfo((String)naviServer, (String)fileServer);
    }

    public static void setStatisticDomain(String domain) {
        RongIMClient.setStatisticDomain((String)domain);
    }

    public void setPublicServiceMenuClickListener(IPublicServiceMenuClickListener menuClickListener) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setPublicServiceMenuClickListener(menuClickListener);
        }
    }

    public void recallMessage(final Message message, String pushContent) {
        RongIMClient.getInstance().recallMessage(message, pushContent, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<RecallNotificationMessage>(){

            public void onSuccess(RecallNotificationMessage recallNotificationMessage) {
                RongContext.getInstance().getEventBus().post(new Event.MessageRecallEvent(message.getMessageId(), recallNotificationMessage, true));
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                RLog.d((String)TAG, (String)("recallMessage errorCode = " + errorCode.getValue()));
            }
        });
    }

    public void sendMediaMessage(Message message, String pushContent, String pushData, final IRongCallback.ISendMediaMessageCallback callback) {
        Message temp = this.filterSendMessage(message);
        if (temp == null) {
            return;
        }
        if (temp != message) {
            message = temp;
        }
        this.setMessageAttachedUserInfo(message.getContent());
        final RongIMClient.ResultCallback.Result result = new RongIMClient.ResultCallback.Result();
        result.t = new Event.OnReceiveMessageProgressEvent();
        IRongCallback.ISendMediaMessageCallback sendMessageCallback = new IRongCallback.ISendMediaMessageCallback(){

            public void onProgress(Message message, int progress) {
                if (result.t == null) {
                    return;
                }
                ((Event.OnReceiveMessageProgressEvent)result.t).setMessage(message);
                ((Event.OnReceiveMessageProgressEvent)result.t).setProgress(progress);
                RongContext.getInstance().getEventBus().post(result.t);
                if (callback != null) {
                    callback.onProgress(message, progress);
                }
            }

            public void onAttached(Message message) {
                RongContext.getInstance().getEventBus().post(message);
                if (callback != null) {
                    callback.onAttached(message);
                }
            }

            public void onSuccess(Message message) {
                RongIM.this.filterSentMessage(message, null);
                if (callback != null) {
                    callback.onSuccess(message);
                }
            }

            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RongIM.this.filterSentMessage(message, errorCode);
                if (callback != null) {
                    callback.onError(message, errorCode);
                }
            }

            public void onCanceled(Message message) {
                RongIM.this.filterSentMessage(message, null);
                if (callback != null) {
                    callback.onCanceled(message);
                }
            }
        };
        RongIMClient.getInstance().sendMediaMessage(message, pushContent, pushData, sendMessageCallback);
    }

    public void sendDirectionalMediaMessage(Message message, String[] userIds, String pushContent, String pushData, final IRongCallback.ISendMediaMessageCallback callback) {
        Message temp = this.filterSendMessage(message);
        if (temp == null) {
            return;
        }
        if (temp != message) {
            message = temp;
        }
        this.setMessageAttachedUserInfo(message.getContent());
        final RongIMClient.ResultCallback.Result result = new RongIMClient.ResultCallback.Result();
        result.t = new Event.OnReceiveMessageProgressEvent();
        IRongCallback.ISendMediaMessageCallback sendMessageCallback = new IRongCallback.ISendMediaMessageCallback(){

            public void onProgress(Message message, int progress) {
                if (result.t == null) {
                    return;
                }
                ((Event.OnReceiveMessageProgressEvent)result.t).setMessage(message);
                ((Event.OnReceiveMessageProgressEvent)result.t).setProgress(progress);
                RongContext.getInstance().getEventBus().post(result.t);
                if (callback != null) {
                    callback.onProgress(message, progress);
                }
            }

            public void onAttached(Message message) {
                RongContext.getInstance().getEventBus().post(message);
                if (callback != null) {
                    callback.onAttached(message);
                }
            }

            public void onSuccess(Message message) {
                RongIM.this.filterSentMessage(message, null);
                if (callback != null) {
                    callback.onSuccess(message);
                }
            }

            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RongIM.this.filterSentMessage(message, errorCode);
                if (callback != null) {
                    callback.onError(message, errorCode);
                }
            }

            public void onCanceled(Message message) {
                RongIM.this.filterSentMessage(message, null);
                if (callback != null) {
                    callback.onCanceled(message);
                }
            }
        };
        RongIMClient.getInstance().sendDirectionalMediaMessage(message, userIds, pushContent, pushData, sendMessageCallback);
    }

    public void sendMediaMessage(Message message, String pushContent, String pushData, final IRongCallback.ISendMediaMessageCallbackWithUploader callback) {
        Message temp = this.filterSendMessage(message);
        if (temp == null) {
            return;
        }
        if (temp != message) {
            message = temp;
        }
        this.setMessageAttachedUserInfo(message.getContent());
        IRongCallback.ISendMediaMessageCallbackWithUploader sendMediaMessageCallbackWithUploader = new IRongCallback.ISendMediaMessageCallbackWithUploader(){

            public void onAttached(Message message, IRongCallback.MediaMessageUploader uploader) {
                MessageTag tag = message.getContent().getClass().getAnnotation(MessageTag.class);
                if (tag != null && (tag.flag() & 1) == 1) {
                    RongContext.getInstance().getEventBus().post(message);
                }
                if (callback != null) {
                    callback.onAttached(message, uploader);
                }
            }

            public void onProgress(Message message, int progress) {
                RongIMClient.ResultCallback.Result result = new RongIMClient.ResultCallback.Result();
                result.t = new Event.OnReceiveMessageProgressEvent();
                ((Event.OnReceiveMessageProgressEvent)result.t).setMessage(message);
                ((Event.OnReceiveMessageProgressEvent)result.t).setProgress(progress);
                RongContext.getInstance().getEventBus().post(result.t);
                if (callback != null) {
                    callback.onProgress(message, progress);
                }
            }

            public void onSuccess(Message message) {
                RongIM.this.filterSentMessage(message, null);
                if (callback != null) {
                    callback.onSuccess(message);
                }
            }

            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RongIM.this.filterSentMessage(message, errorCode);
                if (callback != null) {
                    callback.onError(message, errorCode);
                }
            }

            public void onCanceled(Message message) {
                RongIM.this.filterSentMessage(message, null);
                if (callback != null) {
                    callback.onCanceled(message);
                }
            }
        };
        RongIMClient.getInstance().sendMediaMessage(message, pushContent, pushData, sendMediaMessageCallbackWithUploader);
    }

    public void cancelDownloadMediaMessage(Message message, RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().cancelDownloadMediaMessage(message, callback);
    }

    public void pauseDownloadMediaMessage(Message message, RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().pauseDownloadMediaMessage(message, callback);
    }

    public void cancelSendMediaMessage(Message message, RongIMClient.OperationCallback callback) {
        RongIMClient.getInstance().cancelSendMediaMessage(message, callback);
    }

    public void setReadReceiptConversationTypeList(Conversation.ConversationType ... types) {
        if (RongContext.getInstance() != null) {
            RongContext.getInstance().setReadReceiptConversationTypeList(types);
        }
    }

    public void sendDirectionalMessage(Conversation.ConversationType type, String targetId, MessageContent content, String[] userIds, String pushContent, String pushData, final IRongCallback.ISendMessageCallback callback) {
        Message message = Message.obtain((String)targetId, (Conversation.ConversationType)type, (MessageContent)content);
        Message filterMsg = this.filterSendMessage(message);
        if (filterMsg == null) {
            RLog.w((String)TAG, (String)"sendDirectionalMessage: \u56e0\u5728 onSend \u4e2d\u6d88\u606f\u88ab\u8fc7\u6ee4\u4e3a null\uff0c\u53d6\u6d88\u53d1\u9001\u3002");
            return;
        }
        if (filterMsg != message) {
            message = filterMsg;
        }
        message.setContent(this.setMessageAttachedUserInfo(message.getContent()));
        RongIMClient.getInstance().sendDirectionalMessage(type, targetId, content, userIds, pushContent, pushData, new IRongCallback.ISendMessageCallback(){

            public void onAttached(Message message) {
                MessageTag tag = message.getContent().getClass().getAnnotation(MessageTag.class);
                if (tag != null && (tag.flag() & 1) == 1) {
                    RongContext.getInstance().getEventBus().post(message);
                }
                if (callback != null) {
                    callback.onAttached(message);
                }
            }

            public void onSuccess(Message message) {
                RongIM.this.filterSentMessage(message, null);
                if (callback != null) {
                    callback.onSuccess(message);
                }
            }

            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RongIM.this.filterSentMessage(message, errorCode);
                if (callback != null) {
                    callback.onError(message, errorCode);
                }
            }
        });
    }

    @Deprecated
    public void setNotificationQuiteHoursConfigured(boolean notificationQuiteHoursConfigured) {
        RongIM.notificationQuiteHoursConfigured = notificationQuiteHoursConfigured;
    }

    public boolean isNotificationQuiteHoursConfigured() {
        return notificationQuiteHoursConfigured;
    }

    public void setMessageInterceptor(MessageInterceptor messageInterceptor) {
        RongIM.messageInterceptor = messageInterceptor;
    }

    public void supportResumeBrokenTransfer(String url, final RongIMClient.ResultCallback<Boolean> callback) {
        RongIMClient.getInstance().supportResumeBrokenTransfer(url, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Boolean>(){

            public void onSuccess(Boolean aBoolean) {
                if (callback != null) {
                    callback.onSuccess((Object)aBoolean);
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                if (callback != null) {
                    callback.onError(e);
                }
            }
        });
    }

    public void setSamplingRate(SamplingRate sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getSamplingRate() {
        return this.sampleRate.getValue();
    }

    public VoiceMessageType getVoiceMessageType() {
        return this.voiceMessageType;
    }

    public void setVoiceMessageType(VoiceMessageType voiceMessageType) {
        this.voiceMessageType = voiceMessageType;
    }

    public Context getApplicationContext() {
        return this.mApplicationContext;
    }

    static {
        mConnectionStatusListener = new RongIMClient.ConnectionStatusListener(){

            public void onChanged(RongIMClient.ConnectionStatusListener.ConnectionStatus status) {
                if (status != null) {
                    RLog.d((String)TAG, (String)("ConnectionStatusListener onChanged : " + status.toString()));
                    if (sConnectionStatusListener != null) {
                        sConnectionStatusListener.onChanged(status);
                    }
                    if (status.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.UNCONNECTED)) {
                        SendImageManager.getInstance().reset();
                        SendMediaManager.getInstance().reset();
                    }
                    if (status.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED)) {
                        ResendManager.getInstance().beginResend();
                        if (!notificationQuiteHoursConfigured) {
                            RLog.d((String)TAG, (String)"ConnectionStatusListener not get notificationQuietHours, get again");
                            SingletonHolder.sRongIM.getNotificationQuietHours(null);
                        }
                    }
                    if (status.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.SIGN_OUT)) {
                        ResendManager.getInstance().removeAllResendMessage();
                    }
                    RongContext.getInstance().getEventBus().post(status);
                }
            }
        };
    }

    public static enum VoiceMessageType {
        Ordinary,
        HighQuality;

    }

    public static enum SamplingRate {
        RC_SAMPLE_RATE_8000(8000),
        RC_SAMPLE_RATE_16000(16000);

        private int value;

        private SamplingRate(int sampleRate) {
            this.value = sampleRate;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static interface MessageInterceptor {
        public boolean intercept(Message var1);
    }

    @Deprecated
    public static interface RequestPermissionsListener {
        @Deprecated
        public void onPermissionRequest(String[] var1, int var2);
    }

    public static interface OnReceiveUnreadCountChangedListener {
        public void onMessageIncreased(int var1);
    }

    public static enum SentMessageErrorCode {
        UNKNOWN(-1, "Unknown error."),
        NOT_IN_DISCUSSION(21406, "not_in_discussion"),
        NOT_IN_GROUP(22406, "not_in_group"),
        FORBIDDEN_IN_GROUP(22408, "forbidden_in_group"),
        NOT_IN_CHATROOM(23406, "not_in_chatroom"),
        REJECTED_BY_BLACKLIST(405, "rejected by blacklist"),
        RC_MSG_BLOCKED_SENSITIVE_WORD(21501, "word is blocked"),
        RC_MSG_REPLACED_SENSITIVE_WORD(21502, "word is replaced"),
        RC_APP_PUBLICSERVICE_UNFOLLOW(29106, "not followed");

        private int code;
        private String msg;

        private SentMessageErrorCode(int code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public int getValue() {
            return this.code;
        }

        public String getMessage() {
            return this.msg;
        }

        public static SentMessageErrorCode setValue(int code) {
            for (SentMessageErrorCode c : SentMessageErrorCode.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            RLog.d((String)"RongIMClient", (String)("SentMessageErrorCode---ErrorCode---code:" + code));
            return UNKNOWN;
        }
    }

    public static interface OnSendMessageListener {
        public Message onSend(Message var1);

        public boolean onSent(Message var1, SentMessageErrorCode var2);
    }

    public static interface OnSelectMemberListener {
        public void startSelectMember(Context var1, Conversation.ConversationType var2, String var3);
    }

    public static interface PublicServiceProfileProvider {
        public PublicServiceProfile getPublicServiceProfile(Conversation.PublicServiceType var1, String var2);
    }

    public static interface GroupInfoProvider {
        public Group getGroupInfo(String var1);
    }

    public static interface GroupUserInfoProvider {
        public GroupUserInfo getGroupUserInfo(String var1, String var2);
    }

    public static interface UserInfoProvider {
        public UserInfo getUserInfo(String var1);
    }

    public static interface ConversationListBehaviorListener {
        public boolean onConversationPortraitClick(Context var1, Conversation.ConversationType var2, String var3);

        public boolean onConversationPortraitLongClick(Context var1, Conversation.ConversationType var2, String var3);

        public boolean onConversationLongClick(Context var1, View var2, UIConversation var3);

        public boolean onConversationClick(Context var1, View var2, UIConversation var3);
    }

    public static interface ConversationClickListener {
        public boolean onUserPortraitClick(Context var1, Conversation.ConversationType var2, UserInfo var3, String var4);

        public boolean onUserPortraitLongClick(Context var1, Conversation.ConversationType var2, UserInfo var3, String var4);

        public boolean onMessageClick(Context var1, View var2, Message var3);

        public boolean onMessageLinkClick(Context var1, String var2, Message var3);

        public boolean onMessageLongClick(Context var1, View var2, Message var3);
    }

    public static interface ConversationBehaviorListener {
        public boolean onUserPortraitClick(Context var1, Conversation.ConversationType var2, UserInfo var3);

        public boolean onUserPortraitLongClick(Context var1, Conversation.ConversationType var2, UserInfo var3);

        public boolean onMessageClick(Context var1, View var2, Message var3);

        public boolean onMessageLinkClick(Context var1, String var2);

        public boolean onMessageLongClick(Context var1, View var2, Message var3);
    }

    public static interface PublicServiceBehaviorListener {
        public boolean onFollowClick(Context var1, PublicServiceProfile var2);

        public boolean onUnFollowClick(Context var1, PublicServiceProfile var2);

        public boolean onEnterConversationClick(Context var1, PublicServiceProfile var2);
    }

    public static interface LocationProvider {
        public void onStartLocation(Context var1, LocationCallback var2);

        public static interface LocationCallback {
            public void onSuccess(LocationMessage var1);

            public void onFailure(String var1);
        }
    }

    public static interface IGroupMemberCallback {
        public void onGetGroupMembersResult(List<UserInfo> var1);
    }

    public static interface IGroupMembersProvider {
        public void getGroupMembers(String var1, IGroupMemberCallback var2);
    }

    public static interface AsyncInitListener {
        public void doBeforeInit();

        public void doAfterInit();
    }

    static class SingletonHolder {
        static RongIM sRongIM = new RongIM();

        SingletonHolder() {
        }
    }
}

