/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.eventbus.EventBus;
import io.rong.imageloader.cache.disc.impl.ext.LruDiskCache;
import io.rong.imageloader.cache.disc.naming.Md5FileNameGenerator;
import io.rong.imageloader.core.DisplayImageOptions;
import io.rong.imageloader.core.ImageLoaderConfiguration;
import io.rong.imageloader.core.download.ImageDownloader;
import io.rong.imageloader.utils.L;
import io.rong.imageloader.utils.StorageUtils;
import io.rong.imkit.IPublicServiceMenuClickListener;
import io.rong.imkit.R;
import io.rong.imkit.RongIM;
import io.rong.imkit.cache.RongCache;
import io.rong.imkit.cache.RongCacheWrap;
import io.rong.imkit.model.ConversationInfo;
import io.rong.imkit.model.ConversationKey;
import io.rong.imkit.model.ConversationProviderTag;
import io.rong.imkit.model.Event;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.utils.RongAuthImageDownloader;
import io.rong.imkit.utils.StringUtils;
import io.rong.imkit.widget.provider.AppServiceConversationProvider;
import io.rong.imkit.widget.provider.CustomerServiceConversationProvider;
import io.rong.imkit.widget.provider.DiscussionConversationProvider;
import io.rong.imkit.widget.provider.EncryptedConversationProvider;
import io.rong.imkit.widget.provider.EvaluateTextMessageItemProvider;
import io.rong.imkit.widget.provider.GroupConversationProvider;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imkit.widget.provider.PrivateConversationProvider;
import io.rong.imkit.widget.provider.PublicServiceConversationProvider;
import io.rong.imkit.widget.provider.SystemConversationProvider;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.common.SavePathUtils;
import io.rong.imlib.common.WeakValueHashMap;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.UserInfo;
import io.rong.push.RongPushClient;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class RongContext {
    private static final String TAG = "RongContext";
    private static final int NOTIFICATION_CACHE_MAX_COUNT = 64;
    private EventBus mBus = EventBus.getDefault();
    private ExecutorService executorService;
    private RongIM.ConversationBehaviorListener mConversationBehaviorListener;
    private RongIM.ConversationClickListener mConversationClickListener;
    private RongIM.ConversationListBehaviorListener mConversationListBehaviorListener;
    private RongIM.PublicServiceBehaviorListener mPublicServiceBehaviorListener;
    private RongIM.OnSelectMemberListener mMemberSelectListener;
    private RongIM.OnSendMessageListener mOnSendMessageListener;
    private RongIM.RequestPermissionsListener mRequestPermissionsListener;
    private IPublicServiceMenuClickListener mPublicServiceMenuClickListener;
    private RongIM.UserInfoProvider mUserInfoProvider;
    private RongIM.GroupInfoProvider mGroupProvider;
    private RongIM.GroupUserInfoProvider mGroupUserInfoProvider;
    private RongIM.PublicServiceProfileProvider mPublicServiceProfileProvider;
    private Map<Class<? extends MessageContent>, IContainerItemProvider.MessageProvider> mTemplateMap;
    private Map<Class<? extends MessageContent>, IContainerItemProvider.MessageProvider> mWeakTemplateMap;
    private Map<Class<? extends MessageContent>, ProviderTag> mProviderMap;
    private Map<String, IContainerItemProvider.ConversationProvider> mConversationProviderMap;
    private Map<String, ConversationProviderTag> mConversationTagMap;
    private RongCache<String, Conversation.ConversationNotificationStatus> mNotificationCache;
    private List<Conversation.ConversationType> mReadReceiptConversationTypeList;
    private RongIM.LocationProvider mLocationProvider;
    private List<String> mCurrentConversationList;
    private Handler mHandler = new Handler();
    private UserInfo mCurrentUserInfo;
    private boolean isUserInfoAttached;
    private boolean isShowUnreadMessageState;
    private boolean isShowNewMessageState;
    private EvaluateTextMessageItemProvider evaluateTextMessageItemProvider;
    private Uri notificationSound;
    private static ImageDownloader imageDownloader;

    public static RongContext getInstance() {
        return Holder.sInstance;
    }

    private RongContext() {
        this.mTemplateMap = new HashMap<Class<? extends MessageContent>, IContainerItemProvider.MessageProvider>();
        this.mWeakTemplateMap = new WeakValueHashMap();
        this.mProviderMap = new HashMap<Class<? extends MessageContent>, ProviderTag>();
        this.mConversationProviderMap = new HashMap<String, IContainerItemProvider.ConversationProvider>();
        this.mConversationTagMap = new HashMap<String, ConversationProviderTag>();
        this.mCurrentConversationList = new ArrayList<String>();
        this.mReadReceiptConversationTypeList = new ArrayList<Conversation.ConversationType>();
        this.mReadReceiptConversationTypeList.add(Conversation.ConversationType.PRIVATE);
        this.initCache();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    ImageLoaderConfiguration getDefaultConfig(Context context) {
        String path = FileUtils.getInternalCachePath((Context)context, (String)"image");
        File cacheDir = TextUtils.isEmpty((CharSequence)path) ? StorageUtils.getOwnCacheDirectory(context, context.getPackageName() + "/cache/image/") : new File(path);
        try {
            ImageLoaderConfiguration.Builder builder = new ImageLoaderConfiguration.Builder(context).threadPoolSize(3).threadPriority(3).denyCacheImageMultipleSizesInMemory().diskCache(new LruDiskCache(cacheDir, new Md5FileNameGenerator(), 0L)).defaultDisplayImageOptions(DisplayImageOptions.createSimple());
            if (imageDownloader != null) {
                builder.imageDownloader(imageDownloader);
            } else {
                builder.imageDownloader(new RongAuthImageDownloader(context));
            }
            ImageLoaderConfiguration config = !SavePathUtils.isSavePathEmpty() ? builder.build(SavePathUtils.getSavePath()) : builder.build();
            L.writeLogs(false);
            return config;
        }
        catch (IOException e) {
            RLog.i((String)TAG, (String)"Use default ImageLoader config.");
            ImageLoaderConfiguration config = !SavePathUtils.isSavePathEmpty() ? ImageLoaderConfiguration.createDefault(context, SavePathUtils.getSavePath()) : ImageLoaderConfiguration.createDefault(context);
            return config;
        }
    }

    void initRegister() {
        this.registerConversationTemplate(new PrivateConversationProvider());
        this.registerConversationTemplate(new GroupConversationProvider());
        this.registerConversationTemplate(new DiscussionConversationProvider());
        this.registerConversationTemplate(new SystemConversationProvider());
        this.registerConversationTemplate(new CustomerServiceConversationProvider());
        this.registerConversationTemplate(new AppServiceConversationProvider());
        this.registerConversationTemplate(new PublicServiceConversationProvider());
        this.registerConversationTemplate(new EncryptedConversationProvider());
    }

    public static void setImageLoaderDownloader(ImageDownloader imageLoaderDownloader) {
        imageDownloader = imageLoaderDownloader;
    }

    private void initCache() {
        this.mNotificationCache = new RongCacheWrap<String, Conversation.ConversationNotificationStatus>(this, 64){
            Vector<String> mRequests;
            {
                this.mRequests = new Vector();
            }

            @Override
            public Conversation.ConversationNotificationStatus obtainValue(final String key) {
                if (TextUtils.isEmpty((CharSequence)key)) {
                    return null;
                }
                if (this.mRequests.contains(key)) {
                    return null;
                }
                this.mRequests.add(key);
                RongContext.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        final ConversationKey conversationKey = ConversationKey.obtain(key);
                        if (conversationKey != null) {
                            RongIM.getInstance().getConversationNotificationStatus(conversationKey.getType(), conversationKey.getTargetId(), new RongIMClient.ResultCallback<Conversation.ConversationNotificationStatus>(){

                                public void onSuccess(Conversation.ConversationNotificationStatus status) {
                                    mRequests.remove(key);
                                    this.put(key, status);
                                    this.getContext().getEventBus().post(new Event.ConversationNotificationEvent(conversationKey.getTargetId(), conversationKey.getType(), status));
                                }

                                public void onError(RongIMClient.ErrorCode errorCode) {
                                    mRequests.remove(key);
                                }
                            });
                        }
                    }
                });
                return null;
            }
        };
    }

    public List<ConversationInfo> getCurrentConversationList() {
        ArrayList<ConversationInfo> infos = new ArrayList<ConversationInfo>();
        int size = this.mCurrentConversationList.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                ConversationKey key = ConversationKey.obtain(this.mCurrentConversationList.get(i));
                ConversationInfo info = ConversationInfo.obtain(key.getType(), key.getTargetId());
                infos.add(info);
            }
        }
        return infos;
    }

    public EventBus getEventBus() {
        return this.mBus;
    }

    public void registerConversationTemplate(IContainerItemProvider.ConversationProvider provider) {
        ConversationProviderTag tag = provider.getClass().getAnnotation(ConversationProviderTag.class);
        if (tag == null) {
            throw new RuntimeException("No ConversationProviderTag added with your provider!");
        }
        this.mConversationProviderMap.put(tag.conversationType(), provider);
        this.mConversationTagMap.put(tag.conversationType(), tag);
    }

    public IContainerItemProvider.ConversationProvider getConversationTemplate(String conversationType) {
        return this.mConversationProviderMap.get(conversationType);
    }

    public ConversationProviderTag getConversationProviderTag(String conversationType) {
        if (!this.mConversationProviderMap.containsKey(conversationType)) {
            throw new RuntimeException("the conversation type hasn't been registered!");
        }
        return this.mConversationTagMap.get(conversationType);
    }

    public void registerMessageTemplate(IContainerItemProvider.MessageProvider provider) {
        ProviderTag tag = provider.getClass().getAnnotation(ProviderTag.class);
        if (tag == null) {
            throw new RuntimeException("ProviderTag not def MessageContent type");
        }
        this.mTemplateMap.put(tag.messageContent(), provider);
        this.mProviderMap.put(tag.messageContent(), tag);
    }

    public IContainerItemProvider.MessageProvider getMessageTemplate(Class<? extends MessageContent> type) {
        IContainerItemProvider.MessageProvider provider = this.mWeakTemplateMap.get(type);
        if (provider == null) {
            try {
                if (this.mTemplateMap != null && this.mTemplateMap.get(type) != null) {
                    provider = (IContainerItemProvider.MessageProvider)this.mTemplateMap.get(type).clone();
                    this.mWeakTemplateMap.put(type, provider);
                } else {
                    RLog.e((String)TAG, (String)("The template of message can't be null. type :" + type));
                }
            }
            catch (CloneNotSupportedException e) {
                RLog.e((String)TAG, (String)"getMessageTemplate", (Throwable)e);
            }
        }
        return provider;
    }

    public ProviderTag getMessageProviderTag(Class<? extends MessageContent> type) {
        return this.mProviderMap.get(type);
    }

    public EvaluateTextMessageItemProvider getEvaluateProvider() {
        if (this.evaluateTextMessageItemProvider == null) {
            this.evaluateTextMessageItemProvider = new EvaluateTextMessageItemProvider();
        }
        return this.evaluateTextMessageItemProvider;
    }

    public void executorBackground(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        this.executorService.execute(runnable);
    }

    public UserInfo getUserInfoFromCache(String userId) {
        if (userId != null) {
            return RongUserInfoManager.getInstance().getUserInfo(userId);
        }
        return null;
    }

    public Group getGroupInfoFromCache(String groupId) {
        if (groupId != null) {
            return RongUserInfoManager.getInstance().getGroupInfo(groupId);
        }
        return null;
    }

    public GroupUserInfo getGroupUserInfoFromCache(String groupId, String userId) {
        return RongUserInfoManager.getInstance().getGroupUserInfo(groupId, userId);
    }

    public Discussion getDiscussionInfoFromCache(String discussionId) {
        return RongUserInfoManager.getInstance().getDiscussionInfo(discussionId);
    }

    public PublicServiceProfile getPublicServiceInfoFromCache(String messageKey) {
        String id2 = StringUtils.getArg1(messageKey);
        String arg2 = StringUtils.getArg2(messageKey);
        int iArg2 = Integer.parseInt(arg2);
        Conversation.PublicServiceType type = null;
        if (iArg2 == Conversation.PublicServiceType.PUBLIC_SERVICE.getValue()) {
            type = Conversation.PublicServiceType.PUBLIC_SERVICE;
        } else if (iArg2 == Conversation.PublicServiceType.APP_PUBLIC_SERVICE.getValue()) {
            type = Conversation.PublicServiceType.APP_PUBLIC_SERVICE;
        }
        return RongUserInfoManager.getInstance().getPublicServiceProfile(type, id2);
    }

    public Conversation.ConversationNotificationStatus getConversationNotifyStatusFromCache(ConversationKey key) {
        Conversation.ConversationNotificationStatus status = null;
        if (key != null && key.getKey() != null) {
            status = this.mNotificationCache.get(key.getKey());
        }
        return status;
    }

    public void setConversationNotifyStatusToCache(ConversationKey conversationKey, Conversation.ConversationNotificationStatus status) {
        this.mNotificationCache.put(conversationKey.getKey(), status);
    }

    public void removeConversationNotifyStatusFromCache(ConversationKey conversationKey) {
        this.mNotificationCache.remove(conversationKey.getKey());
    }

    public void clearConversationNotifyStatusCache() {
        this.mNotificationCache.clear();
    }

    public RongIM.ConversationBehaviorListener getConversationBehaviorListener() {
        return this.mConversationBehaviorListener;
    }

    public void setConversationBehaviorListener(RongIM.ConversationBehaviorListener conversationBehaviorListener) {
        this.mConversationBehaviorListener = conversationBehaviorListener;
    }

    public Object getConversationListener() {
        if (this.mConversationClickListener != null) {
            return this.mConversationClickListener;
        }
        if (this.mConversationBehaviorListener != null) {
            return this.mConversationBehaviorListener;
        }
        return null;
    }

    public RongIM.ConversationClickListener getConversationClickListener() {
        return this.mConversationClickListener;
    }

    public void setConversationClickListener(RongIM.ConversationClickListener conversationClickListener) {
        this.mConversationClickListener = conversationClickListener;
    }

    public RongIM.PublicServiceBehaviorListener getPublicServiceBehaviorListener() {
        return this.mPublicServiceBehaviorListener;
    }

    public void setPublicServiceBehaviorListener(RongIM.PublicServiceBehaviorListener publicServiceBehaviorListener) {
        this.mPublicServiceBehaviorListener = publicServiceBehaviorListener;
    }

    public void setOnMemberSelectListener(RongIM.OnSelectMemberListener listener) {
        this.mMemberSelectListener = listener;
    }

    public RongIM.OnSelectMemberListener getMemberSelectListener() {
        return this.mMemberSelectListener;
    }

    public void setGetUserInfoProvider(RongIM.UserInfoProvider provider, boolean isCache) {
        this.mUserInfoProvider = provider;
        RongUserInfoManager.getInstance().setIsCacheUserInfo(isCache);
    }

    void setGetGroupInfoProvider(RongIM.GroupInfoProvider provider, boolean isCacheGroupInfo) {
        this.mGroupProvider = provider;
        RongUserInfoManager.getInstance().setIsCacheGroupInfo(isCacheGroupInfo);
    }

    RongIM.UserInfoProvider getUserInfoProvider() {
        return this.mUserInfoProvider;
    }

    public RongIM.GroupInfoProvider getGroupInfoProvider() {
        return this.mGroupProvider;
    }

    public void setGroupUserInfoProvider(RongIM.GroupUserInfoProvider groupUserInfoProvider, boolean isCache) {
        this.mGroupUserInfoProvider = groupUserInfoProvider;
        RongUserInfoManager.getInstance().setIsCacheGroupUserInfo(isCache);
    }

    public RongIM.GroupUserInfoProvider getGroupUserInfoProvider() {
        return this.mGroupUserInfoProvider;
    }

    public void setPublicServiceProfileProvider(RongIM.PublicServiceProfileProvider provider) {
        this.mPublicServiceProfileProvider = provider;
    }

    public RongIM.PublicServiceProfileProvider getPublicServiceProfileProvider() {
        return this.mPublicServiceProfileProvider;
    }

    public void registerConversationInfo(ConversationInfo info) {
        ConversationKey key;
        if (info != null && (key = ConversationKey.obtain(info.getTargetId(), info.getConversationType())) != null && !this.mCurrentConversationList.contains(key.getKey())) {
            this.mCurrentConversationList.add(key.getKey());
        }
    }

    public void unregisterConversationInfo(ConversationInfo info) {
        ConversationKey key;
        if (info != null && (key = ConversationKey.obtain(info.getTargetId(), info.getConversationType())) != null && this.mCurrentConversationList.size() > 0) {
            this.mCurrentConversationList.remove(key.getKey());
        }
    }

    public RongIM.LocationProvider getLocationProvider() {
        return this.mLocationProvider;
    }

    public void setLocationProvider(RongIM.LocationProvider locationProvider) {
        this.mLocationProvider = locationProvider;
    }

    public RongIM.OnSendMessageListener getOnSendMessageListener() {
        return this.mOnSendMessageListener;
    }

    public void setOnSendMessageListener(RongIM.OnSendMessageListener onSendMessageListener) {
        this.mOnSendMessageListener = onSendMessageListener;
    }

    public void setCurrentUserInfo(UserInfo userInfo) {
        this.mCurrentUserInfo = userInfo;
        if (userInfo != null && !TextUtils.isEmpty((CharSequence)userInfo.getUserId())) {
            RongUserInfoManager.getInstance().setUserInfo(userInfo);
        }
    }

    public UserInfo getCurrentUserInfo() {
        if (this.mCurrentUserInfo != null) {
            return this.mCurrentUserInfo;
        }
        return null;
    }

    public void setUserInfoAttachedState(boolean state) {
        this.isUserInfoAttached = state;
    }

    public boolean getUserInfoAttachedState() {
        return this.isUserInfoAttached;
    }

    public void setPublicServiceMenuClickListener(IPublicServiceMenuClickListener menuClickListener) {
        this.mPublicServiceMenuClickListener = menuClickListener;
    }

    public IPublicServiceMenuClickListener getPublicServiceMenuClickListener() {
        return this.mPublicServiceMenuClickListener;
    }

    public RongIM.ConversationListBehaviorListener getConversationListBehaviorListener() {
        return this.mConversationListBehaviorListener;
    }

    public void setConversationListBehaviorListener(RongIM.ConversationListBehaviorListener conversationListBehaviorListener) {
        this.mConversationListBehaviorListener = conversationListBehaviorListener;
    }

    public void setRequestPermissionListener(RongIM.RequestPermissionsListener listener) {
        this.mRequestPermissionsListener = listener;
    }

    public RongIM.RequestPermissionsListener getRequestPermissionListener() {
        return this.mRequestPermissionsListener;
    }

    public void showUnreadMessageIcon(boolean state) {
        this.isShowUnreadMessageState = state;
    }

    public void showNewMessageIcon(boolean state) {
        this.isShowNewMessageState = state;
    }

    public boolean getUnreadMessageState() {
        return this.isShowUnreadMessageState;
    }

    public boolean getNewMessageState() {
        return this.isShowNewMessageState;
    }

    public String getGatheredConversationTitle(Context context, Conversation.ConversationType type) {
        String title = "";
        switch (type) {
            case PRIVATE: {
                title = context.getString(R.string.rc_conversation_list_my_private_conversation);
                break;
            }
            case GROUP: {
                title = context.getString(R.string.rc_conversation_list_my_group);
                break;
            }
            case DISCUSSION: {
                title = context.getString(R.string.rc_conversation_list_my_discussion);
                break;
            }
            case CHATROOM: {
                title = context.getString(R.string.rc_conversation_list_my_chatroom);
                break;
            }
            case CUSTOMER_SERVICE: {
                title = context.getString(R.string.rc_conversation_list_my_customer_service);
                break;
            }
            case SYSTEM: {
                title = context.getString(R.string.rc_conversation_list_system_conversation);
                break;
            }
            case APP_PUBLIC_SERVICE: {
                title = context.getString(R.string.rc_conversation_list_app_public_service);
                break;
            }
            case PUBLIC_SERVICE: {
                title = context.getString(R.string.rc_conversation_list_public_service);
                break;
            }
            default: {
                System.err.print("It's not the default conversation type!!");
            }
        }
        return title;
    }

    void setReadReceiptConversationTypeList(Conversation.ConversationType ... types) {
        if (types == null) {
            RLog.d((String)TAG, (String)"setReadReceiptConversationTypeList parameter is null");
            return;
        }
        this.mReadReceiptConversationTypeList.clear();
        for (Conversation.ConversationType type : types) {
            this.mReadReceiptConversationTypeList.add(type);
        }
    }

    public boolean isReadReceiptConversationType(Conversation.ConversationType type) {
        if (this.mReadReceiptConversationTypeList == null) {
            RLog.d((String)TAG, (String)"isReadReceiptConversationType mReadReceiptConversationTypeList is null");
            return false;
        }
        return this.mReadReceiptConversationTypeList.contains(type);
    }

    public void setNotificationSound(Uri uri) {
        this.notificationSound = uri;
        RongPushClient.setNotifiationSound((Uri)uri);
    }

    public Uri getNotificationSound() {
        return this.notificationSound;
    }

    private static class Holder {
        static RongContext sInstance = new RongContext();

        private Holder() {
        }
    }
}

