/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import io.rong.imkit.IRongExtensionState;
import io.rong.imkit.R;
import io.rong.imkit.RongExtension;
import io.rong.imkit.emoticon.EmoticonTabAdapter;

public class NormalState
implements IRongExtensionState {
    NormalState() {
    }

    @Override
    public void changeView(RongExtension pExtension) {
        Button voiceInputToggle;
        EditText editText;
        ImageView emoticonToggle;
        ImageView pluginToggle;
        pExtension.refreshQuickView();
        ImageView voiceToggle = pExtension.getVoiceToggle();
        if (voiceToggle != null) {
            voiceToggle.setImageResource(R.drawable.rc_voice_toggle_selector);
        }
        if ((pluginToggle = pExtension.getPluginToggle()) != null) {
            pluginToggle.setImageResource(R.drawable.rc_plugin_toggle_selector);
        }
        if ((emoticonToggle = pExtension.getEmoticonToggle()) != null) {
            emoticonToggle.setImageResource(R.drawable.rc_emotion_toggle_selector);
        }
        if ((editText = pExtension.getEditText()) != null) {
            editText.setBackgroundResource(R.drawable.rc_edit_text_background_selector);
        }
        if ((voiceInputToggle = pExtension.getVoiceInputToggle()) != null) {
            voiceInputToggle.setTextColor(pExtension.getContext().getResources().getColor(R.color.rc_text_voice));
        }
    }

    @Override
    public void onClick(final RongExtension pExtension, View v) {
        int id2 = v.getId();
        if (id2 == R.id.rc_plugin_toggle) {
            if (pExtension.getExtensionClickListener() != null) {
                pExtension.getExtensionClickListener().onPluginToggleClick(v, (ViewGroup)pExtension);
            }
            pExtension.setPluginBoard();
        } else if (id2 == R.id.rc_emoticon_toggle) {
            if (pExtension.getExtensionClickListener() != null) {
                pExtension.getExtensionClickListener().onEmoticonToggleClick(v, (ViewGroup)pExtension);
            }
            if (pExtension.isKeyBoardActive()) {
                pExtension.hideInputKeyBoard();
                pExtension.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        pExtension.setEmoticonBoard();
                    }
                }, 200L);
            } else {
                pExtension.setEmoticonBoard();
            }
            pExtension.hidePluginBoard();
            pExtension.hidePhrasesBoard();
        } else if (id2 == R.id.rc_voice_toggle) {
            pExtension.clickVoice(pExtension.isRobotFirst(), pExtension, v, R.drawable.rc_emotion_toggle_selector);
        }
    }

    @Override
    public boolean onEditTextTouch(RongExtension pExtension, View v, MotionEvent event) {
        if (0 == event.getAction()) {
            EditText editText = pExtension.getEditText();
            if (pExtension.getExtensionClickListener() != null) {
                pExtension.getExtensionClickListener().onEditTextClick(editText);
            }
            if (Build.BRAND.toLowerCase().contains("meizu")) {
                editText.requestFocus();
                pExtension.getEmoticonToggle().setSelected(false);
                pExtension.setKeyBoardActive(true);
            } else {
                pExtension.showInputKeyBoard();
            }
            pExtension.getContainerLayout().setSelected(true);
            pExtension.hidePluginBoard();
            pExtension.hideEmoticonBoard();
            pExtension.hidePhrasesBoard();
        }
        return false;
    }

    @Override
    public void hideEmoticonBoard(ImageView pEmoticonToggle, EmoticonTabAdapter pEmotionTabAdapter) {
        pEmotionTabAdapter.setVisibility(8);
        pEmoticonToggle.setImageResource(R.drawable.rc_emotion_toggle_selector);
    }
}

