/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import io.rong.imkit.IRongExtensionState;
import io.rong.imkit.R;
import io.rong.imkit.RongExtension;
import io.rong.imkit.dialog.ImageVideoDialogFragment;
import io.rong.imkit.emoticon.EmoticonTabAdapter;
import io.rong.imkit.plugin.IPluginModule;
import io.rong.imkit.plugin.ImagePlugin;
import java.util.List;

public class DestructState
implements IRongExtensionState {
    private ImageVideoDialogFragment imageVideoDialog;

    DestructState() {
    }

    @Override
    public void changeView(RongExtension pExtension) {
        Button voiceInputToggle;
        EditText editText;
        ImageView emoticonToggle;
        ImageView pluginToggle;
        pExtension.refreshQuickView();
        ImageView voiceToggle = pExtension.getVoiceToggle();
        if (voiceToggle != null) {
            voiceToggle.setImageResource(R.drawable.rc_destruct_voice_toggle_selector);
        }
        if ((pluginToggle = pExtension.getPluginToggle()) != null) {
            pluginToggle.setImageResource(R.drawable.rc_destruct_plugin_toggle_selector);
        }
        if ((emoticonToggle = pExtension.getEmoticonToggle()) != null) {
            emoticonToggle.setImageResource(R.drawable.rc_destruct_emotion_toggle_selector);
        }
        if ((editText = pExtension.getEditText()) != null) {
            editText.setBackgroundResource(R.drawable.rc_destruct_edit_text_background_selector);
        }
        if ((voiceInputToggle = pExtension.getVoiceInputToggle()) != null) {
            voiceInputToggle.setTextColor(pExtension.getContext().getResources().getColor(R.color.rc_destruct_voice_color));
        }
    }

    @Override
    public void onClick(final RongExtension pExtension, View v) {
        int id2 = v.getId();
        if (id2 == R.id.rc_plugin_toggle) {
            pExtension.exitBurnMode();
        } else if (id2 == R.id.rc_emoticon_toggle) {
            if (this.imageVideoDialog == null) {
                List<IPluginModule> pluginModules = pExtension.getPluginModules();
                boolean hasSight = false;
                boolean hasImage = false;
                IPluginModule imagePlugin = null;
                IPluginModule sightPlugin = null;
                for (IPluginModule plugin : pluginModules) {
                    if (plugin instanceof ImagePlugin) {
                        hasImage = true;
                        imagePlugin = plugin;
                        continue;
                    }
                    if (!plugin.getClass().getName().equals("io.rong.sight.SightPlugin")) continue;
                    hasSight = true;
                    sightPlugin = plugin;
                }
                this.imageVideoDialog = new ImageVideoDialogFragment();
                this.imageVideoDialog.setHasImage(hasImage);
                this.imageVideoDialog.setHasSight(hasSight);
                final IPluginModule finalSightPlugin = sightPlugin;
                final IPluginModule finalImagePlugin = imagePlugin;
                this.imageVideoDialog.setImageVideoDialogListener(new ImageVideoDialogFragment.ImageVideoDialogListener(){

                    @Override
                    public void onSightClick(View v) {
                        if (finalSightPlugin != null) {
                            finalSightPlugin.onClick(pExtension.getFragment(), pExtension);
                        }
                    }

                    @Override
                    public void onImageClick(View v) {
                        if (finalImagePlugin != null) {
                            finalImagePlugin.onClick(pExtension.getFragment(), pExtension);
                        }
                    }
                });
            }
            this.imageVideoDialog.show(pExtension.getFragment().getFragmentManager());
        } else if (id2 == R.id.rc_voice_toggle) {
            pExtension.clickVoice(pExtension.isRobotFirst(), pExtension, v, R.drawable.rc_destruct_emotion_toggle_selector);
        }
    }

    @Override
    public boolean onEditTextTouch(RongExtension pExtension, View v, MotionEvent event) {
        if (0 == event.getAction()) {
            EditText editText = pExtension.getEditText();
            if (pExtension.getExtensionClickListener() != null) {
                pExtension.getExtensionClickListener().onEditTextClick(editText);
            }
            if (Build.BRAND.toLowerCase().contains("meizu")) {
                editText.requestFocus();
                pExtension.getEmoticonToggle().setSelected(false);
                pExtension.setKeyBoardActive(true);
            } else {
                pExtension.showInputKeyBoard();
            }
            pExtension.getContainerLayout().setSelected(true);
            pExtension.hidePluginBoard();
            pExtension.hideEmoticonBoard();
            pExtension.hidePhrasesBoard();
        }
        return false;
    }

    @Override
    public void hideEmoticonBoard(ImageView pEmoticonToggle, EmoticonTabAdapter pEmotionTabAdapter) {
        pEmotionTabAdapter.setVisibility(8);
    }
}

