/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imageloader.utils;

import android.opengl.GLES10;
import io.rong.imageloader.core.assist.ImageSize;
import io.rong.imageloader.core.assist.ViewScaleType;
import io.rong.imageloader.core.imageaware.ImageAware;

public final class ImageSizeUtils {
    private static final int DEFAULT_MAX_BITMAP_DIMENSION = 2048;
    private static ImageSize maxBitmapSize;

    private ImageSizeUtils() {
    }

    public static ImageSize defineTargetSizeForView(ImageAware imageAware, ImageSize maxImageSize) {
        int height;
        int width = imageAware.getWidth();
        if (width <= 0) {
            width = maxImageSize.getWidth();
        }
        if ((height = imageAware.getHeight()) <= 0) {
            height = maxImageSize.getHeight();
        }
        return new ImageSize(width, height);
    }

    public static int computeImageSampleSize(ImageSize srcSize, ImageSize targetSize, ViewScaleType viewScaleType, boolean powerOf2Scale) {
        int srcWidth = srcSize.getWidth();
        int srcHeight = srcSize.getHeight();
        int targetWidth = targetSize.getWidth();
        int targetHeight = targetSize.getHeight();
        int scale = 1;
        switch (viewScaleType) {
            case FIT_INSIDE: {
                if (powerOf2Scale) {
                    int halfWidth = srcWidth / 2;
                    int halfHeight = srcHeight / 2;
                    while (halfWidth / scale > targetWidth || halfHeight / scale > targetHeight) {
                        scale *= 2;
                    }
                    break;
                }
                scale = Math.max(srcWidth / targetWidth, srcHeight / targetHeight);
                break;
            }
            case CROP: {
                if (powerOf2Scale) {
                    int halfWidth = srcWidth / 2;
                    int halfHeight = srcHeight / 2;
                    while (halfWidth / scale > targetWidth && halfHeight / scale > targetHeight) {
                        scale *= 2;
                    }
                    break;
                }
                scale = Math.min(srcWidth / targetWidth, srcHeight / targetHeight);
            }
        }
        if (scale < 1) {
            scale = 1;
        }
        scale = ImageSizeUtils.considerMaxTextureSize(srcWidth, srcHeight, scale, powerOf2Scale);
        return scale;
    }

    private static int considerMaxTextureSize(int srcWidth, int srcHeight, int scale, boolean powerOf2) {
        int maxWidth = maxBitmapSize.getWidth();
        int maxHeight = maxBitmapSize.getHeight();
        while (srcWidth / scale > maxWidth || srcHeight / scale > maxHeight) {
            if (powerOf2) {
                scale *= 2;
                continue;
            }
            ++scale;
        }
        return scale;
    }

    public static int computeMinImageSampleSize(ImageSize srcSize) {
        int srcWidth = srcSize.getWidth();
        int srcHeight = srcSize.getHeight();
        int targetWidth = maxBitmapSize.getWidth();
        int targetHeight = maxBitmapSize.getHeight();
        int widthScale = (int)Math.ceil((float)srcWidth / (float)targetWidth);
        int heightScale = (int)Math.ceil((float)srcHeight / (float)targetHeight);
        return Math.max(widthScale, heightScale);
    }

    public static float computeImageScale(ImageSize srcSize, ImageSize targetSize, ViewScaleType viewScaleType, boolean stretch) {
        int destHeight;
        int destWidth;
        int srcWidth = srcSize.getWidth();
        int srcHeight = srcSize.getHeight();
        int targetWidth = targetSize.getWidth();
        int targetHeight = targetSize.getHeight();
        float widthScale = (float)srcWidth / (float)targetWidth;
        float heightScale = (float)srcHeight / (float)targetHeight;
        if (viewScaleType == ViewScaleType.FIT_INSIDE && widthScale >= heightScale || viewScaleType == ViewScaleType.CROP && widthScale < heightScale) {
            destWidth = targetWidth;
            destHeight = (int)((float)srcHeight / widthScale);
        } else {
            destWidth = (int)((float)srcWidth / heightScale);
            destHeight = targetHeight;
        }
        float scale = 1.0f;
        if (!stretch && destWidth < srcWidth && destHeight < srcHeight || stretch && destWidth != srcWidth && destHeight != srcHeight) {
            scale = (float)destWidth / (float)srcWidth;
        }
        return scale;
    }

    static {
        int[] maxTextureSize = new int[1];
        GLES10.glGetIntegerv((int)3379, (int[])maxTextureSize, (int)0);
        int maxBitmapDimension = Math.max(maxTextureSize[0], 2048);
        maxBitmapSize = new ImageSize(maxBitmapDimension, maxBitmapDimension);
    }
}

