/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imageloader.core.imageaware;

import android.graphics.Bitmap;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import io.rong.imageloader.core.assist.ViewScaleType;
import io.rong.imageloader.core.imageaware.ViewAware;
import io.rong.imageloader.utils.L;
import java.lang.reflect.Field;

public class ImageViewAware
extends ViewAware {
    public ImageViewAware(ImageView imageView) {
        super((View)imageView);
    }

    public ImageViewAware(ImageView imageView, boolean checkActualViewSize) {
        super((View)imageView, checkActualViewSize);
    }

    @Override
    public int getWidth() {
        ImageView imageView;
        int width = super.getWidth();
        if (width <= 0 && (imageView = (ImageView)this.viewRef.get()) != null) {
            width = ImageViewAware.getImageViewFieldValue(imageView, "mMaxWidth");
        }
        return width;
    }

    @Override
    public int getHeight() {
        ImageView imageView;
        int height = super.getHeight();
        if (height <= 0 && (imageView = (ImageView)this.viewRef.get()) != null) {
            height = ImageViewAware.getImageViewFieldValue(imageView, "mMaxHeight");
        }
        return height;
    }

    @Override
    public ViewScaleType getScaleType() {
        ImageView imageView = (ImageView)this.viewRef.get();
        if (imageView != null) {
            return ViewScaleType.fromImageView(imageView);
        }
        return super.getScaleType();
    }

    public ImageView getWrappedView() {
        return (ImageView)super.getWrappedView();
    }

    @Override
    protected void setImageDrawableInto(Drawable drawable2, View view) {
        ((ImageView)view).setImageDrawable(drawable2);
        if (drawable2 instanceof AnimationDrawable) {
            ((AnimationDrawable)drawable2).start();
        }
    }

    @Override
    protected void setImageBitmapInto(Bitmap bitmap, View view) {
        ((ImageView)view).setImageBitmap(bitmap);
    }

    private static int getImageViewFieldValue(Object object, String fieldName) {
        int value = 0;
        try {
            Field field = ImageView.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            int fieldValue = (Integer)field.get(object);
            if (fieldValue > 0 && fieldValue < Integer.MAX_VALUE) {
                value = fieldValue;
            }
        }
        catch (Exception e) {
            L.e(e);
        }
        return value;
    }
}

