/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imageloader.core.download;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import io.rong.imageloader.core.assist.ContentLengthInputStream;
import io.rong.imageloader.core.download.ImageDownloader;
import io.rong.imageloader.utils.IoUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class BaseImageDownloader
implements ImageDownloader {
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 5000;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 20000;
    protected static final int BUFFER_SIZE = 32768;
    protected static final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";
    protected static final int MAX_REDIRECT_COUNT = 5;
    private static final String ERROR_UNSUPPORTED_SCHEME = "UIL doesn't support scheme(protocol) by default [%s]. You should implement this support yourself (BaseImageDownloader.getStreamFromOtherSource(...))";
    protected final Context context;
    protected final int connectTimeout;
    protected final int readTimeout;

    public BaseImageDownloader(Context context) {
        this(context, 5000, 20000);
    }

    public BaseImageDownloader(Context context, int connectTimeout, int readTimeout) {
        this.context = context.getApplicationContext();
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public InputStream getStream(String imageUri, Object extra) throws IOException {
        switch (ImageDownloader.Scheme.ofUri(imageUri)) {
            case HTTP: 
            case HTTPS: {
                return this.getStreamFromNetwork(imageUri, extra);
            }
            case FILE: {
                return this.getStreamFromFile(imageUri, extra);
            }
            case CONTENT: {
                return this.getStreamFromContent(imageUri, extra);
            }
            case ASSETS: {
                return this.getStreamFromAssets(imageUri, extra);
            }
            case DRAWABLE: {
                return this.getStreamFromDrawable(imageUri, extra);
            }
            case AVATAR: {
                return this.getStreamByGenerateBitmap(imageUri, extra);
            }
        }
        return this.getStreamFromOtherSource(imageUri, extra);
    }

    protected InputStream getStreamFromNetwork(String imageUri, Object extra) throws IOException {
        InputStream imageStream;
        HttpURLConnection conn = this.createConnection(imageUri, extra);
        for (int redirectCount = 0; conn.getResponseCode() / 100 == 3 && redirectCount < 5; ++redirectCount) {
            conn = this.createConnection(conn.getHeaderField("Location"), extra);
        }
        try {
            imageStream = conn.getInputStream();
        }
        catch (IOException e) {
            IoUtils.readAndCloseStream(conn.getErrorStream());
            throw e;
        }
        if (!this.shouldBeProcessed(conn)) {
            IoUtils.closeSilently(imageStream);
            throw new IOException("Image request failed with response code " + conn.getResponseCode());
        }
        return new ContentLengthInputStream(new BufferedInputStream(imageStream, 32768), conn.getContentLength());
    }

    protected boolean shouldBeProcessed(HttpURLConnection conn) throws IOException {
        return conn.getResponseCode() == 200 || conn.getResponseCode() == 404 && conn.getContentLength() > 0 && conn.getContentType().contains("image/");
    }

    protected HttpURLConnection createConnection(String url, Object extra) throws IOException {
        String encodedUrl = Uri.encode((String)url, (String)ALLOWED_URI_CHARS);
        HttpURLConnection conn = (HttpURLConnection)new URL(encodedUrl).openConnection();
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        return conn;
    }

    protected InputStream getStreamFromFile(String imageUri, Object extra) throws IOException {
        String filePath = ImageDownloader.Scheme.FILE.crop(imageUri);
        if (this.isVideoFileUri(imageUri)) {
            return this.getVideoThumbnailStream(filePath);
        }
        BufferedInputStream imageStream = new BufferedInputStream(new FileInputStream(filePath), 32768);
        return new ContentLengthInputStream(imageStream, (int)new File(filePath).length());
    }

    @TargetApi(value=8)
    private InputStream getVideoThumbnailStream(String filePath) {
        Bitmap bitmap;
        if (Build.VERSION.SDK_INT >= 8 && (bitmap = ThumbnailUtils.createVideoThumbnail((String)filePath, (int)2)) != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)bos);
            return new ByteArrayInputStream(bos.toByteArray());
        }
        return null;
    }

    protected InputStream getStreamFromContent(String imageUri, Object extra) throws FileNotFoundException {
        long origId;
        Bitmap bitmap;
        ContentResolver res = this.context.getContentResolver();
        Uri uri = Uri.parse((String)imageUri);
        if (this.isVideoContentUri(uri) && (bitmap = MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)res, (long)(origId = Long.parseLong(uri.getLastPathSegment())), (int)1, null)) != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)bos);
            return new ByteArrayInputStream(bos.toByteArray());
        }
        return res.openInputStream(uri);
    }

    protected InputStream getStreamFromAssets(String imageUri, Object extra) throws IOException {
        String filePath = ImageDownloader.Scheme.ASSETS.crop(imageUri);
        return this.context.getAssets().open(filePath);
    }

    protected InputStream getStreamFromDrawable(String imageUri, Object extra) {
        String drawableIdString = ImageDownloader.Scheme.DRAWABLE.crop(imageUri);
        int drawableId = Integer.parseInt(drawableIdString);
        return this.context.getResources().openRawResource(drawableId);
    }

    protected InputStream getStreamByGenerateBitmap(String key, Object extra) {
        return null;
    }

    protected InputStream getStreamFromOtherSource(String imageUri, Object extra) throws IOException {
        throw new UnsupportedOperationException(String.format(ERROR_UNSUPPORTED_SCHEME, imageUri));
    }

    private boolean isVideoContentUri(Uri uri) {
        String mimeType = this.context.getContentResolver().getType(uri);
        return mimeType != null && mimeType.startsWith("video/");
    }

    private boolean isVideoFileUri(String uri) {
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)uri);
        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        return mimeType != null && mimeType.startsWith("video/");
    }
}

