/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imageloader.cache.memory.impl;

import android.graphics.Bitmap;
import io.rong.imageloader.cache.memory.MemoryCache;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class LruMemoryCache
implements MemoryCache {
    private final LinkedHashMap<String, Bitmap> map;
    private final int maxSize;
    private int size;

    public LruMemoryCache(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = maxSize;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Bitmap get(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean put(String key, Bitmap value) {
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            this.size += this.sizeOf(key, value);
            Bitmap previous = this.map.put(key, value);
            if (previous != null) {
                this.size -= this.sizeOf(key, previous);
            }
        }
        this.trimToSize(this.maxSize);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize(int maxSize) {
        while (true) {
            LruMemoryCache lruMemoryCache = this;
            synchronized (lruMemoryCache) {
                if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.map.isEmpty()) {
                    break;
                }
                Map.Entry<String, Bitmap> toEvict = this.map.entrySet().iterator().next();
                if (toEvict == null) {
                    break;
                }
                String key = toEvict.getKey();
                Bitmap value = toEvict.getValue();
                this.map.remove(key);
                this.size -= this.sizeOf(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Bitmap remove(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            Bitmap previous = (Bitmap)this.map.remove(key);
            if (previous != null) {
                this.size -= this.sizeOf(key, previous);
            }
            return previous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> keys() {
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            return new HashSet<String>(this.map.keySet());
        }
    }

    @Override
    public void clear() {
        this.trimToSize(-1);
    }

    private int sizeOf(String key, Bitmap value) {
        return value.getRowBytes() * value.getHeight();
    }

    public final synchronized String toString() {
        return String.format("LruCache[maxSize=%d]", this.maxSize);
    }
}

