/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imageloader.cache.disc.naming;

import io.rong.imageloader.cache.disc.naming.FileNameGenerator;
import io.rong.imageloader.utils.L;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5FileNameGenerator
implements FileNameGenerator {
    private static final String HASH_ALGORITHM = "MD5";
    private static final int RADIX = 36;

    @Override
    public String generate(String imageUri) {
        byte[] md5 = this.getMD5(imageUri.getBytes());
        BigInteger bi = new BigInteger(md5).abs();
        return bi.toString(36);
    }

    private byte[] getMD5(byte[] data) {
        byte[] hash = null;
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_ALGORITHM);
            digest.update(data);
            hash = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            L.e(e);
        }
        return hash;
    }
}

