/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imageloader.cache.disc.impl.ext;

import android.graphics.Bitmap;
import io.rong.imageloader.cache.disc.DiskCache;
import io.rong.imageloader.cache.disc.impl.ext.DiskLruCache;
import io.rong.imageloader.cache.disc.naming.FileNameGenerator;
import io.rong.imageloader.utils.IoUtils;
import io.rong.imageloader.utils.L;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LruDiskCache
implements DiskCache {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    public static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.PNG;
    public static final int DEFAULT_COMPRESS_QUALITY = 100;
    private static final String ERROR_ARG_NULL = " argument must be not null";
    private static final String ERROR_ARG_NEGATIVE = " argument must be positive number";
    protected DiskLruCache cache;
    private File reserveCacheDir;
    protected final FileNameGenerator fileNameGenerator;
    protected int bufferSize = 32768;
    protected Bitmap.CompressFormat compressFormat = DEFAULT_COMPRESS_FORMAT;
    protected int compressQuality = 100;

    public LruDiskCache(File cacheDir, FileNameGenerator fileNameGenerator, long cacheMaxSize) throws IOException {
        this(cacheDir, null, fileNameGenerator, cacheMaxSize, 0);
    }

    public LruDiskCache(File cacheDir, File reserveCacheDir, FileNameGenerator fileNameGenerator, long cacheMaxSize, int cacheMaxFileCount) throws IOException {
        if (cacheDir == null) {
            throw new IllegalArgumentException("cacheDir argument must be not null");
        }
        if (cacheMaxSize < 0L) {
            throw new IllegalArgumentException("cacheMaxSize argument must be positive number");
        }
        if (cacheMaxFileCount < 0) {
            throw new IllegalArgumentException("cacheMaxFileCount argument must be positive number");
        }
        if (fileNameGenerator == null) {
            throw new IllegalArgumentException("fileNameGenerator argument must be not null");
        }
        if (cacheMaxSize == 0L) {
            cacheMaxSize = Long.MAX_VALUE;
        }
        if (cacheMaxFileCount == 0) {
            cacheMaxFileCount = Integer.MAX_VALUE;
        }
        this.reserveCacheDir = reserveCacheDir;
        this.fileNameGenerator = fileNameGenerator;
        this.initCache(cacheDir, reserveCacheDir, cacheMaxSize, cacheMaxFileCount);
    }

    private void initCache(File cacheDir, File reserveCacheDir, long cacheMaxSize, int cacheMaxFileCount) throws IOException {
        block3: {
            try {
                this.cache = DiskLruCache.open(cacheDir, 1, 1, cacheMaxSize, cacheMaxFileCount);
            }
            catch (IOException e) {
                L.e(e);
                if (reserveCacheDir != null) {
                    this.initCache(reserveCacheDir, null, cacheMaxSize, cacheMaxFileCount);
                }
                if (this.cache != null) break block3;
                throw e;
            }
        }
    }

    @Override
    public File getDirectory() {
        return this.cache.getDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File get(String imageUri) {
        try (DiskLruCache.Snapshot snapshot = null;){
            snapshot = this.cache.get(this.getKey(imageUri));
            File file = snapshot == null ? null : snapshot.getFile(0);
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(String imageUri, InputStream imageStream, IoUtils.CopyListener listener) throws IOException {
        DiskLruCache.Editor editor = this.cache.edit(this.getKey(imageUri));
        if (editor == null) {
            return false;
        }
        BufferedOutputStream os = new BufferedOutputStream(editor.newOutputStream(0), this.bufferSize);
        boolean copied = false;
        try {
            copied = IoUtils.copyStream(imageStream, os, listener, this.bufferSize);
        }
        finally {
            IoUtils.closeSilently(os);
            if (copied) {
                editor.commit();
            } else {
                editor.abort();
            }
        }
        return copied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(String imageUri, Bitmap bitmap) throws IOException {
        DiskLruCache.Editor editor = this.cache.edit(this.getKey(imageUri));
        if (editor == null) {
            return false;
        }
        BufferedOutputStream os = new BufferedOutputStream(editor.newOutputStream(0), this.bufferSize);
        boolean savedSuccessfully = false;
        try {
            savedSuccessfully = bitmap.compress(this.compressFormat, this.compressQuality, (OutputStream)os);
        }
        finally {
            IoUtils.closeSilently(os);
        }
        if (savedSuccessfully) {
            editor.commit();
        } else {
            editor.abort();
        }
        return savedSuccessfully;
    }

    @Override
    public boolean remove(String imageUri) {
        try {
            return this.cache.remove(this.getKey(imageUri));
        }
        catch (IOException e) {
            L.e(e);
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.cache.close();
        }
        catch (IOException e) {
            L.e(e);
        }
        this.cache = null;
    }

    @Override
    public void clear() {
        try {
            this.cache.delete();
        }
        catch (IOException e) {
            L.e(e);
        }
        try {
            this.initCache(this.cache.getDirectory(), this.reserveCacheDir, this.cache.getMaxSize(), this.cache.getMaxFileCount());
        }
        catch (IOException e) {
            L.e(e);
        }
    }

    private String getKey(String imageUri) {
        return this.fileNameGenerator.generate(imageUri);
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setCompressFormat(Bitmap.CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
    }

    public void setCompressQuality(int compressQuality) {
        this.compressQuality = compressQuality;
    }
}

