/*
 * Decompiled with CFR 0.152.
 */
package io.rong.eventbus.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import io.rong.eventbus.EventBus;
import io.rong.eventbus.util.ErrorDialogManager;

public class ErrorDialogFragments {
    public static int ERROR_DIALOG_ICON = 0;
    public static Class<?> EVENT_TYPE_ON_CLICK;

    public static Dialog createDialog(Context context, Bundle arguments, DialogInterface.OnClickListener onClickListener) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)arguments.getString("de.greenrobot.eventbus.errordialog.title"));
        builder.setMessage((CharSequence)arguments.getString("de.greenrobot.eventbus.errordialog.message"));
        if (ERROR_DIALOG_ICON != 0) {
            builder.setIcon(ERROR_DIALOG_ICON);
        }
        builder.setPositiveButton(17039370, onClickListener);
        return builder.create();
    }

    public static void handleOnClick(DialogInterface dialog, int which, Activity activity, Bundle arguments) {
        boolean finish;
        if (EVENT_TYPE_ON_CLICK != null) {
            Object event;
            try {
                event = EVENT_TYPE_ON_CLICK.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Event cannot be constructed", e);
            }
            EventBus eventBus = ErrorDialogManager.factory.config.getEventBus();
            eventBus.post(event);
        }
        if ((finish = arguments.getBoolean("de.greenrobot.eventbus.errordialog.finish_after_dialog", false)) && activity != null) {
            activity.finish();
        }
    }

    public static class Support
    extends DialogFragment
    implements DialogInterface.OnClickListener {
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return ErrorDialogFragments.createDialog((Context)this.getActivity(), this.getArguments(), this);
        }

        public void onClick(DialogInterface dialog, int which) {
            ErrorDialogFragments.handleOnClick(dialog, which, (Activity)this.getActivity(), this.getArguments());
        }
    }

    @TargetApi(value=11)
    public static class Honeycomb
    extends android.app.DialogFragment
    implements DialogInterface.OnClickListener {
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return ErrorDialogFragments.createDialog((Context)this.getActivity(), this.getArguments(), this);
        }

        public void onClick(DialogInterface dialog, int which) {
            ErrorDialogFragments.handleOnClick(dialog, which, this.getActivity(), this.getArguments());
        }
    }
}

