/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc.task;

import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.webrtc.task.PubSubTask;
import cn.rongcloud.rtc.webrtc.task.TaskCustomerThread;
import java.util.concurrent.LinkedBlockingQueue;

public class PubSubTaskQueue {
    private static final String TAG = PubSubTaskQueue.class.getSimpleName();
    private LinkedBlockingQueue<PubSubTask> mTasks = new LinkedBlockingQueue();
    private TaskCustomerThread mTaskCustomer = new TaskCustomerThread(this);

    public PubSubTaskQueue() {
        this.mTaskCustomer.start();
    }

    public void init() {
    }

    public void offerTask(PubSubTask task) {
        task.setCustomer(this.mTaskCustomer);
        this.mTasks.offer(task);
    }

    protected PubSubTask takeTask() {
        PubSubTask task = null;
        try {
            task = this.mTasks.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        return task;
    }

    public void clearTask() {
        this.mTasks.clear();
        this.mTaskCustomer.notifyTask();
    }

    public void stop(final Runnable runnable) {
        FinLog.d(TAG, "stop PubSubTaskQueue");
        this.clearTask();
        this.offerTask(new PubSubTask(null){

            protected AsyncResult handleTask() {
                PubSubTaskQueue.this.mTaskCustomer.onStop();
                if (runnable != null) {
                    runnable.run();
                }
                return null;
            }
        });
    }
}

