/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc.task;

import cn.rongcloud.rtc.api.callback.IRCRTCFailedCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.webrtc.task.TaskCustomerThread;

public abstract class PubSubTask<T>
implements Runnable {
    private TaskCustomerThread mCustomerThread;
    private boolean isSync = true;
    private IRCRTCFailedCallback mCallback;

    public PubSubTask(IRCRTCFailedCallback callback) {
        this.mCallback = callback;
    }

    public void setCustomer(TaskCustomerThread customerThread) {
        this.mCustomerThread = customerThread;
    }

    @Override
    public void run() {
        AsyncResult<T> res = this.handleTask();
        if (this.mCallback != null && res != null) {
            if (res.isFailed()) {
                this.mCallback.onFailed(res.getErrorCode());
            } else if (this.mCallback instanceof IRCRTCResultDataCallback) {
                ((IRCRTCResultDataCallback)this.mCallback).onSuccess(res.getData());
            } else if (this.mCallback instanceof IRCRTCResultCallback) {
                ((IRCRTCResultCallback)this.mCallback).onSuccess();
            }
        }
    }

    protected abstract AsyncResult<T> handleTask();

    public boolean isSync() {
        return this.isSync;
    }
}

