/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc;

import android.content.Context;
import android.util.Pair;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCStatusReportListener;
import cn.rongcloud.rtc.api.report.RTCStatusReportManager;
import cn.rongcloud.rtc.api.stream.RCRTCLiveInfo;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.core.MediaConstraints;
import cn.rongcloud.rtc.core.audio.AudioDeviceModule;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.stat.RongRtcStatMagr;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import cn.rongcloud.rtc.webrtc.IWebRTCCore;
import cn.rongcloud.rtc.webrtc.MediaCommonParams;
import cn.rongcloud.rtc.webrtc.PeerConnectionFactoryHolder;
import cn.rongcloud.rtc.webrtc.RTCConnectionEvents;
import cn.rongcloud.rtc.webrtc.RTCConnectionHolder;
import cn.rongcloud.rtc.webrtc.RTCPubSubManager;
import java.util.List;
import org.json.JSONObject;

public class WebRTCCoreImpl
implements IWebRTCCore {
    private static final String TAG = "WebRTCCoreImpl";
    private Context mContext;
    protected PeerConnectionFactoryHolder mRTCFactory;
    private RTCPubSubManager mPubSubManager;
    private RCRTCConfigImpl mRTCConfig;
    private RTCStatusReportManager mStatusReport;
    private IRCRTCStatusReportListener mStatusReportListener;

    public WebRTCCoreImpl(Context context, RCRTCConfigImpl config, AudioDeviceModule audioDeviceModule, MediaConstraints audioConstraints) {
        this.mContext = context;
        this.mRTCConfig = config;
        this.mRTCFactory = new PeerConnectionFactoryHolder(context, config, audioDeviceModule, audioConstraints);
        SignalManager.getInstance().setObfuscationKeyListener(this.mRTCFactory);
    }

    @Override
    public void initPeerConnection(String userId, int maxStreamCount, RTCConnectionEvents events) throws NullPointerException {
        RTCConnectionHolder mRTCConnection = new RTCConnectionHolder(this.mRTCFactory, this.mRTCConfig, events);
        this.mStatusReport = new RTCStatusReportManager(mRTCConnection, this.mRTCConfig.getStatusReportInterval().intValue());
        this.mStatusReport.setRTCStatusReportListener(this.mStatusReportListener);
        events.setStatusReportManager(this.mStatusReport);
        RongRtcStatMagr.instance.setRTCConnectionHolder(mRTCConnection);
        this.mPubSubManager = new RTCPubSubManager(mRTCConnection, userId, this.mRTCFactory, maxStreamCount, this.mStatusReport);
    }

    @Override
    public void bindingTrack(IStreamResource resource) throws NullPointerException {
        this.mRTCFactory.bindingTrack(resource);
    }

    @Override
    public void publishStream(List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> pubStreams, List<? extends IStreamResource> allSubStreams, MediaCommonParams<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> params) {
        this.mPubSubManager.publishStreams(allPubStreams, pubStreams, allSubStreams, params);
    }

    @Override
    public void unpublishedStreams(List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, List<? extends IStreamResource> unpublishedStreams, MediaCommonParams<List<MediaResourceInfo>> params) {
        this.mPubSubManager.unpublishedStreams(allPubStreams, allSubStreams, unpublishedStreams, params);
    }

    @Override
    public void subscribeStreams(List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, MediaCommonParams params) {
        this.mPubSubManager.subscribeStreams(allPubStreams, allSubStreams, params);
    }

    @Override
    public void unsubscribeStreams(List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, List<? extends IStreamResource> unSubStreams, boolean needExchangeSDP, MediaCommonParams params) {
        this.mPubSubManager.unsubscribeStreams(allPubStreams, allSubStreams, unSubStreams, needExchangeSDP, params);
    }

    @Override
    public void subscribeLiveStream(String liveUrl, RCRTCAVStreamType avStreamType, IRCRTCResultCallback callback) {
        this.mPubSubManager.subscribeLiveStream(liveUrl, avStreamType, callback);
    }

    @Override
    public void exchangeVideoSize(List<? extends IStreamResource> allPubStreams, List<IStreamResource> allSubStreams, MediaCommonParams params) {
        this.mPubSubManager.exchangeVideoSize(allPubStreams, allSubStreams, params);
    }

    @Override
    public void reconnectConnection(boolean forceSendSignal, List<? extends IStreamResource> allPubStreams, List<IStreamResource> allSubStreams, MediaCommonParams<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> params) {
        this.mPubSubManager.reConnected(forceSendSignal, allPubStreams, allSubStreams, params);
    }

    @Override
    public void exchangeRemoteSDP(boolean restartICE, List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, MediaCommonParams<Pair<List<MediaResourceInfo>, JSONObject>> params) {
        this.mPubSubManager.exchangeRemoteSDP(restartICE, allPubStreams, allSubStreams, params);
    }

    @Override
    public void setRTCStatusReportListener(IRCRTCStatusReportListener eventsListener) {
        this.mStatusReportListener = eventsListener;
        if (this.mStatusReport != null) {
            this.mStatusReport.setRTCStatusReportListener(eventsListener);
        }
    }

    @Override
    public void closePeerConnection() {
        FinLog.d(TAG, "closePeerConnection");
        if (this.mPubSubManager != null) {
            this.mPubSubManager.release();
        }
        this.mPubSubManager = null;
        if (this.mStatusReport != null) {
            this.mStatusReport.stop();
        }
        this.mStatusReport = null;
        this.mStatusReportListener = null;
    }

    @Override
    public void release() {
        FinLog.d(TAG, "release");
        this.closePeerConnection();
        if (this.mRTCFactory != null) {
            this.mRTCFactory.release();
        }
        SignalManager.getInstance().setObfuscationKeyListener(null);
    }

    static {
        try {
            System.loadLibrary("_RongRTC_so");
            FinLog.d(TAG, "'lib_RongRTC_so.so' loaded!");
        }
        catch (Exception e) {
            FinLog.e(TAG, e.getMessage());
            throw new RuntimeException("load 'lib_RongRTC_so.so' failed!!");
        }
    }
}

