/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.report.RTCStatusReportManager;
import cn.rongcloud.rtc.api.stream.RCRTCLiveInfo;
import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.stream.RCRTCLiveInfoImpl;
import cn.rongcloud.rtc.core.MediaStream;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.SessionDescription;
import cn.rongcloud.rtc.core.VideoTrack;
import cn.rongcloud.rtc.proxy.ReConnectTool;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.stat.RongRtcStatMagr;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.RTCSDPTools;
import cn.rongcloud.rtc.utils.ResourceTools;
import cn.rongcloud.rtc.webrtc.ILocalVideoStreamResource;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import cn.rongcloud.rtc.webrtc.MediaCommonParams;
import cn.rongcloud.rtc.webrtc.PeerConnectionFactoryHolder;
import cn.rongcloud.rtc.webrtc.RTCConnectionHolder;
import cn.rongcloud.rtc.webrtc.task.PubSubTask;
import cn.rongcloud.rtc.webrtc.task.PubSubTaskQueue;
import io.rong.imlib.model.RTCStatusDate;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class RTCPubSubManager {
    private static final String TAG = "RTCPubSubManager";
    private RTCConnectionHolder mRTCConnection;
    private PeerConnectionFactoryHolder mFactoryManager;
    private PubSubTaskQueue mTaskQueue;
    private String mUserId;
    private int mMaxStreamCount;
    private RTCStatusReportManager mReportManager;

    protected RTCPubSubManager(RTCConnectionHolder rtcConnection, String userId, PeerConnectionFactoryHolder connectionFactoryManager, int maxStreamCount, RTCStatusReportManager reportManager) throws NullPointerException {
        this.mRTCConnection = rtcConnection;
        this.mUserId = userId;
        this.mFactoryManager = connectionFactoryManager;
        this.mMaxStreamCount = maxStreamCount;
        this.mTaskQueue = new PubSubTaskQueue();
        this.mReportManager = reportManager;
    }

    public void publishStreams(final List<? extends IStreamResource> allPubStreams, final List<? extends IStreamResource> pubStreams, final List<? extends IStreamResource> allSubStreams, final MediaCommonParams params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncPublishStreams(false, params, allPubStreams, pubStreams, allSubStreams);
            }
        });
    }

    public AsyncResult<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> syncPublishStreams(boolean restartICE, MediaCommonParams params, List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> pubStreams, List<? extends IStreamResource> allSubStreams) {
        if (!this.isAllowPubSub()) {
            return AsyncResult.create(RTCErrorCode.RongRTCCodeRTCConnectionIsNull).getResult();
        }
        if (this.isEmpty(pubStreams)) {
            return AsyncResult.create(RTCErrorCode.RongRTCCodeParameterError).getResult();
        }
        for (IStreamResource iStreamResource : pubStreams) {
            if (this.mRTCConnection.getPublishedStreamSize() > this.mMaxStreamCount) {
                return AsyncResult.create(RTCErrorCode.RongRTCCodePublishStreamsHasReachedMaxCount).getResult();
            }
            MediaStream stream = this.getAndCreateLocalMediaStream(iStreamResource.getStreamId());
            this.mFactoryManager.bindingTrack(iStreamResource);
            if (!this.mRTCConnection.addStream(stream)) {
                return AsyncResult.create(RTCErrorCode.ConnectionAddStreamFailed).getResult();
            }
            if (iStreamResource instanceof ILocalVideoStreamResource && ((ILocalVideoStreamResource)iStreamResource).isPreserved()) {
                VideoTrack track = (VideoTrack)iStreamResource.getTrack();
                stream.addPreservedTrack(track);
            } else {
                stream.addTrack(iStreamResource.getTrack());
            }
            this.mRTCConnection.bindStreamEncryption(iStreamResource.getTrack());
            this.mReportManager.addReport(this.mUserId, stream.getId(), iStreamResource.getTrack().id());
        }
        AsyncResult<Pair<List<MediaResourceInfo>, JSONObject>> exchangeResult = this.syncExchangeRemoteSDP(restartICE, allPubStreams, allSubStreams, params);
        if (exchangeResult.isFailed()) {
            return this.onPublishFailed(params.roomId, exchangeResult.getErrorCode(), pubStreams);
        }
        List list = (List)exchangeResult.getData().first;
        FinLog.i(TAG, "publish-exchangeRemoteSDP success");
        AsyncResult putResult = this.syncSendIMSignal(params.roomId, allPubStreams, pubStreams, list);
        if (putResult.isFailed()) {
            return this.onPublishFailed(params.roomId, putResult.getErrorCode(), pubStreams);
        }
        RongRtcStatMagr.instance.reportPublish(true, pubStreams);
        AsyncResult<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> res = this.getExchangeSDPDataResult(params.roomId, params.roomType, exchangeResult, list);
        return res;
    }

    private AsyncResult<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> getExchangeSDPDataResult(String roomId, RCRTCRoomType roomType, AsyncResult<Pair<List<MediaResourceInfo>, JSONObject>> exchangeResult, List<MediaResourceInfo> publishMediaInfoList) {
        AsyncResult.TemporaryResult res = AsyncResult.create();
        if (roomType != RCRTCRoomType.MEETING) {
            JSONObject extra = (JSONObject)exchangeResult.getData().second;
            if (extra != null) {
                JSONObject jsonObject = extra;
                try {
                    String liveUrl = jsonObject.has("liveUrl") ? jsonObject.getString("liveUrl") : null;
                    RCRTCLiveInfoImpl liveRoom = new RCRTCLiveInfoImpl(roomId, liveUrl, this.mUserId, jsonObject.optString("configUrl"));
                    res.setAndNotify(Pair.create(publishMediaInfoList, (Object)liveRoom));
                }
                catch (Exception e) {
                    FinLog.e(TAG, e.getMessage());
                    res.setAndNotify(RTCErrorCode.JsonParseError);
                }
            } else {
                res.setAndNotify(RTCErrorCode.LiveInfoIsNull);
            }
        } else {
            res.setAndNotify(Pair.create(publishMediaInfoList, null));
        }
        return res.getResult();
    }

    /*
     * WARNING - void declaration
     */
    private AsyncResult syncSendIMSignal(String roomId, List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> pubStreams, List<MediaResourceInfo> publishMediaInfoList) {
        void var9_12;
        ResourceTools.RepublishInfo republishInfo = ResourceTools.getUnpubJSON(publishMediaInfoList, allPubStreams);
        String publish = this.mediaResourceInfoListToJson(publishMediaInfoList);
        ArrayList<MediaResourceInfo> mediaResourceInfos = new ArrayList<MediaResourceInfo>();
        if (!this.isEmpty(pubStreams)) {
            block0: for (IStreamResource iStreamResource : pubStreams) {
                for (MediaResourceInfo mediaResourceInfo : publishMediaInfoList) {
                    if (iStreamResource.getMediaType() != mediaResourceInfo.getType() || !TextUtils.equals((CharSequence)iStreamResource.getTag(), (CharSequence)mediaResourceInfo.getTag())) continue;
                    mediaResourceInfos.add(mediaResourceInfo);
                    continue block0;
                }
            }
        }
        RTCStatusDate[] kv = new RTCStatusDate[]{ResourceTools.getStatusDate("uris", publish)};
        if (republishInfo != null) {
            FinLog.e(TAG, "publishResource()->needUnpub:" + republishInfo.getUnpub_JSON());
            RTCStatusDate[] rTCStatusDateArray = new RTCStatusDate[2];
            rTCStatusDateArray[0] = ResourceTools.getStatusDate("RCRTC:UnpublishResource", republishInfo.getUnpub_JSON());
            if (republishInfo.getRepubList().size() > 0) {
                mediaResourceInfos.addAll(republishInfo.getRepubList());
            }
            rTCStatusDateArray[1] = ResourceTools.getStatusDate("RCRTC:PublishResource", ResourceTools.getURIS(mediaResourceInfos, true, ""));
        } else {
            RTCStatusDate[] rTCStatusDateArray = new RTCStatusDate[]{ResourceTools.getStatusDate("RCRTC:PublishResource", ResourceTools.getURIS(mediaResourceInfos, true, ""))};
        }
        return SignalManager.getInstance().syncRTCSetUserResource(roomId, kv, "RCRTC:TotalContentResources", (RTCStatusDate[])var9_12);
    }

    public void reConnected(final boolean forceSendSignal, final List<? extends IStreamResource> allPubStreams, final List<? extends IStreamResource> allSubStreams, final MediaCommonParams<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncReConnected(forceSendSignal, allPubStreams, allSubStreams, params);
            }
        });
    }

    private AsyncResult<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> syncReConnected(boolean forceSendSignal, List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, MediaCommonParams params) {
        AsyncResult<Pair<List<MediaResourceInfo>, JSONObject>> exchangeResult = this.syncExchangeRemoteSDP(true, allPubStreams, allSubStreams, params);
        if (exchangeResult.isFailed()) {
            return AsyncResult.convert(exchangeResult);
        }
        List publishMediaInfoList = (List)exchangeResult.getData().first;
        AsyncResult result = ReConnectTool.sendSourceMessage(params.roomId, forceSendSignal, publishMediaInfoList, allPubStreams);
        if (result.isFailed()) {
            return AsyncResult.convert(result);
        }
        return this.getExchangeSDPDataResult(params.roomId, params.roomType, exchangeResult, publishMediaInfoList);
    }

    public void exchangeRemoteSDP(final boolean restartICE, final List<? extends IStreamResource> allPubStreams, final List<? extends IStreamResource> allSubStreams, final MediaCommonParams<Pair<List<MediaResourceInfo>, JSONObject>> params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncExchangeRemoteSDP(restartICE, allPubStreams, allSubStreams, params);
            }
        });
    }

    private AsyncResult<Pair<List<MediaResourceInfo>, JSONObject>> syncExchangeRemoteSDP(boolean restartICE, List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, MediaCommonParams params) {
        int totalMinBitRate;
        RTCConnectionHolder rtcConnection = this.mRTCConnection;
        if (!this.isAllowPubSub()) {
            return AsyncResult.create(RTCErrorCode.RongRTCCodeRTCConnectionIsNull).getResult();
        }
        int totalMaxBitRate = RTCSDPTools.getTotalMaxBitRate(allPubStreams);
        AsyncResult<SessionDescription> sdpResult = rtcConnection.syncCreateAndSetOffer(params.roomId, restartICE, totalMaxBitRate);
        if (sdpResult.isFailed()) {
            return AsyncResult.convert(sdpResult);
        }
        AsyncResult<Object[]> sendSDPResult = SignalManager.getInstance().syncSendSDPOffer(params.roomId, sdpResult.getData(), params.clientSessionId, allPubStreams, allSubStreams, params.roomType, params.autoMixJSONInfo, params.role);
        if (sendSDPResult.isFailed()) {
            return AsyncResult.convert(sendSDPResult);
        }
        if (!this.isAllowPubSub()) {
            return AsyncResult.create(RTCErrorCode.RongRTCCodeRTCConnectionIsNull).getResult();
        }
        SessionDescription remoteSDP = (SessionDescription)sendSDPResult.getData()[0];
        AsyncResult setResult = rtcConnection.syncSetRemoteDescription(remoteSDP, totalMaxBitRate, totalMinBitRate = RTCSDPTools.getTotalMinBitRate(allPubStreams));
        if (setResult.isFailed()) {
            return AsyncResult.convert(setResult);
        }
        List publishMediaInfoList = (List)sendSDPResult.getData()[1];
        block0: for (IStreamResource iStreamResource : allPubStreams) {
            for (MediaResourceInfo info : publishMediaInfoList) {
                if (!TextUtils.equals((CharSequence)info.getTag(), (CharSequence)iStreamResource.getTag()) || info.getType() != iStreamResource.getMediaType()) continue;
                info.setRCRTCResourceState(iStreamResource.getResourceState());
                continue block0;
            }
        }
        JSONObject extra = null;
        if (sendSDPResult.getData().length > 2) {
            extra = (JSONObject)sendSDPResult.getData()[2];
        }
        return AsyncResult.create(Pair.create((Object)publishMediaInfoList, extra)).getResult();
    }

    private AsyncResult onPublishFailed(String roomId, RTCErrorCode errorCode, List<? extends IStreamResource> pubStreamResources) {
        if (this.isAllowPubSub()) {
            RTCConnectionHolder connectionClient = this.mRTCConnection;
            this.removeStreams(pubStreamResources, connectionClient);
        }
        return AsyncResult.create(errorCode).getResult();
    }

    private void removeStreams(List<? extends IStreamResource> streamResources, RTCConnectionHolder connectionClient) {
        for (IStreamResource iStreamResource : streamResources) {
            MediaStream mediaStream = connectionClient.getMediaStream(iStreamResource.getStreamId());
            MediaStreamTrack track = iStreamResource.getTrack();
            if (mediaStream == null) continue;
            if (track != null) {
                this.mReportManager.removeReport(track.id());
                mediaStream.removeTrack(track);
            }
            if (mediaStream.getAllTrackSize() != 0) continue;
            connectionClient.removeStream(mediaStream);
            mediaStream.dispose();
        }
    }

    public void unpublishedStreams(final List<? extends IStreamResource> allPubStreams, final List<? extends IStreamResource> allSubStreams, final List<? extends IStreamResource> unpublishedStreams, final MediaCommonParams<List<MediaResourceInfo>> params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncUnpublishedStreams(allPubStreams, allSubStreams, unpublishedStreams, params);
            }
        });
    }

    private AsyncResult<List<MediaResourceInfo>> syncUnpublishedStreams(List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, List<? extends IStreamResource> unpublishedStreams, MediaCommonParams<List<MediaResourceInfo>> params) {
        Log.i((String)TAG, (String)"syncUnpublishedStreams");
        if (!this.isAllowPubSub()) {
            return AsyncResult.create(RTCErrorCode.RongRTCCodeRTCConnectionIsNull).getResult();
        }
        this.removeStreams(unpublishedStreams, this.mRTCConnection);
        AsyncResult<Pair<List<MediaResourceInfo>, JSONObject>> exchangeResult = this.syncExchangeRemoteSDP(false, allPubStreams, allSubStreams, params);
        if (exchangeResult.isFailed()) {
            return AsyncResult.convert(exchangeResult);
        }
        List publishMediaInfoList = (List)exchangeResult.getData().first;
        String publish = this.mediaResourceInfoListToJson(publishMediaInfoList);
        FinLog.d(TAG, "publish = " + publish);
        ResourceTools.RepublishInfo republishInfo = ResourceTools.getUnpubJSON(publishMediaInfoList, allPubStreams);
        RTCStatusDate[] kv = new RTCStatusDate[]{ResourceTools.getStatusDate("uris", publish)};
        RTCStatusDate[] content = null;
        ArrayList<MediaResourceInfo> unPublishResourceList = new ArrayList<MediaResourceInfo>();
        for (IStreamResource iStreamResource : unpublishedStreams) {
            unPublishResourceList.add(new MediaResourceInfo(iStreamResource));
        }
        if (republishInfo != null) {
            content = new RTCStatusDate[2];
            unPublishResourceList.addAll(republishInfo.getNeedUnpublist());
            content[0] = ResourceTools.getStatusDate("RCRTC:UnpublishResource", ResourceTools.getURIS(unPublishResourceList, true, ""));
            content[1] = ResourceTools.getStatusDate("RCRTC:PublishResource", ResourceTools.getURIS(unPublishResourceList, true, ""));
        } else {
            content = new RTCStatusDate[]{ResourceTools.getStatusDate("RCRTC:UnpublishResource", ResourceTools.getURIS(unPublishResourceList, true, ""))};
        }
        AsyncResult result = SignalManager.getInstance().syncRTCSetUserResource(params.roomId, kv, "RCRTC:TotalContentResources", content);
        if (result.isFailed()) {
            return result;
        }
        RongRtcStatMagr.instance.reportPublish(false, unpublishedStreams);
        return AsyncResult.create(publishMediaInfoList).getResult();
    }

    private MediaStream getAndCreateLocalMediaStream(String streamId) {
        MediaStream mediaStream = this.mRTCConnection.getMediaStream(streamId);
        if (mediaStream != null) {
            return mediaStream;
        }
        mediaStream = this.mFactoryManager.createLocalMediaStream(streamId);
        return mediaStream;
    }

    private String mediaResourceInfoListToJson(List<MediaResourceInfo> mediaResourceInfoList) {
        String publishData = "[]";
        if (mediaResourceInfoList != null) {
            JSONArray jsonArray = new JSONArray();
            for (MediaResourceInfo mediaResourceInfo : mediaResourceInfoList) {
                jsonArray.put((Object)mediaResourceInfo.getJsonObject());
            }
            publishData = jsonArray.toString();
        }
        return publishData;
    }

    public void subscribeStreams(final List<? extends IStreamResource> publishedStreams, final List<? extends IStreamResource> subscribedStreams, final MediaCommonParams params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncSubscribeStreams(publishedStreams, subscribedStreams, params);
            }
        });
    }

    private AsyncResult syncSubscribeStreams(List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, MediaCommonParams params) {
        long currentTime = System.currentTimeMillis();
        FinLog.d(TAG, "subscribeResources() run");
        if (!this.isAllowPubSub()) {
            return AsyncResult.create(RTCErrorCode.RongRTCCodeRTCConnectionIsNull).getResult();
        }
        AsyncResult result = this.subscribeRemoteSDP(allPubStreams, allSubStreams, false, params);
        if (result.isFailed()) {
            FinLog.e(TAG, "subscribeResources onFailed() errorCode: " + (Object)((Object)result.getErrorCode()));
        } else {
            long endTime = System.currentTimeMillis();
            FinLog.d(TAG, "subscribeResources onSuccess() costTime = " + (endTime - currentTime));
        }
        return result;
    }

    public AsyncResult subscribeRemoteSDP(List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, boolean needExchangeSDP, MediaCommonParams params) {
        FinLog.i(TAG, "subscribeRemoteSDP . needExchangeSDP :" + needExchangeSDP);
        if (needExchangeSDP) {
            return this.syncExchangeRemoteSDP(false, allPubStreams, allSubStreams, params);
        }
        if (this.mRTCConnection.everOfferIsCreated()) {
            AsyncResult<SessionDescription> res = SignalManager.getInstance().syncSubscribeSDP(params.roomId, params.roomType, params.clientSessionId, allSubStreams, allPubStreams);
            if (res.isFailed()) {
                FinLog.e(TAG, "subscribeSDP error: " + (Object)((Object)res.getErrorCode()));
                return res;
            }
            if (!this.isAllowPubSub()) {
                return AsyncResult.create(RTCErrorCode.RongRTCCodeRTCConnectionIsNull).getResult();
            }
            FinLog.i(TAG, "subscribeRemoteSDP subscribeSDP onSuccess");
            AsyncResult setResult = this.mRTCConnection.syncSetRemoteDescription(res.getData(), RTCSDPTools.getTotalMaxBitRate(allPubStreams), RTCSDPTools.getTotalMinBitRate(allPubStreams));
            if (setResult.isFailed()) {
                FinLog.e(TAG, "setRemoteDescription error: " + (Object)((Object)setResult.getErrorCode()));
                return setResult;
            }
            FinLog.i(TAG, "subscribeRemoteSDP subscribeSDP onRemoteSdpSetSuccess");
            return this.mRTCConnection.syncCreateAnswer(params.roomId);
        }
        return this.syncExchangeRemoteSDP(false, allPubStreams, allSubStreams, params);
    }

    public void unsubscribeStreams(final List<? extends IStreamResource> allPubStreams, final List<? extends IStreamResource> allSubStreams, final List<? extends IStreamResource> unSubStreams, final boolean needExchangeSDP, final MediaCommonParams params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncUnsubscribeResources(allPubStreams, allSubStreams, unSubStreams, needExchangeSDP, params);
            }
        });
    }

    public AsyncResult syncUnsubscribeResources(List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, List<? extends IStreamResource> unSubStreams, boolean needExchangeSDP, MediaCommonParams params) {
        FinLog.i(TAG, "syncUnsubscribeResources run()");
        if (!this.isAllowPubSub()) {
            FinLog.e(TAG, "PeerConnection Is Released");
            return AsyncResult.create(RTCErrorCode.RongRTCCodeRTCConnectionIsNull).getResult();
        }
        AsyncResult result = this.subscribeRemoteSDP(allPubStreams, allSubStreams, needExchangeSDP, params);
        if (result.isFailed()) {
            return result;
        }
        RongRtcStatMagr.instance.reportUnSubscribe(unSubStreams);
        return result;
    }

    public void subscribeLiveStream(final String liveUrl, final RCRTCAVStreamType avStreamType, IRCRTCResultCallback callback) {
        this.offerTask(new PubSubTask(callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncSubscribeLiveStream(liveUrl, avStreamType);
            }
        });
    }

    public AsyncResult syncSubscribeLiveStream(String liveUrl, RCRTCAVStreamType avStreamType) {
        long currentTime = System.currentTimeMillis();
        FinLog.i(TAG, "subscribeLiveResources() run -- " + liveUrl);
        if (!this.isAllowPubSub()) {
            FinLog.i(TAG, "subscribeLiveResources() run -- onFailed RongRTCCodeRTCConnectionIsNull");
            return AsyncResult.create(RTCErrorCode.RongRTCCodeRTCConnectionIsNull).getResult();
        }
        AsyncResult<SessionDescription> sdpResult = this.mRTCConnection.syncCreateAndSetOffer("", false, 0);
        if (sdpResult.isFailed()) {
            return sdpResult;
        }
        FinLog.d(TAG, "subscribeLiveSDP onLocalSdpSetSuccess ");
        AsyncResult<SessionDescription> subResult = SignalManager.getInstance().syncSubscribeLive(sdpResult.getData(), liveUrl, avStreamType);
        if (subResult.isFailed()) {
            return subResult;
        }
        AsyncResult setResult = this.mRTCConnection.syncSetRemoteDescription(subResult.getData(), 0, 0);
        if (setResult.isFailed()) {
            return setResult;
        }
        long endTime = System.currentTimeMillis();
        FinLog.i(TAG, "subscribeLiveSDP onSuccess() costTime = " + (endTime - currentTime));
        return setResult;
    }

    public void exchangeVideoSize(final List<? extends IStreamResource> allPubStreams, final List<IStreamResource> allSubStreams, final MediaCommonParams params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncExchangeVideoSize(allPubStreams, allSubStreams, params);
            }
        });
    }

    private AsyncResult syncExchangeVideoSize(List<? extends IStreamResource> allPubStreams, List<IStreamResource> allSubStreams, MediaCommonParams params) {
        AsyncResult<Pair<List<MediaResourceInfo>, JSONObject>> res = this.syncExchangeRemoteSDP(false, allPubStreams, allSubStreams, params);
        if (res.isFailed()) {
            return res;
        }
        return SignalManager.getInstance().syncResolutionChanged(params.roomId, params.roomType, params.clientSessionId, allPubStreams);
    }

    private boolean isAllowPubSub() {
        return this.mRTCConnection != null && this.mRTCConnection.isAvailable() && this.mFactoryManager != null;
    }

    private boolean isEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public void offerTask(PubSubTask task) {
        if (this.mTaskQueue != null) {
            this.mTaskQueue.offerTask(task);
        }
    }

    public void clearTask() {
        if (this.mTaskQueue != null) {
            this.mTaskQueue.clearTask();
        }
    }

    public void release() {
        this.mTaskQueue.stop(new Runnable(){

            @Override
            public void run() {
            }
        });
        this.mTaskQueue = null;
        this.mRTCConnection.release();
        this.mRTCConnection = null;
    }
}

