/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc;

import android.text.TextUtils;
import cn.rongcloud.rtc.api.report.RTCStatusReportManager;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.core.IceCandidate;
import cn.rongcloud.rtc.core.MediaStream;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.RtpReceiver;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.stat.RongRtcStatMagr;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.util.HashMap;

public class RTCConnectionEvents {
    private RTCStatusReportManager mStatusReportManager;

    public void setStatusReportManager(RTCStatusReportManager statusReport) {
        this.mStatusReportManager = statusReport;
    }

    public void onIceCandidate(IceCandidate candidate) {
    }

    public void onIceCandidatesRemoved(IceCandidate[] candidates) {
    }

    public void onIceConnected() {
    }

    public void onIceDisconnected() {
        RTCEngineImpl.getInstance().sendMessage(8000, new Object[0]);
    }

    public void onRTCConnectionError(String description) {
    }

    public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
        String userId;
        String streamId = "";
        MediaStream mediaStream = null;
        if (mediaStreams != null && mediaStreams.length >= 1) {
            mediaStream = mediaStreams[0];
            streamId = mediaStream.getId();
        }
        MediaStreamTrack track = receiver.track();
        String trackId = track.id();
        ReportUtil.libStatus(ReportUtil.TAG.ONADDTRACK, "media|trackId|streamId", track.kind(), trackId, streamId);
        String realUserId = userId = streamId;
        String tag = "";
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            if (RTCEngineImpl.getInstance().version2UserIDs.containsKey(userId)) {
                realUserId = userId;
            } else {
                int n = userId.lastIndexOf(95);
                if (n > 0 && n < userId.length()) {
                    realUserId = userId.substring(0, n);
                    if (n < userId.length() - 1) {
                        tag = userId.substring(n + 1, userId.length());
                    }
                }
            }
        }
        RCRTCMediaType videoType = RCRTCMediaType.AUDIO.getDescription().equals(track.kind()) ? RCRTCMediaType.AUDIO : RCRTCMediaType.VIDEO;
        HashMap<MediaStream, MediaStreamTrack> steams = new HashMap<MediaStream, MediaStreamTrack>();
        if (mediaStream != null) {
            steams.put(mediaStream, track);
        }
        RTCEngineImpl.getInstance().sendMessage(2060, new Object[]{realUserId, tag, videoType, track});
        RongRtcStatMagr.instance.reportSubscribe(steams);
        this.mStatusReportManager.addReport(realUserId, streamId, trackId);
    }

    public void onRemoveStream(MediaStream stream) {
    }
}

