/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.core.AudioSource;
import cn.rongcloud.rtc.core.AudioTrack;
import cn.rongcloud.rtc.core.DefaultVideoDecoderFactory;
import cn.rongcloud.rtc.core.DefaultVideoEncoderFactory;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.MediaConstraints;
import cn.rongcloud.rtc.core.MediaStream;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.PeerConnection;
import cn.rongcloud.rtc.core.PeerConnectionFactory;
import cn.rongcloud.rtc.core.SoftwareVideoDecoderFactory;
import cn.rongcloud.rtc.core.SoftwareVideoEncoderFactory;
import cn.rongcloud.rtc.core.VideoDecoderFactory;
import cn.rongcloud.rtc.core.VideoEncoderFactory;
import cn.rongcloud.rtc.core.VideoSource;
import cn.rongcloud.rtc.core.VideoTrack;
import cn.rongcloud.rtc.core.audio.AudioDeviceModule;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.signal.IUpdateUdpObfuscationKeyListener;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.webrtc.ILocalVideoStreamResource;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import cn.rongcloud.rtc.webrtc.RTCConnectionHolder;
import io.rong.common.RLog;
import java.util.ArrayList;
import java.util.List;

public class PeerConnectionFactoryHolder
implements IUpdateUdpObfuscationKeyListener {
    private static final String TAG = "PCFactoryHolder";
    private PeerConnectionFactory factory;
    private MediaConstraints audioConstraints;
    private static final boolean UDP_ENCRYPT_SUPPORT = true;
    private List<VideoTrack> mPreservedTracks = new ArrayList<VideoTrack>();

    public PeerConnectionFactoryHolder(Context context, RCRTCConfigImpl rtcConfig, AudioDeviceModule audioDeviceModule, MediaConstraints audioConstraints) {
        Log.d((String)TAG, (String)("PeerConnectionFactoryHolder: jch" + audioConstraints));
        this.audioConstraints = audioConstraints;
        this.createRongRTCConnectionFactory(context, rtcConfig, audioDeviceModule);
    }

    private void createRongRTCConnectionFactory(Context context, RCRTCConfigImpl rongRTCConfig, AudioDeviceModule audioDeviceModule) {
        try {
            VideoDecoderFactory decoderFactory;
            VideoEncoderFactory encoderFactory;
            FinLog.v(TAG, "createRongRTCConnectionFactory");
            if (this.factory != null) {
                FinLog.v(TAG, "factory is not null!  " + this.factory);
                return;
            }
            FinLog.d(TAG, "rtcConfig - " + rongRTCConfig.toString());
            PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
            options.disableNetworkMonitor = true;
            options.disableEncryption = true;
            if (rongRTCConfig.isSRTPEnable()) {
                options.disableEncryption = false;
            }
            PeerConnectionFactory.initialize(PeerConnectionFactory.InitializationOptions.builder(context).setFieldTrials("WebRTC-TimestampOffsetAdvertised/Enabled/WebRTC-AbsSendAdvertised/Enabled/WebRTC-AudioLevelAdvertised/Enabled/").setEnableInternalTracer(true).createInitializationOptions());
            EglBase.Context eglContext = rongRTCConfig.isEncoderTexture() ? RTCEngineImpl.getInstance().getEglBaseContext() : null;
            FinLog.d(TAG, "videoConfig: isHardWareEncode " + rongRTCConfig.isHardWareEncoder());
            if (!rongRTCConfig.isHardWareEncoder()) {
                FinLog.e(TAG, "No use HW encoder !");
                encoderFactory = new SoftwareVideoEncoderFactory();
            } else {
                encoderFactory = new DefaultVideoEncoderFactory(eglContext, true, rongRTCConfig.isEncoderHighProfile());
            }
            FinLog.v(TAG, "videoConfig: isHardWareDecode " + rongRTCConfig.isHardWareDecoder());
            if (!rongRTCConfig.isHardWareDecoder()) {
                FinLog.e(TAG, "No use HW decoder !");
                decoderFactory = new SoftwareVideoDecoderFactory();
            } else {
                decoderFactory = new DefaultVideoDecoderFactory(eglContext);
            }
            FinLog.v(TAG, "audioConfig: audioSource " + rongRTCConfig.getAudioSource() + " sampleRate " + rongRTCConfig.getAudioSampleRate() + " is stereo = " + rongRTCConfig.isStereo());
            this.factory = PeerConnectionFactory.builder().setOptions(options).setVideoDecoderFactory(decoderFactory).setVideoEncoderFactory(encoderFactory).setAudioDeviceModule(audioDeviceModule).createPeerConnectionFactory();
            Log.d((String)TAG, (String)"createRongRTCConnectionFactory: end");
        }
        catch (Exception e) {
            FinLog.e(TAG, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bindingTrack(IStreamResource resource) {
        if (resource == null || TextUtils.isEmpty((CharSequence)resource.getTag()) || TextUtils.isEmpty((CharSequence)resource.getStreamId())) {
            return false;
        }
        PeerConnectionFactoryHolder peerConnectionFactoryHolder = this;
        synchronized (peerConnectionFactoryHolder) {
            if (resource.getTrack() == null) {
                resource.setTrack(this.createTrack(resource));
            }
        }
        return true;
    }

    public MediaStreamTrack createTrack(IStreamResource resouce) throws NullPointerException {
        if (this.factory == null) {
            throw new NullPointerException("PeerConnectionFactory is Null");
        }
        if (resouce instanceof ILocalVideoStreamResource) {
            return this.onCreateVideoTrack((ILocalVideoStreamResource)resouce);
        }
        return this.onCreateAudioTrack(resouce);
    }

    private MediaStreamTrack onCreateAudioTrack(IStreamResource resource) {
        RLog.d((String)TAG, (String)("getAudioTrack: " + this.audioConstraints.toString()));
        Log.d((String)TAG, (String)("onCreateAudioTrack:jch " + this.audioConstraints.toString()));
        AudioSource audioSource = this.factory.createAudioSource(this.audioConstraints);
        AudioTrack audioTrack = this.factory.createAudioTrack(resource.getStreamId() + "_" + RCRTCMediaType.AUDIO.getDescription(), audioSource);
        audioTrack.setAudioSource(audioSource);
        audioTrack.setEnabled(true);
        return audioTrack;
    }

    private VideoTrack onCreateVideoTrack(ILocalVideoStreamResource resource) {
        VideoSource videoSource = this.factory.createVideoSource(resource.isScreencast());
        videoSource.adaptOutputFormat(resource.getHeight(), resource.getWidth(), resource.getVideoFps().getFps());
        VideoTrack videoTrack = this.factory.createVideoTrack(resource.getStreamId() + "_" + RCRTCMediaType.VIDEO.getDescription(), videoSource);
        videoTrack.setVideoSource(videoSource);
        if (resource.isPreserved()) {
            this.mPreservedTracks.add(videoTrack);
        }
        return videoTrack;
    }

    public void disposePreservedTracks() {
        for (VideoTrack track : this.mPreservedTracks) {
            try {
                track.dispose();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mPreservedTracks.clear();
    }

    public void release() {
        FinLog.d(TAG, "release");
        this.disposePreservedTracks();
        if (this.factory != null) {
            this.factory.dispose();
        }
        this.factory = null;
    }

    public MediaStream createLocalMediaStream(String streamId) {
        if (this.factory == null) {
            throw new NullPointerException("PeerConnectionFactory is Null");
        }
        return this.factory.createLocalMediaStream(streamId);
    }

    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rtcConfig, MediaConstraints pcConstraints, RTCConnectionHolder.PCObserver pcObserver) {
        if (this.factory == null) {
            return null;
        }
        return this.factory.createPeerConnection(rtcConfig, pcConstraints, (PeerConnection.Observer)pcObserver);
    }

    @Override
    public void onUpdate(String key) {
        PeerConnectionFactory.initializeFieldTrials("RongcloudUdpEncryptKey/" + key + "/");
    }
}

