/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.hardware.Camera;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.utils.FinLog;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

public class RongRTCUtils {
    public static boolean customRate = false;
    public static boolean VIDEOMODE = false;
    public static boolean isMediaStreamTiny = true;
    public static boolean customFPS = false;
    public static int cameraId = -1;

    public static InputStream downLoadFromUrl(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(3000);
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        InputStream inputStream = conn.getInputStream();
        return inputStream;
    }

    public static String byteArrayToStr(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        String str = new String(byteArray);
        return str;
    }

    public static double div(double vl1, double vl2) {
        BigDecimal b1 = BigDecimal.valueOf(vl1);
        BigDecimal b2 = BigDecimal.valueOf(vl2);
        return b1.divide(b2, 4, 4).doubleValue();
    }

    public static double formatDouble4(double d) {
        BigDecimal bg = BigDecimal.valueOf(d).setScale(4, RoundingMode.HALF_UP);
        return bg.doubleValue();
    }

    public static int getInt(double number) {
        BigDecimal bd = BigDecimal.valueOf(number).setScale(0, 4);
        return Integer.parseInt(bd.toString());
    }

    public static Process executeCommand(String command) throws IOException, InterruptedException, TimeoutException {
        Process process = Runtime.getRuntime().exec(command);
        Worker worker = new Worker(process);
        worker.start();
        try {
            worker.join(20000L);
            if (worker.exit != null) {
                return process;
            }
        }
        catch (InterruptedException ex) {
            worker.interrupt();
            Thread.currentThread().interrupt();
        }
        process.destroy();
        process = null;
        return process;
    }

    public static String StringFormat(String format, Object ... args) {
        return String.format(Locale.ENGLISH, format, args);
    }

    public static String getDeviceName() {
        if (cameraId == -1) {
            return null;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        }
        catch (Exception e) {
            FinLog.e("RongRTCUtils", "getCameraInfo failed on index " + cameraId + "  e:" + e);
            return "Unknown";
        }
        String facing = info.facing == 1 ? "front" : "back";
        return "Camera " + cameraId + ", Facing " + facing + ", Orientation " + info.orientation;
    }

    public static boolean resourceNotExist(List<RCRTCInputStream> streamListA, List<? extends RCRTCInputStream> streamListB) {
        boolean tag = true;
        block0: for (int i = 0; i < streamListA.size(); ++i) {
            if (streamListA.get(i) == null) continue;
            for (RCRTCInputStream rCRTCInputStream : streamListB) {
                if (rCRTCInputStream == null) continue;
                String mediaId_A = streamListA.get(i).getStreamId();
                String mediaId_B = rCRTCInputStream.getStreamId();
                if (TextUtils.isEmpty((CharSequence)mediaId_A) || !TextUtils.equals((CharSequence)mediaId_A, (CharSequence)mediaId_B) || streamListA.get(i).getMediaType() != rCRTCInputStream.getMediaType()) continue;
                tag = false;
                break block0;
            }
        }
        return tag;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static String createRoomKey(String inviterRoomId, String inviteeRoomId) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(inviterRoomId);
        stringBuffer.append("|");
        stringBuffer.append(inviteeRoomId);
        return stringBuffer.toString();
    }

    public static String createInviteSessionId(String inviteeRoomId, String inviteeUserId) {
        StringBuffer sb = new StringBuffer();
        String roomId = "";
        roomId = inviteeRoomId.length() > 10 ? inviteeRoomId.substring(0, 10) : inviteeRoomId;
        sb.append(roomId);
        sb.append("_");
        String userId = "";
        userId = inviteeUserId.length() > 10 ? inviteeUserId.substring(0, 10) : inviteeUserId;
        sb.append(userId);
        sb.append("_");
        sb.append(System.currentTimeMillis());
        sb.append("_");
        SecureRandom random = new SecureRandom();
        String randomNum = String.valueOf(random.nextInt(9000) + 1000);
        sb.append(randomNum);
        return sb.toString();
    }

    public static String getUserProfile(String extra) {
        String remoteRoomId = null;
        if (!TextUtils.isEmpty((CharSequence)extra)) {
            try {
                JSONObject jsonExtra = new JSONObject(extra);
                if (jsonExtra != null && jsonExtra.has("roomId")) {
                    remoteRoomId = jsonExtra.getString("roomId");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return remoteRoomId;
    }

    public static String append(String ... values) {
        StringBuilder stringBuilder = new StringBuilder();
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(values[i]);
            if (i >= length - 1) continue;
            stringBuilder.append("|");
        }
        return stringBuilder.toString();
    }

    private static class Worker
    extends Thread {
        private final Process process;
        private Integer exit;

        private Worker(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                this.exit = this.process.waitFor();
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

