/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.text.TextUtils;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.center.stream.RCOutputStreamImpl;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import io.rong.common.RLog;
import io.rong.imlib.model.RTCStatusDate;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceTools {
    private static final String TAG = "ResourceTools";
    public static final String OBJ_NAME_TOTAL_CONTENT = "RCRTC:TotalContentResources";
    public static final String OBJ_NAME_PUBLISH = "RCRTC:PublishResource";
    public static final String KEY_URIS = "uris";
    public static final String OBJ_NAME_MODIFY = "RCRTC:ModifyResource";
    public static final String OBJ_NAME_UNPUBLISH = "RCRTC:UnpublishResource";

    public static String getURIS(List<MediaResourceInfo> uris, boolean ignore, String extra) {
        JSONObject jsonObj = new JSONObject();
        try {
            JSONArray jsonArray = new JSONArray();
            for (MediaResourceInfo info : uris) {
                jsonArray.put((Object)info.getJsonObject());
            }
            jsonObj.putOpt("extra", (Object)extra);
            jsonObj.putOpt("ignore", (Object)ignore);
            jsonObj.putOpt(KEY_URIS, (Object)jsonArray);
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        return jsonObj.toString();
    }

    public static JSONObject getJsonObject(String tag, String streamId, int type, String uri, String features, RCRTCResourceState resourceState) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.putOpt("tag", (Object)tag);
            jsonObject.putOpt("msid", (Object)streamId);
            jsonObject.putOpt("mediaType", (Object)type);
            jsonObject.putOpt("uri", (Object)uri);
            jsonObject.putOpt("features", (Object)features);
            jsonObject.putOpt("state", (Object)resourceState.getValue());
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)("Exception, " + e.getMessage()));
        }
        return jsonObject;
    }

    public static RepublishInfo getUnpubJSON(List<MediaResourceInfo> publishMediaInfoList, List<? extends IStreamResource> outputStreamList) {
        if (outputStreamList == null || outputStreamList.size() == 0) {
            return null;
        }
        JSONObject jsonObj = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        boolean tag = false;
        RepublishInfo republishInfo = new RepublishInfo();
        ArrayList<MediaResourceInfo> infoList = new ArrayList<MediaResourceInfo>();
        ArrayList<MediaResourceInfo> needUnpublist = new ArrayList<MediaResourceInfo>();
        try {
            for (IStreamResource iStreamResource : outputStreamList) {
                if (TextUtils.isEmpty((CharSequence)iStreamResource.getStreamId()) || TextUtils.isEmpty((CharSequence)iStreamResource.getUri())) continue;
                for (MediaResourceInfo info : publishMediaInfoList) {
                    if (iStreamResource.getMediaType().getValue() != info.getType().getValue() || !iStreamResource.getStreamId().equals(info.getStreamId()) || iStreamResource.getUri().equals(info.getUri())) continue;
                    jsonArray.put((Object)ResourceTools.getJsonObject(iStreamResource.getTag(), iStreamResource.getStreamId(), iStreamResource.getMediaType().getValue(), iStreamResource.getUri(), "", iStreamResource.getResourceState()));
                    tag = true;
                    infoList.add(info);
                    needUnpublist.add(new MediaResourceInfo((RCOutputStreamImpl)iStreamResource));
                }
            }
            if (tag) {
                jsonObj.putOpt("extra", (Object)"");
                jsonObj.putOpt("ignore", (Object)true);
                jsonObj.putOpt(KEY_URIS, (Object)jsonArray);
                FinLog.d(TAG, "getUnpubJSON->" + jsonArray.toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
        if (tag) {
            republishInfo.setUnpub_JSON(jsonObj.toString());
            republishInfo.setRepubList(infoList);
            republishInfo.setNeedUnpublist(needUnpublist);
            return republishInfo;
        }
        return null;
    }

    public static RTCStatusDate getStatusDate(String key, String val) {
        RTCStatusDate statusDate = new RTCStatusDate();
        statusDate.setKey(key);
        statusDate.setValue(val);
        return statusDate;
    }

    public static class RepublishInfo {
        private String unpub_JSON = "";
        private List<MediaResourceInfo> repubList = new ArrayList<MediaResourceInfo>();
        private List<MediaResourceInfo> needUnpublist = new ArrayList<MediaResourceInfo>();

        public String getUnpub_JSON() {
            return this.unpub_JSON;
        }

        public void setUnpub_JSON(String unpub_JSON) {
            this.unpub_JSON = unpub_JSON;
        }

        public List<MediaResourceInfo> getRepubList() {
            return this.repubList;
        }

        public void setRepubList(List<MediaResourceInfo> repubList) {
            this.repubList = repubList;
        }

        public List<MediaResourceInfo> getNeedUnpublist() {
            return this.needUnpublist;
        }

        public void setNeedUnpublist(List<MediaResourceInfo> needUnpublist) {
            this.needUnpublist = needUnpublist;
        }
    }
}

