/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.text.TextUtils;
import android.util.Pair;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.base.RCRTCStream;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import io.rong.common.fwlog.LogSplitUtil;
import java.util.Arrays;
import java.util.List;

public class ReportUtil {
    public static final String PREFIX_APP = "A-";
    public static final String PREFIX_LIB = "L-";
    public static final String PREFIX_PROTOCOL = "P-";
    public static final String SUFFIX_OPERATE = "-O";
    public static final String SUFFIX_STATUS = "-S";
    public static final String SUFFIX_TASK = "-T";
    public static final String SUFFIX_RESULT = "-R";
    public static final String SUFFIX_ERROR = "-E";
    public static final String KEY_ROOMID = "roomId";
    public static final String KEY_CODE = "code";
    public static final int CODE_SUCCESS = 0;
    public static final String KEY_ROOMIDCODE = "roomId|code";

    public static void appTask(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_TASK, keys, values);
    }

    public static void appRes(TAG tag, String roomId) {
        ReportUtil.appRes(tag, KEY_ROOMIDCODE, roomId, 0);
    }

    public static void appRes(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_RESULT, keys, values);
    }

    public static void appError(TAG tag, RTCErrorCode code, String keys, Object ... values) {
        Pair<String, Object[]> commonParams = ReportUtil.getCommonParams(code, keys, values);
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(code.getValue() + ""), (String)commonParams.first, (Object[])commonParams.second);
    }

    public static void appError(TAG tag, int level, RTCErrorCode code, String keys, Object ... values) {
        Pair<String, Object[]> commonParams = ReportUtil.getCommonParams(code, keys, values);
        ReportUtil.appError(tag, level, (String)commonParams.first, (Object[])commonParams.second);
    }

    public static void appError(TAG tag, RTCErrorCode code) {
        ReportUtil.appError(tag, code.getValue(), code.getReason());
    }

    public static void appError(TAG tag, int level, RTCErrorCode code) {
        ReportUtil.appError(tag, level, code.getValue(), code.getReason());
    }

    public static void appError(TAG tag, int code, String desc) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(code + ""), "code|desc", code, desc);
    }

    public static void appError(TAG tag, int level, int code, String desc) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, level, "code|desc", code, desc);
    }

    public static void appError(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(values), keys, values);
    }

    public static void appError(TAG tag, boolean checkErrorCodeAndDegradeLevel, String keys, Object ... values) {
        if (!checkErrorCodeAndDegradeLevel) {
            ReportUtil.appError(tag, keys, values);
            return;
        }
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(values), keys, values);
    }

    private static int degradeLogLevel(Object ... values) {
        int level = 1;
        for (Object obj : values) {
            String errorCode;
            if (obj == null || !(errorCode = obj.toString()).equals(RTCErrorCode.RongRTCCodeHttpTimeoutError.getValue() + "") && !errorCode.equals(RTCErrorCode.RongRTCCodeHttpResponseError.getValue() + "")) continue;
            level = 2;
            break;
        }
        return level;
    }

    public static void appError(TAG tag, int level, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, level, keys, values);
    }

    public static void appOperate(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_OPERATE, keys, values);
    }

    public static void appStatus(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_STATUS, keys, values);
    }

    public static void libTask(TAG tag) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_TASK, KEY_CODE, 0);
    }

    public static void libTask(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_TASK, keys, values);
    }

    public static void libRes(TAG tag) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_RESULT, KEY_CODE, 0);
    }

    public static void libRes(TAG tag, String roomId) {
        ReportUtil.libRes(tag, KEY_ROOMIDCODE, roomId, 0);
    }

    public static void libRes(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_RESULT, keys, values);
    }

    public static void libErrorW(TAG tag, RTCErrorCode code, String keys, Object ... values) {
        Pair<String, Object[]> commonParams = ReportUtil.getCommonParams(code, keys, values);
        ReportUtil.libError(tag, 2, (String)commonParams.first, (Object[])commonParams.second);
    }

    public static void libError(TAG tag, RTCErrorCode code, String keys, Object ... values) {
        Pair<String, Object[]> commonParams = ReportUtil.getCommonParams(code, keys, values);
        ReportUtil.libError(tag, (String)commonParams.first, (Object[])commonParams.second);
    }

    public static void libError(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_ERROR, keys, values);
    }

    public static void libError(TAG tag, int level, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_ERROR, level, keys, values);
    }

    public static void libError(TAG tag, boolean checkErrorCodeAndDegradeLevel, String keys, Object ... values) {
        if (!checkErrorCodeAndDegradeLevel) {
            ReportUtil.libError(tag, keys, values);
            return;
        }
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(values), keys, values);
    }

    public static void libStatus(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_STATUS, keys, values);
    }

    public static void report(String prefix, TAG tag, String suffix, String keys, Object ... values) {
        int level = 3;
        if (SUFFIX_ERROR.equals(suffix)) {
            level = 1;
        }
        ReportUtil.write(level, prefix + tag.tag + suffix, keys, values);
    }

    public static void report(String prefix, TAG tag, String suffix, int level, String keys, Object ... values) {
        ReportUtil.write(level, prefix + tag.tag + suffix, keys, values);
    }

    private static void write(int level, String tag, String keys, Object ... values) {
        LogSplitUtil.write((int)level, (String)tag, (String)keys, (Object[])values);
    }

    private static Pair<String, Object[]> getCommonParams(RTCErrorCode code, String keys, Object ... values) {
        String tmpKeys = keys;
        tmpKeys = TextUtils.isEmpty((CharSequence)tmpKeys) ? "code|desc" : tmpKeys + (tmpKeys.endsWith("|") ? "code|desc" : "|code|desc");
        Object[] tmpValues = values != null ? Arrays.copyOf(values, values.length + 2) : new Object[2];
        tmpValues[tmpValues.length - 2] = code.getValue();
        tmpValues[tmpValues.length - 1] = code.getReason();
        return Pair.create((Object)tmpKeys, (Object)tmpValues);
    }

    public static String streamToString(List<? extends RCRTCStream> streams) {
        if (streams == null || streams.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (RCRTCStream rCRTCStream : streams) {
            sb.append(rCRTCStream.toString()).append(" , ");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static String resourceToString(List<? extends IStreamResource> resources) {
        if (resources == null || resources.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (IStreamResource iStreamResource : resources) {
            sb.append(iStreamResource.toString()).append(" , ");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static void reportRemoteUserResource(boolean isPublish, String roomId, String uid, List<RCRTCInputStream> streams) {
        if (isPublish) {
            ReportUtil.libStatus(TAG.ONREMOTEUSERPUBLISHRESOURCE, "uid|resource", uid, ReportUtil.streamToString(streams));
        } else {
            ReportUtil.libStatus(TAG.ONREMOTEUSERUNPUBLISHRESOURCE, "uid|resource", uid, ReportUtil.streamToString(streams));
        }
    }

    public static enum TAG {
        JOINROOM("joinRoom"),
        JOINRTCROOMANDGETDATA("joinRTCRoomAndGetData"),
        REJOINROOM("rejoinRoom"),
        RELEASEROOM("releaseRoom"),
        LEAVEROOM("leaveRoom"),
        LEAVELIVE("leaveLive"),
        CREATEOFFER("createOffer"),
        SETLOCALSDP("setLocalSDP"),
        CREATEANSWER("createAnswer"),
        SETREMOTESDP("setRemoteSDP"),
        PUBLISHAVSTREAM("publishAVStream"),
        SDPEXCHANGE("SDPExchange"),
        RTCPUTINNERDATA("RTCPutInnerData"),
        RTCPUTOUTERDATA("RTCPutOuterData"),
        ENGINESUBSCRIBESTREAMS("engineSubscribeStreams"),
        SUBSCRIBEAVSTREAM("subscribeAVStream"),
        GETRTCTOKEN("getRtcToken"),
        ENGINESUBSCRIBELIVESTREAM("engineSubscribeLiveStream"),
        SUBSCRIBELIVESTREAM("subscribeLiveStream"),
        UNSUBSCRIBEAVSTREAM("unsubscribeAVStream"),
        UNSUBSCRIBELIVESTREAM("unsubscribeLiveStream"),
        UNPUBLISHAVSTREAM("unpublishAVStream"),
        SETMICROPHONEDISABLE("setMicrophoneDisable"),
        STARTCAPTURE("startCapture"),
        STOPCAPTURE("stopCapture"),
        SWITCHCAMERA("switchCamera"),
        USESPEAKER("useSpeaker"),
        CREATEHDVIDEODECODER("createHDVideoDecoder"),
        CREATEHDVIDEOENCODER("createHDVideoEncoder"),
        RTCCONFIG("RTCConfig"),
        RTCAUDIOCONFIG("RTCAudioConfig"),
        RTCVIDEOCONFIG("RTCVideoConfig"),
        RTCINIT("RTCInit"),
        CHANGEAUDIOSCENARIO("changeAudioScenario"),
        ONREMOTEUSERPUBLISHRESOURCE("onRemoteUserPublishResource"),
        ONREMOTEUSERUNPUBLISHRESOURCE("onRemoteUserUnpublishResource"),
        ONREMOTEUSERMODIFYRESOURCE("onRemoteUserModifyResource"),
        ONREMOTEUSERJOINED("onRemoteUserJoined"),
        ONREMOTEUSERLEFT("onRemoteUserLeft"),
        ONREMOTEUSEROFFLINE("onRemoteUserOffline"),
        ONADDTRACK("onAddTrack"),
        ONFIRSTFRAME("onFirstFrame"),
        EXCEPTIONALLEAVEROOM("exceptionalLeaveRoom"),
        RESETICE("resetICE"),
        ONICECONNECTIONCHANGE("onICEConnectionChange"),
        ONREMOVEREMOTESTREAM("onRemoveRemoteStream"),
        SETMIXCONFIG("setMixConfig"),
        ADDPUBLISHSTREAMURL("addPublishStreamUrl"),
        REMOVEPUBLISHSTREAMURL("removePublishStreamUrl"),
        MONITORRECEIVESTAT("monitorReceiveStat"),
        MONITORLOSSSTAT("monitorLossStat"),
        MODIFYRESOURCE("modifyResource"),
        DIFFDATA("diffData"),
        DIFFSTREAM("diffStream"),
        RTCNAVIDATA("RTCNaviData"),
        MUTEALLREMOTEAUDIO("muteAllRemoteAudio"),
        KICKEDFROMSERVER("kickedFromServer"),
        SETROOMATTRIBUTEVALUE("setRoomAttributeValue"),
        DELETEROOMATTRIBUTE("deleteRoomAttribute"),
        PUT_INNER_DATA("putInnerData"),
        GETROOMATTRIBUTE("getRoomAttribute"),
        SETATTRIBUTEVALUE("setAttributeValue"),
        DELETEATTRIBUTE("deleteAttribute"),
        GETATTRIBUTE("getAttribute"),
        SETMEDIASERVERURL("setMediaServerUrl"),
        INITVIDEOVIEW("initVideoView"),
        DESTROYVIDEOVIEW("destroyVideoView"),
        SETREMOTERENDERVIEW("setRemoteRenderView"),
        SETLOCALRENDERVIEW("setLocalRenderView"),
        CREATEVIDEOVIEW("createVideoView"),
        HTTP_REQUEST("httpRequest"),
        GETRTCUSERDATA("getRTCUserData"),
        REMOTEUSERTOTALCONTENTTAG("remoteUserTotalContent"),
        SENDEVENTMESSAGE("sendEventMessage"),
        UNHANDLEDMESSAGE("unhandledMessage"),
        TRANSITIONTOSTATE("transitionToState"),
        IMLOGIN("IMLogin"),
        PUBSUBQUEUEOFFER("PubSubQueueOffer"),
        PUBSUBQUEUECANCEL("PubSubQueueCancel"),
        PUBSUBQUEUEPOLL("PubSubQueuePoll"),
        RESUBSCRIBESTREAMS("resubscribeStreams"),
        SWITCHSTREAMTINYORNORMAL("switchStreamTinyOrNormal"),
        EXCHANGEVIDEOSIZE("exchangeVideoSize"),
        ENABLE_EAR_MONITOR("enableEarMonitor"),
        OPENSLES_DEVICE_ERR("OpenSLESDeviceError"),
        JOINOTHERROOM("joinOtherRoom"),
        LEAVEOTHERROOM("leaveOtherRoom"),
        REQUESTJOINOTHERROOM("requestJoinOtherRoom"),
        RESPONSEJOINOTHERROOM("responseJoinOtherRoom"),
        FINISHOTHERROOM("finishOtherRoom"),
        CANCELREQUESTJOINOTHERROOM("cancelRequestJoinOtherRoom"),
        INVITETIMEOUT("inviteTimeout"),
        INVITE("invite"),
        ANSWER_INVITE("answerInvite"),
        CANCEL_INVITE("cancelInvite"),
        END_INVITE("endInvite");

        private String tag;

        private TAG(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

